// 標準 C++ 関数群 2021-10-01
#ifndef _CH_
#define _CH_

#include <bits/stdc++.h>

#define uint  unsigned int
#define uchar unsigned char

//グローバルレベル乱数生成
//std::random_device seed_gen;
//std::mt19937 mt(static_cast<unsigned int>(time(nullptr)));
std::mt19937 mt(time(0));
//mt.seed(int)で再設定

double randuniform(double in){
 std::uniform_real_distribution<> d(0.0, in);
 return d(mt);
}

int randuniform(int in){
 std::uniform_int_distribution<> d(0, in);
 return d(mt);
}

int startingtime;

template<typename T> T pi(){
 return T(4.0)*atan(T(1.0));
}
//#define Pi pi<double>()


////////////////////////////////////////////////
class C{
  public:
 C(){std::cout << std::setprecision(10);startingtime=time(0);}

 //STRING
 std::string commentcut(std::string);
 std::string commentcut(std::string, const char);
 std::string cutchar(std::string *, const char);

 template<typename T> std::vector<T> string2vector(std::string);
 std::vector<double> string2vectordouble(std::string);
 std::vector<int> string2vectorint(std::string);
 std::vector<std::string> string2vectorstring(std::string);
 std::vector<char> string2vectorchar(std::string *);
 template<typename T>std::vector<std::vector<T> > string2matrix(std::string);
 std::vector<std::vector<std::string> > string2stringmatrix(std::string);
 template<typename T> std::vector<std::vector<T> >tenchi(
  std::vector<std::vector<T> >);
 std::string pickstring(std::string, int);
 std::string pickstringnew(const std::string, const int);
 std::string replaceall(std::string, std::string, std::string);
 std::string chikan(std::string, std::string, std::string);//replaceallと同じ
 std::string deltag(std::string *);
 std::vector<std::string> split(std::string, const char);
 std::vector<std::string> split(std::string, std::string);
 std::string join(std::vector<std::string> *, const char);
 std::string getstring(const std::string, const char *);
 std::map<int, std::vector<double> > csv2map(std::string);
 std::string insertenter(int, std::string *);
 std::string basename(const std::string&);
 std::string dirname(const std::string&);
 std::string trim_right(const std::string&, const std::string&);
 std::string trim_left( const std::string&, const std::string&);

 //TIME
 std::vector<uint> time2char(const time_t);
 double sec2day_val(const time_t);
 char sec2day_char(const time_t);
 int getdays(int, int, int);
 int getweek(int, int, int);

 //MATH
 uint combination(const int, const int);
 uint permutation(const int, const int);
 void tagainiso(uint, uint, uint, std::set<std::pair<uint, uint> > *);
 uint factorial(const int);
 std::vector<int> gencomb_addset(uint s, int N);
 uint gencomb_nextset(uint x);
 std::vector<std::vector<int> > generate_combination(int, int);
 template<typename T> std::vector<T> generate_permutation(T);
 double sigmoid(const double, const double);
 int int45(double);
 int ipow(int,int);
 int gcd(int,int);
 int ngcd(std::vector<int> *);
 int vectorgcd(std::vector<int> *);
 double log_n(double, double);//値 底
 double deg2rad(double);
 double rad2deg(double);
 std::vector<double> solve2(double a, double b, double c);
 std::vector<double> solve3(double a, double b, double c, double d);
 double solve3_cuberoot(double);
 template<typename T> std::vector<T> points2func1(
  std::vector<std::pair<T,T> > *);
 template<typename T> std::vector<T> points2func2(
  std::vector<std::pair<T,T> > *);

 //VECTOR
 template<typename T> T vectormulti(std::vector<T> *);
 template<typename T> std::vector<std::vector<T> >makerepeat(
  const std::vector<T> *,const int);//周期的な分解
 template<typename T> std::vector<double> vectornormalize(
  std::vector<T> *, const double, const double);
 template<typename T> void rotatevector(std::vector<T> *, int);//巡回
 template<typename T> void vectorout(std::ostream&, const T *);
 template<typename T> void vectoroutv(std::ostream&, const T *);
 template<typename T> std::vector<T> sortuniq(std::vector<T>);
 template<typename T> std::vector<std::vector<T> > zeros(int, int);
 template<typename T> std::vector<std::vector<T> > ones(int, int);
 std::vector<double> lpf(std::vector<double> *, double);//ローパスフィルタ

 template<typename T> T kaisa_plus(const T, const T);
 template<typename T> T kaisa_minus(const T, const T);
 template<typename T> T kaisa_mul(const T, const T);
 template<typename T> T kaisa_div(const T, const T);
 template<typename T> std::vector<T> kaisa(std::vector<T> *in,
  T (*calc)(const T,const T) );//階差作成

 //TRANS
 template <typename T> std::string anytos(T in);
 template <typename T> T stoany(std::string in);
 std::string   itoa(const int);
 std::string   itoa(const int, const int);
 std::string   ftoa(const double);
 int       stoi(const std::string);
 double      stof(const std::string);
 bool      stob(const std::string);
 std::vector<int>  stoi_all(std::vector<std::string> *);
 std::vector<double> stof_all(std::vector<std::string> *);

 std::vector<uint> dumpstring(std::string);
 uint  ir(const std::string *, const int, int);
 uint irb(const std::string *, const int, int);
 void iw(std::string *, int, const int, const int);
 void stringfill(std::string *, const int, const int, const int);
 void stringw(std::string *, const std::string, const int);

 std::string vectorchar2string(std::vector<char> *);
 std::vector<bool> double2bin(double, int);
 std::string double2binstring(double, int);
 void wav_headsave(const int, const int, const int, const std::string);
 std::string wav_doublenormalize(const std::vector<double> *);
 std::string midi_int2deltatime(uint);
 int midi_deltatime2int(std::string);
 void pbmout(const char *, std::vector<std::vector<bool> >*);
 void pgmout(const char *, std::vector<std::vector<uint> >*);

 char hex2char(const char, const char);
 std::string urlencode(const std::string&);
 std::string urldecode(std::string);

 bool is_b64char(unsigned char);
 std::string b64en(unsigned char const *, unsigned int);
 std::string b64en(std::string *);
 std::string b64de(std::string *);

 std::vector<double> discrete(double, double, double,
  double (*y)(double, void *), void *);

 std::string mime_encode(std::string, std::string);

 //HOKAN
 double hokan(double, double, std::vector<double> *, double);
 //スプライン補完:最後のspline関数だけが有効：他はサブルーチン
 void spline_maketable(std::vector<double> *, std::vector<double> *,
  std::vector<double> *);
 double spline_inner(double,std::vector<double> *,std::vector<double> *,
  std::vector<double> *);
 void spline_maketable2(std::vector<double> *, std::vector<double> *,
  std::vector<double> *, std::vector<double> *, std::vector<double> *);
 std::vector<double> spline_inner2(double t,
  std::vector<double> *p, std::vector<double> *x, std::vector<double> *y,
  std::vector<double> *a, std::vector<double> *b);
 std::vector<std::vector<double> > spline(std::vector<double> *,
  std::vector<double> *, uint);
 //ベジエ曲線
 double bezie_base(int, int, double);
 std::vector<double> bezier_point(std::vector<std::vector<double> >*,double);
 std::vector<std::vector<double> >bezier(std::vector<std::vector<double> >*,
  double,double,double);

 //OTHER
 std::string read_stream(std::istream&);
 void filecopy(const std::string&, const std::string&);
 std::string binload(const char *);
 void binsave(const char *, std::string);
 void binsave(const char *, const std::string *, const int, const int);
 template<typename T> void swap(T *, T *);
 template<typename T> T maxof3(const T, const T, const T);
 bool issame(const double, const double, const double);
 template<typename T> void errexit(int a,int b, T c);
 template<typename T> void hitanykey(T in);
 std::vector<double> makexaxis(const double, const double, const double);
 std::vector<std::vector<int> > magicsq(uint);
 void simplegraph(std::vector<double> *, uint, uint, std::string);

 template<typename T> T bobyqa(T , T , T (*y)(T, void *), void *);
 template<typename T> std::vector<T> sa(double (*)(std::vector<T> *),
  std::vector<T> (*)(std::vector<T>),uint,double,std::vector<T> *,double);
 template<typename T, typename P> T newton(T, T, T (*fn)(T,P), P);

};
//実体
//========================================================================

//バイナリロード
std::string C::binload(const char *fn){
 std::string str;
 std::ifstream s(fn, std::ios::in|std::ios_base::binary);
 if(!s){std::cout << "Open error: " << fn <<std::endl; exit(-1);}
 std::streamsize size = s.seekg(0, std::ios::end).tellg();
 str.resize(size);
 if(str.size()==0){std::cout << "Malloc error: " << fn <<std::endl; exit(-1);}
 s.seekg(0, std::ios::beg);
 char *buf=new char[size+1];
 if(buf==0){std::cout << "Tmp malloc error: " << fn <<std::endl; exit(-1);}
 buf[size]=0;
 s.read(buf, size);
 for(int i=0;i<size;i++){str[i]=buf[i];}
 delete [] buf;
 return str;
};

//バイナリセーブ
void C::binsave(const char *fn, const std::string in){
 std::ofstream s(fn, std::ios::out|std::ios::binary|std::ios::trunc);
 s.write(in.c_str(), in.size());
 s.close();
}

//一般的なセーブ
void C::binsave(const char *fn, const std::string *in,
   const int bin, const int append){
 if(bin==1 && append==1){
  std::ofstream s(fn, std::ios::out|std::ios::app|std::ios::binary);
  s.write(in->c_str(), in->size());
  s.close();
 }else
 if(bin==1 && append==0){
  std::ofstream s(fn,std::ios::out|std::ios::trunc|std::ios::binary);
  s.write(in->c_str(), in->size());
  s.close();
 }else
 if(bin==0 && append==1){
  std::ofstream s(fn, std::ios::out|std::ios::app);
  s.write(in->c_str(), in->size());
  s.close();
 }else
 if(bin==0 && append==0){
  std::ofstream s(fn, std::ios::out|std::ios::trunc);
  s.write(in->c_str(), in->size());
  s.close();
 }
}

//std::string型のコメントをカット
std::string C::commentcut(std::string in){
 return commentcut(in, '#');
};

//std::string型のコメントをカット
std::string C::commentcut(std::string in, const char c){
 int sw=0;
 std::string out;
 for(auto i : in){
  if(i==c){sw=1;}else if(i=='\n' && sw==1){sw=0;}else
  if(sw==0){out.push_back(i);}
  }
 return out;
};

//ある特定の文字をカット
std::string C::cutchar(std::string *in, const char c){
 std::ostringstream out;
 for(uint i=0;i<in->size();i++){
  if((*in).c_str()[i] != c){out << (*in)[i];}
 }
 return out.str();
}

//コンフィグファイル全体から値を読み出す
std::string C::getstring(const std::string I, const char *str){
 int startchk=I.rfind(str);
 if(startchk==-1){std::cout << "No found " << str <<std::endl;exit(-1);}
 std::streampos start=I.rfind(str);
 std::streampos valstart=I.find("=", start);
 std::streampos valend=I.find("\n", start);
 int valsize=valend-valstart;
 std::string val, val2;
 val=I.substr(valstart, valsize);
 val2=val.substr(1, valsize-1);
 return val2;
};

//CSVを分解してmapに入れる
std::map<int, std::vector<double> > C::csv2map(std::string in){
 int bit=0;//0=int文字列, 1=double文字列
 int id=0;
 double num;
 std::string tmp;
 std::vector<double> vtmp;
 std::map<int, std::vector<double> > out;
 for(auto i=in.begin(); i!=in.end(); i++ ){
 if(*i==','){
  if(bit==0){id=std::atoi(tmp.c_str());}
  if(bit==1){num=std::atof(tmp.c_str());vtmp.push_back(num);}
  bit=1;tmp.erase(tmp.begin(),tmp.end());}else
 if(*i=='\n'){
  if(bit==0){id=std::atoi(tmp.c_str());}
  if(bit==1){num=std::atof(tmp.c_str());vtmp.push_back(num);}
  out.insert(make_pair(id, vtmp));
  vtmp.clear();
  bit=0;tmp.erase(tmp.begin(),tmp.end());}else
 {tmp.insert(tmp.end(),*i);}
 }
return out;
}

//CSVを,または\nで分解：std::string2vectordouble
std::vector<double> C::string2vectordouble(std::string in){
 return string2vector<double>(in);
}

//CSVを,または\nで分解：std::string2vectorint
std::vector<int> C::string2vectorint(std::string in){
 return string2vector<int>(in);
}

//CSVを,または\nで分解 type2：std::string2vectordouble2
/*
std::vector<double> C::string2vectordouble2(std::string input){
 std::vector<double> data;
 double tmp;
 replace(input.begin(), input.end(), '\n', ' ');
 std::istringstream stream(input);
 while (stream>>tmp) {data.push_back(tmp);}
 return data;
}
*/

//
std::vector<std::vector<std::string> >C::string2stringmatrix(std::string in){
 return string2matrix<std::string>(in);
};

//CSVtenchi
template<typename T>
std::vector<std::vector<T> >C::tenchi(std::vector<std::vector<T> >in){
 uint tatesize=in[0].size();
 uint yokosize=in.size();
 std::vector<std::vector<std::string> > out(tatesize);
 for(uint i=0;i<tatesize;i++){
  out[i].resize(yokosize);
  for(uint j=0;j<yokosize;j++){
         out[i][j]=in[j][i];
  }
 }
 return out;
}


//文字列を空白で分解しnum番目を返す
std::string C::pickstringnew(const std::string in, const int num){
 std::vector<std::string> data;
 std::string tmp;
 std::istringstream stream(in);
 while (stream>>tmp) {data.push_back(tmp);}
 if(data.size()<(uint)(num+1)){std::cout << "Error at pickstd::string.";}
 return data[num];
}

//文字列を空白で分解しnum番目(最大10個)を返す
std::string C::pickstring(std::string in, int num){
 //inはスペース分割されてないといけない
 std::string tmp[10];
 for(int i=0;i<10;i++){tmp[i]="";}

 std::istringstream is(in);
 is >> tmp[0] >> tmp[1] >> tmp[2] >> tmp[3] >> tmp[4]
  >> tmp[5] >> tmp[6] >> tmp[7] >> tmp[8] >> tmp[9] ;
 return tmp[num];
}

//実数を二進数列へ
std::vector<bool> C::double2bin(double in, int keta){
 double tmp=in;
 double div=0.5;
 std::vector<bool> out;
 out.resize(keta);
 for(int i=0;i<keta; i++){
  if(tmp>div){tmp-=div; out[i]=true;}
  else{out[i]=false;}
  div/=2.;
 }
 return out;
}

//実数を0か1のstring列へ
std::string C::double2binstring(double in, int keta){
 double tmp=in;
 double div=0.5;
 std::string out("0.");
 for(int i=0;i<keta; i++){
  if(tmp>div){tmp-=div; out+="1";}
  else{out+="0";}
  div/=2.;
 }
 return out;
}

//二値画像として出力
void C::pbmout(const char *fn, std::vector<std::vector<bool> >*in){
 int yoko=(*in)[0].size();
 int tate=in->size();
 std::ofstream out(fn, std::ios::out);
 out << "P1" <<std::endl;
 out << yoko << " " << tate << std::endl;

 for(int i=0;i<tate;i++){
 for(int j=0;j<yoko;j++){
  if((*in)[i][j]==true){out << 1 << " ";}else{out << 0 << " ";}
 }
 out << std::endl;
 }
 out.close();
};

//グレースケール画像として出力
void C::pgmout(const char *fn, std::vector<std::vector<uint> >*in){
 int yoko=(*in)[0].size();
 int tate=in->size();
 std::ofstream out(fn, std::ios::out);
 out << "P2" <<std::endl;
 out << yoko << " " << tate << std::endl;
 out << "255" << std::endl;

 for(int i=0;i<tate;i++){
 for(int j=0;j<yoko;j++){
  out << ((*in)[i][j])%256 << " ";
 }
 out << std::endl;
 }
 out.close();
};

//要素を全部掛けた値を返す
template<typename T>
T C::vectormulti(std::vector<T> *in){
 T out=1;
 for(uint i=0;i<in->size();i++){out*=(*in)[i];}
 return out;
}

std::vector<char> C::string2vectorchar(std::string *data){
 std::vector<char> data2(data->size());
 for(uint i=0;i<data->size();i++){
  data2[i]=(*data)[i];
 }
 return data2;
}

std::string C::vectorchar2string(std::vector<char> *data){
 std::string data2;
 for(uint i=0;i<data->size();i++){
  data2+=(*data)[i];
 }
 return data2;
}

//文字列置換
std::string C::replaceall( std::string str1, std::string str2, std::string str3){
 std::string::size_type  pos( str1.find( str2 ) );
 while( pos != std::string::npos ){
  str1.replace( pos, str2.length(), str3 );
  pos = str1.find(str2, pos+str3.length());
 }
 return str1;
}

std::string C::chikan( std::string str1, std::string str2, std::string str3){
 return replaceall(str1, str2, str3);
}

std::string C::deltag(std::string *in){
 bool start=0;
 std::string out;
 for(uint i=0;i<in->size();i++){
  if((*in)[i] == '<'){start=1;}else
  if((*in)[i] == '>'){start=0;}else
  if(start==0){out+=(*in)[i];}
 }
 return out;
}

std::vector<std::string> C::split(std::string in, const char sep){
 std::vector<std::string> out;
 std::string tmp;
 const char *inn=in.c_str();
 for(uint i=0;i<in.size();i++){
  if(inn[i]==sep){
   out.push_back(tmp);
   tmp.clear();
  }
  else{tmp+=in[i];}
 }
 out.push_back(tmp);
 return out;
}

std::vector<std::string> C::split(std::string s, std::string b){
 s=chikan(s, b, std::string("\x01"));
 std::vector<std::string> out=split(s, 1);
 return out;
}

std::string C::join(std::vector<std::string> *in, const char sep){
 std::string o;
 for(uint i=0;i<in->size()-1;i++){
  o+=(*in)[i];
  o+=sep;
 }
 o+=(*in)[in->size()-1];
 return o;
};

////////////////////////

//３つのなかの最大
template<typename T>
T C::maxof3(const T in1, const T in2, const T in3){
 T max;
 if(in1>=in2){max=in1;}else{max=in2;}
 if(in3>=max){max=in3;}
 return max;
};

//ある範囲で同じかどうか
bool C::issame(const double a, const double b, const double samelimit){
// if(fabs(a-b)<0.0000000001){return 1;}else{return 0;}
 if(fabs(a-b)<=samelimit){return true;}else{return false;}
};

//線形補完した値を返す
double C::hokan(double xmin, double xmax, std::vector<double> *y, double xin){
 if(xin<xmin || xin >xmax){std::cout << "out of range at hokan." <<std::endl;}
 if(xmax==xmin){std::cout << "xmax=xmin at hokan." <<std::endl;}
 double ystep=(xmax-xmin)/((double)y->size()-1.);
 double alpha=(xin-xmin)/ystep;
 double alphaminusintalpha=alpha-(int)alpha;
 //y[intalpha]とy[intalpha+1]を
 //alpha-intalpha: 1-(alpha-intalpha)に内分する点が求める点

 return(
  (1.-alphaminusintalpha)*(*y)[(int)alpha]
  +alphaminusintalpha*(*y)[(int)alpha+1]
 );
}

////////////////////////

//time_tの値を分解して配列に入れる
std::vector<uint> C::time2char(const time_t in){
 std::vector<uint> MP;
 struct tm *lt;
 lt=localtime(&in);
 MP.push_back((lt->tm_year)-100);
 MP.push_back((lt->tm_mon)+1);
 MP.push_back(lt->tm_mday);
 MP.push_back(lt->tm_hour);
 MP.push_back(lt->tm_min);
 MP.push_back(lt->tm_sec);
 return MP;
}

//time_tの値を出す
double C::sec2day_val(const time_t in){
 if(in>86400){return (double)in/86400.;}else
 if(in>3600 ){return (double)in/3600.;}else
 if(in>60 ){return (double)in/60.;}else
 {return((double)in);}
}

//time_tの単位を出す
char C::sec2day_char(const time_t in){
 if(in>86400){return 'd';}else
 if(in>3600 ){return 'h';}else
 if(in>60 ){return 'm';}else
 {return 's';}
}

//1年1月1日からの経過日数
int C::getdays(int y, int m, int d){
 // 1・2月 → 前年の13・14月
 if (m <= 2){--y;m += 12;}
 int dy = 365 * (y - 1); // 経過年数×365日
 int c = y / 100;
 int dl = (y >> 2) - c + (c >> 2); // うるう年分
 int dm = (m * 979 - 1033) >> 5; // 1月1日から m 月1日までの日数
 return dy + dl + dm + d - 1;
}

//曜日判定 0:日曜 6:土曜
int C::getweek(int y, int m, int d){
 int c = y / 100;
 y %= 100;
 int dow = d + 26 * (m + 1) / 10 + y + y / 4  + c / 4 - 2 * c;
 return (dow %= 7);
}

////////////////////////

//組み合わせの数を出力
uint C::combination(const int i, const int j){
 if(i<j || i<0 || j<0){return 0;}
 if (j==0 || j==i){return 1;}
 else if(j==1){return i;}
 return (combination(i-1, j-1)+combination(i-1, j));
}

//順列の数を出力
uint C::permutation(const int i, const int j){
 if(i<j || i<0 || j<0){std::cout << "Error at permutation." <<std::endl;}
 if (j==1){return i;}
 else {return i*permutation(i-1, j-1);}
}

//階乗
uint C::factorial(const int i){
 if(i<0){std::cout << "Error at factorial." <<std::endl;}
 if(i==0){return 1;}
 if(i==1){return 1;}
 else{return i*factorial(i-1);}
}

//組み合わせの生成：サブルーチン
uint C::gencomb_nextset(uint x){
 uint smallest, ripple, new_smallest, ones;
 smallest = x & -x;
 ripple = x + smallest;
 new_smallest = ripple & -ripple;
 ones = ((new_smallest / smallest) >> 1) - 1;
 return ripple | ones;
}

//組み合わせの生成：サブルーチン
std::vector<int> C::gencomb_addset(uint s, int N){
 std::vector<int> o;
 for (int i = 1; i <= N; i++) {
  if (s & 1) {o.push_back(i);}
  s >>= 1;
 }
 return o;
}

//組み合わせの生成
std::vector<std::vector<int> > C::generate_combination(int N, int K){
 uint x;
 std::vector<std::vector<int> > kekka;

 x = ((uint) ((1U << (K)) - 1U));
 while (! (x & ~((uint) ((1U << (N)) - 1U)))) {
  kekka.push_back(gencomb_addset(x, N));
  x = gencomb_nextset(x);
 }
 return kekka;
}

//順列の生成
template<typename T>
std::vector<T> C::generate_permutation(T s){
T stmp=s;
std::sort(stmp.begin(),stmp.end());
std::vector<T>o;
 o.push_back(stmp);
 while(next_permutation(stmp.begin(), stmp.end())){
   o.push_back(stmp);
 }
 return o;
}


////////////////////////

//std::vectorの周期的な分解
template<typename T>
std::vector<std::vector<T> >
 C::makerepeat(const std::vector<T> *in, const int div){
 std::vector<std::vector<T> > out;
 int syou=in->size()/div;
 int amari=in->size()%div;

 std::vector<T> tmp;
 tmp.resize(div);
 out.resize(syou+1);

 for(int n=0;n<syou;n++){
  for(int m=0;m<div;m++){tmp[m]=(*in)[div*n+m];}
 out[n]=tmp;
 }

 tmp.resize(amari);
 for(int m=0;m<amari;m++){tmp[m]=(*in)[div*syou+m];}
 out[syou]=tmp;
 return out;
}

////////////////////////
//std::vectorをminからmaxの間に正規化
template<typename T>
std::vector<double> C::vectornormalize(std::vector<T> *in, const double max, const double min){
 uint size=in->size();
 std::vector<double> out(size);
 T datamax=*max_element(in->begin(), in->end());
 T datamin=*min_element(in->begin(), in->end());
 double rate=(max-min)/(double)(datamax-datamin);
 for(uint i=0; i<size; i++){
  out[i]=((double)(*in)[i]-(double)datamin)*rate+min;
 }
 return out;
}

////////////////////////
//std::vectorの巡回
template<typename T>
void C::rotatevector(std::vector<T> *in, int num){
 rotate(in->begin(), in->begin()+num, in->end());
}

////////////////////////
//std::vectorの表示: カンマ区切り

template<typename T>
void C::vectorout(std::ostream& out, const T *in){
 for(uint i=0; i<in->size(); i++){out << (*in)[i] << ",";}
 out <<std::endl;
}

//std::vectorの表示: 改行区切り
template<typename T>
void C::vectoroutv(std::ostream& out, const T *in){
 for(uint i=0; i<in->size(); i++){out << (*in)[i] << std::endl;}
}

//std::vectorを結合
//template<typename T> T<T> C::std::vectorcat(const T *in1, const T *in2){
// for(uint i=0; i<in->size(); i++){out << (*in)[i] << std::endl;}
//}


////////////////////////

//std::stringの各要素を整数列に変換
std::vector<uint> C::dumpstring(std::string in){
 std::vector<uint> out;
 out.resize(in.size());
 for(uint i=0;i<in.size();i++){out[i]=in.c_str()[i];out[i]=(out[i]&0xFF);}
 return out;
}

//std::string *から n-bit intを読み込み
//usage: ir(&s, 20, 4);
uint C::ir(const std::string *name, const int offset, int keta){
 uint val=0;
 while(keta>1){
  val=val+(unsigned char) (*name)[offset+keta-1];
  val=val<<8;keta--;
 };
 return (val+(unsigned char) (*name)[offset]);
}

//std::string *へ n-bit intを書き込み
//usage: iw(&s, 0x00C7B5B5, 20, 4);
void C::iw(std::string *name, int in, const int offset, const int keta){
 for(int cnt=offset;cnt<(offset+keta);cnt++){
  (*name)[cnt]=(in%256);
  in/=256;
 }
 }

//特定文字で埋める
void C::stringfill(std::string *name, const int fill, const int offset, const int bytes){
 for(int i=offset; i<(offset+bytes);i++){
 (*name)[i]=fill;
 }
}

//std::stringを書き込む
void C::stringw(std::string *name, const std::string in, const int offset){
 for(uint i=offset; i<(offset+in.size());i++){
   (*name)[i]=in[i-offset];
 }
}

//waveファイルヘッダのセーブ
void C::wav_headsave(const int size, const int channel, const int rate, const std::string fn){
//size is datasize =filesize-44bytes.
 std::string MP;
 MP.resize(44, 0);

 stringw(&MP, "RIFF", 0);
 iw(&MP, size+44-8,4 ,4);
 stringw(&MP, "WAVEfmt ",8);
 iw(&MP, 16, 16, 4);
 iw(&MP, 1, 20, 2);
 iw(&MP, channel, 22, 2);   //チャンネル数 1=mono 2=stereo
 iw(&MP, rate, 24,4);     //サンプリングレート
 iw(&MP, rate*channel*2, 28,4); //1秒あたりの使用バイト数
 iw(&MP, 2*channel, 32,2);  //1音あたりの使用バイト数
 iw(&MP, 16, 34,2);     //1音あたりの使用ビット数
 stringw(&MP, "data", 36);
 iw(&MP, size, 40,4);     //データサイズ bytes

 binsave(fn.c_str(), MP);
}

//doubleをstd::stringに変換する
std::string C::wav_doublenormalize(const std::vector<double> *in){
 //C c;
 std::string out;
 int tmp;
 uint size=in->size();
 out.resize(2*size, 0);

 double max=*max_element(in->begin(), in->end());
 double min=*min_element(in->begin(), in->end());

 double rate=65535./(max-min);

 for(uint i=0; i<size; i++){
  tmp=(int)(rate*((*in)[i]-min))-32768;
  iw(&out, tmp, i*2, 2);
 }
 return out;
}

//32bit整数をMIDIデルタタイムに変換
std::string C::midi_int2deltatime(uint value){
 uint buffer;
 buffer = value & 0x7F;
 std::vector<char> out;

 while ( (value >>= 7) ){
   buffer <<= 8;
   buffer |= ((value & 0x7F) | 0x80);
 }

 while(1){
  out.push_back(buffer);
  if (buffer & 0x80){buffer >>= 8;}
  else{break;}
 }

 std::string outs;
 outs.resize(out.size());
 for(uint i=0;i<out.size();i++){
  outs[i]=out[i];
 }
 return outs;
}

//MIDIデルタタイムを32bit整数に変換
int C::midi_deltatime2int(std::string in){
 int value;
 char c;
 int cc=1;

 if((value = in[0]) & 0x80 ){
  value &= 0x7F;
  do{
   value = (value << 7) + ((c = in[cc]) & 0x7F);cc++;
  }while (c & 0x80);
  }
 return value;
}

//sigmoid関数
double C::sigmoid(const double p, const double x){
 return 1./(1.+exp(-p*x));
};

//四捨五入
int C::int45(double x){
 if((ceil(x)-x)<(x-floor(x))){
  x=ceil(x);
 }else
 {
  x=floor(x);
 }
 return (int)x;
}

//整数の累乗
int C::ipow(int base, int po){
 return (int)pow((double)base,(double)po);
}

//最大公約数
int C::gcd(int x, int y){
 if (y == 0) return x;
 else return gcd(y, x % y);
}

// std::vector<int> inの数の最大公約数
int C::ngcd(std::vector<int> *in){
 uint n=in->size();
 int d=(*in)[0];
 for (uint i = 1; i < n && d != 1; i++){d = gcd((*in)[i], d);}
 return d;
}

double C::deg2rad(double in){
 return in/180.*pi<double>();
};
double C::rad2deg(double in){
 return in*180./pi<double>();
};

//二次方程式を解く
std::vector<double> C::solve2(double a, double b, double c){
 double d, x;
 std::vector<double> out(4);

 if (a != 0) {
  b /= a;  c /= a; //aで割って規格化
  if (c != 0) {
   b /= 2; //x^2 + 2b'x + c = 0

   d = b * b - c;//判別式
   if (d > 0) {//判別式＞０
    out[1]=0.; out[3]=0.;//虚数部は0
    if (b > 0){x = -b - sqrt(d);}
    else  {x = -b + sqrt(d);}
    out[0]=x; out[2]=c/x;
   }
   else if (d < 0){//複素解
    out[0]=-b;out[2]=-b;out[1]=sqrt(-d);out[3]=-sqrt(-d);
   }
   else{//重解
   out[2]=out[0]=-b;
   out[3]=out[1]=0;
   }
  }
  else{//片方が０
  out[1]=out[2]=out[3]=0;
  out[0]=-b;
  }
 }
 else if (b != 0){
  out[1]=out[2]=out[3]=0;
  out[0]=-c/b;
 }
 else out.resize(0);//解なし、不定
 return out;
}

//３次方程式を解く：サブルーチン
double C::solve3_cuberoot(double x){
 double s, prev;
 int pos;
 if (x == 0) return 0;
 if (x > 0) pos = 1;  else {  pos = 0;  x = -x;  }
 if (x > 1) s = x;  else s = 1;
 do {
  prev = s;  s = (x / (s * s) + 2. * s) / 3.;
 } while (s < prev);
 if (pos) return prev;  else return -prev;
}

//三次方程式を解く
//カルダノの公式 $ax^3 + bx^2 + cx + d = 0$, $a \ne 0$
std::vector<double> C::solve3(double a, double b, double c, double d){
 double p, q, t, a3, b3, x1, x2, x3;
 std::vector<double> x;

 b /= (3 * a);  c /= a;  d /= a;
 p = b * b - c / 3;
 q = (b * (c - 2 * b * b) - d) / 2;
 a = q * q - p * p * p;
 if (a == 0) {
  q = solve3_cuberoot(q);  x1 = 2 * q - b;  x2 = -q - b;
  x.resize(2);
  x[0]=x1;x[1]=x2;
 } else if (a > 0) {
  if (q > 0) a3 = solve3_cuberoot(q + sqrt(a));
  else   a3 = solve3_cuberoot(q - sqrt(a));
  b3 = p / a3;
  x1 = a3 + b3 - b;  x2 = -0.5 * (a3 + b3) - b;
  x3 = fabs(a3 - b3) * sqrt(3.0) / 2;
  x.resize(3);
  x[0]=x1;x[1]=x2;x[2]=x3;
 } else {
  a = sqrt(p);  t = acos(q / (p * a));  a *= 2;
  x1 = a * cos( t     / 3) - b;
  x2 = a * cos((t + 2 * pi<double>()) / 3) - b;
  x3 = a * cos((t + 4 * pi<double>()) / 3) - b;
  x.resize(3);
  x[0]=x1;x[1]=x2;x[2]=x3;
 }
 return x;
}


////////////////////

//itoa
std::string C::itoa(const int in){
 std::ostringstream tmp;
 tmp<<in;
 return tmp.str();
}

//itoa 桁指定
std::string C::itoa(const int in, const int keta){
 std::ostringstream tmp;
 tmp<<std::setw(keta)<<std::setfill('0')<<in;
 return tmp.str();
}

//ftoa
std::string C::ftoa(const double in){
 std::string out;
 std::ostringstream tmp;
 tmp<<in;
 return tmp.str();
}

//stoi
int C::stoi(const std::string in){
 return std::atoi(in.c_str());
}

//stof
double C::stof(const std::string in){
 return std::atof(in.c_str());
};

//stob
bool C::stob(const std::string in){
 if(in=="1"){return true;}
 else if(in=="true"){return true;}
 else if(in=="TRUE"){return true;}
 else if(in=="0"){return false;}
 else if(in=="false"){return false;}
 else if(in=="FALSE"){return false;}
 else {std::cout << "Error at stob" <<std::endl;return false;}
};

//swap
template<typename T>
void C::swap(T *in1, T *in2){
 T tmp=*in1;
 *in1=*in2;
 *in2=tmp;
}

//sortuniq
template<typename T>
std::vector<T> C::sortuniq(std::vector<T> v){
 sort(v.begin(), v.end());
 std::vector<T> out;
 unique_copy( v.begin(), v.end(), back_inserter(out) );
 return out;
}

//makeaxis
std::vector<double> C::makexaxis(const double s, const double e, const double step){
 std::vector<double> out;
 uint size=(int)((e-s)/step)+1;
 out.resize(size);
 for(uint i=0;i<size;i++){out[i]=s+step/2.+step*i;}
 return out;
};


//スプライン補完：spline関数のみが意味ある。他はサブルーチン
void C:: spline_maketable(std::vector<double> *x, std::vector<double> *y,
 std::vector<double> *z){
 double t;
 std::vector<double> h(x->size()), d(x->size());
 int N=(x->size());

 (*z)[0] = 0;  (*z)[x->size()-1]=0;  /* 両端点での y''(x) / 6 */
  for (int i = 0; i < N - 1; i++) {
  h[i  ] =  (*x)[i + 1] - (*x)[i];
  d[i + 1] = ((*y)[i + 1] - (*y)[i]) / h[i];
 }
 (*z)[1] = d[2] - d[1] - h[0] * (*z)[0];
 d[1] = 2 * ((*x)[2] - (*x)[0]);
 for (int i = 1; i < N - 2; i++) {
  t = h[i] / d[i];
  (*z)[i + 1] = d[i + 2] - d[i + 1] - (*z)[i] * t;
  d[i + 1] = 2 * ((*x)[i + 2] - (*x)[i]) - h[i] * t;
 }
 (*z)[N - 2] -= h[N - 2] * (*z)[N - 1];
 for (int i = N - 2; i > 0; i--)
  (*z)[i] = ((*z)[i] - h[i] * (*z)[i + 1]) / d[i];
}

double C::spline_inner(double t,std::vector<double> *x,std::vector<double> *y,
 std::vector<double> *z){
 int i, j, k;
 double d, h;
 int N=(x->size());

 i = 0;  j = N - 1;
 while (i < j) {
  k = (i + j) / 2;
  if ((*x)[k] < t) i = k + 1;  else j = k;
 }
 if (i > 0) i--;
 h = (*x)[i + 1] - (*x)[i];  d = t - (*x)[i];
 return ((((*z)[i + 1] - (*z)[i]) * d / h + (*z)[i] * 3) * d
  + (((*y)[i + 1] - (*y)[i]) / h
  - ((*z)[i] * 2 + (*z)[i + 1]) * h)) * d + (*y)[i];
}

void C::spline_maketable2(std::vector<double> *p, std::vector<double> *x,
 std::vector<double> *y, std::vector<double> *a, std::vector<double> *b){
 double t1, t2;
 int N=(x->size());

 (*p)[0] = 0;
 for (int i = 1; i < N; i++) {
  t1 = (*x)[i] - (*x)[i - 1];
  t2 = (*y)[i] - (*y)[i - 1];
  (*p)[i] = (*p)[i - 1] + sqrt(t1 * t1 + t2 * t2);
 }
 for (int i = 1; i < N; i++) {(*p)[i] /= (*p)[N - 1];}
 spline_maketable(p, x, a);
 spline_maketable(p, y, b);
}

std::vector<double> C::spline_inner2(double t,
  std::vector<double> *p, std::vector<double> *x, std::vector<double> *y,
  std::vector<double> *a, std::vector<double> *b){
 std::vector<double> out(2);
 out[0] = spline_inner(t, p, x, a);
 out[1] = spline_inner(t, p, y, b);
 return out;
}

std::vector<std::vector<double> > C::spline(std::vector<double> *x,std::vector<double> *y,uint ps){
 //double u, v;
 uint vsize=x->size();
 std::vector<std::vector<double> > o(ps+1);
 std::vector<double> p(vsize);
 std::vector<double> a(vsize);
 std::vector<double> b(vsize);
 spline_maketable2(&p, x, y, &a, &b);
 std::vector<double> kekka;
 for (uint i = 0; i <= ps; i++) {
  o[i]=spline_inner2(1./ps * i, &p, x, y, &a, &b);
 }
 return o;
}

//ベジエ曲線
//サブルーチン
double C::bezie_base(int n, int i, double t){
 double ni, x = 1.0, y = 1.0;
 ni = factorial(i) * factorial(n-i);
 ni = factorial(n) / ni;
 for(int i1=1;i1<=i;i1++){x*=t;}
 t=1.0-t;
 for(int i1=1;i1<=n-i;i1++){y*=t;}
 return ni*x*y;
}

//与えられた点を求めるサブルーチン
//B:頂点座標列, t:計算したい点
std::vector<double> C::bezier_point(std::vector<std::vector<double> > *B, double t){
 int n=B->size()-1;
 std::vector<double> P(2, 0.0);
 double j;
 for (int i=0;i<=n;i++){
  j=bezie_base(n,i,t);
  P[0]+=(*B)[i][0]*j;
  P[1]+=(*B)[i][1]*j;
 }
 return P;
}
//ベジエ曲線本体
std::vector<std::vector<double> > C::bezier(std::vector<std::vector<double> > *B, double s, double e, double step){
 std::vector<std::vector<double> >out;
 for(double t = s; t<=e; t+=step){
  out.push_back(bezier_point(B, t));
 }
 return out;
}



//娯楽
//奇数次の魔方陣
std::vector<std::vector<int> > C::magicsq(uint N){
 int k;
 std::vector<std::vector<int> > a(N);
 for(uint i=0;i<a.size();i++){a[i].resize(N);}
 k = 0;

 for (uint i = - N / 2; i <= N / 2; i++){
  for (uint j = 0; j < N; j++){
   a[(j - i + N) % N][(j + i + N) % N] = ++k;
  }
 }
 return a;
}

//最適化 Bobyqa
template<typename T>
T C::bobyqa(T x0, T dx, T (*y)(T, void *), void *in){
 T x1, x2;
 std::vector<std::pair<T,T> > p(3);
 x1=x0+dx;
 x2=x0-dx;
 p[0]=std::pair<T,T>(x0,y(x0,in));
 p[1]=std::pair<T,T>(x1,y(x1,in));
 p[2]=std::pair<T,T>(x2,y(x2,in));
 //dxが0ならそのまま返す
 if(dx<=T(0)){return x0;}
 //横一直線だったらx0をそのまま返す
 if(p[0].second==p[1].second && p[0].second==p[2].second){
  return x0;
 }
 std::vector<T> re=points2func2(&p);
 //直線だったらx0 pm dx での値を返す
 if(re.size()==2){
  if(p[1].second>=p[2].second){return p[2].first;}
  else{return p[1].first;}
 }
 //上に凸ならx0 pm dx での値を返す
 if(re[2]<0){
  if(p[1].second>=p[2].second){return p[2].first;}
  else{return p[1].first;}
 }
 //下に凸なら普通に返す
 else{return -re[1]/(T(2)*re[2]);}
}
//double y(double x, void *){
// return (x-1.)*(x-2.);
//}
//kekka=bobyqa(kekka , 0.01, y, 0);

//exit
template<typename T>
void C::errexit(int a,int b, T c){
 if(a<b){
  std::cout << c << std::endl;
  exit(-1);
 }
}

template<typename T>
void C::hitanykey(T in){
 std::cout<<in<<std::endl;
 int dummy;
 std::cin >>dummy;
}

std::vector<int> C::stoi_all(std::vector<std::string> *in){
 std::vector<int> o(in->size());
 for(uint i=0;i<in->size();i++){
  o[i]=stoi((*in)[i]);
 }
 return o;
};

std::vector<double> C::stof_all(std::vector<std::string> *in){
 std::vector<double> o(in->size());
 for(uint i=0;i<in->size();i++){
  o[i]=stof((*in)[i]);
 }
 return o;
};

//16進数文字からchar型に変換
char C::hex2char(const char first, const char second){
 char ret;
 //16進数文字を16進数数字に変換
 if(first >= 'A'){
  ret = first-'A' + 10;
 }else{
  ret = first-'0';
 }
 //先の文字を上位ビットにシフト
 ret = ret << 4;
 //後の文字を変換して追加
 if(second >='A'){
  ret += second-'A' + 10;
 }else{
  ret += second-'0';
 }
 return ret;
}

//assumed utf8
std::string C::urlencode(const std::string &value){
 std::ostringstream escaped;
 escaped.fill('0');
 escaped << std::hex;
 for(auto i=value.begin(),n=value.end();i!= n;++i){
  std::string::value_type c = (*i);
  if (std::isalnum(c) || c == '-' || c == '_' || c == '.' || c == '~') {
   escaped << c;
   continue;
  }
  // Any other characters are percent-encoded
  escaped << std::uppercase;
  escaped << '%' << std::setw(2) << int((unsigned char) c);
  escaped << std::nouppercase;
 }
 return escaped.str();
}

std::string C::urldecode(std::string str){
 std::string retStr ="";
 std::string::size_type length = str.size();
 char tmpChar[2];

 //文字数分繰り返す
 for(std::string::size_type i = 0; i < length ; i++){
  //+をスペースに変換
  if(str[i] =='+'){
   retStr+=' ';
   //%付き文字の場合変換
  }else if(str[i] == '%' && (i+2) < length){
   tmpChar[0] = str[i+1];
   tmpChar[1] = str[i+2];
   //16進数文字かチェック
   if(isxdigit(tmpChar[0]) && isxdigit(tmpChar[1])){
    i += 2;
    //変換関数を呼び出して、結果を繋げる
    retStr += hex2char(tmpChar[0],tmpChar[1]);
    //16進数文字ではない場合、%を繋げる
    }else{
    retStr += '%';
   }
   //当てはまらない時は、そのままの文字を繋げる
  }else{
   retStr += str[i];
  }
 }
 return retStr;
}

void C::simplegraph(std::vector<double> *in, uint w, uint h, std::string fn){
 double maxdata=*std::max_element(in->begin(), in->end());
 double mindata=*std::min_element(in->begin(), in->end());
 double diff=maxdata-mindata;

 double scalex=(double)w/(in->size()*1.01);
 double scaley=(double)h/(diff*1.01);

 std::vector<std::vector<bool> > g(h);
 for(uint i=0;i<g.size();i++){g[i].resize(w, false);}

 for(uint i=0;i<in->size();i++){
  g[h-1-(int)(((*in)[i]-mindata)*scaley)][(int)((double)i*scalex)]=true;
 }
 pbmout((fn+".pbm").c_str(), &g);
}

bool C::is_b64char(unsigned char c){
  return(isalnum(c) ||(c=='+') ||(c=='/'));
}

std::string C::b64en(std::string *in){
return b64en(reinterpret_cast<const unsigned char*>(in->c_str()),in->length());
}

std::string C::b64en(unsigned char const* in, unsigned int len){
//usege: b64en(reinterpret_cast<const unsigned char*>(s.c_str()), s.length());
 const std::string base64_chars=
 "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
 std::string ret;
 int i=0, j=0;
 unsigned char char_array_3[3];
 unsigned char char_array_4[4];
 while(len--){
  char_array_3[i++]=*(in++);
  if(i==3){
  char_array_4[0]=(char_array_3[0] & 0xfc) >> 2;
  char_array_4[1]=((char_array_3[0]&0x03)<<4)+((char_array_3[1]&0xf0)>>4);
  char_array_4[2]=((char_array_3[1]&0x0f)<<2)+((char_array_3[2]&0xc0)>>6);
  char_array_4[3]=char_array_3[2] & 0x3f;
  for(i=0;(i<4);i++){ret +=base64_chars[char_array_4[i]];}
  i=0;
  }
 }
 if(i){
  for(j=i; j < 3; j++){char_array_3[j]='\0';}
  char_array_4[0]=(char_array_3[0] & 0xfc) >> 2;
  char_array_4[1]=((char_array_3[0]&0x03)<<4)+((char_array_3[1]&0xf0)>>4);
  char_array_4[2]=((char_array_3[1]&0x0f)<<2)+((char_array_3[2]&0xc0)>>6);
  char_array_4[3]=char_array_3[2] & 0x3f;
  for(j=0;(j<i+1);j++){ret+=base64_chars[char_array_4[j]];}
  while((i++ < 3)){ret +='=';}
 }
 std::string o=insertenter(60,&ret);
 return o;
}

std::string C::b64de(std::string *in){
 const std::string base64_chars=
 "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
 int in_len=in->size();
 int i=0, j=0;
 int in_=0;
 unsigned char char_array_4[4], char_array_3[3];
 std::string ret;
 while(in_len-- &&( (*in)[in_] !='=') && is_b64char((*in)[in_])){
  char_array_4[i++]=(*in)[in_]; in_++;
  if(i==4){
   for(i=0; i <4; i++){
    char_array_4[i]=base64_chars.find(char_array_4[i]);
   }
  char_array_3[0]=(char_array_4[0] << 2) +((char_array_4[1] & 0x30) >> 4);
  char_array_3[1]=((char_array_4[1]&0xf)<<4)+((char_array_4[2]&0x3c)>> 2);
  char_array_3[2]=((char_array_4[2] & 0x3) << 6) + char_array_4[3];
  for(i=0;(i < 3); i++){
   ret +=char_array_3[i];
  }
  i=0;
  }
 }
 if(i){
  for(j=i; j <4; j++){char_array_4[j]=0;}
  for(j=0; j <4; j++){
   char_array_4[j]=base64_chars.find(char_array_4[j]);
  }
  char_array_3[0]=(char_array_4[0] << 2) +((char_array_4[1] & 0x30) >> 4);
  char_array_3[1]=((char_array_4[1]&0xf)<<4)+((char_array_4[2]&0x3c)>>2);
  char_array_3[2]=((char_array_4[2] & 0x3) << 6) + char_array_4[3];
  for(j=0;(j < i - 1); j++){ret+=char_array_3[j];}
 }
 return ret;
}

std::vector<double> C::discrete(double start, double end, double step,
 double (*y)(double, void *), void *in){
 std::vector<double> o;
 for(double i=start;i<=end; i+=step){
  o.push_back(y(i,in));
 }
 return o;
};

//2点から一次方程式の係数を求める
template<typename T>
std::vector<T> C::points2func1(std::vector<std::pair<T,T> > *in){
 std::vector<T> out(2);
 //入力形式エラー
 if(in->size()!=2){out.resize(0);return out;}
 T x1=(*in)[0].first;
 T y1=(*in)[0].second;
 T x2=(*in)[1].first;
 T y2=(*in)[1].second;

 if(x1==x2){out.resize(0);return out;}//1点しかなければ解けない

 T a=(y2-y1)/(x2-x1);
 T b=y1-a*x1;
 out[0]=b;
 out[1]=a;
 return out;
}

//三点を通る二次関数の導出
template<typename T>
std::vector<T> C::points2func2(std::vector<std::pair<T,T> > *in){
//y = ax^2 + bx + c が、(x1, y1), (x2, y2), (x3, y3)を通るときa,b,cを出す
 std::vector<T> out(3);
 //入力形式エラー
 if(in->size()!=3){out.resize(0);return out;}

 T x1=(*in)[0].first;
 T y1=(*in)[0].second;
 T x2=(*in)[1].first;
 T y2=(*in)[1].second;
 T x3=(*in)[2].first;
 T y3=(*in)[2].second;

 if(x1==x2 && x2==x3){out.resize(0);return out;}//1点しかなければ解けない

 //1次関数:点が2点しかない場合
 if(x1==x2 || x2==x3){
  std::vector<std::pair<T,T> > t(2);
  t[0].first=x1;
  t[0].second=y1;
  t[1].first=x3;
  t[1].second=y3;
  return points2func1(&t);
 }

 else
 if(x1==x2 || x3==x1){
  std::vector<std::pair<T,T> > t(2);
  t[0].first=x2;
  t[0].second=y2;
  t[1].first=x3;
  t[1].second=y3;
  return points2func1(&t);
 }

 //1次関数:傾きが同じ場合
 else
 if((y3-y2)/(x3-x2)==(y2-y1)/(x2-x1)){
  std::vector<std::pair<T,T> > t(2);
  t[0].first=x1;
  t[0].second=y1;
  t[1].first=x2;
  t[1].second=y2;
  return points2func1(&t);
 }

 //まともな2次関数
 else{
  T a = ((y1 - y2) * (x1 - x3) - (y1 - y3) * (x1 - x2))
     / ((x1 - x2) * (x1 - x3) * (x2 - x3));
  T b = (y1 - y2) / (x1 - x2) - a * (x1 + x2);
  T c = y1 - a * x1 * x1 - b * x1;
  //逆順出力
  out[0]=c;
  out[1]=b;
  out[2]=a;
  return out;
 }
}

std::vector<std::string> C::string2vectorstring(std::string in){
 return string2vector<std::string>(in);
}

template<typename T>
std::vector<T> C::string2vector(std::string in){
 std::vector<T> out;
 std::string tmp;
 for(auto i=in.begin(); i!=in.end(); i++ ){
  if((*i)!=',' && (*i)!='\n' ){
   tmp.insert(tmp.end(),*i);
  }
  else{
   std::stringstream s(tmp);
         T v;
         s >> v;
   out.push_back(v);tmp.clear();
  }
 }
 return out;
}

template <typename T>
T C::stoany(std::string in){
 std::stringstream ss(in);
 T v;
 ss >> v;
 return v;
}

template <typename T>
std::string C::anytos(T in){
 std::stringstream ss;
 ss << in;
 return ss.str();
}

template<typename T>
std::vector<std::vector<T> > C::string2matrix(std::string in){
 std::vector<std::vector<T> >out;

 std::vector<std::string> tmp=split(in, '\n');
 for(auto i : tmp){
  std::vector<T> tmp2=string2vector<T>(i);
  out.push_back(tmp2);
 }
 return out;
};

//シミュレーティッドアニーリング
template<typename T>
std::vector<T> C::sa(double (*error)(std::vector<T> *),  //誤差値計算関数
           std::vector<T> (*coffupdate)(std::vector<T>  ), //係数更新関数
     uint maxiterate, double stopdistance, //停止判定用
           std::vector<T> *coffin,        //係数初期値入力
     double beta         //選択関数の係数:温度逆数
    ){
 std::vector<T> coffold=*coffin, coffnew;
 double eold, enew;
 for(uint k=0;k<maxiterate;k++){
  coffnew=coffupdate(coffold);
  eold=error(&coffold);
  enew=error(&coffnew);
  //確率 exp(-c*(Dnew-D)) で新しい係数を採用:βが小さい方が変化しやすい
  if(enew<eold && randuniform(1.)<exp(-beta*(enew-eold))){coffold=coffnew;}
  if(enew<stopdistance){break;}
 }
 return coffnew;
}
//誤差関数とupdate関数の例
/*
double err(vector<double> *in){
 double out=0.;
 for(auto i: (*in)){out+=(i-6.)*(i-6.);}
 return out;
}

vector<double> upd(vector<double> in){
 for(auto &i: in){i+=(randuniform(0.03)-0.015);}
 return in;
}

vector<double> kekka=sa<double>(err, upd, 1000000, 0.000001, &init, .1);
*/


uint C::irb(const std::string *name, const int offset, int keta){
 uint val=0;
 int cnt=0;
 while(cnt<keta-1){
  val=val+(unsigned char) (*name)[offset+cnt];
  val=val<<8;
  cnt++;
 }
 return(val+(unsigned char) (*name)[offset+cnt]);
}

//usage:
//set<pair<uint, uint> > v;
//tagainiso(10, 1, 1, &v);
void C::tagainiso(
 uint N, uint a, uint b, std::set<std::pair<uint, uint> > *v){
 for(uint d = a+b; d <= N; d += b) {
  v->insert({b,d});
  tagainiso(N, b, d, v);
 }
}

template<typename T, typename P>
T C::newton(T start, T tor, T (*fn)(T,P), P p){
 T s=start, z, h, w;
 while(1){
  z=fn(s, p);// sを入れてゼロに近い値を出す
  if(z<tor){break;}
  h=z/s;// そのゼロに近い値をsで割る:相対偏差を出す
  w=fn(s+h, p);//sにその割った値を足した物を入れてみる
  s+=h/(T(1)-w/z);// その結果を色々いじった物を足す
 }
 return s;
}

//底の変換
double C::log_n(double in, double tei){
 return log(in)/log(tei);
}

//zeros
template<typename T>
std::vector<std::vector<T> > C::zeros(int x, int y){
 std::vector<std::vector<T> > o(x);
 for(auto &i:o){i.resize(y, T(0));}
 return o;
}

//ones
template<typename T>
std::vector<std::vector<T> > C::ones(int x, int y){
 std::vector<std::vector<T> > o(x);
 for(auto &i:o){i.resize(y, T(1));}
 return o;
}

//MIMEエンコード
std::string C::mime_encode(std::string data, std::string charset){
 std::string o = "=?" + charset + "?B?" + b64en(&data)+ "?=";
 return o;
};


std::string C::insertenter(int n, std::string *in){
 std::string o;
 for(uint i=0;i<in->size();i++){
  o.push_back((*in)[i]);
  if(!((i+1)%n)){o.push_back('\n');}
 }
 return o;
}

//ローパスフィルタ
std::vector<double> C::lpf(std::vector<double> *in, double rate){
//rate: [0:1]
 std::vector<double> o(in->size());
 o[0]=(*in)[0];
 for(uint i=1;i<o.size();i++){
  o[i] = rate*o[i-1] + (1.-rate)*(*in)[i];
 }
 return o;
}

//差分構成
template <typename T>
T C::kaisa_minus(const T val1, const T val2){
 return val1-val2;
}

//和分構成
template <typename T>
T C::kaisa_plus(const T val1, const T val2){
 return val1+val2;
}

//積分構成
template <typename T>
T C::kaisa_mul(const T val1, const T val2){
 return val1*val2;
}

//商分構成
template <typename T>
T C::kaisa_div(const T val1, const T val2){
 return val1/val2;
}

//一般階差列構成
template <typename T>
std::vector<T> C::kaisa(std::vector<T> *in, T (*calc)(const T,const T) ){
 std::vector<T> t=*in;
 for(int j=0;j<t.size()-1;j++){
  for(int i=t.size();i>j;i--){
  t[i]=calc(t[i],t[i-1]);
  }
 }
 return t;
};

//ディレクトリ名の削除
std::string C::basename(const std::string& path){
 return path.substr(path.find_last_of('/') + 1);
}

//ディレクトリ名だけ抽出
std::string C::dirname(const std::string& path) {
 return path.substr(0, path.find_last_of('/'));
}

//行末空白削除
std::string C::trim_right(const std::string& line, const std::string& blank = " \t\r\n"){
 return line.substr(0, line.find_last_not_of(blank) + 1);
}

//行頭空白削除
std::string C::trim_left(
 const std::string& line,
 const std::string& blank = " \t\r\n") {
  std::string::size_type begin = line.find_first_not_of(blank);
  if (begin == line.npos){return "";}
  return line.substr(begin);
}

//binloadの内部
std::string C::read_stream(std::istream& in){
 return std::string(
  std::istreambuf_iterator<char>{in},
  std::istreambuf_iterator<char>{});
}

//ファイルコピー
void C::filecopy(const std::string& src, const std::string& dst) {
 using std::ios_base;
 std::ifstream ifs;
 ifs.exceptions(ios_base::badbit | ios_base::failbit);
 ifs.open(src, ios_base::in | ios_base::binary);
 std::ofstream ofs;
 ofs.exceptions(ios_base::badbit | ios_base::failbit);
 ofs.open(dst, ios_base::out | ios_base::binary);
 ofs << ifs.rdbuf();
}


/////////////////////////////////////////////////////////////
#endif
