#ifndef _CEIGENH_
#include "C-eigen.h"
#endif
//#include <boost/format.hpp>
//#include <cstdlib>
#include <cstdio>

struct Tokusin{
 std::string target;
 std::string basis;
 std::string expression;
 std::string results;
 int err;
};


//各種演算定義
void rec_and(uchar* a, uchar* b, uchar* out, int words){
 int i;
 for(i = 0 ; i < words ; i++){
  out[i] = a[i] & b[i];
 }
}

void rec_or(uchar* a, uchar* b, uchar* out, int words){
 int i;
 for(i = 0 ; i < words ; i++){
  out[i] = a[i] | b[i];
 }
}

void rec_xor(uchar* a, uchar* b, uchar* out, int words){
 int i;
 for(i = 0 ; i < words ; i++){
  out[i] = a[i] ^ b[i];
 }
}

void rec_not(uchar* a, uchar* out, int words){
 int i;
 for(i = 0 ; i < words ; i++){
  out[i] = ~a[i];
 }
}

int rec_count(uchar* a, int words){
 int i;
 int c = 0;
 for(i = 0 ; i < words ; i++){
  int n = a[i];
  while(n){
   n &= n-1;
   c++;
  }
 }
 return c;
}

uchar rec_getbit(uchar *a, int d){
 int by = d / 8;
 int bi = d % 8;
 return (a[by] & (1 << bi)) ? 1 : 0;
}

/////-----------------------
uchar *col2uchar(const Eigen::Matrix<bool, -1, -1> &in, int c){
 int words=in.rows()/8;
 uchar *o=new uchar[words];
 const bool *tb=in.col(c).data();
 uchar tc;
 for(int i=0;i<words;i++){
  o[i]=
  tb[i*8]      +
  tb[i*8+1]*2  +
  tb[i*8+2]*4  +
  tb[i*8+3]*8  +
  tb[i*8+4]*16 +
  tb[i*8+5]*32 +
  tb[i*8+6]*64 +
  tb[i*8+7]*128;
 }
 return o;
}

//////------------------------------------------------------------------
Tokusin search_ex(const Eigen::Matrix<bool, -1, -1> in, std::vector<int> &clst, int dst_in){
 struct Tokusin tok;
 int words=in.rows()/8;
 int cols=clst.size();
 int i, j;
 std::vector<uchar *> bits(cols);
 char ctmp[65535];

 for(int k=0;k<cols;k++){
  bits[k]=col2uchar(in, clst[k]);
 }
 uchar *dst = col2uchar(in, dst_in);

 std::ostringstream o_target;
 for(i = 0; i < words ; i++){
  //std::cout <<  std::hex << std::uppercase << +dst[i];
  sprintf(ctmp, "%0*X", 8 / 4, dst[i]);
  o_target << ctmp;
 }
 o_target << "\n\n";
 tok.target=o_target.str();

 std::ostringstream o_basis;
 for(i = 0; i < cols ; i++){
  sprintf(ctmp,"%c:", i+'A');
  o_basis << ctmp;
  for(j = 0; j < words ; j++){
   sprintf(ctmp, "%0*X", 8 / 4, bits[i][j]);
   o_basis << ctmp;
  }
 o_basis <<"\n";
 }
 tok.basis=o_basis.str(); 


//ワークエリア
 uchar *sol =new uchar[words];
 uchar *mask=new uchar[words];
 for(i = 0 ; i < words ; i++){
  sol[i] = 0;
 }
 int *isnot=new int[cols];

 //最適化本体
 uchar *tmp=new uchar[words];
 std::ostringstream o_expression;
 for(i = 0 ; i < words * 8 ; i++){
  //if(rec_getbit(sol, i) == 1 || rec_getbit(bits[25], i) == 0){
  if(rec_getbit(sol, i) == 1 || rec_getbit(dst, i) == 0){
   continue;
  }
  //uchar *mask= new uchar[words];
  for(j = 0 ; j < words ; j++){
   mask[j] = -1;
  }
 
  for(j = 0; j < cols ; j++){
   if(rec_getbit(bits[j],i)){
       isnot[j] = 0;
    rec_and(mask, bits[j], mask, words);
   }
   else{
       isnot[j] = 1;
    rec_not(bits[j], tmp, words);
    rec_and(mask, tmp, mask, words);
   }
  }
  int cm = rec_count(mask, words);
  rec_and(dst, mask, tmp, words);
  int cz = rec_count(tmp, words);
 
 
  if(cm*2 > cz){
   rec_or(sol, mask, sol, words);
   o_expression << "(";
   for(j = 0; j < cols ; j++){
    sprintf(ctmp,"%c%c%s", isnot[j]?'~':' ',  'A'+j,  j<(cols-1)?"&":")|\n");
    o_expression << ctmp;
   }
  }
 }

 //最適化の結果(sol)の表示

 std::ostringstream o_results;
 for(j = 0; j < words ; j++){
  //std::cout <<  std::hex << std::uppercase << +sol[j];
  sprintf(ctmp, "%0*X", 8 / 4, sol[j]);
  o_results<<ctmp;
 }
 tok.results=o_results.str();
 
 //XORをとってエラーの数を表示
 //uchar tmp[words];//仮置場
 rec_xor(dst, sol, tmp, words);
 //printf("\nErr:%d\n\n", rec_count(tmp, words));
 tok.err=rec_count(tmp, words);
 delete[] sol;
 delete[] mask;
 delete[] dst;
 for(int k=0;k<cols;k++){
  delete[] bits[k];
 }

 return tok;
}

/*
int main(void){
 Eigen::Matrix<bool,-1,-1> sample;
 sample.resize(128,128);
 sample.setRandom();
 std::vector<int> axis(10);
 for(int i=0;i<axis.size();i++){axis[i]=sample.cols()/(axis.size()+1)*i+1;}
 search_ex(sample,axis,0);
}
*/
