//統計量算出
//statistics: EMアルゴリズムを追加する
//サロゲートデータ生成とwaylandstatisticsを実装

//nloptのラッパーも入れる
//moeも使う
//区分線形のルーチン
//パーミテーションエントロピーを求めるルーチン
//相関次元の求めるルーチン
//カンツの方法を追加


#ifndef _CH_
#include "C.h"
#endif

#ifndef _CSTATH_
#define _CSTATH_

//rank計算用クラス///////////////////////////////////////////
template<class S> class Ranktmp{
 public:
 S d;
 S *p;
 unsigned int r;
};

//ランク計算用比較演算
template<class S> 
bool sortbyd(Ranktmp<S> i,Ranktmp<S> j) {return (i.d<j.d);}
template<class S> 
bool sortbyp(Ranktmp<S> i,Ranktmp<S> j) {return (i.p<j.p);}

//STATクラス/////////////////////////////////////////////////
class Statistics{
 public:
 //vectorの統計量
 double average(const std::vector<double> *);
 double variance(const std::vector<double> *);
 double sum(const std::vector<double> *);
 double stdev(const std::vector<double> *);
 double median(const std::vector<double> *);
 std::vector<unsigned int> histgram(const double, const double, const double, const std::vector<double> *);
 std::vector<double> histgramdensity(const double,const double,const double, const std::vector<double> *);
 double range(const double, const std::vector<double> *);
 double range_k(const double, const std::vector<double> *);
 void probabilitynormalize(std::vector<double> *);
 double autocorr(const std::vector<double> *, int);
 std::vector<std::vector<double> > makebootstrapdata(std::vector<double> *);
 std::pair<double,double> regression_linear(std::vector<double>*, std::vector<double>*);//回帰
 double corrcoef(std::vector<double> *, std::vector<double> *);
 template<class T> double entropy(std::vector<T> *);
 template <class T> T max(const std::vector<T> *);
 template <class T> T min(const std::vector<T> *);

 //距離
 template<class T> double kullbackleibler(std::vector<T> *, std::vector<T> *);
 double kantrovichmetric(std::vector<double> *, std::vector<double> *);
 double weightaverage(const std::vector<double> *, const int);//Lnノルム
 double norm(std::vector<double> *, std::vector<double> *, int);

 //乱数：標準ライブラリ
 double randnormal(const double);
 double randlognormal(const double, const double);
 double randt(double);
 double randf(double, double);
 double randchisq(const unsigned int);
 double randcauchy(double, double);
 double randexp(double);
 double randgamma(double,double);
 double randweibull(double, double);
 double randextreme(double, double);
 int randbinomial(int, double);
 int randnbinomial(int, double);
 int randgeometric(double);
 int randpoisson(double);
 bool randbernoulli(double);
 template<class T> int randvec(std::vector<T> *);
 double rand_piecewise_constant(std::array<double, 3> *, 
  std::array<double, 2> *);
 double rand_piecewise_linear(std::array<double, 3> *, 
  std::array<double, 3> *);

 //乱数：真空
 double randsincos(void);
 double randline(const double);
 double randsin(const double);
 double randcircle(void);

 //乱数：独自実装
 double randmaxwell(const double);
 double randinvnormal(double, double);
 double randtriangular(const double);
 double randpower(double);
 double randbeta(double, double);
 double randlogistic(void);
 std::vector<double> randmcmc(uint,uint,double,double (*)(double));
 void randdir(double *, double *, int, double);//ディリクレ

 //統計分布上の値を返す
 double valnormal(const double, const double, const double);
 double vallognormal(const double, const double, const double);

 //その他
 template<class T> std::vector<std::vector<T> > cv(std::vector<T>, double);
 template<class T> std::vector<T> freerun(std::vector<T> *, 
  std::vector<T> *, int, T (*model) (std::vector<T> *, std::vector<T> *));
 //最小自乗法
 std::vector<double> lsq(std::vector<double> *, std::vector<double> *, int);
 template<class T> std::vector<uint> rank(std::vector<T> *);//ランク
 //zscore:変化点検出:変化したところが1になるvector<int>が戻る
 std::vector<int> zscore(std::vector<double>&, int, double, double);

};

///////////////////////////////////////////////////////////////
//平均
double Statistics::average(const std::vector<double> *in){
 double out=0.;
 if(in->size()<=1){std::cout << "Error at statistics." <<std::endl;}
 out=(double)accumulate(in->begin(),in->end(),0.0);
 out=out/in->size();
 return out;
}

//Lnノルム
double Statistics::weightaverage(const std::vector<double> *in, int l){
 double out=0.;
 if(in->size()<=1){std::cout << "Error at statistics." <<std::endl;}

 for(uint i=0;i<in->size();i++){out+=pow((*in)[i],(double)l);}
 out=pow(out, 1./(double)l);
 out=out/in->size();
 return out;
};

//分散-古いバージョン
/*
double Statistics::variance(const std::vector<double> *in){
 double out=0.;
 if(in->size()<=1){std::cout << "Error at statistics." <<std::endl;}
 
 out=average(in);
 std::vector<double> sqr=(*in);
 for(std::vector<double>::iterator i=sqr.begin();i!=sqr.end();i++){
  (*i)=((*i)-out)*((*i)-out);
 }
 out=(double)accumulate(sqr.begin(),sqr.end(),0.0)/(in->size()-1);
 return out;
}
*/

//和
double Statistics::sum(const std::vector<double> *in){
 double out=0.;
 if(in->size()<=1){std::cout << "Error at statistics." <<std::endl;}
 out=(double)accumulate(in->begin(),in->end(),0.0);
 return out;
}

//分散
double Statistics::variance(const std::vector<double> *v){
 double s=sum(v);
 double m=s/v->size();
 double accum = 0.0;
 std::for_each (std::begin(*v), std::end(*v), [&](const double d) {
 accum += (d - m) * (d - m);
 });
 return accum / (v->size()-1);
}

double Statistics::stdev(const std::vector<double> *in){
 double out=0.;
 if(in->size()<=1){std::cout << "Error at statistics." <<std::endl;}
 out=variance(in);
 out=sqrt(out);
 return out;
}

//メジアン
double Statistics::median(const std::vector<double> *in){
 double out;
 std::vector<double> tmp=*in;
 sort(tmp.begin(),tmp.end());
 if(tmp.size()%2){out=tmp[tmp.size()/2];}
 else{
  out=(tmp[tmp.size()/2-1]+tmp[tmp.size()/2])/2.;
 }
 return out;
}

//ヒストグラム:単純カウント datamin=datamaxなら範囲自動設定
std::vector<unsigned int> Statistics::histgram(
        const double datamin, const double datamax, 
        const double binstep, const std::vector<double> *in){
 std::vector<unsigned int> out;
 unsigned int binsize;
 double datamintmp=datamin, datamaxtmp=datamax;

 if(datamintmp==datamaxtmp){
  datamintmp=min(in);
  datamaxtmp=max(in);
 }

 //Scott's method
 if(binstep==0.){binsize=(int)(3.5*stdev(in)*pow(in->size(),(-1./3.)));}
 else{binsize=(unsigned int)((datamaxtmp-datamintmp)/binstep)+1;}

 out.resize(binsize);
 for(unsigned int i=0;i<binsize;i++){out[i]=0;}
 uint size=in->size();
 for(uint i=0;i<size;i++){
  if((*in)[i]>=datamintmp && (*in)[i]<=datamaxtmp){
   out[int(((*in)[i]-datamintmp)/binstep)]++;
  }
 }
 return out;
}

//ヒストグラム:密度分布
std::vector<double> Statistics::histgramdensity(const double datamin, 
         const double datamax, 
         const double binstep, const std::vector<double> *in){

 std::vector<unsigned int> tmp=histgram(datamin, datamax, binstep, in);
 std::vector<double> out(tmp.size());
 for(uint i=0;i<tmp.size();i++){out[i]=(double)tmp[i]/binstep;}
 return out;
}

double Statistics::range(const double cover, const std::vector<double> *in){
//カバーする範囲のxの半値幅を返す : cover=0.95なら 例えば-2〜2→2を返す

 int halfsize=int(cover*(double)in->size()/2.);
 std::vector<double> tmp=*in;
 sort(tmp.begin(),tmp.end());
 return (tmp[tmp.size()/2+halfsize]-tmp[tmp.size()/2-halfsize])/2.;
}

double Statistics::range_k(const double k, const std::vector<double> *in){
//kで示された範囲のxの半値幅を返す
 return k*stdev(in);
}

void Statistics::probabilitynormalize(std::vector<double> *in){
 //double minval=min(in);
 //for(int i=0;i<in->size();i++){(*in)[i]-=minval;}
 double sum=accumulate(in->begin(),in->end(),0.);
 for(std::vector<double>::iterator i = in->begin(); i != in->end(); i++ ){
 (*i)/=sum;
 }
}

//自己相関 遅れn
double Statistics::autocorr(const std::vector<double> *in, int n){
 double out=0.;
 unsigned int size=in->size()-n;

 double mu=average(in);
 double sigma2=variance(in);

 for(uint i=0;i<size;i++){
 out+=(((*in)[i]-mu)*((*in)[i+n]-mu)/sigma2);
 }
 return out/size;
}

//ブートストラップのために1点抜いたデータを多数作成
std::vector<std::vector<double> > Statistics::makebootstrapdata(std::vector<double> *in){
 std::vector<std::vector<double> >out;
 out.resize(in->size());
 std::vector<double> mabiki;
 mabiki.resize(in->size()-1);
 int cnt;

 for(uint i=0;i<in->size();i++){//outloop
  cnt=0;
  for(uint j=0;j<in->size();j++){
   if(i!=j){mabiki[cnt]=(*in)[j];cnt++;}
  }
  out[i]=mabiki;
 }
 return out;
}

//回帰直線の傾き: 底上げ値はyの平均値
std::pair<double,double> Statistics::regression_linear(
 std::vector<double> *x, std::vector<double> *y){
 double avx=average(x);
 double avy=average(y);

 double tmp1=0., tmp2=0.;
 for(uint i=0;i<x->size();i++){
  tmp2+=((*x)[i]-avx)*((*x)[i]-avx);//分散
  tmp1+=((*x)[i]-avx)*((*y)[i]-avy);//共分散
 }
 double outa=tmp1/tmp2;
 double outb=avy-outa*avx;

 return std::pair<double,double>(outa,outb);
}

//相関係数
double Statistics::corrcoef(std::vector<double> *x, std::vector<double> *y){
 uint n=x->size();
 uint i;
 double sx, sy, sxx, syy, sxy, dx, dy;

 sx = sy = sxx = syy = sxy = 0;
 for (i = 0; i < n; i++) {
  sx += (*x)[i];  sy += (*y)[i];
 }
 sx /= n;  sy /= n;
 for (i = 0; i < n; i++) {
  dx = (*x)[i] - sx;  dy = (*y)[i] - sy;
  sxx += dx * dx;  syy += dy * dy;  
  sxy += dx * dy;
 }
 sxx = sqrt(sxx / (n - 1));
 syy = sqrt(syy / (n - 1));
 sxy /= (n - 1) * sxx * syy;
 return sxy;
}

//////////////////////////////////////////////////////////////////////////

//エントロピー
template<class T> double Statistics::entropy(std::vector<T> *in){
 double out=0.;
 T zero=0;
 double sumdiv=1.0/(double)accumulate(in->begin(),in->end(),zero);
 for(std::vector<double>::iterator i = in->begin(); i != in->end(); i++ ){
  out+=(-(*i)*sumdiv*log((*i)*sumdiv));
 }
 return out;
}

template<class T> double Statistics::kullbackleibler(std::vector<T> *in1,
                   std::vector<T> *in2){
 double out=0.;
 unsigned int size=in1->size();
 for(uint cnt=0;cnt<size;cnt++){
  if((*in1)[cnt]==0.){(*in1)[cnt]+=1e-100;}
  if((*in2)[cnt]==0.){(*in2)[cnt]+=1e-100;}
  out+=((*in1)[cnt]*log((double)(*in1)[cnt]/(double)(*in2)[cnt]));
 }
 return out;
}

//同じxをもつ確率変数のカントロビッチメトリックを求める
double Statistics::kantrovichmetric(std::vector<double> *in1, std::vector<double> *in2){
 unsigned int size=in1->size();
 if(size != in2->size()){
  std::cout << "Error at km. Different size of inputs" <<std::endl;exit(-1);
 }
 double out=0.;

 std::vector<double> tmp1, tmp2;
 tmp1.resize(size);
 tmp2.resize(size);
 partial_sum(in1->begin(), in1->end(), tmp1.begin());
 partial_sum(in2->begin(), in2->end(), tmp2.begin());

 for(uint i=0; i<size; i++){out+=fabs(tmp1[i]-tmp2[i]);}
 return out;
}


/////////////////////////////////////////////////////////////
//各種乱数

double Statistics::randnormal(const double sigma){//E=0, V=sigma
 //double rand1=randuniform(1), rand2=randuniform(1);
 //return (sqrt(-2.*log(rand1))*sin(2.*Pi*rand2)*sigma);
 std::normal_distribution<> d(0.0, sigma);
 return d(mt);
}

double Statistics::randchisq(const unsigned int df){
 //double out=0;
 //double tmp;
 //for(uint i=0;i<df;i++){
 // tmp=randnormal(1.);
 // out+=(tmp*tmp);
 //}
 //return out;
 std::chi_squared_distribution<> d(df);
 return d(mt);
}

double Statistics::randlognormal(const double mu, const double sd){
 //return exp(randnormal(sd)+mu);
 std::lognormal_distribution<> d(mu, sd);
 return d(mt);
};

double Statistics::randt(double df){
 //return randnormal(1.)/sqrt(randchisq(df)/(double)df);
 std::student_t_distribution<> d(df);
 return d(mt);
}

double Statistics::randsincos(void){
 double x=0.0,y=2.0;
 while(y>(2.0*cos(x)*sin(x))){x=randuniform(pi<double>()/2.);y=randuniform(2.0);}
 return x;
}

//randline y=2/in/in x
double Statistics::randline(const double in){
 double x=0,y=10;
 double indiv=1./in;
 while(y>(2.0*x*indiv*indiv)){
  x=randuniform((double)in);y=randuniform(2.0*indiv);
 }
 return x;
}

//randsin
double Statistics::randsin(const double in){
 double x=0.0,y=2.0;
 while(y>sin(x)){x=randuniform(in);y=randuniform(1.0);}
 return x;
}

//randcircle
double Statistics::randcircle(void){//-1〜1までの円形確率を返す
 double x=0.0,y=2.0;
 while(y>sqrt(1.-x*x)){x=randuniform(2.)-1.;y=randuniform(1.0);}
 return x;
}

//指数分布
double Statistics::randexp(double lambda){
 //return -log(randuniform(1.))/lambda;
 std::exponential_distribution<> d(lambda);
 return d(mt);
}

//randmaxwell
double Statistics::randmaxwell(const double T){
 double mdiv=1./4.65e-23;
 double m=4.65e-23;
 double k=1.38e-23;
 double v=0.0,y=1.0;
 double f=0;
 //v_average=sqrt(2kT/m)

 while(y>f){
  v=randuniform(5.*sqrt(2.*k*T*mdiv));y=randuniform(1.0);
  f=4.0*pi<double>()*v*v
    *pow(m/(2.0*pi<double>()*k*T),1.5)
    *exp((-m*v*v)/(2.0*k*T));
 }
 return v;
}

//randgamma: ガンマ分布
double Statistics::randgamma(double theta, double kappa ){
 std::gamma_distribution<> d(theta, kappa);
 return d(mt);

/*
  int int_kappa;
  double frac_kappa;

  int_kappa  = (int)kappa;
  frac_kappa = kappa - (double)int_kappa;
  
  double u,uu;
  double b,p,x_frac,x_int;
  int i;
  
  //Int
  x_int=0;
  for(i=0;i<int_kappa;i++){
    x_int+=randexp(1.);
  }
  
  //Frac
  if( fabs(frac_kappa) < 0.01 ) x_frac=0;
  
  else{
    b=(exp(1.0)+frac_kappa)/exp(1.0);
    while(1){
    u=randuniform(1.);
    p=b*u;
    
    uu=randuniform(1.);
    
    if(p<=1.0){
      x_frac=pow(p,1.0/frac_kappa);
      if(uu<=exp(-x_frac)) break;
    }
    
    else{
      x_frac=-log((b-p)/frac_kappa);
      if(uu<=pow(x_frac,frac_kappa-1.0)) break;
    }
    
    }
  }
  
  return (x_int+x_frac)*theta;
*/
}

//randgamma_old: ガンマ分布 （旧） mean=1 fixed

//double Statistics::randgamma_old(double a){
// double x, y, z;
// double u, v, w, b, c, e;
// int accept = 0;
// if (a < 1){
//  /* a < 1. Johnk's generator. Devroye (1986) p.418 */
//  e = randexp(1.);
//  do {
//   x = pow(randuniform(1.), 1 / a);
//   y = pow(randuniform(1.), 1 / (1 - a));
//  } while (x + y > 1);
//  return (e * x / (x + y));
// } else {
//  /* a >= 1. Best's rejection algorithm. Devroye (1986) p.410 */
//  b = a - 1;
//  c = 3 * a - 0.75;
//  do {
//   /* generate */
//   u = randuniform(1.);
//   v = randuniform(1.);
//   w = u * (1 - u);
//   y = sqrt(c / w) * (u - 0.5);
//   x = b + y;
//   if (x >= 0)
//   {
//    z = 64 * w * w * w * v * v;
//    if (z <= 1 - (2 * y * y) / x)
//    {
//     accept = 1;
//    } else {
//     if (log(z) < 2 * (b * log(x / b) - y))
//      accept = 1;
//    }
//   }
//  } while (accept != 1);
//  return x;
// }
//}

/*
ディリクレ分布からサンプルする場合は, 上の dirrand を使って, double *theta, *alpha をアロケートしてから,
dirrand(theta, alpha, k, 0);
とすれば theta に Dir(alpha) からのサンプルが得られます。最後の引数はディリクレ分布を中心 α/Σ(α) と精度 Σ(α) に分解してサンプリングする時に, 精度(中心への集中の度合い)を調整できるようにするためのパラメータ. 
*/

//ディリクレ分布
void Statistics::randdir (double *theta, double *alpha, int k, double prec){
 double z = 0;
 int i;
 /* theta must have been allocated */
 for (i = 0; i < k; i++)
  if (prec != 0)
   theta[i] = randgamma(1, alpha[i] * prec);
  else
   theta[i] = randgamma(1, alpha[i]);
 for (i = 0; i < k; i++)
  z += theta[i];
 for (i = 0; i < k; i++)
  theta[i] /= z;
}

//コーシー分布
double Statistics::randcauchy(double mu, double gamma){
 //return mu + gamma*tan(Pi*( randuniform(1.)-0.5 ));
 //位置母数mu、尺度母数gamma
 std::cauchy_distribution<> d(mu, gamma);
 return d(mt);
};

//逆正規分布
double Statistics::randinvnormal(double mu, double lambda ){
  double y,w,z;
  y=randchisq(1);
  w= mu+0.5*y*mu*mu/lambda -(0.5*mu/lambda)*sqrt(4.0*mu*lambda*y+mu*mu*y*y); 
  z=randuniform(1.);
  if( z< mu/(mu+w) )  return w;
  else      return mu*mu/w;
}

//三角分布
double Statistics::randtriangular(const double mul){
 return (randuniform(1.)-randuniform(1.))*mul;
}

//累乗分布
double Statistics::randpower(double n){
 return pow(randuniform(1.), n);
}

//β分布
double Statistics::randbeta(double a, double b){
 double x, y;
 do {
  x = pow(randuniform(1.), 1 / a);  y = pow(randuniform(1.), 1 / b);
 } while (x + y > 1);
 return x / (x + y);
}

//logistic分布
double Statistics::randlogistic(void){
 double r;
 r = randuniform(1.);
 return log(r / (1 - r));
}

//F分布
double Statistics::randf(double n1, double n2){
 //return (randchisq(n1) * n2) / (randchisq(n2) * n1);
 std::fisher_f_distribution<> d(n1, n2);
 return d(mt);
}

//ワイブル分布
double Statistics::randweibull(double alpha, double beta){
 std::weibull_distribution<> d(alpha, beta);
 return d(mt);
 //return pow(-log(1 - randuniform(1.)), 1 / alpha);
}

//極値分布
double Statistics::randextreme(double alpha, double beta){
 std::extreme_value_distribution<> d(alpha, beta);
 return d(mt);
}

//randvec: std::vectorで与えられた関数に従って乱数発生
template<class T> int Statistics::randvec(std::vector<T> *in){
 std::discrete_distribution<std::size_t> d(
  in->begin(),
  in->end()
 );
 return d(mt);

 //maxinが0でないならそれを優先する
 /*
 double max;
 if(maxin==0.0){max=*max_element(in->begin(), in->end())*1.1;}
 else{max=maxin;}
 
 int x=0;
 double y=max;
 
 while(y>(double)((*in)[x])){
  x=(int)randuniform((double)in->size());
  y=randuniform(max);
 }
 return x;
 */
}

//定数分布
//[0.0, 5.0)の値は、0.3の確率で出現する。
//[5.0, 10.0)の値は、0.5の確率で出現する。
//std::array<double, 3> intervals = {0.0, 5.0, 10.0},
//std::array<double, 2> densities = {0.3, 0.5};
double Statistics::rand_piecewise_constant(
 std::array<double, 3> *n1, 
 std::array<double, 2> *n2){
 std::piecewise_constant_distribution<> d(
  n1->begin(),
  n1->end(),
  n2->begin()
 );
 return d(mt);
}

//線形上昇加工分布
//[0.0, 5.0)の値は、出現確率が0.0から0.5まで線形に上昇する。
//[5.0, 10.0)の値は、出現確率が0.5から0.1まで線形に減少する。
//std::array<double, 3>
//intervals = {0.0, 5.0, 10.0},
//densities = {0.0, 0.5,  0.1};
double Statistics::rand_piecewise_linear(
 std::array<double, 3> *n1, 
 std::array<double, 3> *n2){
 std::piecewise_linear_distribution<> d(
  n1->begin(),
  n1->end(),
  n2->begin()
 );
 return d(mt);
}

//Poisson (ポアソン) 分布
int Statistics::randpoisson(double lambda){
 std::poisson_distribution<> d(lambda);
 return d(mt);
/*
 int k;
 lambda = exp(lambda) * randuniform(1.);
 k = 0;
 while (lambda > 1) {
 lambda *= randuniform(1.);  k++;
 }
 return k;
*/
}

//幾何分布
int Statistics::randgeometric(double p){
 //return ceil(log(1 - randuniform(1.)) / log(1 - p));
 std::geometric_distribution<> d(p);
 return d(mt);
}

//ベルヌーイ分布
bool Statistics::randbernoulli(double p){
 std::bernoulli_distribution d(p);
 return d(mt);
}

//二項分布
int Statistics::randbinomial(int n, double p){
 //int r = 0;
 //for(uint i = 0; i < n; i++){if (randuniform(1.) < p) r++;}
 //return r;
 std::binomial_distribution<> d(n, p);
 return d(mt);
}

//負の二項分布
int Statistics::randnbinomial(int n, double p){
 std::negative_binomial_distribution<> d(n, p);
 return d(mt);
}



//MCMCを使った乱数系列の出力
std::vector<double> Statistics::randmcmc(uint n, uint burn, double sigma, double (*f)(double)){
Statistics s;
 std::vector<double> data(n-burn);
 double x=randuniform(1.)-0.5, xnew;

 for(uint i=0;i<n;i++){
  xnew=s.randnormal(sigma)+x;
  if(f(xnew)/(f(xnew)+f(x))>randuniform(1.)){x=xnew;}
  if(i>burn){data[i-burn]=x;}
 }
 return data;
}



////////////////////////////////////////////////////////////////////
//値の出力

double Statistics::valnormal(
 const double mu, double sigma, const double x){
 return 1./sqrt(2.*pi<double>())/sigma*exp(-(x-mu)*(x-mu)/(2.*sigma*sigma));
};

double Statistics::vallognormal(
 const double mu, double sigma, const double x){
 return 1./sqrt(2.*pi<double>())/sigma/x
    *exp((-(log(x)-mu)*(log(x)-mu)/(2.*sigma*sigma)));
};


////////////////////////////////////////////////////////////////////

//クロスバリデーション：vectorをレートに従ってランダムに二つに分ける
template <class T>
std::vector<std::vector<T> > Statistics::cv(std::vector<T> in, double rate){
 std::vector<T> out1((uint)(in.size()*rate)), out2(in.size()-out1.size());
 random_shuffle(in.begin(),in.end());
 for(uint i=0;i<out1.size();i++){out1[i]=in[i];}
 for(uint i=0;i<out2.size();i++){out2[i]=in[i+out1.size()];}
 std::vector<std::vector<T> > out(2);
 out[0]=out1;
 out[1]=out2;
 return out;
}

//L_nノルムを計算する
double Statistics::norm(std::vector<double> *in1, std::vector<double> *in2, int n){
 if(in1->size()!=in2->size()){std::cout << "Error at norm." <<std::endl;exit(-1);}
 if(n<1){std::cout << "Error at norm." <<std::endl;exit(-1);}

 uint size=in1->size();
 double l=0;
 for(uint i=0;i<size;i++){
  l+=pow((*in1)[i]-(*in2)[i],n);
 }
 return pow(l, 1./n);
};

//フリーラン
template<class T>
std::vector<T> Statistics::freerun(std::vector<T> *coff, std::vector<T> *init, 
         int len, 
         T (*model) (std::vector<T> *, std::vector<T> *)){
 std::vector<T> out(len);
 std::vector<T> inittmp=(*init);
 
 for(uint i=0;i<len;i++){
  out[i]=(*model)(coff,&inittmp);
  //if(out[i]>9e99){out[i]=9e99;}
  rotate(inittmp.begin(), inittmp.begin()+1, inittmp.end());
  inittmp[inittmp.size()-1]=out[i];
 }
 return out;
}

//以下freerunのサンプル
/*
#include "C.h"
#include "C-statistics.h"

double logistic(std::vector<double> *coef, std::vector<double> *init){
 double x=(*init)[0];
 return (*coef)[0] *x*(1.-x);
}

int main(){
 C c;
 Statistics s;
 std::vector<double> init(1);
 init[0]=0.1;
 std::vector<double> coef(1);
 coef[0]=3.8;

 std::vector<double> kekka=s.freerun(&coef, &init, 30, &logistic);
 c.std::vectoroutv(std::cout, &kekka);
 return 0;
}
*/

//n次最小二乗法(吐き出し法利用)：xはソートされていること
//データ列x,y, 多項式の次数Nを与える: 定数項から高次の順に係数を返す
std::vector<double> Statistics::lsq(std::vector<double> *x, std::vector<double> *y, int N){
 unsigned int n=N+1;
 unsigned int S=x->size();
 unsigned int T=y->size();
 if(S != T){std::cout << "Error at lsq" << std::endl; exit(-1);}
 std::vector<double> out(n);
 std::vector<std::vector<double> >A(n);
 for(uint i=0;i<n;i++){A[i].resize(n+1,0.0);}

 //初期行列作成
 for(uint i=0;i<n;i++) {
  for(uint j=0;j<n;j++) {
   for(uint k=0;k<S;k++) {
    A[i][j]+=pow((*x)[k],i+j);
   }
  }
 }

 for(uint i=0;i<n;i++) {
  for(uint k=0;k<S;k++) {
   A[i][n]+=pow((*x)[k],i)*(*y)[k];
  }
 }

 //吐き出し法
 uint pivot;
 double p,q,m,b[1][n+1];

 for(uint i=0;i<n;i++){
  m=0;
  pivot=i;
  for(uint l=i;l<n;l++) {
   if(fabs(A[l][i])>m) { //i列の中で一番値が大きい行を選ぶ
    m=fabs(A[l][i]);
    pivot=l;
   }
  }
  if(pivot!=i) {     //pivotがiと違えば、行の入れ替え
   for(uint j=0;j<n+1;j++) {
    b[0][j]=A[i][j]; 
    A[i][j]=A[pivot][j];
    A[pivot][j]=b[0][j];
   }
  }
 }
 for(uint k=0;k<n;k++) {
  p=A[k][k];   //対角要素を保存
  A[k][k]=1;   //対角要素は１になることがわかっているから
  for(uint j=k+1;j<n+1;j++) {
   A[k][j]/=p;
  }
  for(uint i=k+1;i<n;i++) {
   q=A[i][k];
   for(uint j=k+1;j<n+1;j++) {
    A[i][j]-=q*A[k][j];
   }
  A[i][k]=0;   //０となることがわかっているところ
  }
 }

 //解の計算
 for(uint i=n-1;i>=0;i--) {
  out[i]=A[i][n];
  for(uint j=n-1;j>i;j--) {
   out[i]-=A[i][j]*out[j];
  }
 }
 return out;
}

//順位を出す: std::vector<uint> kekka=rank(&in);
template<class T> std::vector<uint> rank(std::vector<T> *in){
 std::vector<Ranktmp<T> > tmp(in->size());
 for(uint i=0;i<in->size();i++){
  tmp[i].d=(*in)[i];
  tmp[i].p=&((*in)[i]);
 }
 sort(tmp.begin(), tmp.end(),sortbyd<T>);
 for(uint i=0;i<in->size();i++){
  tmp[i].r=i;
 }
 sort(tmp.begin(), tmp.end(),sortbyp<T>);
 std::vector<uint> out(in->size());
 for(uint i=0;i<in->size();i++){
  out[i]=tmp[i].r;
 }
 return out;
}

template <class T> T Statistics::max(const std::vector<T> *in){
  return *max_element(in->begin(), in->end());
}

template <class T> T Statistics::min(const std::vector<T> *in){
 return *min_element(in->begin(), in->end());
}

std::vector<int> Statistics::zscore(std::vector<double> &input, int lag, double threshold, double influence){
 //smoothed_zscore(in, 5, 3.5, .5);
 //lag: the smoothing functions
 //threshold: typically standard deviations for signal
 //influence: [0,1], 1=normal 0.5=half

 if(input.size()<=(size_t)lag+2){
  std::vector<int> emptyVec;
  return emptyVec;
 }

 if(threshold<0.00001){threshold=stdev(&input);}
 if(influence<0.00001){influence=0.5;}

 std::vector<int> signals(input.size(), 0.0);
 std::vector<double> filteredY(input.size(), 0.0);
 std::vector<double> avgFilter(input.size(), 0.0);
 std::vector<double> stdFilter(input.size(), 0.0);
 std::vector<double> subVecStart(input.begin(), input.begin()+ lag);
 avgFilter[lag] = average(&subVecStart);
 stdFilter[lag] = stdev(&subVecStart);

 for(size_t i = lag + 1; i < input.size(); i++){
  if(std::abs(input[i] - avgFilter[i - 1])> threshold * stdFilter[i - 1]){
   if(input[i] > avgFilter[i - 1]){
    signals[i] = 1; //# Positive signal
   }
   else{
    signals[i] = -1; //# Negative signal
   }
   //Make influence lower
   filteredY[i] = influence* input[i] +(1 - influence)* filteredY[i - 1];
  }
  else{
   signals[i] = 0; //# No signal
   filteredY[i] = input[i];
  }
  //Adjust the filters
  std::vector<double> subVec(filteredY.begin()+ i - lag, filteredY.begin()+i);
  avgFilter[i] = average(&subVec);
  stdFilter[i] = stdev(&subVec);
 }
 return signals;
}





//////////////////////////////////////////////////////////

#endif

//カイ２乗分布
//double chisq_randuniform(double n){
// return 2.*randgamma(0.5 * n);
//}
