#ifndef _CH_
#include "C.h"
#endif

#ifndef _CSTATH_
#include "C-stat.h"
#endif


#ifndef _CSETCHAOSH_
#define _CSETCHAOSH_

///////////////////////////////////////////
//遅れ時間多項式のための項の列挙：総数は\sum_{n=1}^N (n+1)(n+2)/2
//src: 数値の種類, tmp: 一つの項の数 呼び出し: rekkyo(0,0,&src,&tmp,&out);

void rekkyo(int now, int loc, std::vector<double> *src, std::vector<double> *tmp, std::vector<std::vector<double> >*out){
 if(loc==tmp->size()){out->push_back(*tmp);return;}
 for(int i=now;i< src->size();i++){
  (*tmp)[loc]=(*src)[i];
  rekkyo(i, loc+1, src, tmp, out);
 }
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
///差分を返す std::vector版
std::vector<double> sabun(std::vector<double> &in){
 std::vector<double> o;
 o.resize(in.size()-1);
 adjacent_difference(in.begin(), in.end(), o.begin());
 return o;
}

/// カオス時系列をセットする関数群
std::vector<double> setchaos_logistic(int size , double A, double startx){
 std::vector<double> X(size);
 X[0]=startx;
 for(int i=1;i<size;i++){
  X[i]=A*X[i-1]*(1.-X[i-1]);
 }
 return X;
}

std::vector<double> setchaos_henon(int size , 
 double A, double B, double startx, double starty){
 std::vector<double> X(size);
 X[0]=startx;
 double Y=starty;
 for(int i=1;i<size;i++){
  X[i] = 1.-A*X[i-1]*X[i-1]+B*Y;
  Y=X[i];
 }
 return X;
}

std::vector<double> setchaos_tbmap( int size , 
 double A, double B, double C, double D, double startx, double starty){
 std::vector<double> X(size);
 X[0]=startx;
 double Y=starty;
 for(int i=1;i<size;i++){
  X[i]=X[i-1]*X[i-1] - Y*Y + A*X[i-1] + B*Y;
  Y=2.0*X[i]*Y + C*X[i] + D*Y;
 }
 return X;
}

std::vector<double> setchaos_tentmap( int size , 
 double startx){
 std::vector<double> X(size);
 X[0]=startx;
 for(int i=1;i<size;i++){
  if(X[i-1]<0.5){X[i]=1.999999999*X[i-1];}
  else{X[i]=1.999999999*(1.-X[i-1]);}
 }
 return X;
}

std::vector<double> setchaos_lorentz( int size , 
 double p, double r, double b, double dt, 
 double startx, double starty, double startz){

 std::vector<double> X(size);
 X[0]=startx;
 double Y=starty;
 double Z=startz;
 double dx, dy, dz;
 for(int i=1;i<size;i++){
  dx=(p*Y-p*X[i-1])*dt;
  dy=(r*X[i-1]-Y-X[i-1]*Z)*dt;
  dz=(X[i-1]*Y-b*Z)*dt;
  X[i]=X[i-1]+dx;
  Y+=dy;
  Z+=dz;
 }
 return X;
}

std::vector<double> setchaos_rossler(int size , 
 double A, double B, double C, double dt, 
 double startx, double starty, double startz){

 //A=0.15, B=0.2, C=10, dt=0.05

 std::vector<double> X(size);
 X[0]=startx;
 double Y=starty;
 double Z=startz;
 double dx, dy, dz;
 for(int i=1;i<size;i++){
  dx=(-Y-Z)*dt;
  dy=(X[i-1]+A*Y)*dt;
  dz=(B+Z*(X[i-1]-C))*dt;
  X[i]=X[i-1]+dx;
  Y+=dy;
  Z+=dz;
 }
 return X;
}

std::vector<double> setchaos_circle(int size , double scale, double start){
 std::vector<double> X;
 X.resize(size);
 double t=start;
 for(int i=0;i<size;i++){
  t=sqrt((1.-(t-0.5)*(t-0.5)/0.25)*scale*scale);
  X[i]=t;
 }
 return X;
}

///正弦波
std::vector<double> setlinear_sine(int size , double dt){
 std::vector<double> X(size);
 double t=0;
 for(int i=0;i<size;i++){
  X[i]=sin(t);
  t+=dt;
 }
 return X;
}

///トーラス
std::vector<double> setlinear_torus(int size , int xyz, double A, double B, double dt, double ds){
//A=0.05, B=0.8, dt=(0.001)*3.141592*2, ds=10*dt

/*
 if(A ==0.){A=0.05;}
 if(B ==0.){B=0.8;}
 if(dt==0.){dt=(0.001)*3.141592*2.;}
 if(ds==0.){ds=10.*dt;}
*/

 std::vector<double> X(size);
 double t=0., s=0., x, y, z;
 for(int i=0;i<size;i++){
  x=(A*cos(s)+B)*cos(t);
  y=(A*cos(s)+B)*sin(t);
  z=A*sin(s);
  if(xyz==0){X[i]=x;}else
  if(xyz==1){X[i]=y;}else
  if(xyz==2){X[i]=z;}
  t+=dt;
  s+=ds;
 }
 return X;
}

std::vector<double> setlinear_ar_simple(int size, double k, double r, double init){
 Statistics s;
 std::vector<double> X(size);
 double tmp=init;
 X[0]=tmp;
 for(int i=1;i<size;i++){
  X[i]=k*X[i-1]+s.randnormal(r);
 }
 return X;
}

std::vector<double> setlinear_ar2(int size , std::vector<double> &co, std::vector<double> &init){
 std::vector<double> X(size);
 std::vector<double> t;
 t=init;
 double tmp;

 for(int i=0;i<size;i++){
  tmp=0.;
  for(int k=0;k<co.size();k++){tmp+=co[k]*t[k];}
  for(int k=1;k<co.size();k++){t[k]=t[k-1];}
  X[i]=t[0]=tmp;
 }
 return X;
}


std::vector<double> setrandom(int size){
 std::vector<double> X(size);
 for(int i=0;i<size;i++){
  X[i]=randuniform(1.0);
 }
 return X;
}


std::vector<double> setrandom_normal(int size, double std){
 Statistics s;
 double tmp;
 std::vector<double> X;
 while(X.size()<size){
  tmp=s.randnormal(std)+0.5;
  if(tmp < 1. && tmp > 0.){X.push_back(tmp);}
 }
 return X;
}

#endif
