#include "../.c/C.h"
#include <png++/png.hpp>
#include "../.c/C-eigen.h"
#include "../.c/C-setchaos.h"
#include "../.c/C-tokusin.h"
#include "../.c/C-zlib.h"

class Node{
 public:
 int myid;
 std::vector<int> to;
 std::vector<double> w;
};

using Graph = std::vector<Node>;



//縦軸上下反転してPNGに
void save_rec_png(Eigen::Matrix<bool,-1,-1> *in, std::string fn){
 png::image<png::rgb_pixel> image(in->cols(),in->rows());
 for(int x=0;x<image.get_width();x++){
  for(int y=0;y<image.get_height();y++){
  if((*in)(x,y)==true){image.set_pixel(x,in->rows()-y-1,png::rgb_pixel(0,0,0));}
   else{image.set_pixel(x,in->rows()-y-1,png::rgb_pixel(255,255,255));}
  }
 }
 image.write(fn);
}

//リカレンスプロットの上三角部分を文字列にして圧縮率を計算する
double compressrate(Eigen::Matrix<bool,-1,-1> &in){
 //std::string t((in.cols()-1)*(in.cols()-1)/2);
 std::string t;
 for(int i=1;i<in.cols();i++){
 for(int j=i;j<in.rows();j++){
  if(in(i,j)==true){t+="1";}else{t+="0";}
 }std::cout << t << "\n";}
 return double(zlib_compress(&t))/double(in.cols());
}



//FFT的基底のための行列を作る
Eigen::Matrix<bool,-1,-1> make_kitei_stripe_startfix(int size){
 Eigen::Matrix<bool,-1,-1> o;
 double t;
 o.resize(size,size);
 for(int j=0;j<o.cols();j++){
  for(int i=0;i<o.rows();i++){
   t=cos(double(i/2.)*(j+1)*2.*pi<double>()/double(size));
   if(t>0){o(j,i)=true;}else{o(j,i)=false;}
  }
 }
 return o;
}


Eigen::Matrix<bool,-1,-1> make_kitei_stripe_startrandom(int size){
Eigen::Matrix<bool,-1,-1> o;
 double t;
 double add;
 o.resize(size,size);
 for(int j=0;j<o.cols();j++){
   add=randuniform(double(size));
   for(int i=0;i<o.rows();i++){
      t=cos(add+(double(i/2.)*(j+1))*2.*pi<double>()/double(size));
      if(t>0){o(j,i)=true;}else{o(j,i)=false;}
   }
 }
 return o;
}




Eigen::Matrix<bool,-1,-1> make_kitei_random(int size){
 Eigen::Matrix<bool,-1,-1> o;
 o.resize(size,size);
 for(int j=0;j<o.cols();j++){
 for(int i=0;i<o.rows();i++){
  if(randuniform(1.)>0.5){o(j,i)=true;}else{o(j,i)=false;}
 }}
 return o;
}



//TokusiN法で演算が構成できなかった割合
double error_rate(Eigen::Matrix<bool,-1,-1> &rec, int axis_n, int iterate){
 std::vector<Tokusin> tok(iterate);
 std::vector<int> rec_tmp(rec.cols());
 for(int i=0;i<rec.cols();i++){rec_tmp[i]=i;}
 std::vector<int> axis(axis_n);
 int target, err;

 for(int iter=0;iter<iterate;iter++){
  std::random_shuffle(rec_tmp.begin(),rec_tmp.end());
  for(int i=0;i<axis.size();i++){axis[i]=rec_tmp[i];}
  target=randuniform(static_cast<int>(rec.cols())-2);
  tok[iter]=search_ex(rec,axis,1+target);
 }
 
 double sum_err=0.;
 for(int i=0;i<tok.size();i++){sum_err+=tok[i].err;}
 return sum_err/tok.size();
}

//深さ優先探索本体
void dfs(const Graph &G, int v, std::vector<bool> *seen) {
 (*seen)[v] = true;
 for (auto e : G[v].to) {
  if (!((*seen)[e])) { // 訪問済みでなければ探索
   dfs(G, e, seen);
  }
 }
}

//単連結の個数を数える
int count_renketu(int n, std::vector<std::pair<int,int>> *in){//n:ノード数
 int m=in->size();//エッジ数
 Graph G(n);
 for(int i=0;i<n;i++){G[i].myid=i;}
 for (int i = 0; i < m; i++) {
  int a=(*in)[i].first;
  int b=(*in)[i].second;
  G[a].to.push_back({b});G[a].w.push_back(1.);
  G[b].to.push_back({a});G[b].w.push_back(1.);
 }

 std::vector<bool> seen;
 seen.assign(n, false); // 初期化
 int cnt=0;
 for (int i=0; i<n; i++) {
  if (!seen[i]) {
   dfs(G, i, &seen);
   cnt++; // dfsした回数をカウント
  }
 }
 return cnt;
}

//点の値が近いペアであればそれを配列に加える
void add_pairs(std::vector<double> &tm, double val, std::vector<std::pair<int,int>> *pairs, double recrate){
 for(int c=0;c<tm.size();c++){
  if(abs(tm[c]-val)<recrate){
   pairs->push_back({c,tm.size()});
   pairs->push_back({tm.size(),c});
  }
 }
}

