#!/usr/bin/gnuplot
set terminal png size 1800,1000 truecolor
#set title 'Number of red blood cells (F)' font "Arial,55"
#set title offset 0,2
set output '../ict-fig7.png'
set style data lines
set boxwidth 0.7 relative
set style fill solid border lc rgb '#00000'

set tics font "Arial,35"
set xtics offset 0,-2
set ytics offset 0,-1
set mytics 5

set border lw 4
set xlabel font "Arial,40"
set ylabel font "Arial,40"
set ylabel "Number of errors / length"
set xlabel "Length of time series"
set ylabel offset -4,0
set xlabel offset 0,-3

set logscale x

set key right bottom
set key font "Arial,30"
# set key spacing 3
#set key offset 0 -1
#set pointsize 4

set lmargin 16
set rmargin 8
#set bmargin 10
#set tmargin 10

set xrange [100:10000]
set yrange [0:0.1]

set samples 100000

EXP(x,l,a,y)=(x <= 0) ? 1/0 : a*exp(-l*x)+y

plot \
"./.ict-fig7-logistic.csv" with points pt 7 ps 2 lc rgb '#00ff00' title "Logistic", \
EXP(x,0.00442597,-0.05110745,0.04978972)  with lines dt (6,3) lw 3 lc rgb '#00ff00' notitle, \
"./.ict-fig7-random.csv" with points pt 7 ps 2 lc rgb '#ff0000' title "Random", \
EXP(x,0.003585153,-0.0739878,0.0864759)  with lines dt (6,3) lw 3 lc rgb '#ff0000' notitle, \
"./.ict-fig7-sine.csv" with points pt 7 ps 2 lc rgb '#0000ff' title "Sine", \
EXP(x,0.004264493,-0.02038409,0.03245826)  with lines dt (6,3) lw 3 lc rgb '#0000ff' notitle, \
"./.ict-fig7-ar.csv" with points pt 7 ps 2 lc rgb '#ff00ff' title "AR", \
EXP(x,0.01052579,-0.05328867,0.04290086)  with lines dt (6,3) lw 3 lc rgb '#ff00ff' notitle
