#!/usr/bin/gnuplot
set terminal png size 1800,1000 truecolor
#set title 'Number of red blood cells (F)' font "Arial,55"
#set title offset 0,2
set output '../ict-fig7-0.05.png'
set style data lines
set boxwidth 0.7 relative
set style fill solid border lc rgb '#00000'

set tics font "Arial,35"
set xtics offset 0,-2
set ytics offset 0,-1
set mytics 5

set border lw 4
set xlabel font "Arial,40"
set ylabel font "Arial,40"
set ylabel "Number of errors / length"
set xlabel "Length of time series"
set ylabel offset -4,0
set xlabel offset 0,-3

set logscale x

set key right top
set key font "Arial,40"
# set key spacing 3
#set key offset 0 -1
#set pointsize 4

set lmargin 16
set rmargin 8
#set bmargin 10
#set tmargin 10

set xrange [100:10000]
set yrange [0:0.1]

set samples 100000

EXP(x,l,a,y)=(x <= 0) ? 1/0 : a*exp(-l*x)+y

plot \
"./.ict-fig7-0.05-logistic.csv" with points pt 7 ps 2 lc rgb '#00ff00' title "Logistic", \
EXP(x,0.004252061,-0.02739899,0.03071658)  with lines dt (6,3) lw 3 lc rgb '#00ff00' notitle, \
"./.ict-fig7-0.05-random.csv" with points pt 7 ps 2 lc rgb '#ff0000' title "Random", \
EXP(x,0.003557336,-0.02728014,0.03531824)  with lines dt (6,3) lw 3 lc rgb '#ff0000' notitle, \
"./.ict-fig7-0.05-sine.csv" with points pt 7 ps 2 lc rgb '#0000ff' title "Sine", \
EXP(x,0.005365151,-0.01861395,0.02323555)  with lines dt (6,3) lw 3 lc rgb '#0000ff' notitle, \
"./.ict-fig7-0.05-ar.csv" with points pt 7 ps 2 lc rgb '#ff00ff' title "AR", \
EXP(x,0.004690237,-0.02543567,0.03245402)  with lines dt (6,3) lw 3 lc rgb '#ff00ff' notitle
