#!/usr/bin/gnuplot
set terminal png size 1800,1000 truecolor
#set title 'Number of red blood cells (F)' font "Arial,55"
#set title offset 0,2
set output '../ict-fig6.png'
set style data lines
set boxwidth 0.7 relative
set style fill solid border lc rgb '#00000'

set tics font "Arial,35"
set xtics offset 0,-2
set ytics offset 0,-1
set mytics 5

set border lw 4
set xlabel font "Arial,40"
set ylabel font "Arial,40"
set ylabel "Error rate"
set xlabel "Number of elements for a basis"
set ylabel offset -4,0
set xlabel offset 0,-3


set key right top
set key font "Arial,40"
#set key offset 0 -1
#set pointsize 4

set lmargin 15
#set rmargin 4
#set bmargin 10
#set tmargin 10

set xrange [0:50]
set yrange [0:1]

set samples 100000

EXP(x,l,a,y)=(x <= 0) ? 1/0 : a*exp(-l*x)+y


plot \
"./.ict-fig6-logistic.csv" with points pt 7 ps 2 lc rgb '#00ff00' title "Logistic", \
EXP(x,0.1174124,0.8859409,0.01537731)  with lines dt (6,3) lw 3 lc rgb '#00ff00' notitle, \
"./.ict-fig6-random.csv" with points pt 7 ps 2 lc rgb '#ff0000' title "Random", \
EXP(x,0.08721708,0.9869793,0.002099181)  with lines dt (6,3) lw 3 lc rgb '#ff0000' notitle, \
"./.ict-fig6-sine.csv" with points pt 7 ps 2 lc rgb '#0000ff' title "Sine", \
EXP(x,0.1156821,0.9618646,0.0002671484)  with lines dt (6,3) lw 3 lc rgb '#0000ff' notitle, \
"./.ict-fig6-ar.csv" with points pt 7 ps 2 lc rgb '#ff00ff' title "AR", \
EXP(x,0.1488867,0.8993725,0.02152527)  with lines dt (6,3) lw 3 lc rgb '#ff00ff' notitle

## dexp3,19.35202,34.64674,66.03255,!,356120.3,0,98 NA,

