#!/usr/bin/gnuplot
set terminal png size 1800,1000 truecolor
#set title 'Number of red blood cells (F)' font "Arial,55"
#set title offset 0,2
set output '../ict-fig4.png'
set style data lines
set boxwidth 0.7 relative
set style fill solid border lc rgb '#00000'

set tics font "Arial,35"
set xtics offset 0,-2
set ytics offset 0,-1
set mytics 5

set border lw 4
set xlabel font "Arial,40"
set ylabel font "Arial,40"
set xlabel "Time"
set ylabel "Value"
set ylabel offset -4,0
set xlabel offset 0,-3


set key left top
set key font "Arial,40"
#set key offset 0 -1
#set pointsize 4

#set lmargin 25
#set rmargin 4
#set bmargin 10
#set tmargin 10

SIN(x)=0.5*sin(13*x)*cos(19*x)*sin(17*x*x)*cos(11*x*x)+0.5

set xrange [0:2]
set yrange [0:1]

set samples 100000
  

plot \
"./.ict-fig4-g.dat" with points pt 7 ps 2 lc rgb '#00ff00' title "0.3-0.35", \
"./.ict-fig4-r.dat" with points pt 7 ps 2 lc rgb '#ff0000' title "0.4-0.45", \
"./.ict-fig4-b.dat" with points pt 7 ps 2 lc rgb '#0000ff' title "0.5-0.55", \
SIN(x) with lines dt (6,3) lw 3 lc rgb '#000000' notitle
