#!/usr/bin/gnuplot
set terminal png size 1800,1000 truecolor
#set title 'Number of red blood cells (F)' font "Arial,55"
#set title offset 0,2
set output '../ict-fig10.png'
set style data lines
set boxwidth 0.7 relative
set style fill solid border lc rgb '#00000'

set tics font "Arial,35"
set xtics offset 0,-2
set ytics offset 0,-1
set mytics 5

set border lw 4
set xlabel font "Arial,40"
set ylabel font "Arial,40"
set ylabel "Number of errors / length"
set xlabel "Recurrence rate"
set ylabel offset -4,0
set xlabel offset 0,-3

set logscale xy

set key right top
set key font "Arial,40"
#set key spacing 3
#set key offset 0 -1
#set pointsize 4

set lmargin 16
set rmargin 8
#set bmargin 10
#set tmargin 10

set xrange [0.01:1]
set yrange [0.001:1]

set samples 100000

EXP(x,l,a,y)=(x <= 0) ? 1/0 : a*exp(-l*x)+y

# EXP(x,0.0889052,500.0149,3.24176)  with lines dt (6,3) lw 3 lc rgb '#00ff00' notitle, \
# EXP(x,0.0889052,500.0149,3.24176)  with lines dt (6,3) lw 3 lc rgb '#ff0000' notitle, \
# EXP(x,0.1157768,463.5166,0.02276955)  with lines dt (6,3) lw 3 lc rgb '#0000ff' notitle



plot \
"./.ict-fig10-logistic.csv" with points pt 7 ps 2 lc rgb '#00ff00' title "Logistic", \
"./.ict-fig10-random.csv" with points pt 7 ps 2 lc rgb '#ff0000' title "Random", \
"./.ict-fig10-sine.csv" with points pt 7 ps 2 lc rgb '#0000ff' title "Sine", \
"./.ict-fig10-ar.csv" with points pt 7 ps 2 lc rgb '#ff00ff' title "AR"
