/*
 * Decompiled with CFR 0.152.
 */
package multiSNPLD;

import Tool.FileTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import multiSNPLD.HaploTools;
import multiSNPLD.MultiMarkerLD;
import multiSNPLD.MultiMarkerLDEnt;

public class multiSNPLDdecayuniform {
    public static void main(String[] args) {
        int nsMin = 2;
        int nsMax = 5;
        int repeat = 100;
        String outfile = "test";
        String out = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-MinSNP")) {
                nsMin = Integer.parseInt(args[i + 1]);
            }
            if (nsMin < 2) {
                nsMin = 2;
            }
            if (args[i].equals("-MaxSNP")) {
                nsMax = Integer.parseInt(args[i + 1]);
            }
            if (nsMax <= nsMin) {
                nsMax = nsMin;
            }
            if (args[i].equals("-out")) {
                outfile = args[i + 1];
            }
            ++i;
        }
        int[] ns = new int[nsMax - nsMin + 1];
        int i2 = 0;
        while (i2 < ns.length) {
            ns[i2] = nsMin + i2;
            ++i2;
        }
        outfile = String.valueOf(outfile) + nsMin + "_" + nsMax + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile));
            out = "SNP\tunit\tLDk\tLD2\tSB\tSE\tepsiron\tepsiron'\n";
            FileTools.out3File(bw[0], out);
            int i3 = 0;
            while (i3 < ns.length) {
                out = "";
                int[][] h = HaploTools.Makehaplotype(ns[i3]);
                double[] hf = new double[h.length];
                double hfunit = 1.0 / (double)h.length;
                int j = 0;
                while (j < repeat + 1) {
                    double unit = (double)j / (double)repeat;
                    hf[0] = hfunit * ((double)(h.length / 2 - 1) * unit + 1.0);
                    hf[h.length - 1] = hfunit * ((double)(h.length / 2 - 1) * unit + 1.0);
                    int k = 1;
                    while (k < h.length - 1) {
                        hf[k] = hfunit * (1.0 - unit);
                        ++k;
                    }
                    MultiMarkerLD LD = new MultiMarkerLD(h, hf);
                    MultiMarkerLDEnt LDEnt = new MultiMarkerLDEnt(h, hf);
                    out = String.valueOf(out) + ns[i3] + "\t" + unit + "\t" + LD.chi + "\t" + LDEnt.chi2 + "\t" + LDEnt.SB + "\t" + LDEnt.SE + "\t" + LDEnt.epsi + "\t" + LDEnt.epsiP + "\n";
                    ++j;
                }
                FileTools.out3File(bw[0], out);
                ++i3;
            }
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }

    public static int[][] Makehaplotype(int ns) {
        int nh = (int)Math.pow(2.0, ns);
        int[][] ret = new int[nh][ns];
        int i = 1;
        while (i < ret.length) {
            ret[i][ns - 1] = ret[i - 1][ns - 1] + 1;
            int j = ns - 1;
            while (j > 0) {
                if (ret[i][j] == 2) {
                    ret[i][j] = 0;
                    ret[i][j - 1] = ret[i - 1][j - 1] + 1;
                } else {
                    ret[i][j - 1] = ret[i - 1][j - 1];
                }
                --j;
            }
            ++i;
        }
        return ret;
    }
}

