/*
 * Decompiled with CFR 0.152.
 */
package Tool;

import Tool.GenoTools;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class RegressTools {
    public static void main(String[] args) {
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, -99.0, 12.0};
        double[] array2 = new double[]{4.0, -99.0, 4.0, 5.0, 6.0, 5.0, 7.0, -99.0, 6.0, 8.0, 9.0, 10.0, 7.0};
        int[][] Tarray1 = new int[][]{{604, 897, 208, 398, 161, 29}, {361, 683, 168, 379, 189, 28}};
        int[][] Tarray2 = new int[][]{{426, 715, 150, 334, 133, 25}, {361, 683, 168, 379, 189, 28}};
        int[][] Tarray3 = new int[][]{{142, 273, 45, 134, 65, 10}, {361, 683, 168, 379, 189, 28}};
        int[][] Tarray4 = new int[][]{{110, 195, 52, 81, 40, 5}, {361, 683, 168, 379, 189, 28}};
        int[][] Tarray1_2 = new int[][]{{1590, 1424, 336}, {1573, 1630, 413}};
        int[][] Tarray2_2 = new int[][]{{825, 701, 166}, {756, 794, 186}};
        int[][] Tarray3_2 = new int[][]{{765, 723, 170}, {817, 836, 227}};
        double[] genlabel = new double[]{4.0, 3.0, 2.0, 2.0, 1.0, 0.0};
        double[] phenlabel = new double[]{2.0, 1.0};
        int[][][] ArrayG = new int[][][]{new int[][]{{208, 326, 83, 156, 63, 10}, {175, 340, 66, 183, 88, 16}}, new int[][]{{188, 312, 77, 169, 73, 10}, {186, 343, 102, 196, 101, 12}}};
        int[][][] ArrayG1 = new int[][][]{new int[][]{{208, 326, 83, 156, 63, 10}, {175, 340, 66, 183, 88, 16}}};
        int[][][] ArrayG2 = new int[][][]{new int[][]{{188, 312, 77, 169, 73, 10}, {186, 343, 102, 196, 101, 12}}};
        int[][][] ArrayG12 = new int[][][]{new int[][]{{396, 638, 160, 325, 136, 20}, {361, 683, 168, 379, 189, 28}}};
        double[] scoreG = new double[]{4.0, 3.0, 2.0, 2.0, 1.0, 0.0};
        int[][][] ArrayH = new int[][][]{new int[][]{{825, 701, 166}, {756, 794, 186}}, new int[][]{{765, 723, 170}, {817, 836, 227}}};
        int[][][] ArrayH1 = new int[][][]{new int[][]{{825, 701, 166}, {756, 794, 186}}};
        int[][][] ArrayH2 = new int[][][]{new int[][]{{765, 723, 170}, {817, 836, 227}}};
        int[][][] ArrayH12 = new int[][][]{new int[][]{{1590, 1424, 336}, {1573, 1630, 413}}};
        double[] scoreH = new double[]{0.0, 1.0, 2.0};
        int[][][] nArrayArray = new int[2][][];
        int[][] nArrayArray2 = new int[2][];
        int[] nArray = new int[5];
        nArray[1] = 3;
        nArray[2] = 6;
        nArray[3] = 5;
        nArray[4] = 2;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[5];
        nArray2[0] = 6;
        nArray2[1] = 3;
        nArray2[3] = 1;
        nArrayArray2[1] = nArray2;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[2][];
        int[] nArray3 = new int[5];
        nArray3[2] = 2;
        nArray3[3] = 6;
        nArray3[4] = 5;
        nArrayArray3[0] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[0] = 5;
        nArray4[1] = 6;
        nArray4[2] = 4;
        nArrayArray3[1] = nArray4;
        nArrayArray[1] = nArrayArray3;
        int[][][] Rabbit = nArrayArray;
        int[][][] nArrayArray4 = new int[2][][];
        int[][] nArrayArray5 = new int[2][];
        int[] nArray5 = new int[5];
        nArray5[1] = 3;
        nArray5[2] = 6;
        nArray5[3] = 5;
        nArray5[4] = 2;
        nArrayArray5[0] = nArray5;
        int[] nArray6 = new int[5];
        nArray6[0] = 5;
        nArray6[1] = 6;
        nArray6[2] = 4;
        nArrayArray5[1] = nArray6;
        nArrayArray4[0] = nArrayArray5;
        int[][] nArrayArray6 = new int[2][];
        int[] nArray7 = new int[5];
        nArray7[2] = 2;
        nArray7[3] = 6;
        nArray7[4] = 5;
        nArrayArray6[0] = nArray7;
        int[] nArray8 = new int[5];
        nArray8[0] = 6;
        nArray8[1] = 3;
        nArray8[3] = 1;
        nArrayArray6[1] = nArray8;
        nArrayArray4[1] = nArrayArray6;
        int[][][] Rabbit2 = nArrayArray4;
        double[] scoreR = new double[]{0.125, 0.25, 0.5, 1.0, 4.0};
        double[] T1 = RegressTools.CorTrend(Tarray1, genlabel, phenlabel);
        double[] T2 = RegressTools.CorTrend(Tarray2, genlabel, phenlabel);
        double[] T3 = RegressTools.CorTrend(Tarray3, genlabel, phenlabel);
        double[] T4 = RegressTools.CorTrend(Tarray4, genlabel, phenlabel);
        boolean df = true;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df);
        try {
            System.out.println(String.valueOf(T1[0]) + "\t" + T1[1] + "\t" + T1[2] + "\t" + RegressTools.TranslateToPdf1(T1[0], chidf1));
            System.out.println(String.valueOf(T2[0]) + "\t" + T2[1] + "\t" + T2[2] + "\t" + RegressTools.TranslateToPdf1(T2[0], chidf1));
            System.out.println(String.valueOf(T3[0]) + "\t" + T3[1] + "\t" + T3[2] + "\t" + RegressTools.TranslateToPdf1(T3[0], chidf1));
            System.out.println(String.valueOf(T4[0]) + "\t" + T4[1] + "\t" + T4[2] + "\t" + RegressTools.TranslateToPdf1(T4[0], chidf1));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static double ExtendedMantel(int[][][] array, double[] score) {
        int numTable = array.length;
        int numCol = array[0][0].length;
        double[] Sxx = new double[numTable];
        double[] Syy = new double[numTable];
        double[] Sxy = new double[numTable];
        double[] T = new double[numTable];
        double[] t = new double[numTable];
        double[] s2N = new double[numTable];
        double[] sN = new double[numTable];
        double[] sn = new double[numTable];
        double numer = 0.0;
        double denom = 0.0;
        int i = 0;
        while (i < numTable) {
            Sxx[i] = 0.0;
            Syy[i] = 0.0;
            Sxy[i] = 0.0;
            T[i] = 0.0;
            t[i] = 0.0;
            s2N[i] = 0.0;
            sN[i] = 0.0;
            sn[i] = 0.0;
            int j = 0;
            while (j < numCol) {
                int n = i;
                T[n] = T[n] + (double)(array[i][0][j] + array[i][1][j]);
                int n2 = i;
                t[n2] = t[n2] + (double)array[i][0][j];
                int n3 = i;
                s2N[n3] = s2N[n3] + score[j] * score[j] * (double)(array[i][0][j] + array[i][1][j]);
                int n4 = i;
                sN[n4] = sN[n4] + score[j] * (double)(array[i][0][j] + array[i][1][j]);
                int n5 = i;
                sn[n5] = sn[n5] + score[j] * (double)array[i][0][j];
                ++j;
            }
            Sxx[i] = (T[i] * s2N[i] - sN[i] * sN[i]) / T[i];
            Syy[i] = t[i] * (T[i] - t[i]) / T[i];
            Sxy[i] = (T[i] * sn[i] - t[i] * sN[i]) / T[i];
            ++i;
        }
        i = 0;
        while (i < numTable) {
            numer += Sxy[i];
            denom += Sxx[i] * Syy[i] / (T[i] - 1.0);
            ++i;
        }
        double ret = numer * numer / denom;
        return ret;
    }

    public static double[] CorTrend(int[][] array, double[] genlabel, double[] phenlabel) {
        double[] ret = new double[3];
        double[][] seq = RegressTools.ChangeArrayToSeq(array, genlabel, phenlabel);
        double[] gen = RegressTools.ExtractRow(seq, 0);
        double[] phen = RegressTools.ExtractRow(seq, 1);
        double[] regResult = RegressTools.LinearRegress(gen, phen);
        double cor = regResult[3];
        double N = regResult[2];
        ret[0] = N * cor * cor;
        ret[1] = N;
        ret[2] = cor;
        return ret;
    }

    public static double[] ExtractRow(double[][] array, int row) {
        double[] ret = new double[array[0].length];
        int i = 0;
        while (i < array[0].length) {
            ret[i] = array[row][i];
            ++i;
        }
        return ret;
    }

    public static double[][] ChangeArrayToSeq(int[][] array, double[] genlabel, double[] phenlabel) {
        int N = 0;
        int count = 0;
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                N += array[i][j];
                ++j;
            }
            ++i;
        }
        double[][] ret = new double[2][N];
        int i2 = 0;
        while (i2 < array.length) {
            int j = 0;
            while (j < array[0].length) {
                int k = 0;
                while (k < array[i2][j]) {
                    ret[0][count] = genlabel[j];
                    ret[1][count] = phenlabel[i2];
                    ++count;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        return ret;
    }

    public static double[] LinearRegress(double[] array1, double[] array2) {
        double[] ret = new double[17];
        double[][] array = GenoTools.PairedContDataWithThres(array1, array2, -99.0);
        double Sig_xi = 0.0;
        double Sig_yi = 0.0;
        double Sig_xi2 = 0.0;
        double Sig_yi2 = 0.0;
        double Sig_xiyi = 0.0;
        double n = array.length;
        int i = 0;
        while (i < array.length) {
            Sig_xi += array[i][0];
            Sig_yi += array[i][1];
            Sig_xi2 += Math.pow(array[i][0], 2.0);
            Sig_yi2 += Math.pow(array[i][1], 2.0);
            Sig_xiyi += array[i][0] * array[i][1];
            ++i;
        }
        double Sxx = Sig_xi2 - Math.pow(Sig_xi, 2.0) / n;
        double Syy = Sig_yi2 - Math.pow(Sig_yi, 2.0) / n;
        double Sxy = Sig_xiyi - Sig_xi * Sig_yi / n;
        double b = Sxy / Sxx;
        double a = (Sig_yi - b * Sig_xi) / n;
        double s = Math.sqrt((Syy - b * Sxy) / (n - 2.0));
        double sb = s / Math.sqrt(Sxx);
        double tb = b * Math.sqrt(Sxx) / s;
        double sa = s * Math.sqrt(Sig_xi2 / (n * Sxx));
        double ta = (a - 0.0) / s * Math.sqrt(n * Sxx / Sig_xi2);
        double r = Math.sqrt(Sxy * Sxy / (Sxx * Syy));
        ret[0] = a;
        ret[1] = b;
        ret[2] = n;
        ret[3] = r;
        ret[4] = s;
        ret[5] = sa;
        ret[6] = sb;
        ret[7] = ta;
        ret[8] = tb;
        ret[9] = Sxx;
        ret[10] = Syy;
        ret[11] = Sxy;
        ret[12] = Sig_xi;
        ret[13] = Sig_yi;
        ret[14] = Sig_xi2;
        ret[15] = Sig_yi2;
        ret[16] = Sig_xiyi;
        return ret;
    }

    public static double TranslateToPdf1(double Chi, ChiSquaredDistributionImpl chidf1) throws Exception {
        double ret = -1.0;
        ret = 1.0 - chidf1.cumulativeProbability(Chi);
        return ret;
    }
}

