/*
 * Decompiled with CFR 0.152.
 */
package Tool;

import Tool.FileTools;
import Tool.PlotTools;
import Tool.Quicksort;
import Tool.StatTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class FMCTools {
    public static void main(String[] args) {
        double thresP = Math.pow(10.0, -10.0);
        double thresC = 41.82146;
        int maxN = 5000;
        double[] LogFact = new double[maxN * 2 + 1];
        int i = 0;
        while (i < maxN * 2 + 1) {
            LogFact[i] = Tools.factlog(i);
            ++i;
        }
        BufferedWriter[] bw = new BufferedWriter[2];
        try {
            bw[0] = new BufferedWriter(new FileWriter("FMC_Fisher.txt"));
            bw[1] = new BufferedWriter(new FileWriter("FMC_Chi.txt"));
            short[][] data = FileTools.readDatFileIOStringTABshort("test_countdata.txt");
            int[][] array2 = FMCTools.ShrinkArray(data);
            PlotTools.Array2(array2);
            FMCTools.OutputTheoDist(array2, LogFact, thresP, thresC, bw[0], bw[1]);
            bw[0].close();
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void OutputTheoDist(int[][] array, double[] LogFact, double thresP, double thresC, BufferedWriter bw1, BufferedWriter bw2) {
        int len = array.length;
        int[] tmparray = new int[4];
        String out = "";
        double[] ThresArrayP = new double[]{0.0, thresP};
        double[] ThresArrayC = new double[]{0.0, thresC};
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < 4) {
                tmparray[j] = array[i][j];
                ++j;
            }
            double[][] List2 = StatTools.TheoDistMarginal2x2(tmparray, LogFact);
            int tmplen = List2.length;
            int j2 = 0;
            while (j2 < tmplen) {
                List2[j2][0] = List2[j2][0] * (double)array[i][4];
                if (List2[j2][1] > ThresArrayP[1]) {
                    out = String.valueOf(List2[j2][0]) + "\t" + List2[j2][1] + "\n";
                    FileTools.out3File(bw1, out);
                } else {
                    ThresArrayP[0] = ThresArrayP[0] + List2[j2][0];
                }
                if (List2[j2][2] < ThresArrayC[1]) {
                    out = String.valueOf(List2[j2][0]) + "\t" + List2[j2][2] * -1.0 + "\n";
                    FileTools.out3File(bw2, out);
                } else {
                    ThresArrayC[0] = ThresArrayC[0] + List2[j2][0];
                }
                ++j2;
            }
            out = String.valueOf(ThresArrayP[0]) + "\t" + ThresArrayP[1] + "\n";
            FileTools.out3File(bw1, out);
            ThresArrayP[0] = 0.0;
            out = String.valueOf(ThresArrayC[0]) + "\t" + ThresArrayC[1] * -1.0 + "\n";
            FileTools.out3File(bw2, out);
            ThresArrayC[0] = 0.0;
            ++i;
        }
    }

    public static void OutputTheoDistOnlyFish(int[][] array, double[] LogFact, double thresP, BufferedWriter bw1) {
        int len = array.length;
        int[] tmparray = new int[4];
        String out = "";
        double[] ThresArrayP = new double[]{0.0, thresP};
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < 4) {
                tmparray[j] = array[i][j];
                ++j;
            }
            double[][] List2 = StatTools.TheoDistMarginal2x2OnlyFish(tmparray, LogFact);
            int tmplen = List2.length;
            int j2 = 0;
            while (j2 < tmplen) {
                List2[j2][0] = List2[j2][0] * (double)array[i][4];
                if (List2[j2][1] > ThresArrayP[1]) {
                    out = String.valueOf(List2[j2][0]) + "\t" + List2[j2][1] + "\n";
                    FileTools.out3File(bw1, out);
                } else {
                    ThresArrayP[0] = ThresArrayP[0] + List2[j2][0];
                }
                ++j2;
            }
            out = String.valueOf(ThresArrayP[0]) + "\t" + ThresArrayP[1] + "\n";
            FileTools.out3File(bw1, out);
            ThresArrayP[0] = 0.0;
            ++i;
        }
    }

    public static int[][] ShrinkArray(short[][] array) {
        int len = array.length;
        long[] key = new long[len];
        int i = 0;
        while (i < len) {
            key[i] = FMCTools.ChangeToLong(array[i]);
            ++i;
        }
        Quicksort.sortLong(key);
        int truelen = FMCTools.UniqueCountLong(key);
        long[][] Uniquekey = FMCTools.MakeUniqueArrayLong(key, truelen);
        int[][] ret = FMCTools.ReturnToInt(Uniquekey);
        return ret;
    }

    public static long ChangeToLong(short[] array) {
        long ret = 0L;
        int[] Margin = new int[4];
        int a = array[0] * 2 + array[1];
        int b = array[2] * 2 + array[1];
        int c = array[3] * 2 + array[4];
        int d = array[5] * 2 + array[4];
        int N = a + b + c + d;
        Margin[0] = a + b;
        Margin[1] = c + d;
        Margin[2] = a + c;
        Margin[3] = b + d;
        Margin = Tools.NormalSort1arrayInt(Margin);
        ret = 100000000L * (long)N + 10000L * (long)Margin[1] + (long)Margin[0];
        return ret;
    }

    public static int UniqueCountLong(long[] array) {
        int ret = 1;
        int i = 0;
        while (i < array.length - 1) {
            if (array[i] != array[i + 1]) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static long[][] MakeUniqueArrayLong(long[] array, int truelen) {
        long[][] ret = new long[truelen][2];
        int i = 0;
        while (i < truelen) {
            ret[i][1] = 0L;
            ++i;
        }
        ret[0][0] = array[0];
        ret[0][1] = 1L;
        int counter = 0;
        int i2 = 0;
        while (i2 < array.length - 1) {
            if (array[i2] != array[i2 + 1]) {
                ret[++counter][0] = array[i2 + 1];
                long[] lArray = ret[counter];
                lArray[1] = lArray[1] + 1L;
            } else {
                long[] lArray = ret[counter];
                lArray[1] = lArray[1] + 1L;
            }
            ++i2;
        }
        return ret;
    }

    public static int[][] ReturnToInt(long[][] array) {
        int len = array.length;
        int[][] ret = new int[len][5];
        int i = 0;
        while (i < len) {
            int N = (int)(array[i][0] / 100000000L);
            int R1 = (int)(array[i][0] % 10000L);
            int C1 = (int)((array[i][0] % 100000000L - (long)R1) / 10000L);
            int R2 = N - R1;
            int C2 = N - C1;
            ret[i][0] = R1;
            ret[i][1] = R2;
            ret[i][2] = C1;
            ret[i][3] = C2;
            ret[i][4] = (int)array[i][1];
            ++i;
        }
        return ret;
    }

    public static double[] MakeSumFile(String filepath, BufferedWriter bw1, double[] lamda) throws IOException {
        double[][] tmparray = FileTools.readDatFileIOStringTAB(filepath);
        Quicksort.sortDouble2_2(tmparray);
        int j = 1;
        while (j < tmparray.length) {
            double[] dArray = tmparray[j];
            dArray[0] = dArray[0] + tmparray[j - 1][0];
            ++j;
        }
        double sum = tmparray[tmparray.length - 1][0];
        int j2 = 1;
        while (j2 < tmparray.length) {
            tmparray[j2][0] = tmparray[j2][0] / sum;
            ++j2;
        }
        j2 = 0;
        while (j2 < tmparray.length) {
            String out = tmparray[j2][0] + "\t" + tmparray[j2][1] + "\n";
            FileTools.out3File(bw1, out);
            ++j2;
        }
        double[] ret = FMCTools.LamdaCheck(tmparray, lamda);
        return ret;
    }

    public static double[] MakeSumFileAlpha(String filepath, BufferedWriter bw1, double[] alpha) throws IOException {
        double[] ret = new double[alpha.length + 1];
        double[] tmp = new double[alpha.length];
        double[][] tmparray = FileTools.readDatFileIOStringTAB(filepath);
        Quicksort.sortDouble2_2(tmparray);
        int j = 1;
        while (j < tmparray.length) {
            double[] dArray = tmparray[j];
            dArray[0] = dArray[0] + tmparray[j - 1][0];
            ++j;
        }
        double sum = tmparray[tmparray.length - 1][0];
        int j2 = 1;
        while (j2 < tmparray.length) {
            tmparray[j2][0] = tmparray[j2][0] / sum;
            ++j2;
        }
        j2 = 0;
        while (j2 < tmparray.length) {
            String out = tmparray[j2][0] + "\t" + tmparray[j2][1] + "\n";
            FileTools.out3File(bw1, out);
            ++j2;
        }
        tmp = FMCTools.AlphaCheck(tmparray, alpha);
        int i = 0;
        while (i < alpha.length) {
            ret[i] = tmp[i];
            ++i;
        }
        ret[alpha.length] = FMCTools.QuantCheck(tmparray, 0.5);
        return ret;
    }

    public static double[] MakeSumFileAlphaPlot(String filepath, BufferedWriter bw1, double[] alpha, double[] plotk, BufferedWriter bw2) throws IOException {
        double[] ret = new double[alpha.length + 1];
        double[] tmp = new double[alpha.length];
        double[] plot = new double[plotk.length];
        int counter = 0;
        int len = plotk.length;
        double[][] tmparray = FileTools.readDatFileIOStringTAB(filepath);
        Quicksort.sortDouble2_2(tmparray);
        int j = 1;
        while (j < tmparray.length) {
            double[] dArray = tmparray[j];
            dArray[0] = dArray[0] + tmparray[j - 1][0];
            ++j;
        }
        double sum = tmparray[tmparray.length - 1][0];
        int j2 = 1;
        while (j2 < tmparray.length) {
            tmparray[j2][0] = tmparray[j2][0] / sum;
            ++j2;
        }
        j2 = 0;
        while (j2 < tmparray.length) {
            String out = tmparray[j2][0] + "\t" + tmparray[j2][1] + "\n";
            FileTools.out3File(bw1, out);
            boolean iter = true;
            while (iter) {
                if (counter < len && tmparray[j2][0] >= plotk[counter] && tmparray[Math.max(j2 - 1, 0)][0] <= plotk[counter]) {
                    plot[counter] = tmparray[j2][1];
                    out = String.valueOf(plotk[counter]) + "\t" + plot[counter] + "\n";
                    FileTools.out3File(bw2, out);
                    ++counter;
                    continue;
                }
                iter = false;
            }
            ++j2;
        }
        tmp = FMCTools.AlphaCheck(tmparray, alpha);
        int i = 0;
        while (i < alpha.length) {
            ret[i] = tmp[i];
            ++i;
        }
        ret[alpha.length] = FMCTools.QuantCheck(tmparray, 0.5);
        return ret;
    }

    public static double QuantCheck(double[][] data, double thres) {
        double ret = 0.0;
        int i = data.length - 1;
        while (i > 0) {
            if (data[i][0] >= thres && data[i - 1][0] <= thres) {
                ret = data[i][1];
                i = 0;
            }
            --i;
        }
        return ret;
    }

    public static double[] AlphaCheck(double[][] data, double[] alpha) {
        double[] ret = new double[alpha.length];
        int counter = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i][1] > alpha[counter]) {
                ret[counter] = data[i][0];
                if (++counter == alpha.length) {
                    i = data.length;
                }
            }
            ++i;
        }
        return ret;
    }

    public static double[] LamdaCheck(double[][] data, double[] lamda) {
        double[] ret = new double[lamda.length];
        int counter = lamda.length - 1;
        int i = data.length - 1;
        while (i > 0) {
            if (data[i][0] >= lamda[counter] && data[i - 1][0] <= lamda[counter]) {
                ret[counter] = data[i][1];
                ++i;
                if (--counter < 0) {
                    i = 0;
                }
            }
            --i;
        }
        return ret;
    }
}

