/*
 * Decompiled with CFR 0.152.
 */
package StepWisePheno;

import StepWisePheno.MultiPhenoTools;
import Tool.ArrayTools;
import Tool.Disturibution;
import Tool.FileTools;
import Tool.PlotTools;
import Tool.StatTools;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class FindBestMergedArray {
    public int Initialdf;
    public int Bestdf;
    public int[][] BestArray;
    public int[][] BestLocation;
    public double InitialChi;
    public double InitialP;
    public double BestChi;
    public double BestP;

    public static void main(String[] args) {
        try {
            String CorresFile = "P_Chi_CorresTable_mid.txt";
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
            int[][] MultiPhenoH0_1 = new int[][]{{80, 234, 186}, {92, 231, 177}, {70, 253, 177}, {65, 240, 195}, {70, 237, 193}, {75, 236, 189}, {76, 243, 181}, {78, 237, 185}, {76, 236, 188}, {75, 234, 191}};
            int[][] MultiPhenoH1_2 = new int[][]{{88, 230, 182}, {84, 235, 181}, {76, 245, 179}, {65, 235, 200}, {75, 247, 178}, {66, 247, 187}, {39, 207, 254}, {53, 212, 235}, {56, 199, 245}, {52, 228, 220}};
            int[][] MultiPhenoH1_3 = new int[][]{{77, 251, 172}, {71, 251, 178}, {85, 239, 176}, {68, 241, 191}, {44, 226, 230}, {53, 205, 242}, {46, 208, 246}, {132, 260, 108}, {126, 253, 121}, {129, 246, 125}};
            FindBestMergedArray BA = new FindBestMergedArray(MultiPhenoTools.ConvertKx3toKx2(MultiPhenoH0_1), 0.1, CorresTableChi, chidf1);
            PlotTools.Array2(BA.BestArray);
            System.out.println(String.valueOf(BA.InitialChi) + "\t" + BA.Initialdf + "\t" + BA.InitialP + "\t" + BA.BestChi + "\t" + BA.Bestdf + "\t" + BA.BestP + "\t");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public FindBestMergedArray(int[][] BaseArray, double ThresP, double[][] CorresTableChi, ChiSquaredDistributionImpl chidf1) throws Exception {
        this.BestArray = ArrayTools.CopyArray2(BaseArray);
        this.Initialdf = this.BestArray.length - 1;
        this.BestChi = this.InitialChi = MultiPhenoTools.ChiTestKx2(this.BestArray);
        this.BestP = this.InitialP = StatTools.TranslateChitoP(this.BestChi, this.BestArray.length - 1, CorresTableChi, chidf1);
        boolean iter = true;
        while (iter) {
            int[][] tmpArray = MultiPhenoTools.FindMergedArrayMinP(this.BestArray);
            double tmpChi = MultiPhenoTools.ChiTestKx2(tmpArray);
            int tmpdf = tmpArray.length - 1;
            double tmpP = StatTools.TranslateChitoP(tmpChi, tmpdf, CorresTableChi, chidf1);
            double F = tmpChi / (double)tmpdf / (this.BestChi - tmpChi);
            double Pdiff = Disturibution.Fdist_upper(F, tmpdf, 1);
            if (Pdiff < ThresP && tmpArray.length >= 2) {
                this.BestArray = ArrayTools.CopyArray2(tmpArray);
                this.BestChi = tmpChi;
                this.Bestdf = tmpdf;
                this.BestP = tmpP;
                if (this.BestArray.length != 2) continue;
                iter = false;
                continue;
            }
            iter = false;
        }
    }
}

