/*
 * Decompiled with CFR 0.152.
 */
package Mains;

import Algorithms.MersenneTwisterFast;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class MakeCountDataMultiPheno {
    public static void main(String[] args) {
        int numPheno = 15;
        int numSNP = 5000;
        int numSampleBase = 1000;
        int N = 0;
        double[] AfBase = new double[]{0.05, 0.95};
        double ORH1 = 1.2;
        String outfile = "testH0";
        String outfileCond = "";
        String outfileCount = "";
        String outfileLog = "";
        String out1 = "";
        String out2 = "";
        boolean Onfilter = false;
        boolean OnZerofilter = true;
        boolean H1 = false;
        int seedgiven = 999999999;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-numPheno")) {
                numPheno = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numSNP")) {
                numSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numSampleBase")) {
                numSampleBase = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-af")) {
                AfBase[0] = Double.parseDouble(args[i + 1]);
                AfBase[1] = Double.parseDouble(args[i + 2]);
            }
            if (args[i].equals("-out")) {
                outfile = args[i + 1];
            }
            if (args[i].equals("-filter")) {
                Onfilter = true;
            }
            if (args[i].equals("-zerofilter")) {
                OnZerofilter = true;
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        int[] numSample = new int[numPheno];
        double[] OR = new double[numPheno];
        double[] d = new double[numPheno];
        double[] miss = new double[numPheno];
        int i2 = 0;
        while (i2 < numPheno) {
            numSample[i2] = (int)Math.round((double)numSampleBase * (0.5 + mz.nextDouble()));
            OR[i2] = 1.0;
            d[i2] = 1.0E-8;
            miss[i2] = 0.995;
            ++i2;
        }
        i2 = 0;
        while (i2 < args.length) {
            int j;
            if (args[i2].equals("-numSample")) {
                j = 0;
                while (j < numPheno) {
                    numSample[j] = Integer.parseInt(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-OR")) {
                j = 0;
                while (j < numPheno) {
                    OR[j] = Double.parseDouble(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-d")) {
                j = 0;
                while (j < numPheno) {
                    d[j] = Integer.parseInt(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-miss")) {
                j = 0;
                while (j < numPheno) {
                    miss[j] = Double.parseDouble(args[i2 + 1 + j]);
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < numPheno) {
            out1 = String.valueOf(out1) + numSample[i2] + "\t";
            N += numSample[i2];
            ++i2;
        }
        outfileCond = String.valueOf(outfile) + "_condition.txt";
        outfileCount = String.valueOf(outfile) + "_countdata.txt";
        outfileLog = String.valueOf(outfile) + "_log.txt";
        int numFile = 3;
        BufferedWriter[] bw = new BufferedWriter[numFile];
        int i3 = 0;
        while (i3 < numFile) {
            bw[i3] = null;
            ++i3;
        }
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileCond));
            bw[1] = new BufferedWriter(new FileWriter(outfileCount));
            bw[2] = new BufferedWriter(new FileWriter(outfileLog));
            out2 = "Log for MakeCountDataMultiPheno.java\n\nNo.Phenotype:\t" + numPheno + "\nNo.TotalSamples:\t" + N + "\nNo.Samples:\t" + out1 + "\nNo.SNPs:\t" + numSNP + "\nAllele Freq Range:\t" + AfBase[0] + "\t" + AfBase[1] + "\nH1:\t" + H1 + "\n\nOutput Files:\n\t" + outfileCond + "\n\t" + outfileCount + "\n\t" + outfileLog + "\n\n";
            out2 = String.valueOf(out2) + "MakeCountdata_started_at:\t" + Tools.GetTime() + "\n";
            FileTools.out3File(bw[2], out2);
            int[] Count = new int[3];
            int iter = 0;
            int maxiter = 100000;
            double[][] CausGeno = new double[3][2];
            int i4 = 0;
            while (i4 < numSNP) {
                double Af = AfBase[0] + (AfBase[1] - AfBase[0]) * mz.nextDouble();
                out1 = "";
                out2 = "";
                int j = 0;
                while (j < numPheno) {
                    boolean AfCheck = false;
                    if (H1) {
                        OR[j] = mz.nextDouble() < 0.2 ? (mz.nextDouble() < 0.5 ? ORH1 : 1.0 / ORH1) : 1.0;
                    }
                    if (Onfilter) {
                        iter = 0;
                        while (!AfCheck) {
                            if (OR[j] == 1.0) {
                                Count = GenoTools.GenoCount(numSample[j], Af, miss[j], mz);
                            } else {
                                CausGeno = GenoTools.CaseContAf(Af, OR[j], d[j]);
                                Count = GenoTools.GenoCountCausal(numSample[j], CausGeno[0][0], CausGeno[1][0], CausGeno[2][0], miss[j], mz);
                            }
                            AfCheck = OnZerofilter ? GenoTools.AfCheck(Count, AfBase[0], AfBase[1]) & GenoTools.MonoCheck(Count) : GenoTools.AfCheck(Count, AfBase[0], AfBase[1]);
                            if (++iter < maxiter) continue;
                            AfCheck = true;
                            System.out.println("over maxiteration1!!");
                        }
                    } else {
                        iter = 0;
                        while (!AfCheck) {
                            if (OR[j] == 1.0) {
                                Count = GenoTools.GenoCount(numSample[j], Af, miss[j], mz);
                            } else {
                                CausGeno = GenoTools.CaseContAf(Af, OR[j], d[j]);
                                Count = GenoTools.GenoCountCausal(numSample[j], CausGeno[0][0], CausGeno[1][0], CausGeno[2][0], miss[j], mz);
                            }
                            AfCheck = OnZerofilter ? GenoTools.MonoCheck(Count) : true;
                            if (++iter < maxiter) continue;
                            AfCheck = true;
                            System.out.println("over maxiteration!!");
                        }
                    }
                    out1 = String.valueOf(out1) + Count[0] + "\t" + Count[1] + "\t" + Count[2] + "\t";
                    ++j;
                }
                out1 = String.valueOf(out1) + "\n";
                out2 = String.valueOf(Af) + "\n";
                FileTools.out3File(bw[1], out1);
                FileTools.out3File(bw[0], out2);
                ++i4;
            }
            out1 = "MakeCountdata_ended_at:\t" + Tools.GetTime() + "\n";
            FileTools.out3File(bw[2], out1);
            bw[0].close();
            bw[1].close();
            bw[2].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

