	rm(list = ls(all = TRUE));
	setwd("C:/WORK/HP_WORK/yokada/files/ManhattanPlot"); # set your working directory

PLOT <- function (filename) {
	head <- substring(filename,1,nchar(filename)-4);
	table <- read.table(filename, header=TRUE);
	nSNP <- length(table[,3]);
	nP <- length(table[1,]);
	posilength <- 100000000000;
	plotthre <- 50000;
	color <- colors();
	colname <- rep(c(24,552,258,26,124,452,92,180),4);
	table$color <- pmax(numeric(nSNP)+1,table[,2]%/%posilength);
	chrom <- c(c(0,248,492,693,885,1067,1239,1399,1546,1687,1823,1958,2090,2204,2310,2411,2501,2581,2658,2723,2785,2832,2882)*1000000,rep(3000000000,10000));
	table$posiR <- table[,2]-posilength*table$color+chrom[table$color];
	table$color <- color[colname[table$color]];

	## Graphical settings.
	
	dot <- 0.8;c <- 1/10;Bonthre <- 0.05/nSNP;
	yax <- nSNP*c;
	tag <- c("before GC", "after GC");ylabel <-c("1/(N+1)-N/(N+1)");
	tag2 <- c("chrom. 1","chrom. 2","chrom. 3","chrom. 4","chrom. 5","chrom. 6","chrom. 7","chrom. 8","chrom. 9","chrom. 10","chrom. 11","chrom. 12","chrom. 13","chrom. 14","chrom. 15","chrom. 16","chrom. 17","chrom. 18","chrom. 19","chrom. 20","chrom. 21","chrom. 22");

	## Genomic Control function.
	
	GC <- function(x,label,gc,DF,limit) {
		x[x>=1 | x<0] <- 1;
		len <-length(x);
		y <-numeric(len);Chi <- y;
		k <- c(1:len)/(len+1);
		limitlog <- limit;
		lamda <- 1;
		thre <- 1;
		if (len>plotthre) { thre=0.1};
		RAND <-runif(len, 0, 1);
		x <-sort(x);
		Chi <-qchisq(x, df=DF, lower.tail=FALSE);
		Chi <-ifelse(is.nan(Chi), 0, Chi);
		lamda <-quantile(Chi, 0.5)/qchisq(0.5, df=DF, lower.tail=FALSE);
		print(lamda);
		y <-pchisq(Chi/lamda, df=DF, lower.tail=FALSE);
		
			png(file=paste(head,"_QQplot_",label,".png",sep=""), width = 900, height = 900);
			par(mfrow=c(2,1));par(mar=c(2,6,2,6));
			plot (x, k, col=4, pch=20, type="l", cex.main=1.5, cex.lab=1.5, cex.axis=1.5, xlim=c(0,1), ylim=c(0,1), main=(paste(filename,"_","QQ plots of ",label,sep="")), ylab="Expected P-value", xlab="Observed P-value");abline(0,1);
			if (gc==1) {
				legend (0.7, 0.3, legend=tag, col=c(4,2), pch=20, ncol=1, cex=1.5);
				par(new=T);plot (y[RAND<=thre], k[RAND<=thre], col=2, pch=20, type="l", cex.main=1.5, cex.lab=1.5, cex.axis=1, xlim=c(0,1), ylim=c(0,1), main=(""), xlab="", ylab="", axes=F);
				text(0, 0.9, cex=1.5, adj=0, labels=expression(lambda[" GC"]));
				text(0.1, 0.9, cex=1.5, adj=0, labels=paste(":", round(lamda,5)));
			}
			plot(-1*log(x[k<=1],10), -1*log(k[k<=1],10), ylim=c(limitlog,0), xlim=c(limitlog,0), col=4, type="l", pch=16, cex.main=1.5, cex.lab=1.5, cex.axis=1.5, ylab="Expected P-value", xlab="Observed P-value", main=(paste("QQ-plots of P-values (-log 10) ",label,sep="")));abline(0,1);
			if (gc==1) {
				par(new=T);plot(-1*log(y[k<=1],10), -1*log(k[k<=1],10), ylim=c(limitlog,0), xlim=c(limitlog,0), col=2, type="l", pch=16, cex.main=1.5, cex.lab=1.5, cex.axis=1.5, xlab="", ylab="");abline(0,1);
			}
			dev.off();
	return (invisible(lamda));
	}
	
	##Manhattan plot function
	
	POSI <- function(x,label,limitlog) {
		x[x>=1 | x<0] <- 1;
		len <- length(x);thre <- 0.1
		if (len<plotthre) { thre=1 }
		
		try({
			png(file=paste(head,"_Manhattan_",label,"_",limitlog,".png",sep=""), width = 900, height = 900);
			par(mfrow=c(2,1));par(mar=c(2,6,2,6));
			plot (table$posiR[table$posiR>0], pmin(-1*log(x[table$posiR>0],10),limitlog), ylim=c(0,limitlog), col=table$color[table$posiR>0], pch=16, cex=dot, main=(paste(filename,"_","Mahattan plot of ",label," (-log10)",sep="")), cex.main=1.5, cex.lab=1.5, cex.axis=1.5, xlab="", ylab="-log10",xaxt="n");box();
			abline(h=log(5*10^-8,10)*-1,lwd=0.5,col=1);
			plot(0,0,type="n",xlim=c(0,1),ylim=c(0,1), main="",xlab="",ylab="",axes=F);
			legend (0, 1, legend=tag2, col=color[colname[1:22]], pch=16, ncol=3, cex=1.5);
			dev.off()
		})
	}
	
	for (i in 3:nP) {
		GC(table[,i],names(table)[i],1,1,7);
#		POSI(table[,i],names(table)[i],100);
#		POSI(table[,i],names(table)[i],50);
#		POSI(table[,i],names(table)[i],20);
		POSI(table[,i],names(table)[i],15);
		POSI(table[,i],names(table)[i],10); # select the y-axis threholds
	}
}
	
	PLOT("Example.txt");
	
