/*
 * Decompiled with CFR 0.152.
 */
package multiSNPLDdiff;

import Algorithms.MersenneTwisterFast;
import Tool.FileTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import multiSNPLDdiff.HaplotypeManageTool;
import multiSNPLDdiff.NullHaploGenerator;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class NullDistCheck {
    public static void main(String[] args) {
        int numSNP = 10;
        int numSample = 5000;
        int numCase = 2500;
        int rep = 2000;
        double AF1 = 0.4;
        double AF2 = 0.6;
        double OR1 = 1.0;
        double OR2 = 1.0;
        int seedgiven = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-numSNP")) {
                numSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numSample")) {
                numSample = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numCase")) {
                numCase = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-rep")) {
                rep = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-AF1")) {
                AF1 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-AF2")) {
                AF2 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-OR1")) {
                OR1 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-OR2")) {
                OR2 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        int numControl = numSample - numCase;
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        String outfile1 = "NullHaploEntropyStats_Case" + numCase + "_Control" + numControl + "_SNP" + numSNP + "_AF1-" + AF1 + "_AF2-" + AF2 + "_OR1-" + OR1 + "_OR2-" + OR2 + "_rep" + rep + "_stat.txt";
        String outfile2 = "NullHaploEntropyStats_Case" + numCase + "_Control" + numControl + "_SNP" + numSNP + "_AF1-" + AF1 + "_AF2-" + AF2 + "_OR1-" + OR1 + "_OR2-" + OR2 + "_rep" + rep + "_summary.txt";
        String out = "";
        BufferedWriter[] bw = new BufferedWriter[]{null, null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile1));
            bw[1] = new BufferedWriter(new FileWriter(outfile2));
            ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
            double df = Math.pow(2.0, numSNP) - ((double)numSNP + 1.0);
            double[] DeltaStatCase = new double[rep];
            double[] DeltaStatControl = new double[rep];
            double[] DeltaDeltaStat = new double[rep];
            double[] DeltaDeltaStatP = new double[rep];
            double[] RatioDeltaStat = new double[rep];
            double[] RatioDeltaStatP = new double[rep];
            int i2 = 0;
            while (i2 < rep) {
                double[] AlleleFreq = NullHaploGenerator.GenetAlleleFreq(numSNP, AF1, AF2, mz);
                double[] AlleleFreqCase = NullHaploGenerator.GenetAlleleFreqCase(AlleleFreq, OR1, OR2, mz);
                String[] HaplotypeCase = NullHaploGenerator.DecideMultiHaplotypeNull(numSNP, numCase, AlleleFreqCase, mz);
                String[] HaplotypeControl = NullHaploGenerator.DecideMultiHaplotypeNull(numSNP, numControl, AlleleFreq, mz);
                double[] tmpStat = HaplotypeManageTool.CalHaploEntDiff(HaplotypeCase, HaplotypeControl);
                DeltaStatCase[i2] = tmpStat[3];
                DeltaStatControl[i2] = tmpStat[9];
                DeltaDeltaStat[i2] = tmpStat[13];
                DeltaDeltaStatP[i2] = tmpStat[14];
                RatioDeltaStat[i2] = tmpStat[16];
                RatioDeltaStatP[i2] = tmpStat[17];
                out = "";
                int j = 0;
                while (j < tmpStat.length) {
                    out = String.valueOf(out) + tmpStat[j] + "\t";
                    ++j;
                }
                FileTools.out3File(bw[0], String.valueOf(out) + "\n");
                ++i2;
            }
            double[] SumDeltaStatCase = Tools.MeanVarSD(DeltaStatCase);
            double[] SumDeltaStatControl = Tools.MeanVarSD(DeltaStatControl);
            double[] SumDeltaDeltaStat = Tools.MeanVarSD(DeltaDeltaStat);
            double LambdaDeltaDeltaStatP = chidf1.inverseCumulativeProbability(1.0 - Tools.Median(DeltaDeltaStatP)) / chidf1.inverseCumulativeProbability(0.5);
            double[] SumRatioDeltaStat = Tools.MeanVarSD(RatioDeltaStat);
            double LambdaRatioDeltaStatP = chidf1.inverseCumulativeProbability(1.0 - Tools.Median(RatioDeltaStatP)) / chidf1.inverseCumulativeProbability(0.5);
            out = "";
            out = String.valueOf(out) + "DeltaStatCase\t" + SumDeltaStatCase[0] + "\t" + SumDeltaStatCase[1] + "\t" + SumDeltaStatCase[2] + "\tdf\n";
            out = String.valueOf(out) + "DeltaStatControl\t" + SumDeltaStatControl[0] + "\t" + SumDeltaStatControl[1] + "\t" + SumDeltaStatControl[2] + "\t" + df + "\n";
            out = String.valueOf(out) + "DeltaDeltaStat\t" + SumDeltaDeltaStat[0] + "\t" + SumDeltaDeltaStat[1] + "\t" + SumDeltaDeltaStat[2] + "\t" + LambdaDeltaDeltaStatP + "\n";
            out = String.valueOf(out) + "RatioDeltaStat\t" + SumRatioDeltaStat[0] + "\t" + SumRatioDeltaStat[1] + "\t" + SumRatioDeltaStat[2] + "\t" + LambdaRatioDeltaStatP + "\n";
            FileTools.out3File(bw[1], out);
            bw[0].close();
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

