/*
 * Decompiled with CFR 0.152.
 */
package multiSNPLD;

import Algorithms.MersenneTwisterFast;
import Tool.FileTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import multiSNPLD.MultiMarkerLD;

public class multiSNPLDdistribution {
    public static void main(String[] args) {
        int nsMin = 2;
        int nsMax = 5;
        int repeat = 1000;
        String outfile = "test";
        String out = "";
        int seed = 0;
        int seedgiven = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-MinSNP")) {
                nsMin = Integer.parseInt(args[i + 1]);
            }
            if (nsMin < 2) {
                nsMin = 2;
            }
            if (args[i].equals("-MaxSNP")) {
                nsMax = Integer.parseInt(args[i + 1]);
            }
            if (nsMax <= nsMin) {
                nsMax = nsMin;
            }
            if (args[i].equals("-out")) {
                outfile = args[i + 1];
            }
            if (args[i].equals("-repeat")) {
                repeat = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        int[] ns = new int[nsMax - nsMin + 1];
        int i2 = 0;
        while (i2 < ns.length) {
            ns[i2] = nsMin + i2;
            ++i2;
        }
        outfile = String.valueOf(outfile) + nsMin + "_" + nsMax + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile));
            out = "SNP\tunit\tLD\n";
            FileTools.out3File(bw[0], out);
            int i3 = 0;
            while (i3 < ns.length) {
                out = "";
                int[][] h = multiSNPLDdistribution.Makehaplotype(ns[i3]);
                double[] hf = new double[h.length];
                int j = 0;
                while (j < repeat) {
                    double unit = (double)j / (double)repeat;
                    double hfunit = 0.0;
                    int k = 0;
                    while (k < h.length) {
                        hf[k] = mz.nextDouble();
                        hfunit += hf[k];
                        ++k;
                    }
                    k = 0;
                    while (k < h.length) {
                        int n = k++;
                        hf[n] = hf[n] / hfunit;
                    }
                    MultiMarkerLD LD = new MultiMarkerLD(h, hf);
                    out = String.valueOf(out) + ns[i3] + "\t" + unit + "\t" + LD.chi + "\n";
                    if (mz.nextDouble() < 0.01) {
                        System.out.println(j);
                    }
                    ++j;
                }
                FileTools.out3File(bw[0], out);
                ++i3;
            }
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }

    public static int[][] Makehaplotype(int ns) {
        int nh = (int)Math.pow(2.0, ns);
        int[][] ret = new int[nh][ns];
        int i = 1;
        while (i < ret.length) {
            ret[i][ns - 1] = ret[i - 1][ns - 1] + 1;
            int j = ns - 1;
            while (j > 0) {
                if (ret[i][j] == 2) {
                    ret[i][j] = 0;
                    ret[i][j - 1] = ret[i - 1][j - 1] + 1;
                } else {
                    ret[i][j - 1] = ret[i - 1][j - 1];
                }
                --j;
            }
            ++i;
        }
        return ret;
    }
}

