/*
 * Decompiled with CFR 0.152.
 */
package multiSNPLD;

import Tool.FileTools;
import Tool.Tools;
import multiSNPLD.HaploTools;
import multiSNPLD.MultiMarkerLD;
import multiSNPLD.MultiMarkerLDEnt;
import multiSNPLD.SummarizeHaplotypeAll;
import multiSNPLD.SummarizeHaplotypeString;

public class PairwiseAndMultiple {
    int[][] PairwiseSNPs;
    double[] r2;
    double r2mean;
    double r2sd;
    double rk;
    double epsi;
    double epsiP;
    double chi2;

    public static void main(String[] args) {
        String inputfile = "sample50maf0-0.5_haplo_1.txt";
        try {
            int[][] data = FileTools.readDatFileIOStringSPACEint(inputfile);
            PairwiseAndMultiple PairMulti = new PairwiseAndMultiple(data, 0, 1);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public PairwiseAndMultiple(int[][] data, int elem1, int elem2) {
        int NumHaplo = data.length;
        int NumSNP = data[0].length;
        this.PairwiseSNPs = HaploTools.Pairwise(NumSNP);
        int[][] CutHaplo = new int[NumHaplo][2];
        int[] SNPposi = new int[2];
        int repeat = this.PairwiseSNPs.length;
        double[] r2Array = new double[repeat];
        int i = 0;
        while (i < repeat) {
            SNPposi[0] = this.PairwiseSNPs[i][0];
            SNPposi[1] = this.PairwiseSNPs[i][1];
            CutHaplo = HaploTools.CutHaplotype(data, SNPposi);
            SummarizeHaplotypeString Haplo = new SummarizeHaplotypeString(CutHaplo);
            MultiMarkerLD multiLD = new MultiMarkerLD(Haplo.SumHaplo, Haplo.SumFreq);
            r2Array[i] = multiLD.chi;
            ++i;
        }
        this.r2 = r2Array;
        double[] tmp = Tools.MeanVarSD(r2Array);
        this.r2mean = tmp[0];
        this.r2sd = tmp[1];
        SummarizeHaplotypeAll Haplo = new SummarizeHaplotypeAll(data, elem1, elem2);
        MultiMarkerLDEnt multiLD = new MultiMarkerLDEnt(Haplo.SumHaplo, Haplo.SumFreq);
        this.rk = multiLD.chi;
        this.epsi = multiLD.epsi;
        this.epsiP = multiLD.epsiP;
        this.chi2 = multiLD.chi2;
    }
}

