/*
 * Decompiled with CFR 0.152.
 */
package multiSNPLD;

import Tool.FileTools;
import Tool.PlotTools;
import multiSNPLD.MultiMarkerLD;
import multiSNPLD.SummarizeHaplotypeString;

public class HaploTools {
    public static void main(String[] args) {
        byte[][] byArrayArray = new byte[6][];
        byte[] byArray = new byte[5];
        byArray[0] = 1;
        byArray[2] = 1;
        byArrayArray[0] = byArray;
        byArrayArray[1] = new byte[]{1, 1, 1, 1, 1};
        byte[] byArray2 = new byte[5];
        byArray2[3] = 1;
        byArray2[4] = 1;
        byArrayArray[2] = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[0] = 1;
        byArray3[1] = 1;
        byArray3[2] = 1;
        byArrayArray[3] = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[0] = 1;
        byArray4[4] = 1;
        byArrayArray[4] = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[1] = 1;
        byArray5[2] = 1;
        byArray5[3] = 1;
        byArrayArray[5] = byArray5;
        byte[][] haplo = byArrayArray;
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 4;
        int[] posi = nArray;
        PlotTools.Array2(HaploTools.Pairwise(5));
        String inputfile = "sample50maf0-0.5_haplo_1.txt";
        try {
            int[][] data = FileTools.readDatFileIOStringSPACEint(inputfile);
            HaploTools.PairwiseAndK(data);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static int[][] Makehaplotype(int ns) {
        int nh = (int)Math.pow(2.0, ns);
        int[][] ret = new int[nh][ns];
        int i = 1;
        while (i < ret.length) {
            ret[i][ns - 1] = ret[i - 1][ns - 1] + 1;
            int j = ns - 1;
            while (j > 0) {
                if (ret[i][j] == 2) {
                    ret[i][j] = 0;
                    ret[i][j - 1] = ret[i - 1][j - 1] + 1;
                } else {
                    ret[i][j - 1] = ret[i - 1][j - 1];
                }
                --j;
            }
            ++i;
        }
        return ret;
    }

    public static int[][] CutHaplotype(byte[][] Haplo, int[] SNPposi) {
        int NumHaplo = Haplo.length;
        int NumSNP = Haplo[0].length;
        int[][] ret = new int[NumHaplo][SNPposi.length];
        int i = 0;
        while (i < NumHaplo) {
            int j = 0;
            while (j < SNPposi.length) {
                ret[i][j] = Haplo[i][SNPposi[j]];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static int[][] CutHaplotype(int[][] Haplo, int[] SNPposi) {
        int NumHaplo = Haplo.length;
        int NumSNP = Haplo[0].length;
        int[][] ret = new int[NumHaplo][SNPposi.length];
        int i = 0;
        while (i < NumHaplo) {
            int j = 0;
            while (j < SNPposi.length) {
                ret[i][j] = Haplo[i][SNPposi[j]];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static int[][] Pairwise(int k) {
        int len = k * (k - 1) / 2;
        int[][] ret = new int[len][2];
        int counter = 0;
        int i = 0;
        while (i < k - 1) {
            int j = i + 1;
            while (j < k) {
                ret[counter][0] = i;
                ret[counter][1] = j++;
                ++counter;
            }
            ++i;
        }
        return ret;
    }

    public static void PairwiseAndK(int[][] data) {
        int NumHaplo = data.length;
        int NumSNP = data[0].length;
        int[][] PairwiseSNPs = HaploTools.Pairwise(NumSNP);
        int[][] CutHaplo = new int[NumHaplo][2];
        int[] SNPposi = new int[2];
        int repeat = PairwiseSNPs.length;
        int i = 0;
        while (i < repeat) {
            SNPposi[0] = PairwiseSNPs[i][0];
            SNPposi[1] = PairwiseSNPs[i][1];
            CutHaplo = HaploTools.CutHaplotype(data, SNPposi);
            SummarizeHaplotypeString Haplo = new SummarizeHaplotypeString(CutHaplo);
            MultiMarkerLD multiLD = new MultiMarkerLD(Haplo.SumHaplo, Haplo.SumFreq);
            double r2 = multiLD.chi;
            System.out.println(r2);
            ++i;
        }
        SummarizeHaplotypeString Haplo = new SummarizeHaplotypeString(data);
        MultiMarkerLD multiLD = new MultiMarkerLD(Haplo.SumHaplo, Haplo.SumFreq);
        double rk = multiLD.chi;
        System.out.println(rk);
    }
}

