/*
 * Decompiled with CFR 0.152.
 */
package WorksFromRY;

public class Permutation {
    public static void main(String[] args) {
        int a1 = 66;
        int a2 = 34;
        int b1 = 90;
        int b2 = 10;
        int a = a1 + a2;
        int b = b1 + b2;
        int n = a + b;
        int[] genotype = new int[n];
        int[] type = new int[n];
        int[] observedOrder = new int[n];
        int h = 0;
        while (h < n) {
            if (h >= 0 && h < a1) {
                genotype[h] = 1;
            }
            if (a <= h && h < a + b1) {
                genotype[h] = 1;
            }
            if (h >= 0 && h < a) {
                type[h] = 1;
            }
            observedOrder[h] = h;
            ++h;
        }
        int[][] Tobs = Permutation.T(type, genotype);
        double Sobs = Permutation.S(Tobs);
        int repeat = 100000;
        int count = 0;
        int i = 0;
        while (i < repeat) {
            int[] omega = Permutation.omega(n);
            int[] di = Permutation.di(n, a, omega);
            int[][] T = Permutation.T(di, genotype);
            double S = Permutation.S(T);
            if (S >= Sobs) {
                ++count;
            }
            ++i;
        }
        System.out.println((double)count / (double)repeat);
    }

    public static int[] omega(int len) {
        int[] result = new int[len];
        int[] flag = new int[len];
        int h = 0;
        while (h < len) {
            int x = 1;
            do {
                result[h] = x = (int)(Math.random() * (double)len);
            } while (flag[x] > 0);
            int n = x;
            flag[n] = flag[n] + 1;
            ++h;
        }
        return result;
    }

    public static int[] di(int n, int a, int[] omega) {
        int[] result = new int[n];
        int h = 0;
        while (h < a) {
            int n2 = omega[h];
            result[n2] = result[n2] + 1;
            ++h;
        }
        return result;
    }

    public static int[][] T(int[] d, int[] genotype) {
        int[][] result = new int[2][2];
        int len = d.length;
        int h = 0;
        while (h < len) {
            int[] nArray = result[d[h]];
            int n = genotype[h];
            nArray[n] = nArray[n] + 1;
            ++h;
        }
        return result;
    }

    public static double S(int[][] T) {
        return Permutation.Fst(T);
    }

    public static double PearsonScore(int[][] T) {
        int a1 = T[0][0];
        int a2 = T[0][1];
        int a = a1 + a2;
        int b1 = T[1][0];
        int b2 = T[1][1];
        int b = b1 + b2;
        int n1 = a1 + b1;
        int n2 = a2 + b2;
        int n = n1 + n2;
        return (double)n * (double)(a1 * b2 - a2 * b1) * (double)(a1 * b2 - a2 * b1) / (double)(a * b * n1 * n2);
    }

    public static double Fst(int[][] T) {
        double a1 = T[0][0];
        double a2 = T[0][1];
        double a = a1 + a2;
        double b1 = T[1][0];
        double b2 = T[1][1];
        double b = b1 + b2;
        double n1 = a1 + b1;
        double n2 = a2 + b2;
        double n = n1 + n2;
        double p = a / n;
        double p1 = a1 / n1;
        double p2 = a2 / n2;
        double Hs = 0.5 * (p1 * (1.0 - p1) + p2 * (1.0 - p2));
        double Ht = p * (1.0 - p);
        double Fst = 1.0 - Hs / Ht;
        return Fst;
    }

    public static void showVector(int[] data) {
        int h = 0;
        while (h < data.length) {
            System.out.print(data[h]);
            System.out.print("\t");
            ++h;
        }
        System.out.println();
    }
}

