/*
 * Decompiled with CFR 0.152.
 */
package WorksFromRY;

import WorksFromRY.Permutation;

public class FstPermutation {
    public static void main(String[] args) {
        int a1 = 66;
        int a2 = 34;
        int b1 = 90;
        int b2 = 10;
        int a = a1 + a2;
        int b = b1 + b2;
        int n = a + b;
        String typeA = "AAA";
        String typeB = "ATT";
        String[] sequence = new String[n];
        System.out.println(FstPermutation.diff(typeA, typeB));
        int[] type = new int[n];
        int[] observedOrder = new int[n];
        int h = 0;
        while (h < n) {
            sequence[h] = typeB;
            if (h >= 0 && h < a1) {
                sequence[h] = typeA;
            }
            if (a <= h && h < a + b1) {
                sequence[h] = typeA;
            }
            if (h >= 0 && h < a) {
                type[h] = 1;
            }
            if (a <= h && h < n) {
                type[h] = 0;
            }
            observedOrder[h] = h;
            ++h;
        }
        double FstObs = FstPermutation.Fst92(type, sequence);
        System.out.println(FstObs);
        int repeat = 100000;
        int count = 0;
        int i = 0;
        while (i < repeat) {
            int[] omega = Permutation.omega(n);
            int[] di = Permutation.di(n, a, omega);
            double FstPerm = FstPermutation.Fst92(di, sequence);
            if (FstPerm > FstObs) {
                ++count;
            }
            ++i;
        }
        System.out.println((double)count / (double)repeat);
    }

    public static double Fst92(int[] type, String[] seq) {
        int len = type.length;
        if (len > seq.length) {
            len = seq.length;
        }
        int count0 = 0;
        int count1 = 0;
        int i = 0;
        while (i < len) {
            if (type[i] == 0) {
                ++count0;
            }
            if (type[i] == 1) {
                ++count1;
            }
            ++i;
        }
        String[] pop0 = new String[count0];
        String[] pop1 = new String[count1];
        int c0 = 0;
        int c1 = 0;
        int i2 = 0;
        while (i2 < len) {
            if (type[i2] == 0) {
                pop0[c0] = seq[i2];
                ++c0;
            }
            if (type[i2] == 1) {
                pop1[c1] = seq[i2];
                ++c1;
            }
            ++i2;
        }
        double Hw = FstPermutation.Hw(pop0, pop1);
        double Hb = FstPermutation.Hb(pop0, pop1);
        return 1.0 - Hw / Hb;
    }

    static double Hw(String[] pop) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop.length - 1) {
            int j = i + 1;
            while (j < pop.length) {
                count += 1.0;
                result += FstPermutation.diff(pop[i], pop[j]);
                ++j;
            }
            ++i;
        }
        return result / count;
    }

    static double Hw(String[] pop1, String[] pop2) {
        double count1 = pop1.length;
        double count2 = pop2.length;
        return (FstPermutation.Hw(pop1) * count1 + FstPermutation.Hw(pop2) * count2) / (count1 + count2);
    }

    static double Hb(String[] pop1, String[] pop2) {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < pop1.length - 1) {
            int j = 0;
            while (j < pop2.length) {
                count += 1.0;
                result += FstPermutation.diff(pop1[i], pop2[j]);
                ++j;
            }
            ++i;
        }
        return result / count;
    }

    static double diff(String seq1, String seq2) {
        double result = 0.0;
        int len = seq1.length();
        if (len > seq2.length()) {
            len = seq2.length();
        }
        int i = 0;
        while (i < len) {
            if (seq1.charAt(i) != seq2.charAt(i)) {
                result += 1.0;
            }
            ++i;
        }
        return result;
    }
}

