/*
 * Decompiled with CFR 0.152.
 */
package TablePlot2D;

import Tool.PlotTools;
import Tool.StatTools;
import Tool.Tools;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class Prob2x2 {
    public static void main(String[] args) {
        int R1 = 500;
        int R2 = 500;
        int[] Marginal = Prob2x2.setMarginal(R1, R2);
        R1 = Marginal[0];
        R2 = Marginal[1];
        int N = Marginal[2];
        int MinC1 = Marginal[3];
        int MaxC1 = Marginal[4];
        int numDot = Marginal[5];
        int[] posiP = new int[]{1, 2};
        double[] logFact = new double[N + 1];
        double ThresChi = 59.89609;
        double[] contourLevelP = new double[]{1.0, 0.1, Math.pow(10.0, -10.0), Math.pow(10.0, -50.0)};
        double[] contourLevelC = new double[]{0.0, 2.705543, 41.82146, 224.3847};
        double[] tmpArray1 = new double[]{0.01, 0.1, 0.2, 1.0, 0.2, 0.1, 0.001};
        double[] tmpArray2 = new double[]{0.01, 0.1, 0.2, 1.0, 1.0, 0.2, 0.1, 0.001};
        int i = 0;
        while (i < N + 1) {
            logFact[i] = Tools.factlog(i);
            ++i;
        }
        boolean df = true;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df);
        int[][] ArrayC1x = Prob2x2.MakeArrayC1x(Marginal);
        try {
            double[][] Prob = Prob2x2.CalcProbPC1x(Marginal, logFact, chidf1, ThresChi);
            N = 100;
            int z = 40;
            PlotTools.Array2(Prob2x2.CalcProbXY(N, z, logFact));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static int DecideRatioStateOneThres(double Ratio, double Thres) {
        int ret = -99;
        if (Ratio < 0.0) {
            ret = 0;
        } else if (Ratio < 1.0 / Thres) {
            ret = 1;
        } else if (Ratio < Thres) {
            ret = 2;
        } else if (Ratio >= Thres) {
            ret = 3;
        }
        return ret;
    }

    public static int DecideRatioState(double Ratio, double ThresL, double ThresH) {
        int ret = -99;
        if (Ratio < 0.0) {
            ret = 0;
        } else if (Ratio < 1.0 / ThresH) {
            ret = 1;
        } else if (Ratio < 1.0 / ThresL) {
            ret = 2;
        } else if (Ratio < ThresL) {
            ret = 3;
        } else if (Ratio < ThresH) {
            ret = 4;
        } else if (Ratio >= ThresH) {
            ret = 5;
        }
        return ret;
    }

    public static double[] DecidePosiUpDown(double[] Array, double level) {
        double[] ret = new double[2];
        int len = Array.length;
        boolean up = false;
        boolean down = false;
        ret[0] = -99.0;
        ret[1] = -99.0;
        int i = 0;
        while (i < len) {
            if (Array[i] == level && !up) {
                ret[0] = i;
                up = true;
            } else if (Array[i] > level && !up) {
                ret[0] = (double)i - 0.5;
                up = true;
            }
            if (Array[len - 1 - i] == level && !down) {
                ret[1] = len - 1 - i;
                down = true;
            } else if (Array[len - 1 - i] > level && !down) {
                ret[1] = (double)(len - 1 - i) + 0.5;
                down = true;
            }
            ++i;
        }
        if (ret[0] < 0.0) {
            ret[0] = -99.0;
        }
        if (ret[1] > (double)(len - 1)) {
            ret[1] = -99.0;
        }
        return ret;
    }

    public static double[] DecidePosiDownUp(double[] Array, double level) {
        double[] ret = new double[2];
        int len = Array.length;
        boolean up = false;
        boolean down = false;
        ret[0] = -99.0;
        ret[1] = -99.0;
        int i = 0;
        while (i < len) {
            if (Array[i] == level && !down) {
                ret[0] = i;
                down = true;
            } else if (Array[i] < level && !down) {
                ret[0] = (double)i - 0.5;
                down = true;
            }
            if (Array[len - 1 - i] == level && !up) {
                ret[1] = len - 1 - i;
                up = true;
            } else if (Array[len - 1 - i] < level && !up) {
                ret[1] = (double)(len - 1 - i) + 0.5;
                up = true;
            }
            ++i;
        }
        if (ret[0] < 0.0) {
            ret[0] = -99.0;
        }
        if (ret[1] > (double)(len - 1)) {
            ret[1] = -99.0;
        }
        return ret;
    }

    public static double[][] MeasureContourMidP(int[] Marginal, double[][] Prob, double[] contourLevelP, double[] contourLevelC, int[] posi, int[] PCflag) {
        int R1 = Marginal[0];
        int R2 = Marginal[1];
        int N = Marginal[2];
        int MinC1 = Marginal[3];
        int MaxC1 = Marginal[4];
        int numDot = Marginal[5];
        int len = contourLevelP.length;
        int lenVar = posi.length;
        int counter = 0;
        double[] tmpPosi = new double[2];
        double[][] ret = new double[(MaxC1 - MinC1 + 1) * 2][len * lenVar + 1];
        int i = MinC1;
        while (i <= MaxC1) {
            ret[(i - MinC1) * 2][0] = i;
            ret[(i - MinC1) * 2 + 1][0] = i;
            double[] Array = new double[Math.min(i, R1) + 1];
            int k = 0;
            while (k < lenVar) {
                int j = 0;
                while (j <= Math.min(i, R1)) {
                    Array[j] = Prob[counter + j][posi[k]];
                    ++j;
                }
                int l = 0;
                while (l < len) {
                    if (PCflag[k] == 0) {
                        tmpPosi = Prob2x2.DecidePosiUpDown(Array, contourLevelP[l]);
                    } else if (PCflag[k] == 1) {
                        tmpPosi = Prob2x2.DecidePosiDownUp(Array, contourLevelC[l]);
                    }
                    ret[(i - MinC1) * 2][k * len + l + 1] = tmpPosi[0];
                    ret[(i - MinC1) * 2 + 1][k * len + l + 1] = tmpPosi[1];
                    ++l;
                }
                ++k;
            }
            counter += Math.min(i, R1) + 1;
            ++i;
        }
        return ret;
    }

    public static double[][] MeasureContour(int[] Marginal, double[][] Prob, double[] contourLevelP, double[] contourLevelC, int[] posi) {
        int R1 = Marginal[0];
        int R2 = Marginal[1];
        int N = Marginal[2];
        int MinC1 = Marginal[3];
        int MaxC1 = Marginal[4];
        int numDot = Marginal[5];
        int len = contourLevelP.length;
        int counter = 0;
        double[] tmpPosi = new double[2];
        double[][] ret = new double[(MaxC1 - MinC1 + 1) * 2][len * 2 + 1];
        int i = MinC1;
        while (i <= MaxC1) {
            ret[(i - MinC1) * 2][0] = i;
            ret[(i - MinC1) * 2 + 1][0] = i;
            double[] Array = new double[Math.min(i, R1) + 1];
            int k = 0;
            while (k < 2) {
                int j = 0;
                while (j <= Math.min(i, R1)) {
                    Array[j] = Prob[counter + j][posi[k]];
                    ++j;
                }
                int l = 0;
                while (l < len) {
                    if (k == 0) {
                        tmpPosi = Prob2x2.DecidePosiUpDown(Array, contourLevelP[l]);
                    } else if (k == 1) {
                        tmpPosi = Prob2x2.DecidePosiDownUp(Array, contourLevelC[l]);
                    }
                    ret[(i - MinC1) * 2][k * len + l + 1] = tmpPosi[0];
                    ret[(i - MinC1) * 2 + 1][k * len + l + 1] = tmpPosi[1];
                    ++l;
                }
                ++k;
            }
            counter += Math.min(i, R1) + 1;
            ++i;
        }
        return ret;
    }

    public static double[][] CalcProbXY(int N, int z, double[] logFact) {
        int numDot = (N - z + 1) * (N - z + 2) / 2;
        int counter = 0;
        double[][] ret = new double[numDot][7];
        int[] tmp = new int[4];
        int x = z;
        while (x <= N) {
            int y = z;
            while (y <= N + z - x) {
                ret[counter][0] = x;
                ret[counter][1] = y;
                tmp[0] = z;
                tmp[1] = x - z;
                tmp[2] = y - z;
                tmp[3] = N - x - y + z;
                ret[counter][5] = StatTools.Chi2Count(tmp);
                ret[counter][6] = StatTools.Chi2CountYates(tmp);
                double logBase = logFact[x] + logFact[N - x] + logFact[y] + logFact[N - y] - logFact[N];
                double logVar = logFact[tmp[0]] + logFact[tmp[1]] + logFact[tmp[2]] + logFact[tmp[3]];
                double[] ExactP = StatTools.FisherCountMidP2x2(tmp, logFact);
                ret[counter][2] = Math.exp(logBase - logVar);
                ret[counter][3] = ExactP[0];
                ret[counter][4] = ExactP[1];
                ++counter;
                ++y;
            }
            ++x;
        }
        return ret;
    }

    public static double[][] CalcProbPC1xMidP(int[] Marginal, double[] logFact, ChiSquaredDistributionImpl chidf1, double ThresChi) throws Exception {
        int R1 = Marginal[0];
        int R2 = Marginal[1];
        int N = Marginal[2];
        int MinC1 = Marginal[3];
        int MaxC1 = Marginal[4];
        int numDot = Marginal[5];
        int[] tmp = new int[4];
        int counter = 0;
        double[][] ProbP = new double[numDot][10];
        int i = MinC1;
        while (i <= MaxC1) {
            int C2 = N - i;
            double logBase = logFact[R1] + logFact[R2] + logFact[i] + logFact[C2] - logFact[N];
            double[] logVar = new double[Math.min(i, R1) + 1];
            int j = 0;
            while (j <= Math.min(i, R1)) {
                tmp[0] = j;
                tmp[1] = R1 - j;
                tmp[2] = i - j;
                tmp[3] = R2 - i + j;
                double Chi = StatTools.Chi2Count(tmp);
                Tools.NormalSort1arrayInt(tmp);
                logVar[j] = logFact[tmp[0]] + logFact[tmp[1]] + logFact[tmp[2]] + logFact[tmp[3]];
                ProbP[counter + j][0] = Math.exp(logBase - logVar[j]);
                ProbP[counter + j][2] = Chi;
                if (Chi <= ThresChi) {
                    ProbP[counter + j][3] = Chi;
                    ProbP[counter + j][4] = StatTools.TranslateToPdf1(Chi, chidf1);
                } else {
                    ProbP[counter + j][3] = -99.0;
                    ProbP[counter + j][4] = -99.0;
                }
                ProbP[counter + j][5] = ProbP[counter + j][3] / ProbP[counter + j][0];
                ++j;
            }
            j = 0;
            while (j <= Math.min(i, R1)) {
                double ExactP = 0.0;
                double MidP = 0.0;
                int k = 0;
                while (k <= Math.min(i, R1)) {
                    if (logVar[k] >= logVar[j]) {
                        ExactP += Math.exp(logBase - logVar[k]);
                    }
                    if (logVar[k] == logVar[j]) {
                        MidP += Math.exp(logBase - logVar[k]) / 2.0;
                    }
                    if (logVar[k] > logVar[j]) {
                        MidP += Math.exp(logBase - logVar[k]);
                    }
                    ++k;
                }
                if (Math.abs(1.0 - ExactP) < Math.pow(10.0, -7.0)) {
                    ExactP = 1.0;
                }
                if (Math.abs(1.0 - MidP) < Math.pow(10.0, -7.0)) {
                    MidP = 1.0;
                }
                ProbP[counter + j][1] = ExactP;
                ProbP[counter + j][6] = ProbP[counter + j][4] / ProbP[counter + j][1];
                ProbP[counter + j][7] = MidP;
                ProbP[counter + j][8] = ProbP[counter + j][7] / ProbP[counter + j][1];
                ProbP[counter + j][9] = ProbP[counter + j][4] / ProbP[counter + j][7];
                ++j;
            }
            counter += logVar.length;
            ++i;
        }
        return ProbP;
    }

    public static double[][] CalcProbPC1x(int[] Marginal, double[] logFact, ChiSquaredDistributionImpl chidf1, double ThresChi) throws Exception {
        int R1 = Marginal[0];
        int R2 = Marginal[1];
        int N = Marginal[2];
        int MinC1 = Marginal[3];
        int MaxC1 = Marginal[4];
        int numDot = Marginal[5];
        int[] tmp = new int[4];
        int counter = 0;
        double[][] ProbP = new double[numDot][7];
        int i = MinC1;
        while (i <= MaxC1) {
            int C2 = N - i;
            double logBase = logFact[R1] + logFact[R2] + logFact[i] + logFact[C2] - logFact[N];
            double[] logVar = new double[Math.min(i, R1) + 1];
            int j = 0;
            while (j <= Math.min(i, R1)) {
                tmp[0] = j;
                tmp[1] = R1 - j;
                tmp[2] = i - j;
                tmp[3] = R2 - i + j;
                double Chi = StatTools.Chi2Count(tmp);
                Tools.NormalSort1arrayInt(tmp);
                logVar[j] = logFact[tmp[0]] + logFact[tmp[1]] + logFact[tmp[2]] + logFact[tmp[3]];
                ProbP[counter + j][0] = Math.exp(logBase - logVar[j]);
                ProbP[counter + j][2] = Chi;
                if (Chi <= ThresChi) {
                    ProbP[counter + j][3] = Chi;
                    ProbP[counter + j][4] = StatTools.TranslateToPdf1(Chi, chidf1);
                } else {
                    ProbP[counter + j][3] = -99.0;
                    ProbP[counter + j][4] = -99.0;
                }
                ProbP[counter + j][5] = ProbP[counter + j][3] / ProbP[counter + j][0];
                ++j;
            }
            j = 0;
            while (j <= Math.min(i, R1)) {
                double ExactP = 0.0;
                int k = 0;
                while (k <= Math.min(i, R1)) {
                    if (logVar[k] >= logVar[j]) {
                        ExactP += Math.exp(logBase - logVar[k]);
                    }
                    ++k;
                }
                if (Math.abs(1.0 - ExactP) < Math.pow(10.0, -7.0)) {
                    ExactP = 1.0;
                }
                ProbP[counter + j][1] = ExactP;
                ProbP[counter + j][6] = ProbP[counter + j][4] / ProbP[counter + j][1];
                ++j;
            }
            counter += logVar.length;
            ++i;
        }
        return ProbP;
    }

    public static int[][] MakeArrayC1x(int[] Marginal) {
        int R1 = Marginal[0];
        int MinC1 = Marginal[3];
        int MaxC1 = Marginal[4];
        int numDot = Marginal[5];
        int[][] ret = new int[numDot][2];
        int counter = 0;
        int i = MinC1;
        while (i <= MaxC1) {
            int j = 0;
            while (j <= Math.min(i, R1)) {
                ret[counter][0] = i;
                ret[counter][1] = j++;
                ++counter;
            }
            ++i;
        }
        return ret;
    }

    public static int[] setMarginal(int R1, int R2) {
        int[] ret = new int[6];
        ret[0] = Math.min(R1, R2);
        ret[1] = Math.max(R1, R2);
        ret[2] = R1 + R2;
        ret[3] = 1;
        ret[4] = (int)Math.floor((double)ret[2] / 2.0);
        int k = ret[4] + 1;
        int m = ret[4] - R1;
        ret[5] = k * (k + 1) / 2 - m * (m + 1) / 2 - 1;
        return ret;
    }
}

