/*
 * Decompiled with CFR 0.152.
 */
package TablePlot2D;

import TablePlot2D.Prob2x2;
import Tool.ArrayTools;
import Tool.CorresTable;
import Tool.FileTools;
import Tool.StatTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class CalcProb2x2XYZ {
    public static void main(String[] args) {
        int N = 100;
        int ThresN = 400;
        int ThresK = 5;
        double ThresChi = 45.0;
        double ThresH = 5.0;
        double ThresL = 1.2;
        double ThresAdd = 1.5;
        double[] CutValue = new double[]{0.0, 0.01, 0.03, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.496, 0.5, 0.504, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 0.97, 0.99, 1.0};
        double[] ThresP = new double[]{1.1, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, Math.pow(10.0, -20.0), Math.pow(10.0, -30.0), Math.pow(10.0, -40.0), Math.pow(10.0, -50.0), Math.pow(10.0, -60.0), Math.pow(10.0, -70.0), Math.pow(10.0, -80.0), Math.pow(10.0, -90.0), Math.pow(10.0, -100.0)};
        int[] CutValueInt = new int[CutValue.length];
        int i = 0;
        while (i < CutValue.length) {
            CutValueInt[i] = (int)Math.round((double)N * CutValue[i]);
            ++i;
        }
        int numCondition = (CutValueInt.length * 2 + 1) * ThresP.length;
        int[][] StateCounterC = new int[numCondition][6];
        int[][] StateCounterY = new int[numCondition][6];
        int[][] StateCounterR5 = new int[numCondition][6];
        int[][] StateCounterNR5 = new int[numCondition][6];
        int[][] StateCounterAfR5 = new int[numCondition][6];
        String[] StateStr = new String[numCondition];
        ArrayTools.InitialaizeArray2(StateCounterC);
        ArrayTools.InitialaizeArray2(StateCounterY);
        ArrayTools.InitialaizeArray2(StateCounterR5);
        ArrayTools.InitialaizeArray2(StateCounterNR5);
        ArrayTools.InitialaizeArray2(StateCounterAfR5);
        int counterS = 0;
        int i2 = 0;
        while (i2 < ThresP.length) {
            StateStr[counterS] = "All\t-\t" + Math.min(ThresP[i2], 1.0) + "\t";
            ++counterS;
            int j = 0;
            while (j < CutValueInt.length) {
                StateStr[counterS] = "x\t" + CutValueInt[j] + "\t" + Math.min(ThresP[i2], 1.0) + "\t";
                ++counterS;
                ++j;
            }
            j = 0;
            while (j < CutValueInt.length) {
                StateStr[counterS] = "z\t" + CutValueInt[j] + "\t" + Math.min(ThresP[i2], 1.0) + "\t";
                ++counterS;
                ++j;
            }
            ++i2;
        }
        String CorresFile = "P_Chi_CorresTable_mid.txt";
        String outfile = "TetraTable";
        String out = "";
        boolean all = false;
        boolean rule = false;
        boolean RatioLMH = false;
        int i3 = 0;
        while (i3 < args.length) {
            if (args[i3].equals("-N")) {
                N = Integer.parseInt(args[i3 + 1]);
            }
            if (args[i3].equals("-ThresChi")) {
                ThresChi = Double.parseDouble(args[i3 + 1]);
            }
            if (args[i3].equals("-out")) {
                outfile = args[i3 + 1];
            }
            if (args[i3].equals("-all")) {
                all = true;
            }
            if (args[i3].equals("-rule")) {
                rule = true;
            }
            ++i3;
        }
        outfile = String.valueOf(outfile) + "_" + ThresH + "_" + ThresL + "_frule" + ThresK;
        String outfile_all = String.valueOf(outfile) + "_" + N + "_XYZ_all.txt";
        String outfile_Exp5 = String.valueOf(outfile) + "_" + N + "_XYZ_Exp5.txt";
        String outfile_Obs5 = String.valueOf(outfile) + "_" + N + "_XYZ_Obs5.txt";
        String outfile_Exp5in = String.valueOf(outfile) + "_" + N + "_XYZ_Exp5in.txt";
        String outfile_RatioH = String.valueOf(outfile) + "_" + N + "_XYZ_RatioH.txt";
        String outfile_RatioM = String.valueOf(outfile) + "_" + N + "_XYZ_RatioM.txt";
        String outfile_RatioL = String.valueOf(outfile) + "_" + N + "_XYZ_RatioL.txt";
        String outfile_Count = String.valueOf(outfile) + "_" + N + "_XYZ_Count.txt";
        double[] logFact = new double[N + 1];
        int i4 = 0;
        while (i4 < N + 1) {
            logFact[i4] = Tools.factlog(i4);
            ++i4;
        }
        boolean df1 = true;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df1);
        BufferedWriter[] bw = new BufferedWriter[8];
        int i5 = 0;
        while (i5 < bw.length) {
            bw[i5] = null;
            ++i5;
        }
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile_all));
            bw[1] = new BufferedWriter(new FileWriter(outfile_Exp5));
            bw[2] = new BufferedWriter(new FileWriter(outfile_Obs5));
            bw[3] = new BufferedWriter(new FileWriter(outfile_Exp5in));
            bw[4] = new BufferedWriter(new FileWriter(outfile_RatioH));
            bw[5] = new BufferedWriter(new FileWriter(outfile_RatioM));
            bw[6] = new BufferedWriter(new FileWriter(outfile_RatioL));
            bw[7] = new BufferedWriter(new FileWriter(outfile_Count));
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            out = "x\ty\tz\tChi\tYates\tChiP\tYatesP\tExactP\tRatioCE\tRatioYE\trFive\n";
            FileTools.out3File(bw[0], out);
            out = "x\ty\tz\tExactP\tRatioCE\tRatioYE\n";
            FileTools.out3File(bw[1], out);
            FileTools.out3File(bw[2], out);
            FileTools.out3File(bw[3], out);
            out = "x\ty\tz\tRatioCE\n";
            FileTools.out3File(bw[4], out);
            FileTools.out3File(bw[5], out);
            FileTools.out3File(bw[6], out);
            int[] tmp = new int[4];
            int x = 0;
            while (x <= N) {
                System.out.println(x);
                int y = 0;
                while (y <= N) {
                    double logBase = logFact[x] + logFact[y] + logFact[N - x] + logFact[N - y] - logFact[N];
                    double[] logVar = new double[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    double[][] ProbP = new double[Math.min(x, y) - Math.max(0, x + y - N) + 1][10];
                    int[] ruleOfFiveExp = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int[] ruleOfFiveObs = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int[] ruleOfTenExp = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int z = Math.max(0, x + y - N);
                    while (z <= Math.min(x, y)) {
                        int ord = z - Math.max(0, x + y - N);
                        tmp[0] = z;
                        tmp[1] = x - z;
                        tmp[2] = y - z;
                        tmp[3] = N - x - y + z;
                        ProbP[ord][0] = x;
                        ProbP[ord][1] = y;
                        ProbP[ord][2] = z;
                        double Chi = StatTools.Chi2Count(tmp);
                        double YatesChi = StatTools.Chi2CountYates(tmp);
                        ProbP[ord][3] = Chi;
                        ProbP[ord][4] = YatesChi;
                        ProbP[ord][5] = Chi == -99.0 ? -99.0 : (Chi <= ThresChi ? StatTools.TranslateToPdf1(Chi, chidf1) : CorresTable.ConvChitoPbyCorres(Chi, CorresTableChi, 1));
                        ProbP[ord][6] = YatesChi == -99.0 ? -99.0 : (YatesChi <= ThresChi ? StatTools.TranslateToPdf1(YatesChi, chidf1) : CorresTable.ConvChitoPbyCorres(YatesChi, CorresTableChi, 1));
                        ruleOfFiveExp[ord] = StatTools.ruleOfkExp(tmp, ThresK);
                        ruleOfFiveObs[ord] = StatTools.ruleOfkObs(tmp, ThresK - 2);
                        ruleOfTenExp[ord] = StatTools.ruleOfkExp(tmp, ThresK + 2);
                        Tools.NormalSort1arrayInt(tmp);
                        logVar[ord] = logFact[tmp[0]] + logFact[tmp[1]] + logFact[tmp[2]] + logFact[tmp[3]];
                        ++z;
                    }
                    z = Math.max(0, x + y - N);
                    while (z <= Math.min(x, y)) {
                        int ordz = z - Math.max(0, x + y - N);
                        double ExactP = 0.0;
                        int k = Math.max(0, x + y - N);
                        while (k <= Math.min(x, y)) {
                            int ordk = k - Math.max(0, x + y - N);
                            if (logVar[ordk] >= logVar[ordz]) {
                                ExactP += Math.exp(logBase - logVar[ordk]);
                            }
                            ++k;
                        }
                        if (Math.abs(1.0 - ExactP) < Math.pow(10.0, -7.0)) {
                            ExactP = 1.0;
                        }
                        ProbP[ordz][7] = ExactP;
                        ProbP[ordz][8] = ProbP[ordz][5] / ExactP;
                        ProbP[ordz][9] = ProbP[ordz][6] / ExactP;
                        int RatioStateC = Prob2x2.DecideRatioState(ProbP[ordz][8], ThresL, ThresH);
                        int RatioStateY = Prob2x2.DecideRatioState(ProbP[ordz][9], ThresL, ThresH);
                        counterS = 0;
                        int i6 = 0;
                        while (i6 < ThresP.length) {
                            if (ExactP <= ThresP[i6]) {
                                int[] nArray = StateCounterC[counterS];
                                int n = RatioStateC;
                                nArray[n] = nArray[n] + 1;
                                int[] nArray2 = StateCounterY[counterS];
                                int n2 = RatioStateY;
                                nArray2[n2] = nArray2[n2] + 1;
                                if (ruleOfFiveExp[ordz] == 1) {
                                    int[] nArray3 = StateCounterR5[counterS];
                                    int n3 = RatioStateC;
                                    nArray3[n3] = nArray3[n3] + 1;
                                    int[] nArray4 = StateCounterAfR5[counterS];
                                    nArray4[3] = nArray4[3] + 1;
                                } else {
                                    int[] nArray5 = StateCounterNR5[counterS];
                                    int n4 = RatioStateC;
                                    nArray5[n4] = nArray5[n4] + 1;
                                    int[] nArray6 = StateCounterAfR5[counterS];
                                    int n5 = RatioStateC;
                                    nArray6[n5] = nArray6[n5] + 1;
                                }
                            }
                            ++counterS;
                            int j = 0;
                            while (j < CutValueInt.length) {
                                if (CutValueInt[j] == x && ExactP <= ThresP[i6]) {
                                    int[] nArray = StateCounterC[counterS];
                                    int n = RatioStateC;
                                    nArray[n] = nArray[n] + 1;
                                    int[] nArray7 = StateCounterY[counterS];
                                    int n6 = RatioStateY;
                                    nArray7[n6] = nArray7[n6] + 1;
                                    if (ruleOfFiveExp[ordz] == 1) {
                                        int[] nArray8 = StateCounterR5[counterS];
                                        int n7 = RatioStateC;
                                        nArray8[n7] = nArray8[n7] + 1;
                                        int[] nArray9 = StateCounterAfR5[counterS];
                                        nArray9[3] = nArray9[3] + 1;
                                    } else {
                                        int[] nArray10 = StateCounterNR5[counterS];
                                        int n8 = RatioStateC;
                                        nArray10[n8] = nArray10[n8] + 1;
                                        int[] nArray11 = StateCounterAfR5[counterS];
                                        int n9 = RatioStateC;
                                        nArray11[n9] = nArray11[n9] + 1;
                                    }
                                }
                                ++counterS;
                                ++j;
                            }
                            j = 0;
                            while (j < CutValueInt.length) {
                                if (CutValueInt[j] == z && ExactP <= ThresP[i6]) {
                                    int[] nArray = StateCounterC[counterS];
                                    int n = RatioStateC;
                                    nArray[n] = nArray[n] + 1;
                                    int[] nArray12 = StateCounterY[counterS];
                                    int n10 = RatioStateY;
                                    nArray12[n10] = nArray12[n10] + 1;
                                    if (ruleOfFiveExp[ordz] == 1) {
                                        int[] nArray13 = StateCounterR5[counterS];
                                        int n11 = RatioStateC;
                                        nArray13[n11] = nArray13[n11] + 1;
                                        int[] nArray14 = StateCounterAfR5[counterS];
                                        nArray14[3] = nArray14[3] + 1;
                                    } else {
                                        int[] nArray15 = StateCounterNR5[counterS];
                                        int n12 = RatioStateC;
                                        nArray15[n12] = nArray15[n12] + 1;
                                        int[] nArray16 = StateCounterAfR5[counterS];
                                        int n13 = RatioStateC;
                                        nArray16[n13] = nArray16[n13] + 1;
                                    }
                                }
                                ++counterS;
                                ++j;
                            }
                            ++i6;
                        }
                        ++z;
                    }
                    int i7 = 0;
                    while (i7 < ProbP.length) {
                        out = "";
                        int j = 0;
                        while (j < ProbP[0].length) {
                            out = String.valueOf(out) + ProbP[i7][j] + "\t";
                            ++j;
                        }
                        out = String.valueOf(out) + ruleOfFiveExp[i7] + "\n";
                        if (all) {
                            FileTools.out3File(bw[0], out);
                        }
                        out = String.valueOf(ProbP[i7][0]) + "\t" + ProbP[i7][1] + "\t" + ProbP[i7][2] + "\t" + ProbP[i7][7] + "\t" + ProbP[i7][8] + "\t" + ProbP[i7][9] + "\n";
                        if (rule) {
                            if (ruleOfFiveExp[i7] == 1) {
                                FileTools.out3File(bw[1], out);
                            }
                            if (ruleOfFiveObs[i7] == 1) {
                                FileTools.out3File(bw[2], out);
                            }
                            if (ruleOfFiveExp[i7] == 0 && (ruleOfFiveObs[i7] == 1 || ruleOfTenExp[i7] == 1)) {
                                FileTools.out3File(bw[3], out);
                            }
                        }
                        out = String.valueOf(ProbP[i7][0]) + "\t" + ProbP[i7][1] + "\t" + ProbP[i7][2] + "\t" + ProbP[i7][8] + "\n";
                        if (RatioLMH && (Math.random() < 0.2 || N < ThresN)) {
                            if (ProbP[i7][8] > ThresH) {
                                FileTools.out3File(bw[4], out);
                            } else if (ProbP[i7][8] <= ThresL && ProbP[i7][8] >= ThresAdd || ProbP[i7][8] >= 1.0 / ThresL && ProbP[i7][8] <= 1.0 / ThresAdd) {
                                FileTools.out3File(bw[5], out);
                            } else if (ProbP[i7][8] < 1.0 / ThresH && ProbP[i7][8] >= 0.0) {
                                FileTools.out3File(bw[6], out);
                            }
                        }
                        ++i7;
                    }
                    ++y;
                }
                ++x;
            }
            String outTmp = "-\t-\t-\t-\t-\t-\t-\t-\t-\t-\t-\t-\t";
            out = String.valueOf(ThresH) + "\t" + ThresL + "\t" + ThresK + "\t" + "Normal\t" + outTmp + "Yates\t" + outTmp + "RuleOf5\t" + outTmp + "NotRuleOf5\t" + outTmp + "AfRuleOf5\t" + outTmp + "\n";
            outTmp = "-99\t<1/TH\t1/TH~1/TM\t1/TM~TM\tTM~TH\t>TH\tSum\t-99\t<1/TH(f)\t1/TH~1/TM(f)\t1/TM~TM(f)\tTM~TH(f)\t>TH(f)\t";
            out = String.valueOf(out) + "Type\tCutVal\tP\t" + outTmp + outTmp + outTmp + outTmp + outTmp + "\n";
            FileTools.out3File(bw[7], out);
            int i8 = 0;
            while (i8 < numCondition) {
                out = StateStr[i8];
                out = String.valueOf(out) + CalcProb2x2XYZ.AddStateCounter(StateCounterC, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ.AddStateCounter(StateCounterY, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ.AddStateCounter(StateCounterR5, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ.AddStateCounter(StateCounterNR5, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ.AddStateCounter(StateCounterAfR5, i8);
                out = String.valueOf(out) + "\n";
                FileTools.out3File(bw[7], out);
                ++i8;
            }
            i8 = 0;
            while (i8 < bw.length) {
                bw[i8].close();
                ++i8;
            }
            if (!all) {
                FileTools.FileDelete(outfile_all);
            }
            if (!rule) {
                FileTools.FileDelete(outfile_Exp5);
                FileTools.FileDelete(outfile_Obs5);
                FileTools.FileDelete(outfile_Exp5in);
            }
            if (!RatioLMH) {
                FileTools.FileDelete(outfile_RatioH);
                FileTools.FileDelete(outfile_RatioM);
                FileTools.FileDelete(outfile_RatioL);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String AddStateCounter(int[][] StateCounter, int nrow) {
        String out = "";
        double[] Freq = CalcProb2x2XYZ.CalcFreqState(StateCounter, nrow);
        int i = 0;
        while (i < StateCounter[0].length) {
            out = String.valueOf(out) + StateCounter[nrow][i] + "\t";
            ++i;
        }
        i = 0;
        while (i < Freq.length) {
            out = String.valueOf(out) + Freq[i] + "\t";
            ++i;
        }
        return out;
    }

    public static double[] CalcFreqState(int[][] StateCounter, int nrow) {
        double[] ret = new double[StateCounter[0].length + 1];
        int sum = 0;
        int j = 0;
        while (j < StateCounter[0].length) {
            sum += StateCounter[nrow][j];
            ++j;
        }
        ret[0] = sum;
        j = 0;
        while (j < StateCounter[0].length) {
            ret[j + 1] = (double)StateCounter[nrow][j] / (double)sum;
            ++j;
        }
        return ret;
    }
}

