/*
 * Decompiled with CFR 0.152.
 */
package StepWisePheno;

import Tool.ArrayTools;
import Tool.CorresTable;
import Tool.Disturibution;
import Tool.FileTools;
import Tool.PlotTools;
import Tool.StatTools;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class MultiPhenoTools {
    public static void main(String[] args) {
        String CorresFile = "P_Chi_CorresTable_mid.txt";
        try {
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            CorresTable.ConvChitoPbyCorres(100.01, CorresTableChi, 1);
            ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
            int[][] MultiPhenoH0_1 = new int[][]{{80, 234, 186}, {92, 231, 177}, {70, 253, 177}, {65, 240, 195}, {70, 237, 193}, {75, 236, 189}, {76, 243, 181}, {78, 237, 185}, {76, 236, 188}, {75, 234, 191}};
            int[][] MultiPhenoH1_2 = new int[][]{{88, 230, 182}, {84, 235, 181}, {76, 245, 179}, {65, 235, 200}, {75, 247, 178}, {66, 247, 187}, {39, 207, 254}, {53, 212, 235}, {56, 199, 245}, {52, 228, 220}};
            int[][] MultiPhenoH1_3 = new int[][]{{77, 251, 172}, {71, 251, 178}, {85, 239, 176}, {68, 241, 191}, {44, 226, 230}, {53, 205, 242}, {46, 208, 246}, {132, 260, 108}, {126, 253, 121}, {129, 246, 125}};
            int[][] Array1 = new int[][]{{50, 60}, {40, 50}, {30, 40}, {20, 30}, {10, 20}};
            PlotTools.Array2(MultiPhenoTools.FindBestArrayBack(MultiPhenoTools.ConvertKx3toKx2(MultiPhenoH0_1), CorresTableChi, chidf1));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static int[][] FindBestArrayBack(int[][] BaseArray, double[][] CorresTableChi, ChiSquaredDistributionImpl chidf1) throws Exception {
        double Chi;
        int[][] Array = ArrayTools.CopyArray2(BaseArray);
        int orgdf = Array.length - 1;
        double orgChi = Chi = MultiPhenoTools.ChiTestKx2(Array);
        double P = StatTools.TranslateChitoP(Chi, Array.length - 1, CorresTableChi, chidf1);
        double ThresP = 0.05;
        boolean iter = true;
        while (iter) {
            int[][] tmpArray = MultiPhenoTools.FindMergedArrayMinP(Array);
            double tmpChi = MultiPhenoTools.ChiTestKx2(tmpArray);
            int tmpdf = tmpArray.length - 1;
            double tmpP = StatTools.TranslateChitoP(tmpChi, tmpdf, CorresTableChi, chidf1);
            double F = tmpChi / (double)tmpdf / ((orgChi - tmpChi) / (double)(orgdf - tmpdf));
            double Fdiff = tmpChi / (double)tmpdf / (Chi - tmpChi);
            double Pdiff = Disturibution.Fdist_upper(Fdiff, tmpdf, 1);
            if (Pdiff < ThresP && tmpArray.length >= 2) {
                P = tmpP;
                Chi = tmpChi;
                Array = ArrayTools.CopyArray2(tmpArray);
                if (Array.length != 2) continue;
                iter = false;
                continue;
            }
            iter = false;
        }
        return Array;
    }

    public static int[][] FindMergedArrayMinP(int[][] Array) {
        int len = Array.length;
        int[][] ret = new int[len - 1][2];
        int[][] tmpArray = new int[len - 1][2];
        int[][] CombiArray = MultiPhenoTools.CombinationK_2(len);
        int posiMinP = -1;
        double Chi = -1.0;
        int i = 0;
        while (i < CombiArray.length) {
            tmpArray = MultiPhenoTools.MergeArrayRow(Array, CombiArray[i][0], CombiArray[i][1]);
            double tmpChi = MultiPhenoTools.ChiTestKx2(tmpArray);
            if (tmpChi > Chi) {
                Chi = tmpChi;
                ret = ArrayTools.CopyArray2(tmpArray);
            }
            ++i;
        }
        return ret;
    }

    public static int[][] MergeArrayRow(int[][] Array, int posi1, int posi2) {
        int len = Array.length;
        int[][] ret = new int[len - 1][2];
        int counter = 1;
        ret[0][0] = Array[posi1][0] + Array[posi2][0];
        ret[0][1] = Array[posi1][1] + Array[posi2][1];
        int i = 0;
        while (i < len) {
            if (i != posi1 && i != posi2) {
                ret[counter][0] = Array[i][0];
                ret[counter][1] = Array[i][1];
                ++counter;
            }
            ++i;
        }
        return ret;
    }

    public static int[][] CombinationK_2(int k) {
        int len = k * (k - 1) / 2;
        int counter = 0;
        int[][] ret = new int[len][2];
        int i = 1;
        while (i < k) {
            int j = i + 1;
            while (j <= k) {
                ret[counter][0] = i - 1;
                ret[counter][1] = j - 1;
                ++counter;
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static int[][] ConvertKx3toKx2(int[][] Array) {
        int len = Array.length;
        int[][] ret = new int[len][2];
        int i = 0;
        while (i < len) {
            ret[i][0] = Array[i][0] * 2 + Array[i][1];
            ret[i][1] = Array[i][2] * 2 + Array[i][1];
            ++i;
        }
        return ret;
    }

    public static double ChiTestKx2(int[][] Array) {
        double ret = 0.0;
        int N = 0;
        int len = Array.length;
        int[] Col = new int[2];
        int[] Row = new int[len];
        int i = 0;
        while (i < len) {
            Row[i] = Array[i][0] + Array[i][1];
            Col[0] = Col[0] + Array[i][0];
            Col[1] = Col[1] + Array[i][1];
            N += Array[i][0] + Array[i][1];
            ++i;
        }
        i = 0;
        while (i < len) {
            int j = 0;
            while (j < 2) {
                double Exp = (double)Row[i] * (double)Col[j] / (double)N;
                ret += Math.pow(Exp - (double)Array[i][j], 2.0) / Exp;
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

