/*
 * Decompiled with CFR 0.152.
 */
package QTLAnalysis;

import Algorithms.MersenneTwisterFast;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.PlotTools;
import Tool.StatTools;
import WorksFromRY.LinearRegression;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class SerialDataGenerator {
    public static void main(String[] args) {
        String CorresFile = "P_Chi_CorresTable_mid.txt";
        int seed = 0;
        int x = 10000000;
        seed = (int)((double)x * Math.random());
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
        try {
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            double[] Norm = SerialDataGenerator.RandNormalDist(2.0, 4.0, 100, CorresTableChi, mz, chidf1);
            double[] genofreq = new double[]{0.16, 0.48, 0.36};
            double[] Geno = SerialDataGenerator.SerialData1SNP(100, genofreq, mz);
            int[] Count = SerialDataGenerator.CountData1SNP(100000, genofreq, mz);
            LinearRegression lr = new LinearRegression(Norm, Geno);
            double P = lr.p;
            System.out.println(P);
            double[][] Freq2D = GenoTools.DecideGenoFreqHWE_2D(0.2, 0.1);
            int[][] Count2D = GenoTools.DecideGenoCount_2D(10000000, Freq2D, mz);
            PlotTools.Array2(Count2D);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static double[] RandNormalDist(double mean, double var, int N, double[][] CorresTableChi, MersenneTwisterFast mz, ChiSquaredDistributionImpl chidf1) throws Exception {
        double[] ret = new double[N];
        double sd = Math.pow(var, 0.5);
        int i = 0;
        while (i < N) {
            ret[i] = Math.pow(StatTools.TranslatePtoChiDf1(mz.nextDouble(), CorresTableChi, chidf1), 0.5);
            if (mz.nextDouble() < 0.5) {
                ret[i] = ret[i] * -1.0;
            }
            ret[i] = ret[i] * sd + mean;
            ++i;
        }
        return ret;
    }

    public static double[] SerialData1SNP(int N, double[] genofreq, MersenneTwisterFast mz) {
        double[] ret = new double[N];
        int i = 0;
        while (i < N) {
            ret[i] = GenoTools.DecideGeno(genofreq[0], genofreq[1], genofreq[2], mz);
            ++i;
        }
        return ret;
    }

    public static int[] CountData1SNP(int N, double[] genofreq, MersenneTwisterFast mz) {
        int[] ret = new int[3];
        int i = 0;
        while (i < N) {
            byte by = GenoTools.DecideGeno(genofreq[0], genofreq[1], genofreq[2], mz);
            ret[by] = ret[by] + 1;
            ++i;
        }
        return ret;
    }
}

