/*
 * Decompiled with CFR 0.152.
 */
package QTLAnalysis;

import Tool.ArrayTools;
import Tool.Disturibution;
import Tool.FileTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class BetaCompPoly {
    public static void main(String[] args) {
        String inputfile = "RA_JpEu_stat_noAssoc_head";
        String out = "";
        double[] ThresP = new double[]{1.0, 0.5, 0.1, 0.05, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, Math.pow(10.0, -300.0)};
        int numThres = ThresP.length;
        double[] Likelihood = new double[numThres];
        int[] CountCncrd = new int[numThres];
        int[] CountTotal = new int[numThres];
        ArrayTools.InitializeArray1(Likelihood);
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-prefix")) {
                inputfile = args[i + 1];
            }
            ++i;
        }
        String outfileLike = String.valueOf(inputfile) + "_Likelihood.txt";
        inputfile = String.valueOf(inputfile) + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileLike));
            double[][] Stat = FileTools.readDatFileIOStringTABCol(inputfile, 2, 6);
            int numSNP = Stat.length;
            int i2 = 0;
            while (i2 < numSNP) {
                double Beta1 = Stat[i2][0];
                double SE1 = Stat[i2][1];
                double P1 = Stat[i2][2];
                double Beta2 = Stat[i2][3];
                double SE2 = Stat[i2][4];
                double P2 = Stat[i2][5];
                double ZNull = (Beta2 - 0.0) / SE2;
                double ZAltr = (Beta2 - Beta1) / SE2;
                double LikeNull = Disturibution.pdf_Norm_log(0.0, 1.0, ZNull);
                double LikeAltr = Disturibution.pdf_Norm_log(0.0, 1.0, ZAltr);
                int j = 0;
                while (j < numThres) {
                    if (P1 <= ThresP[j] + Math.pow(10.0, -300.0)) {
                        int n = j;
                        Likelihood[n] = Likelihood[n] + LikeAltr;
                        if (LikeAltr > LikeNull) {
                            int n2 = j;
                            CountCncrd[n2] = CountCncrd[n2] + 1;
                        }
                        int n3 = j;
                        CountTotal[n3] = CountTotal[n3] + 1;
                    } else {
                        int n = j;
                        Likelihood[n] = Likelihood[n] + LikeNull;
                    }
                    ++j;
                }
                ++i2;
            }
            out = "ThresP\tLikelihhod\n";
            FileTools.out3File(bw[0], out);
            int j = 0;
            while (j < numThres) {
                out = String.valueOf(ThresP[j]) + "\t" + Likelihood[j] + "\t" + CountCncrd[j] + "\t" + CountTotal[j] + "\t" + (double)CountCncrd[j] / (double)CountTotal[j] + "\n";
                FileTools.out3File(bw[0], out);
                ++j;
            }
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

