/*
 * Decompiled with CFR 0.152.
 */
package PairLD;

import PairLD.LDTools;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.PlotTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class PairWiseLDnear {
    public static void main(String[] args) {
        int NearSNP = 500;
        long Gap = 500000L;
        double[] af = new double[2];
        byte[] byArray = new byte[9];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byte[] genotypeNum = byArray;
        String inputfile = "ASN_QC3_PLINK_comm12";
        String inputfileList = "";
        String[] genotype = new String[]{"1 1", "1 2", "2 1", "2 2", "0 0", "0 1", "1 0", "0 2", "2 0"};
        String outfileSum = "";
        String out = "";
        String out2 = "";
        boolean list = true;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-file")) {
                inputfile = args[i + 1];
            }
            if (args[i].equals("-SNPlist")) {
                list = true;
            }
            if (args[i].equals("-NearSNP")) {
                NearSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Gap")) {
                Gap = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        outfileSum = String.valueOf(outfileSum) + inputfile + "_nearLDdata.txt";
        inputfileList = String.valueOf(inputfile) + ".info";
        inputfile = String.valueOf(inputfile) + ".geno";
        BufferedWriter[] bw = new BufferedWriter[]{null, null};
        try {
            int i2;
            bw[1] = new BufferedWriter(new FileWriter(outfileSum));
            byte[][] GenoArray = GenoTools.GenotypeConvert(inputfile, genotype, genotypeNum);
            int numSNP = GenoArray[0].length;
            int numSample = GenoArray.length;
            String[] SNPlist = new String[numSNP];
            long[] Posi = new long[numSNP];
            if (list) {
                String[][] tmp = FileTools.readDatFileIOStringTABString(inputfileList);
                i2 = 0;
                while (i2 < numSNP) {
                    SNPlist[i2] = tmp[i2][0];
                    Posi[i2] = Long.parseLong(tmp[i2][1]);
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < numSNP) {
                    SNPlist[i2] = "SNP" + (i2 + 1);
                    Posi[i2] = i2;
                    ++i2;
                }
            }
            byte[] SNP1 = new byte[numSample];
            byte[] SNP2 = new byte[numSample];
            int[][] geno = new int[3][3];
            FileTools.out3File(bw[1], out);
            int i3 = 0;
            while (i3 < numSNP - 1) {
                int j = i3;
                while (j < i3 + NearSNP + 1) {
                    int k = 0;
                    while (k < numSample) {
                        SNP1[k] = GenoArray[k][i3];
                        SNP2[k] = j < numSNP && Posi[j] - Posi[i3] < Gap ? GenoArray[k][j] : -1;
                        ++k;
                    }
                    geno = LDTools.make3x3table(SNP1, SNP2);
                    double[] hf = LDTools.pairwiseEM(geno);
                    af[0] = hf[0] + hf[1];
                    af[1] = hf[0] + hf[2];
                    double r2 = LDTools.Rsq(hf);
                    double D = LDTools.D(hf);
                    double Dprime = LDTools.Dprime(hf);
                    if (j < numSNP && Posi[j] - Posi[i3] < Gap) {
                        out = String.valueOf(SNPlist[i3]) + "\t" + SNPlist[j] + "\t" + PlotTools.DecimalHU(r2, 3) + "\t" + PlotTools.DecimalHU(Math.abs(Dprime), 3) + "\n";
                        if (j != i3) {
                            out = String.valueOf(out) + SNPlist[j] + "\t" + SNPlist[i3] + "\t" + PlotTools.DecimalHU(r2, 3) + "\t" + PlotTools.DecimalHU(Math.abs(Dprime), 3) + "\n";
                        }
                        FileTools.out3File(bw[1], out);
                    }
                    ++j;
                }
                ++i3;
            }
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

