/*
 * Decompiled with CFR 0.152.
 */
package Mains_meta;

import Tool.ArrayTools;
import Tool.FileTools;
import Tool.PlotTools;
import Tool.StatTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class MetaAnalysisBetaUnionCaCoGZIP {
    public static void main(String[] args) {
        String inputfile = "Ex_Meta_CaCo";
        String outfileGC = "";
        String outfileMeta = "";
        String outfileLog = "";
        String out = "";
        boolean GCeach = true;
        String CorresFile = "P_Chi_CorresTable_high.txt";
        double kiz = Math.pow(10.0, -10.0);
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-prefix")) {
                inputfile = args[i + 1];
            }
            if (args[i].equals("-noGCeach")) {
                GCeach = false;
            }
            ++i;
        }
        outfileGC = String.valueOf(inputfile) + "_GCed_gz.txt";
        outfileMeta = String.valueOf(inputfile) + "_GCed_Meta_res_gz.txt";
        outfileLog = String.valueOf(inputfile) + "_Meta_log_gz.txt";
        inputfile = String.valueOf(inputfile) + ".txt.gz";
        BufferedWriter[] bw = new BufferedWriter[]{null, null, null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileGC));
            bw[1] = new BufferedWriter(new FileWriter(outfileMeta));
            bw[2] = new BufferedWriter(new FileWriter(outfileLog));
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
            out = "Log for MetaAnalysisBeta.java\n\nInput File:\t" + inputfile + ".txt\nGC_for_each_study:\t" + GCeach + "\n\n";
            out = String.valueOf(out) + "Calculation started at:\t" + Tools.GetTime() + "\n\n";
            FileTools.out3File(bw[2], out);
            double[][] data = FileTools.readDatFileIOStringTABGZIPList(inputfile);
            int numSNP = data.length;
            int numStudy = data[0].length / 7;
            int numSNPMeta = 0;
            int[] numSNPeach = new int[numStudy];
            int[] numStudyeach = new int[numSNP];
            ArrayTools.InitializeArray1(numSNPeach);
            ArrayTools.InitializeArray1(numStudyeach);
            double[] lambda = new double[numStudy];
            double[][] Porg = new double[numSNP][numStudy];
            double[] NMeta_Ca = new double[numSNP];
            double[] NMeta_Co = new double[numSNP];
            double[] FreqMeta_Ca = new double[numSNP];
            double[] FreqMeta_Co = new double[numSNP];
            double[] BetaMeta = new double[numSNP];
            double[] SEMeta = new double[numSNP];
            double[] PMeta = new double[numSNP];
            double[] PMetaW = new double[numSNP];
            ArrayTools.InitializeArray1(NMeta_Ca);
            ArrayTools.InitializeArray1(NMeta_Co);
            ArrayTools.InitializeArray1(FreqMeta_Ca);
            ArrayTools.InitializeArray1(FreqMeta_Co);
            out = "No.Study:\t" + numStudy + "\nNo.SNP:\t" + numSNP + "\n\n";
            FileTools.out3File(bw[2], out);
            out = "";
            int i2 = 0;
            while (i2 < numStudy) {
                out = String.valueOf(out) + "N_Ca\tN_Co\tFreq_Ca\tFreq_Co\tBeta_GCed\tSE_GCed\tP_GCed\t";
                ++i2;
            }
            FileTools.out3File(bw[0], String.valueOf(out) + "\n");
            out = "NumStudy\tN_total_Ca\tN_total_Co\tFreq1_Ca\tFreq1_Co\tInv_Beta\tInv_SE\tInv_P\tWeight_P\n";
            FileTools.out3File(bw[1], out);
            i2 = 0;
            while (i2 < numSNP) {
                int j = 0;
                while (j < numStudy) {
                    if (!(data[i2][j * 7] > -99.0 - kiz) || !(data[i2][j * 7] < -99.0 + kiz)) {
                        int n = j;
                        numSNPeach[n] = numSNPeach[n] + 1;
                        Porg[numSNPeach[j]][j] = data[i2][j * 7 + 6];
                        int n2 = i2;
                        numStudyeach[n2] = numStudyeach[n2] + 1;
                    }
                    ++j;
                }
                if (numStudyeach[i2] > 0) {
                    ++numSNPMeta;
                }
                ++i2;
            }
            out = "Study\tnumSNP\tlambda\n";
            FileTools.out3File(bw[2], out);
            int j = 0;
            while (j < numStudy) {
                double[] tmpP = new double[numSNPeach[j]];
                int i3 = 0;
                while (i3 < numSNPeach[j]) {
                    tmpP[i3] = Porg[i3][j];
                    ++i3;
                }
                lambda[j] = chidf1.inverseCumulativeProbability(1.0 - Tools.Median(tmpP)) / chidf1.inverseCumulativeProbability(0.5);
                out = "Study_" + (j + 1) + "\t" + numSNPeach[j] + "\t" + lambda[j] + "\n";
                FileTools.out3File(bw[2], out);
                ++j;
            }
            double[] tmpPMeta = new double[numSNPMeta];
            double[] tmpPMetaW = new double[numSNPMeta];
            int counter0 = 0;
            int i4 = 0;
            while (i4 < numSNP) {
                if (numStudyeach[i4] > 0) {
                    out = "";
                    double[] N_Ca = new double[numStudyeach[i4]];
                    double[] N_Co = new double[numStudyeach[i4]];
                    double[] N_Total = new double[numStudyeach[i4]];
                    double[] Freq_Ca = new double[numStudyeach[i4]];
                    double[] Freq_Co = new double[numStudyeach[i4]];
                    double[] Beta = new double[numStudyeach[i4]];
                    double[] SE = new double[numStudyeach[i4]];
                    double[] P = new double[numStudyeach[i4]];
                    double[] tmplambda = new double[numStudyeach[i4]];
                    int counter = 0;
                    out = "";
                    int j2 = 0;
                    while (j2 < numStudy) {
                        if (!(data[i4][j2 * 7] > -99.0 - kiz) || !(data[i4][j2 * 7] < -99.0 + kiz)) {
                            N_Ca[counter] = data[i4][j2 * 7];
                            N_Co[counter] = data[i4][j2 * 7 + 1];
                            N_Total[counter] = N_Ca[counter] + N_Co[counter];
                            Freq_Ca[counter] = data[i4][j2 * 7 + 2];
                            Freq_Co[counter] = data[i4][j2 * 7 + 3];
                            Beta[counter] = data[i4][j2 * 7 + 4];
                            SE[counter] = data[i4][j2 * 7 + 5];
                            P[counter] = data[i4][j2 * 7 + 6];
                            tmplambda[counter] = GCeach ? lambda[j2] : 1.0;
                            int n = i4;
                            NMeta_Ca[n] = NMeta_Ca[n] + N_Ca[counter];
                            int n3 = i4;
                            NMeta_Co[n3] = NMeta_Co[n3] + N_Co[counter];
                            int n4 = i4;
                            FreqMeta_Ca[n4] = FreqMeta_Ca[n4] + N_Ca[counter] * Freq_Ca[counter];
                            int n5 = i4;
                            FreqMeta_Co[n5] = FreqMeta_Co[n5] + N_Co[counter] * Freq_Co[counter];
                            out = GCeach ? String.valueOf(out) + N_Ca[counter] + "\t" + N_Co[counter] + "\t" + PlotTools.DecimalHU(Freq_Ca[counter], 3) + "\t" + PlotTools.DecimalHU(Freq_Co[counter], 3) + "\t" + PlotTools.DecimalHU(Beta[counter], 7) + "\t" + PlotTools.DecimalHU(SE[counter] * Math.pow(lambda[j2], 0.5), 7) + "\t" + StatTools.TranslateChitoP(StatTools.TranslatePtoChiDf1(P[counter], CorresTableChi, chidf1) / lambda[j2], 1, CorresTableChi, chidf1) + "\t" : String.valueOf(out) + N_Ca[counter] + "\t" + N_Co[counter] + "\t" + PlotTools.DecimalHU(Freq_Ca[counter], 3) + "\t" + PlotTools.DecimalHU(Freq_Co[counter], 3) + "\t" + PlotTools.DecimalHU(Beta[counter], 7) + "\t" + PlotTools.DecimalHU(SE[counter], 7) + "\t" + P[counter] + "\t";
                            ++counter;
                        } else {
                            out = String.valueOf(out) + "-\t-\t-\t-\t-\t-\t-\t";
                        }
                        ++j2;
                    }
                    double[] stat = StatTools.MetaTestBeta(numStudyeach[i4], Beta, SE, P, N_Total, tmplambda, CorresTableChi, chidf1);
                    FreqMeta_Ca[i4] = FreqMeta_Ca[i4] / NMeta_Ca[i4];
                    FreqMeta_Co[i4] = FreqMeta_Co[i4] / NMeta_Co[i4];
                    BetaMeta[i4] = stat[3];
                    SEMeta[i4] = stat[4];
                    PMeta[i4] = stat[6];
                    PMetaW[i4] = stat[2];
                    tmpPMeta[counter0] = PMeta[i4];
                    tmpPMetaW[counter0] = PMetaW[i4];
                    ++counter0;
                } else {
                    out = "";
                    int j3 = 0;
                    while (j3 < numStudy) {
                        out = String.valueOf(out) + "-\t-\t-\t-\t-\t-\t-\t";
                        ++j3;
                    }
                }
                FileTools.out3File(bw[0], String.valueOf(out) + "\n");
                ++i4;
            }
            bw[0].close();
            double lambdaMeta = chidf1.inverseCumulativeProbability(1.0 - Tools.Median(tmpPMeta)) / chidf1.inverseCumulativeProbability(0.5);
            double lambdaMetaW = chidf1.inverseCumulativeProbability(1.0 - Tools.Median(tmpPMetaW)) / chidf1.inverseCumulativeProbability(0.5);
            out = "Meta_Analysis\t" + numSNPMeta + "\t" + lambdaMeta + "\t" + lambdaMetaW + "\n";
            FileTools.out3File(bw[2], out);
            i4 = 0;
            while (i4 < numSNP) {
                out = numStudyeach[i4] > 0 ? (GCeach ? String.valueOf(numStudyeach[i4]) + "\t" + NMeta_Ca[i4] + "\t" + NMeta_Co[i4] + "\t" + PlotTools.DecimalHU(FreqMeta_Ca[i4], 3) + "\t" + PlotTools.DecimalHU(FreqMeta_Co[i4], 3) + "\t" + PlotTools.DecimalHU(BetaMeta[i4], 7) + "\t" + PlotTools.DecimalHU(SEMeta[i4] * Math.pow(lambdaMeta, 0.5), 7) + "\t" + StatTools.TranslateChitoP(StatTools.TranslatePtoChiDf1(PMeta[i4], CorresTableChi, chidf1) / lambdaMeta, 1, CorresTableChi, chidf1) + "\t" + StatTools.TranslateChitoP(StatTools.TranslatePtoChiDf1(PMetaW[i4], CorresTableChi, chidf1) / lambdaMetaW, 1, CorresTableChi, chidf1) + "\n" : String.valueOf(numStudyeach[i4]) + "\t" + NMeta_Ca[i4] + "\t" + NMeta_Co[i4] + "\t" + PlotTools.DecimalHU(FreqMeta_Ca[i4], 3) + "\t" + PlotTools.DecimalHU(FreqMeta_Co[i4], 3) + "\t" + PlotTools.DecimalHU(BetaMeta[i4], 7) + "\t" + PlotTools.DecimalHU(SEMeta[i4], 7) + "\t" + PMeta[i4] + "\t" + PMetaW[i4] + "\n") : "0\t0\t0\t-\t-\t-\t-\t-\t-\n";
                FileTools.out3File(bw[1], out);
                ++i4;
            }
            out = "\nCalculation ended at:\t" + Tools.GetTime() + "\n";
            FileTools.out3File(bw[2], out);
            bw[1].close();
            bw[2].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

