/*
 * Decompiled with CFR 0.152.
 */
package Mains;

import Algorithms.MersenneTwisterFast;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.RankTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class SerialDataAnalysis {
    public static void main(String[] args) {
        String inputfile = "test_serial";
        String inputhead = "test_serial";
        String inputpheno = "";
        String outfileCount = "";
        String outfileStat = "";
        String outfileSum = "";
        String out = "";
        String[] genotype = new String[]{"1 1", "1 2", "2 1", "2 2", "0 0", "0 1", "1 0", "0 2", "2 0"};
        byte[] byArray = new byte[9];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byte[] genotypeNum = byArray;
        int rep = 1;
        int type = 0;
        int seedgiven = 0;
        int numiter = 100;
        boolean FileOrHead = true;
        boolean CountAnalysis = false;
        boolean SerialAnalysis = true;
        boolean Permutation2 = true;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-file")) {
                inputfile = args[i + 1];
                FileOrHead = true;
            }
            if (args[i].equals("-head")) {
                inputhead = args[i + 1];
                FileOrHead = false;
                inputfile = inputhead;
            }
            if (args[i].equals("-type")) {
                type = Integer.parseInt(args[i + 1]);
                CountAnalysis = true;
                SerialAnalysis = false;
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        if (Permutation2) {
            rep = 1;
        }
        inputpheno = String.valueOf(inputpheno) + inputfile + "_pheno.txt";
        outfileCount = String.valueOf(outfileCount) + inputfile + "_countdata.txt";
        outfileStat = String.valueOf(outfileStat) + inputfile + "_stat.txt";
        outfileSum = String.valueOf(outfileSum) + inputfile + "_sum.txt";
        inputfile = String.valueOf(inputfile) + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null, null, null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileCount));
            bw[1] = new BufferedWriter(new FileWriter(outfileStat));
            if (!FileOrHead) {
                rep = FileTools.readDatFileIOStringTABString(inputfile).length;
            }
            String[] inputGeno = new String[rep];
            if (FileOrHead) {
                inputGeno[0] = inputfile;
            } else {
                String[][] tmpS = FileTools.readDatFileIOStringTABString(inputfile);
                int i2 = 0;
                while (i2 < rep) {
                    inputGeno[i2] = tmpS[i2][0];
                    ++i2;
                }
            }
            double[][] PhenArray = FileTools.readDatFileIOStringTAB(inputpheno);
            byte[] Genodata = new byte[PhenArray.length];
            double[] Phendata = new double[PhenArray.length];
            double[] orgMinP = new double[8];
            int i3 = 0;
            while (i3 < orgMinP.length) {
                orgMinP[i3] = 1.0;
                ++i3;
            }
            i3 = 0;
            while (i3 < rep) {
                byte[][] GenoArray = GenoTools.GenotypeConvert(inputGeno[i3], genotype, genotypeNum);
                int j = 0;
                while (j < GenoArray[0].length) {
                    int k = 0;
                    while (k < Genodata.length) {
                        Genodata[k] = GenoArray[k][j];
                        ++k;
                    }
                    k = 0;
                    while (k < PhenArray[0].length) {
                        int l = 0;
                        while (l < Phendata.length) {
                            Phendata[l] = PhenArray[l][k];
                            ++l;
                        }
                        if (SerialAnalysis) {
                            int[] Count = new int[3];
                            Count = GenoTools.GenotypeCount(Genodata);
                            double[] stat = RankTools.QTLAnalysis(Genodata, Phendata);
                            out = String.valueOf(k) + "\t" + Count[0] + "\t" + Count[1] + "\t" + Count[2] + "\t";
                            int m = 0;
                            while (m < stat.length) {
                                out = String.valueOf(out) + stat[m] + "\t";
                                ++m;
                            }
                            out = String.valueOf(out) + "\n";
                            int l2 = 0;
                            while (l2 < stat.length) {
                                ++l2;
                            }
                        }
                        if (CountAnalysis) {
                            int[] Count = new int[6];
                            Count = GenoTools.GenotypeCount(Genodata, Phendata);
                            out = String.valueOf(k) + "\t" + Count[0] + "\t" + Count[1] + "\t" + Count[2] + "\t" + Count[3] + "\t" + Count[4] + "\t" + Count[5] + "\n";
                            out = String.valueOf(out) + "\n";
                        }
                        FileTools.out3File(bw[0], out);
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
            bw[0].close();
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

