/*
 * Decompiled with CFR 0.152.
 */
package LOCH_Mapping;

import LOCH_Mapping.LOCH_MappingTools;
import Tool.FileTools;
import Tool.PedTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class LOCH_MappingPed {
    public static void main(String[] args) {
        int Windowkb = 1000;
        int Stretchkb = 1500;
        int numGapSNP = 1;
        int numMinSNP = 50;
        String prefix = "Test";
        String out = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-Windowkb")) {
                Windowkb = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Stretchkb")) {
                Stretchkb = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numGapSNP")) {
                numGapSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numMinSNP")) {
                numMinSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            ++i;
        }
        String inputfilePed = String.valueOf(prefix) + ".ped";
        String inputfileMap = String.valueOf(prefix) + ".map";
        String outfile1 = String.valueOf(prefix) + "_LOCH_MappingCount_Windowkb-" + Windowkb + "_Stretchkb-" + Stretchkb + "_GapSNP-" + numGapSNP + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile1));
            String[] DataPed = FileTools.readDatFileIOStringSingle(inputfilePed);
            String[] DataMap = FileTools.readDatFileIOStringSingle(inputfileMap);
            int numSNP = DataMap.length;
            String[] SNPID = new String[numSNP];
            int[] Chr = new int[numSNP];
            int[] bp = new int[numSNP];
            long[] Position2 = new long[numSNP];
            int[][] Count = new int[numSNP][3];
            out = "Log_for_LOCM_MappingCount.java\n\nInput_File:\t" + prefix + ".txt\nNo.SNP:\t" + numSNP + "\nWindow_kb:\t" + Windowkb + "\nStretch_kb:\t" + Stretchkb + "\nNo.GapSNP:\t" + numGapSNP + "\nNo.MinSNP:\t" + numMinSNP + "\n\n";
            FileTools.out3File(bw[0], out);
            int i2 = 0;
            while (i2 < numSNP) {
                String[] tmp = DataMap[i2].split("\t");
                SNPID[i2] = tmp[1];
                Chr[i2] = Integer.parseInt(tmp[0]);
                bp[i2] = Integer.parseInt(tmp[3]);
                Position2[i2] = Long.parseLong(tmp[0]) * 100000000000L + Long.parseLong(tmp[3]);
                ++i2;
            }
            Count = PedTools.TranslatePed12toCount(DataPed, 6);
            int[] flagLOCHSNP = LOCH_MappingTools.CheckLOCHfromCount(Count);
            int[] flagLOCHWindow = LOCH_MappingTools.MakeLOCHonWindow(flagLOCHSNP, Position2, Windowkb, numGapSNP, numMinSNP);
            int[][] Stretch = LOCH_MappingTools.DecideLOCHStretch(flagLOCHWindow, Position2);
            int[][] StretchLong = LOCH_MappingTools.ExtractLOCHStretchLong(Stretch, Position2, Stretchkb);
            int numStretch = Stretch.length;
            int numStretchLong = StretchLong.length;
            System.out.println(String.valueOf(numStretch) + "\t" + numStretchLong);
            out = "No.Stretch:\t" + numStretch + "\nNo.Long_Stretch:\t" + numStretchLong + "\n\n";
            FileTools.out3File(bw[0], out);
            int i3 = 0;
            while (i3 < numStretchLong) {
                out = String.valueOf(i3 + 1) + "\t" + Chr[StretchLong[i3][0]] + "\t" + SNPID[StretchLong[i3][0]] + "\t" + SNPID[StretchLong[i3][1]] + "\t" + bp[StretchLong[i3][0]] + "\t" + bp[StretchLong[i3][1]] + "\t" + (bp[StretchLong[i3][1]] - bp[StretchLong[i3][0]]) + "\n";
                FileTools.out3File(bw[0], out);
                ++i3;
            }
            out = "\nCalculation_finished_at:\t" + Tools.GetTime() + "\n";
            FileTools.out3File(bw[0], out);
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

