/*
 * Decompiled with CFR 0.152.
 */
package LOCH_Mapping;

import Tool.ArrayTools;

public class LOCH_2x3TableTools {
    public static void main(String[] args) {
        int maxN = 12500;
        int[] Table0 = new int[]{5, 10, 5, 2, 10, 8};
        int[] Table1 = new int[]{32, 462, 1020, 84, 1896, 8557};
        int[] Table2 = new int[]{138, 649, 732, 2730, 5227, 2582};
        int[] Table3 = new int[]{377, 722, 414, 1143, 4397, 4999};
        int[] Table4 = new int[]{264, 478, 149, 907, 1665, 811};
        double[] LogFact = ArrayTools.LogFact(maxN * 2);
        LOCH_2x3TableTools.LOCHExactP_2df(Table0, LogFact);
        LOCH_2x3TableTools.LOCHExactP_2df(Table1, LogFact);
        LOCH_2x3TableTools.LOCHExactP_2df(Table2, LogFact);
        LOCH_2x3TableTools.LOCHExactP_2df(Table3, LogFact);
        LOCH_2x3TableTools.LOCHExactP_2df(Table4, LogFact);
    }

    public static double[] LOCHExactP_2df(int[] Table, double[] LogFact) {
        double[] ret = new double[4];
        int N1 = Table[0] + Table[1] + Table[2];
        int N2 = Table[3] + Table[4] + Table[5];
        int NA1 = Table[0] * 2 + Table[1];
        int NB1 = Table[2] * 2 + Table[1];
        int NA2 = Table[3] * 2 + Table[4];
        int NB2 = Table[5] * 2 + Table[4];
        int NAB1max = Math.min(NA1, NB1);
        int NAB2max = Math.min(NA2, NB2);
        int NAB1min = (NAB1max & 1) == 0 ? 0 : 1;
        int NAB2min = (NAB2max & 1) == 0 ? 0 : 1;
        double[] Fixation = LOCH_2x3TableTools.FixationIndexDiff(Table[0], Table[1], Table[2], Table[3], Table[4], Table[5]);
        double ExactProb = LOCH_2x3TableTools.ExactProbability_2df(Table[0], Table[1], Table[2], Table[3], Table[4], Table[5], LogFact);
        double LOCHExactP = 0.0;
        double HomoExactP = 0.0;
        double ExactHWEP_Case = LOCH_2x3TableTools.ExactHWE_1df(Table[0], Table[1], Table[2], LogFact);
        double ExactHWEP_Cont = LOCH_2x3TableTools.ExactHWE_1df(Table[3], Table[4], Table[5], LogFact);
        int i = NAB1min;
        while (i <= NAB1max) {
            int j = NAB2min;
            while (j <= NAB2max) {
                int tmpa = (NA1 - i) / 2;
                int tmpb = i;
                int tmpc = (NB1 - i) / 2;
                int tmpd = (NA2 - j) / 2;
                int tmpe = j;
                int tmpf = (NB2 - j) / 2;
                double[] tmpFixation = LOCH_2x3TableTools.FixationIndexDiff(tmpa, tmpb, tmpc, tmpd, tmpe, tmpf);
                double tmpExactProb = LOCH_2x3TableTools.ExactProbability_2df(tmpa, tmpb, tmpc, tmpd, tmpe, tmpf, LogFact);
                if (Fixation[2] > tmpFixation[2]) {
                    LOCHExactP += Math.exp(tmpExactProb);
                }
                if (Fixation[2] < tmpFixation[2]) {
                    HomoExactP += Math.exp(tmpExactProb);
                }
                if (Fixation[2] == tmpFixation[2]) {
                    LOCHExactP += Math.exp(tmpExactProb) / 2.0;
                    HomoExactP += Math.exp(tmpExactProb) / 2.0;
                }
                j += 2;
            }
            i += 2;
        }
        if (LOCHExactP > 1.0) {
            LOCHExactP = 1.0;
        }
        if (HomoExactP > 1.0) {
            HomoExactP = 1.0;
        }
        ret[0] = ExactHWEP_Case;
        ret[1] = ExactHWEP_Cont;
        ret[2] = LOCHExactP;
        ret[3] = HomoExactP;
        return ret;
    }

    public static double[] LOCHExactP_3df(int[] Table, double[] LogFact) {
        double[] ret = new double[3];
        int N = Table[0] + Table[1] + Table[2] + Table[3] + Table[4] + Table[5];
        int R1 = Table[0] + Table[1] + Table[2];
        int R2 = Table[3] + Table[4] + Table[5];
        int C1 = Table[0] + Table[3];
        int C2 = Table[1] + Table[4];
        int C3 = Table[2] + Table[5];
        int NA = C1 * 2 + C2;
        int NB = C3 * 2 + C2;
        int C2max = Math.min(NA, NB);
        double[] Fixation = LOCH_2x3TableTools.FixationIndexDiff(Table[0], Table[1], Table[2], Table[3], Table[4], Table[5]);
        double[] ExactProb = LOCH_2x3TableTools.ExactProbability_3df(Table[0], Table[1], Table[2], Table[3], Table[4], Table[5], LogFact);
        double LOCHExactP = 0.0;
        double HomoExactP = 0.0;
        double HWEExactP = 0.0;
        int C2min = (C2max & 1) == 0 ? 0 : 1;
        int i = C2min;
        while (i <= C2max) {
            int tmpC1 = (NA - i) / 2;
            int tmpC2 = i;
            int tmpC3 = (NB - i) / 2;
            int amax = Math.min(tmpC1, R1);
            int fmax = Math.min(tmpC3, R2);
            int j = 0;
            while (j <= amax) {
                int k = 0;
                while (k <= fmax) {
                    int tmpa = j;
                    int tmpb = R1 - j - (tmpC3 - k);
                    int tmpc = tmpC3 - k;
                    int tmpd = tmpC1 - j;
                    int tmpe = R2 - (tmpC1 - j) - k;
                    int tmpf = k;
                    if (tmpa >= 0 && tmpb >= 0 && tmpc >= 0 && tmpd >= 0 && tmpe >= 0 && tmpf >= 0) {
                        double[] tmpExactProb = LOCH_2x3TableTools.ExactProbability_3df(tmpa, tmpb, tmpc, tmpd, tmpe, tmpf, LogFact);
                        double[] tmpFixation = LOCH_2x3TableTools.FixationIndexDiff(tmpa, tmpb, tmpc, tmpd, tmpe, tmpf);
                        if (Fixation[2] >= tmpFixation[2]) {
                            LOCHExactP += Math.exp(tmpExactProb[1]);
                        }
                        if (Fixation[2] <= tmpFixation[2]) {
                            HomoExactP += Math.exp(tmpExactProb[1]);
                        }
                        if (ExactProb[1] >= tmpExactProb[1]) {
                            HWEExactP += Math.exp(tmpExactProb[1]);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            i += 2;
        }
        ret[0] = LOCHExactP;
        ret[1] = HomoExactP;
        ret[2] = HWEExactP;
        return ret;
    }

    public static double ExactHWE_1df(int a, int b, int c, double[] LogFact) {
        int NA = a * 2 + b;
        int NB = c * 2 + b;
        int NABmax = Math.min(NA, NB);
        double ExactProb = LOCH_2x3TableTools.ExactProbability_1df(a, b, c, LogFact);
        double HWEExactP = 0.0;
        int NABmin = (NABmax & 1) == 0 ? 0 : 1;
        int i = NABmin;
        while (i <= NABmax) {
            int tmpa = (NA - i) / 2;
            int tmpb = i;
            int tmpc = (NB - i) / 2;
            double tmpExactProb = LOCH_2x3TableTools.ExactProbability_1df(tmpa, tmpb, tmpc, LogFact);
            if (ExactProb >= tmpExactProb) {
                HWEExactP += Math.exp(tmpExactProb);
            }
            i += 2;
        }
        return HWEExactP;
    }

    public static double ExactProbability_1df(int a, int b, int c, double[] LogFact) {
        int N = a + b + c;
        int NA = Math.min(a * 2 + b, c * 2 + b);
        int NB = Math.max(a * 2 + b, c * 2 + b);
        double ret = LogFact[N] + LogFact[NA] + LogFact[NB] + (double)b * Math.log(2.0) - (LogFact[2 * N] + LogFact[Math.min(a, c)] + LogFact[b] + LogFact[Math.max(a, c)]);
        return ret;
    }

    public static double ExactProbability_2df(int a, int b, int c, int d, int e, int f, double[] LogFact) {
        double ExactProbCase = LOCH_2x3TableTools.ExactProbability_1df(a, b, c, LogFact);
        double ExactProbCont = LOCH_2x3TableTools.ExactProbability_1df(d, e, f, LogFact);
        double ret = ExactProbCase + ExactProbCont;
        return ret;
    }

    public static double[] ExactProbability_3df(int a, int b, int c, int d, int e, int f, double[] LogFact) {
        double[] ret = new double[2];
        int N = a + b + c + d + e + f;
        int R1 = a + b + c;
        int R2 = d + e + f;
        int C1 = a + d;
        int C2 = b + e;
        int C3 = c + f;
        int NA = C1 * 2 + C2;
        int NB = C3 * 2 + C2;
        double ExactProb2x3 = LogFact[C1] + LogFact[C2] + LogFact[C3] + LogFact[R1] + LogFact[R2] - (LogFact[N] + LogFact[a] + LogFact[b] + LogFact[c] + LogFact[d] + LogFact[e] + LogFact[f]);
        double ExactProb2x3HWE = (double)C2 * Math.log(2.0) + LogFact[NA] + LogFact[NB] + LogFact[R1] + LogFact[R2] - (LogFact[2 * N] + LogFact[a] + LogFact[b] + LogFact[c] + LogFact[d] + LogFact[e] + LogFact[f]);
        ret[0] = ExactProb2x3;
        ret[1] = ExactProb2x3HWE;
        return ret;
    }

    public static double[] FixationIndexDiff(int a, int b, int c, int d, int e, int f) {
        double[] ret = new double[3];
        double FixCase = LOCH_2x3TableTools.FixationIndex(a, b, c);
        double FixCont = LOCH_2x3TableTools.FixationIndex(d, e, f);
        ret[0] = FixCase;
        ret[1] = FixCont;
        ret[2] = FixCase - FixCont;
        if (a == d && b == e && c == f || b == 0 && e == 0) {
            ret[2] = 0.0;
        }
        return ret;
    }

    public static double FixationIndex(int AA, int AB, int BB) {
        double ret = 0.0;
        double p = 0.0;
        double q = 0.0;
        if (AA * 2 + AB > 0 && BB * 2 + AB > 0) {
            p = (double)(AA * 2 + AB) / (double)(AA + AB + BB) / 2.0;
            q = (double)(BB * 2 + AB) / (double)(AA + AB + BB) / 2.0;
            ret = 1.0 - (double)AB / (double)(AA + AB + BB) / (2.0 * p * q);
        } else {
            ret = 1.0;
        }
        return ret;
    }
}

