/*
 * Decompiled with CFR 0.152.
 */
package LOCH_Mapping;

import LOCH_Mapping.LOCH_2x3TableTools;
import Tool.ArrayTools;
import Tool.FileTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class LOCH_2x3TableCount {
    public static void main(String[] args) {
        int maxN = 3500;
        String prefix = "Test";
        String out = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-maxN")) {
                maxN = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            ++i;
        }
        double[] LogFact = ArrayTools.LogFact(maxN * 2);
        String inputfile = String.valueOf(prefix) + ".txt";
        String outfile1 = String.valueOf(prefix) + "_LOCH_PopulationCount.txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile1));
            String[][] Data = FileTools.readDatFileIOStringTABString(inputfile);
            int numSNP = Data.length;
            int i2 = 0;
            while (i2 < numSNP) {
                String rsID = Data[i2][0];
                long Position2 = Long.parseLong(Data[i2][1]);
                int[] Table = new int[]{Integer.parseInt(Data[i2][2]), Integer.parseInt(Data[i2][3]), Integer.parseInt(Data[i2][4]), Integer.parseInt(Data[i2][5]), Integer.parseInt(Data[i2][6]), Integer.parseInt(Data[i2][7])};
                double[] Fixation = LOCH_2x3TableTools.FixationIndexDiff(Table[0], Table[1], Table[2], Table[3], Table[4], Table[5]);
                double[] LOCHExactP = LOCH_2x3TableTools.LOCHExactP_2df(Table, LogFact);
                out = String.valueOf(rsID) + "\t" + Position2 + "\t" + Table[0] + "\t" + Table[1] + "\t" + Table[2] + "\t" + Table[3] + "\t" + Table[4] + "\t" + Table[5] + "\t" + Fixation[0] + "\t" + Fixation[1] + "\t";
                out = String.valueOf(out) + LOCHExactP[0] + "\t" + LOCHExactP[1] + "\t" + LOCHExactP[2] + "\t" + LOCHExactP[3] + "\n";
                FileTools.out3File(bw[0], out);
                ++i2;
            }
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

