/*
 * Decompiled with CFR 0.152.
 */
package Interaction;

import Likelihood.TableManage;
import Tool.ArrayTools;
import Tool.PlotTools;

public class TableLike2x3 {
    public static void main(String[] args) {
        int Pk = 100;
        int Maxrep = 1000;
        int testtype = 0;
        int[][] data2x3 = new int[][]{{50, 100, 50}, {32, 96, 72}};
        double kizOR = 1.005;
        double ThresL = Math.pow(10.0, -10.0);
        double boost = 50.0;
        PlotTools.Array(TableLike2x3.CalcMaxLike2x3(data2x3, true, testtype, Pk, kizOR, Maxrep, ThresL, boost));
        PlotTools.Array(TableLike2x3.CalcMaxLike2x3(data2x3, false, testtype, Pk, kizOR, Maxrep, ThresL, boost));
    }

    public static double[][] CalcLike2x3H0H1(int[][] array, int testtype, int Pk, double kizOR, int Maxrep, double ThresL, double boost) {
        double[][] ret = new double[2][3];
        double[] LikeH0 = TableLike2x3.CalcMaxLike2x3(array, false, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        double[] LikeH1 = TableLike2x3.CalcMaxLike2x3(array, true, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        int i = 0;
        while (i < LikeH0.length) {
            ret[0][i] = LikeH0[i];
            ret[1][i] = LikeH1[i];
            ++i;
        }
        return ret;
    }

    public static double[] CalcMaxLike2x3(int[][] array, boolean H1flag, int testtype, int Pk, double kizOR, int Maxrep, double ThresL, double boost) {
        double[] ret = new double[3];
        int boostcounter = 0;
        int[] TotalArray = TableManage.CombineTable(array);
        int[] ContArray = TableManage.ExtractTable(array, 0);
        int[] CaseArray = TableManage.ExtractTable(array, 1);
        double[] Freq = TableManage.NormarizeTable(TotalArray);
        double[] ContFreq = TableManage.NormarizeTable(ContArray);
        double[] CaseFreq = TableManage.NormarizeTable(CaseArray);
        double OR = -99.0;
        double tmpOR = TableLike2x3.CalcBaseRiskFrom2x3(array, testtype);
        double[] tmpORcand = new double[2];
        double counter = 0.0;
        double L = -9.99999999E8;
        boolean iter = true;
        if (!H1flag) {
            tmpOR = 1.0;
        }
        while (iter) {
            int flagOR;
            if (H1flag) {
                tmpORcand[0] = tmpOR / kizOR;
                tmpORcand[1] = tmpOR * kizOR;
                flagOR = TableLike2x3.FindHighestLikeOR(L, array, tmpORcand, testtype, Pk);
            } else {
                tmpORcand[0] = 1.0;
                tmpORcand[1] = 1.0;
                flagOR = -99;
            }
            tmpOR = TableLike2x3.DecideORfromFlag(tmpOR, flagOR, kizOR);
            double[] tmpORArray = TableLike2x3.CalcRisk2x3FromOR(tmpOR, testtype);
            double[][] tmpFreq = TableLike2x3.EstimateFreqFrom2x3ORfixedTotalFreq(array, tmpORArray, Pk);
            double tmpL = TableLike2x3.LikeArray(array, tmpFreq);
            if (tmpL - L > ThresL) {
                L = tmpL;
                OR = tmpOR;
            } else {
                kizOR = 1.0 + (kizOR - 1.0) / boost;
                if (boostcounter == 1) {
                    iter = false;
                }
                ++boostcounter;
            }
            counter += 1.0;
        }
        ret[0] = OR;
        ret[1] = L;
        ret[2] = counter;
        return ret;
    }

    public static double DecideORfromFlag(double tmpOR, int flag, double kizOR) {
        double ret = -99.0;
        if (flag == 0) {
            ret = tmpOR / kizOR;
        } else if (flag == 1) {
            ret = tmpOR * kizOR;
        } else if (flag == -99) {
            ret = tmpOR;
        }
        return ret;
    }

    public static int FindHighestLikeOR(double BaseL, int[][] Array, double[] OR, int testtype, int Pk) {
        int len = OR.length;
        int ret = -99;
        int i = 0;
        while (i < len) {
            double[] tmpORArray = TableLike2x3.CalcRisk2x3FromOR(OR[i], testtype);
            int[] ContArray = TableManage.ExtractTable(Array, 0);
            double[] ContFreq = TableManage.NormarizeTable(ContArray);
            double[][] tmpFreq = TableLike2x3.EstimateFreqFrom2x3ORfixedTotalFreq(Array, tmpORArray, Pk);
            double tmpL = TableLike2x3.LikeArray(Array, tmpFreq);
            if (tmpL > BaseL) {
                BaseL = tmpL;
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public static double LikeArray(int[][] array, double[][] Freq) {
        double L = 0.0;
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                if (Freq[i][j] != 0.0 && array[i][j] != 0) {
                    L += (double)array[i][j] * Math.log(Freq[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return L;
    }

    public static double[][] EstimateFreqFrom2x3OR(double[] ContFreq, double[] ORArray) {
        double[][] ret = new double[2][ContFreq.length];
        double N = 0.0;
        int i = 0;
        while (i < ContFreq.length) {
            ret[0][i] = ContFreq[i];
            ret[1][i] = ContFreq[i] * ORArray[i];
            N += ContFreq[i] * ORArray[i];
            ++i;
        }
        i = 0;
        while (i < ContFreq.length) {
            double[] dArray = ret[1];
            int n = i++;
            dArray[n] = dArray[n] / N;
        }
        return ret;
    }

    public static double[][] EstimateFreqFrom2x3ORfixedTotalFreq(int[][] Array, double[] OR, int k) {
        double[][] ret = new double[2][3];
        double BestP1 = TableLike2x3.FindBestP1seq(Array, OR, k)[0];
        double[] ContP = TableLike2x3.EstimateContFreqFrom2x3ORwithP1(Array, OR, BestP1);
        double R0 = Array[0][0] + Array[0][1] + Array[0][2];
        double R1 = Array[1][0] + Array[1][1] + Array[1][2];
        double C0 = Array[0][0] + Array[1][0];
        double C1 = Array[0][1] + Array[1][1];
        double C2 = Array[0][2] + Array[1][2];
        ret[0][0] = ContP[0];
        ret[0][1] = ContP[1];
        ret[0][2] = ContP[2];
        ret[1][0] = (C0 - R0 * ret[0][0]) / R1;
        ret[1][1] = (C1 - R0 * ret[0][1]) / R1;
        ret[1][2] = (C2 - R0 * ret[0][2]) / R1;
        return ret;
    }

    public static double[] FindBestP1seq(int[][] Array, double[] OR, int k) {
        double[] ret = new double[2];
        double finP = -1.0;
        double minRet = 1000000.0;
        ret = TableLike2x3.FindBestP1(Array, OR, k, 0.0, 1.0);
        ret = TableLike2x3.FindBestP1(Array, OR, k, ret[0] - 1.0 / (double)(k + 1), ret[0] + 1.0 / (double)(k + 1));
        ret = TableLike2x3.FindBestP1(Array, OR, k, ret[0] - 2.0 / (double)((k + 1) * (k + 1)), ret[0] + 2.0 / (double)((k + 1) * (k + 1)));
        ret = TableLike2x3.FindBestP1(Array, OR, k, ret[0] - 4.0 / (double)((k + 1) * (k + 1) * (k + 1)), ret[0] + 4.0 / (double)((k + 1) * (k + 1) * (k + 1)));
        return ret;
    }

    public static double[] FindBestP1(int[][] Array, double[] OR, int k, double range0, double range1) {
        double[] ret = new double[2];
        double finP = -1.0;
        double minRet = 1.0E8;
        double[] Pcand = ArrayTools.MakeThomasArray(k, range0, range1);
        int i = 0;
        while (i < Pcand.length) {
            double tmpRet = TableLike2x3.CheckSumContFreqFrom2x3ORwithP1(Array, OR, Pcand[i]);
            if (tmpRet <= minRet) {
                minRet = tmpRet;
                finP = Pcand[i];
            }
            ++i;
        }
        ret[0] = finP;
        ret[1] = minRet;
        return ret;
    }

    public static double CheckSumContFreqFrom2x3ORwithP1(int[][] Array, double[] OR, double P1) {
        double[] P = TableLike2x3.EstimateContFreqFrom2x3ORwithP1(Array, OR, P1);
        double ret = 1.0E8;
        if (TableManage.CheckRange(P, 0.0, 1.0)) {
            ret = Math.abs(1.0 - TableManage.SumTable(P));
        }
        return ret;
    }

    public static double[] EstimateContFreqFrom2x3ORwithP1(int[][] Array, double[] OR, double P1) {
        double[] ret = new double[3];
        OR[0] = OR[0] / OR[1];
        OR[2] = OR[2] / OR[1];
        int C0 = Array[0][0] + Array[1][0];
        int C1 = Array[0][1] + Array[1][1];
        int C2 = Array[0][2] + Array[1][2];
        int R0 = Array[0][0] + Array[0][1] + Array[0][2];
        ret[0] = (double)C0 * P1 / ((double)R0 * P1 * (1.0 - OR[0]) + OR[0] * (double)C1);
        ret[1] = P1;
        ret[2] = (double)C2 * P1 / ((double)R0 * P1 * (1.0 - OR[2]) + OR[2] * (double)C1);
        return ret;
    }

    public static double[] CalcRisk2x3FromOR(double OR, int testtype) {
        double[] ret = new double[3];
        if (testtype == 0) {
            ret[0] = 1.0 / OR;
            ret[1] = 1.0;
            ret[2] = OR;
        } else if (testtype == 1) {
            ret[0] = 1.0;
            ret[1] = OR;
            ret[2] = 2.0 * OR - 1.0;
        } else if (testtype == 2) {
            ret[0] = 1.0 / OR;
            ret[1] = 1.0;
            ret[2] = 1.0;
        } else if (testtype == 3) {
            ret[0] = 1.0;
            ret[1] = 1.0;
            ret[2] = OR;
        }
        return ret;
    }

    public static double CalcBaseRiskFrom2x3(int[][] Array, int testtype) {
        double ret = -99.0;
        double[] tmpAF = new double[2];
        if (testtype == 0) {
            tmpAF[0] = (double)(Array[0][2] * 2 + Array[0][1]) / ((double)(Array[0][0] + Array[0][1] + Array[0][2]) * 2.0);
            tmpAF[1] = (double)(Array[1][2] * 2 + Array[1][1]) / ((double)(Array[1][0] + Array[1][1] + Array[1][2]) * 2.0);
            ret = tmpAF[1] / (1.0 - tmpAF[1]) * (1.0 - tmpAF[0]) / tmpAF[0];
        } else if (testtype == 1) {
            tmpAF[0] = (double)(Array[0][2] * 2 + Array[0][1]) / ((double)(Array[0][0] + Array[0][1] + Array[0][2]) * 2.0);
            tmpAF[1] = (double)(Array[1][2] * 2 + Array[1][1]) / ((double)(Array[1][0] + Array[1][1] + Array[1][2]) * 2.0);
            ret = tmpAF[1] / (1.0 - tmpAF[1]) * (1.0 - tmpAF[0]) / tmpAF[0];
        } else if (testtype == 2) {
            tmpAF[0] = (double)(Array[0][2] + Array[0][1]) / (double)(Array[0][2] + Array[0][1] + Array[0][0]);
            tmpAF[1] = (double)(Array[1][2] + Array[1][1]) / (double)(Array[1][2] + Array[1][1] + Array[1][0]);
            ret = tmpAF[1] / (1.0 - tmpAF[1]) * (1.0 - tmpAF[0]) / tmpAF[0];
        } else if (testtype == 3) {
            tmpAF[0] = (double)Array[0][2] / (double)(Array[0][2] + Array[0][1] + Array[0][0]);
            tmpAF[1] = (double)Array[1][2] / (double)(Array[1][2] + Array[1][1] + Array[1][0]);
            ret = tmpAF[1] / (1.0 - tmpAF[1]) * (1.0 - tmpAF[0]) / tmpAF[0];
        }
        return ret;
    }
}

