/*
 * Decompiled with CFR 0.152.
 */
package HWE;

import Algorithms.MersenneTwisterFast;
import HWE.HWETools;
import Tool.ArrayTools;
import Tool.FileTools;

public class HWEMulti {
    public static void main(String[] args) {
        String infile = "DRB1_CCP+_conv.txt";
        String[] infileSeq = new String[]{"CD_B_conv.txt", "CD_C_conv.txt", "CD_DP_conv.txt", "CD_DR_conv.txt", "MRC_B_conv.txt", "MRC_C_conv.txt", "MRC_DP_conv.txt", "MRC_DR_conv.txt", "UC_B_conv.txt", "UC_C_conv.txt", "UC_DP_conv.txt", "UC_DR_conv.txt"};
        int rep = 100;
        int repSeq = 100000;
        int seed = 0;
        int x = 90000006;
        seed = (int)((double)x * Math.random());
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        double[] LogFact = ArrayTools.LogFact(5000);
        try {
            int[][] data = FileTools.readDatFileIOStringTABint(infile);
            int[] SampleArray = ArrayTools.LineUpArraybyCol(data);
            int[][] DiploArray = HWETools.ChangeSampleToDiplo(SampleArray);
            double HWEChi = HWETools.HWEChifromDiplo(DiploArray);
            double HWEPermP = HWETools.HWEPfromDiploPerm(DiploArray, rep, mz);
            double HWEPermPExact = HWETools.HWEPfromDiploPermExact(DiploArray, rep, mz, LogFact);
            System.out.println(String.valueOf(HWEChi) + "\t" + HWEPermP + "\t" + HWEPermPExact);
            int i = 0;
            while (i < infileSeq.length) {
                data = FileTools.readDatFileIOStringTABint(infileSeq[i]);
                SampleArray = ArrayTools.LineUpArraybyCol(data);
                DiploArray = HWETools.ChangeSampleToDiplo(SampleArray);
                HWEChi = HWETools.HWEChifromDiplo(DiploArray);
                HWEPermP = HWETools.HWEPfromDiploPerm(DiploArray, repSeq, mz);
                HWEPermPExact = HWETools.HWEPfromDiploPermExact(DiploArray, repSeq, mz, LogFact);
                System.out.println(String.valueOf(infileSeq[i]) + "\t" + HWEChi + "\t" + HWEPermP + "\t" + HWEPermPExact);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

