/*
 * Decompiled with CFR 0.152.
 */
package Likelihood;

import Likelihood.TableManage;
import Tool.PlotTools;

public class TableLike2x2x2 {
    public static void main(String[] args) {
        double[][][] data2x2x2 = new double[][][]{new double[][]{{974.5813, 753.2749}, {286.0415, 220.1022}}, new double[][]{{334.9069, 116.897}, {70.09314, 22.103}}};
        double[][][] data2x2x2_2 = new double[][][]{new double[][]{{1249.477, 605.8143}, {11.14564, 367.5629}}, new double[][]{{402.896, 76.66429}, {2.104036, 62.33571}}};
        PlotTools.Array(TableLike2x2x2.CalcLike2x2ORseq(data2x2x2_2, 0.25, 4.0, 200));
    }

    public static double[] CalcLikeH0H12x2(double[][][] array) {
        double[] ret = new double[6];
        double[][] TotalArray = TableManage.CombineTable(array);
        double[][] CaseArray = TableManage.ExtractTable(array, 0);
        double[][] ContArray = TableManage.ExtractTable(array, 1);
        double LikeH0H0 = TableManage.Like2x2(CaseArray, TableLike2x2x2.GetFreqfromP(TableLike2x2x2.GetP1P2(TotalArray)[0], TableLike2x2x2.GetP1P2(TotalArray)[1])) + TableManage.Like2x2(ContArray, TableLike2x2x2.GetFreqfromP(TableLike2x2x2.GetP1P2(TotalArray)[0], TableLike2x2x2.GetP1P2(TotalArray)[1]));
        double LikeH1H0 = TableManage.Like2x2(CaseArray, TableLike2x2x2.GetFreqfromP(TableLike2x2x2.GetP1P2(CaseArray)[0], TableLike2x2x2.GetP1P2(TotalArray)[1])) + TableManage.Like2x2(ContArray, TableLike2x2x2.GetFreqfromP(TableLike2x2x2.GetP1P2(ContArray)[0], TableLike2x2x2.GetP1P2(TotalArray)[1]));
        double LikeH0H1 = TableManage.Like2x2(CaseArray, TableLike2x2x2.GetFreqfromP(TableLike2x2x2.GetP1P2(TotalArray)[0], TableLike2x2x2.GetP1P2(CaseArray)[1])) + TableManage.Like2x2(ContArray, TableLike2x2x2.GetFreqfromP(TableLike2x2x2.GetP1P2(TotalArray)[0], TableLike2x2x2.GetP1P2(ContArray)[1]));
        double LikeH1H1 = TableManage.Like2x2(CaseArray, TableLike2x2x2.GetFreqfromP(TableLike2x2x2.GetP1P2(CaseArray)[0], TableLike2x2x2.GetP1P2(CaseArray)[1])) + TableManage.Like2x2(ContArray, TableLike2x2x2.GetFreqfromP(TableLike2x2x2.GetP1P2(ContArray)[0], TableLike2x2x2.GetP1P2(ContArray)[1]));
        double LikeH0H0LD = TableManage.Like2x2(CaseArray, TableManage.GetFreq(TotalArray)) + TableManage.Like2x2(ContArray, TableManage.GetFreq(TotalArray));
        double LikeH1H1LD = TableManage.Like2x2(CaseArray, TableManage.GetFreq(CaseArray)) + TableManage.Like2x2(ContArray, TableManage.GetFreq(ContArray));
        ret[0] = LikeH0H0;
        ret[1] = LikeH1H0;
        ret[2] = LikeH0H1;
        ret[3] = LikeH1H1;
        ret[4] = LikeH0H0LD;
        ret[5] = LikeH1H1LD;
        return ret;
    }

    public static double[] CalcLike2x2ORseq(double[][][] array, double ORsta, double ORend, int k) {
        double L_H00;
        double[] ret = new double[8];
        ORsta = Math.log10(ORsta);
        ORend = Math.log10(ORend);
        double[] ORseq = new double[k];
        int i = 0;
        while (i < k) {
            ORseq[i] = Math.pow(10.0, (ORend - ORsta) / (double)(k - 1) * (double)i + ORsta);
            ++i;
        }
        double[][] L = new double[k][k];
        double MaxL_H10 = -999999.0;
        double MaxL_H01 = -999999.0;
        double MaxL_H11 = -999999.0;
        double MaxOR_H10 = -99.0;
        double MaxOR_H01 = -99.0;
        double[] MaxOR_H11 = new double[]{-99.0, -99.0};
        int i2 = 0;
        while (i2 < k) {
            int j = 0;
            while (j < k) {
                L[k - 1 - i2][j] = TableLike2x2x2.CalcLike2x2OR(array, ORseq[i2], ORseq[j]);
                if (L[k - 1 - i2][j] > MaxL_H11) {
                    MaxL_H11 = L[k - 1 - i2][j];
                    MaxOR_H11[0] = ORseq[i2];
                    MaxOR_H11[1] = ORseq[j];
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < k) {
            double tmpL = TableLike2x2x2.CalcLike2x2OR(array, ORseq[i2], 1.0);
            if (tmpL > MaxL_H10) {
                MaxL_H10 = tmpL;
                MaxOR_H10 = ORseq[i2];
            }
            if ((tmpL = TableLike2x2x2.CalcLike2x2OR(array, 1.0, ORseq[i2])) > MaxL_H01) {
                MaxL_H01 = tmpL;
                MaxOR_H01 = ORseq[i2];
            }
            ++i2;
        }
        ret[0] = L_H00 = TableLike2x2x2.CalcLike2x2OR(array, 1.0, 1.0);
        ret[1] = MaxL_H10;
        ret[2] = MaxL_H01;
        ret[3] = MaxL_H11;
        ret[4] = MaxOR_H10;
        ret[5] = MaxOR_H01;
        ret[6] = MaxOR_H11[0];
        ret[7] = MaxOR_H11[1];
        return ret;
    }

    public static double CalcLike2x2OR(double[][][] array, double OR0, double OR1) {
        double tmpRet;
        double P11;
        double P10;
        double P01;
        double P;
        double L = 0.0;
        double[][] TotalArray = TableManage.CombineTable(array);
        double[][] CaseArray = TableManage.ExtractTable(array, 0);
        double[][] ContArray = TableManage.ExtractTable(array, 1);
        double[][] Freq = TableManage.GetFreq(TotalArray);
        double[][] CaseFreq = new double[2][2];
        double[][] ContFreq = new double[2][2];
        double f = TableManage.SumTable(CaseArray) / TableManage.SumTable(TotalArray);
        int k = 1000;
        double finP = 0.0;
        double minRet = 1000000.0;
        int minposi = 0;
        int i = 0;
        while (i < k) {
            P = (double)(i + 1) / (double)(k + 1);
            P01 = OR1 * P * Freq[0][1] / (Freq[0][0] + (OR1 - 1.0) * f * P);
            P10 = OR0 * P * Freq[1][0] / (Freq[0][0] + (OR0 - 1.0) * f * P);
            P11 = OR0 * OR1 * P * Freq[1][1] / (Freq[0][0] + (OR0 * OR1 - 1.0) * f * P);
            tmpRet = P + P01 + P10 + P11 - 1.0;
            if (Math.abs(tmpRet) < Math.abs(minRet) && tmpRet <= 0.0 && 0.0 <= P10 && P10 <= 1.0 && 0.0 <= P01 && P01 <= 1.0 && 0.0 <= P11 && P11 <= 1.0) {
                minRet = tmpRet;
                minposi = i;
                finP = P;
            }
            ++i;
        }
        i = 0;
        while (i < k) {
            P = ((double)minposi + 2.0 * (double)(i + 1) / (double)(k + 1)) / (double)(k + 1);
            P01 = OR1 * P * Freq[0][1] / (Freq[0][0] + (OR1 - 1.0) * f * P);
            P10 = OR0 * P * Freq[1][0] / (Freq[0][0] + (OR0 - 1.0) * f * P);
            P11 = OR0 * OR1 * P * Freq[1][1] / (Freq[0][0] + (OR0 * OR1 - 1.0) * f * P);
            tmpRet = P + P01 + P10 + P11 - 1.0;
            if (Math.abs(tmpRet) < Math.abs(minRet) && tmpRet <= 0.0 && 0.0 <= P10 && P10 <= 1.0 && 0.0 <= P01 && P01 <= 1.0 && 0.0 <= P11 && P11 <= 1.0) {
                minRet = tmpRet;
                minposi = i;
                finP = P;
            }
            ++i;
        }
        CaseFreq[0][0] = finP;
        CaseFreq[1][0] = OR0 * CaseFreq[0][0] * Freq[1][0] / (Freq[0][0] + (OR0 - 1.0) * f * CaseFreq[0][0]);
        CaseFreq[0][1] = OR1 * CaseFreq[0][0] * Freq[0][1] / (Freq[0][0] + (OR1 - 1.0) * f * CaseFreq[0][0]);
        CaseFreq[1][1] = OR0 * OR1 * CaseFreq[0][0] * Freq[1][1] / (Freq[0][0] + (OR0 * OR1 - 1.0) * f * CaseFreq[0][0]);
        ContFreq[0][0] = (Freq[0][0] - f * CaseFreq[0][0]) / (1.0 - f);
        ContFreq[1][0] = (Freq[1][0] - f * CaseFreq[1][0]) / (1.0 - f);
        ContFreq[0][1] = (Freq[0][1] - f * CaseFreq[0][1]) / (1.0 - f);
        ContFreq[1][1] = (Freq[1][1] - f * CaseFreq[1][1]) / (1.0 - f);
        L = TableManage.Like2x2(CaseArray, CaseFreq) + TableManage.Like2x2(ContArray, ContFreq);
        return L;
    }

    public static double[] GetR2D(double[][] array) {
        double[] ret = new double[2];
        double[] P = TableLike2x2x2.GetP1P2(array);
        ret[0] = Math.pow(array[0][0] * array[1][1] - array[1][0] * array[0][1], 2.0) / (P[0] * P[1] * (1.0 - P[0]) * (1.0 - P[1]));
        ret[1] = array[0][0] * array[1][1] - array[1][0] * array[0][1];
        return ret;
    }

    public static double[][] GetFreqfromP(double P0, double P1) {
        double[][] ret = new double[2][2];
        ret[0][0] = P0 * P1;
        ret[1][0] = (1.0 - P0) * P1;
        ret[0][1] = P0 * (1.0 - P1);
        ret[1][1] = (1.0 - P0) * (1.0 - P1);
        return ret;
    }

    public static double[] GetP1P2(double[][] array) {
        double[] p = new double[2];
        double N = 0.0;
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                N += array[i][j];
                ++j;
            }
            ++i;
        }
        p[0] = (array[0][0] + array[0][1]) / N;
        p[1] = (array[0][0] + array[1][0]) / N;
        return p;
    }
}

