/*
 * Decompiled with CFR 0.152.
 */
package LOF_analysis;

import Tool.ArrayTools;
import Tool.FileTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class EthicLikelihood {
    public static void main(String[] args) {
        double kiz = Math.pow(10.0, -10.0);
        String prefix = "ExomePGRN_CcCC_Hap_eigen12tab_RA";
        String out = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            ++i;
        }
        String inputPed = String.valueOf(prefix) + ".ped";
        String inputFreq = String.valueOf(prefix) + ".freq";
        String outfile1 = String.valueOf(prefix) + "_likelihood.txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile1));
            String[][] Ped = FileTools.readDatFileIOStringTABString(inputPed);
            double[][] Freq = FileTools.readDatFileIOStringTAB(inputFreq);
            int numSNP = Ped[0].length - 6;
            int numPop = Freq[0].length;
            int numSample = Ped.length;
            double[][] LogLike = new double[numSample][numPop];
            double[] numSamplePop = new double[numPop];
            if (numSNP != Freq.length - 1) {
                System.out.println("No. SNPs do not match");
            }
            ArrayTools.InitialaizeArray2(LogLike);
            int i2 = 0;
            while (i2 < numPop) {
                numSamplePop[i2] = Freq[0][i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < numSample) {
                int j = 1;
                while (j <= numSNP) {
                    int k = 0;
                    while (k < numPop) {
                        double AF = Freq[j][k];
                        if (AF < kiz) {
                            AF = 0.5 / (numSamplePop[k] * 2.0);
                        } else if (AF > 1.0 - kiz) {
                            AF = 1.0 - 0.5 / (numSamplePop[k] * 2.0);
                        }
                        double GF11 = (1.0 - AF) * (1.0 - AF);
                        double GF12 = 2.0 * AF * (1.0 - AF);
                        double GF22 = AF * AF;
                        if (Ped[i2][j + 5].equals("1 1")) {
                            double[] dArray = LogLike[i2];
                            int n = k;
                            dArray[n] = dArray[n] + Math.log(GF11);
                        } else if (Ped[i2][j + 5].equals("1 2")) {
                            double[] dArray = LogLike[i2];
                            int n = k;
                            dArray[n] = dArray[n] + Math.log(GF12);
                        } else if (Ped[i2][j + 5].equals("2 2")) {
                            double[] dArray = LogLike[i2];
                            int n = k;
                            dArray[n] = dArray[n] + Math.log(GF22);
                        } else if (!Ped[i2][j + 5].equals("0 0")) {
                            System.out.println("Unformated Ped file : " + Ped[i2][j + 5]);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < numSample) {
                double maxLogLike = -1.0 * Math.pow(10.0, 300.0);
                int maxPop = -1;
                out = Ped[i2][0];
                int j = 0;
                while (j < numPop) {
                    if (maxLogLike < LogLike[i2][j]) {
                        maxLogLike = LogLike[i2][j];
                        maxPop = j;
                    }
                    out = String.valueOf(out) + "\t" + LogLike[i2][j];
                    ++j;
                }
                out = String.valueOf(out) + "\t" + maxPop + "\n";
                FileTools.out3File(bw[0], out);
                ++i2;
            }
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

