/*
 * Decompiled with CFR 0.152.
 */
package LOCH_Mapping;

import LOCH_Mapping.LOCH_MappingTools;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.PedTools;
import Tool.StatTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class LOCH_MappingPedwithControl {
    public static void main(String[] args) {
        int Windowkb = 1000;
        int Stretchkb = 2000;
        int StretchkbControl = 2000;
        int numGapSNP = 1;
        int numMinSNP = 20;
        int counter = 0;
        int maxN = 100;
        int[] Table2x2 = new int[4];
        String prefix = "Test";
        String out = "";
        boolean tmpFlag = true;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-Windowkb")) {
                Windowkb = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Stretchkb")) {
                Stretchkb = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-StretchkbControl")) {
                StretchkbControl = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numGapSNP")) {
                numGapSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numMinSNP")) {
                numMinSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            ++i;
        }
        double[] LogFact = new double[maxN * 2 + 1];
        int i2 = 0;
        while (i2 < maxN * 2 + 1) {
            LogFact[i2] = Tools.factlog(i2);
            ++i2;
        }
        String inputfilePed = String.valueOf(prefix) + ".ped";
        String inputfileMap = String.valueOf(prefix) + ".map";
        String inputfileCase = String.valueOf(prefix) + ".case";
        String inputfilePoint = String.valueOf(prefix) + ".point";
        String outfile1 = String.valueOf(prefix) + "_LOCM_MappingCount_Windowkb" + Windowkb + "_Stretchkb" + Stretchkb + "StretchkbControl" + StretchkbControl + "_GapSNP" + numGapSNP + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile1));
            String[] DataPed = FileTools.readDatFileIOStringSingle(inputfilePed);
            String[] DataMap = FileTools.readDatFileIOStringSingle(inputfileMap);
            String[] CaseID = FileTools.readDatFileIOStringSingle(inputfileCase);
            String[] SampleID = PedTools.ExtractSampleIDfromPed(DataPed);
            String[] Point = FileTools.readDatFileIOStringSingle(inputfilePoint);
            int numSNP = DataMap.length;
            int numCase = CaseID.length;
            int numSample = SampleID.length;
            int numControl = numSample - numCase;
            int numPoint = Point.length;
            String[] ControlID = new String[numControl];
            String[] CaseControlID = new String[numCase + 1];
            String[] PointID = new String[numPoint];
            long[] PointPosition = new long[numPoint];
            int[][] PointHitResult = new int[numPoint][numControl + 1];
            int[] PointHitSumControl = new int[numPoint];
            int[] PointChr = new int[numPoint];
            int[] Pointbp = new int[numPoint];
            double[] PointHitFisherP = new double[numPoint];
            double[] PointHitFisherMidP = new double[numPoint];
            ArrayTools.InitializeArray1(PointHitSumControl);
            Table2x2[0] = numCase;
            Table2x2[1] = 0;
            int i3 = 0;
            while (i3 < numCase) {
                CaseControlID[i3] = CaseID[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < numSample) {
                tmpFlag = true;
                int j = 0;
                while (j < numCase) {
                    if (SampleID[i3].equals(CaseID[j])) {
                        tmpFlag = false;
                    }
                    ++j;
                }
                if (tmpFlag) {
                    ControlID[counter] = SampleID[i3];
                    ++counter;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < numPoint) {
                String[] tmp = Point[i3].split("\t");
                PointID[i3] = tmp[0];
                PointChr[i3] = Integer.parseInt(tmp[1]);
                Pointbp[i3] = Integer.parseInt(tmp[2]);
                PointPosition[i3] = Long.parseLong(tmp[1]) * 100000000000L + Long.parseLong(tmp[2]);
                ++i3;
            }
            String[] SNPID = new String[numSNP];
            int[] Chr = new int[numSNP];
            int[] bp = new int[numSNP];
            long[] Position = new long[numSNP];
            int[][] CaseCount = new int[numSNP][3];
            int[][] CaseControlCount = new int[numSNP][3];
            out = "Log_for_LOCM_MappingCount.java\n\nInput_File:\t" + prefix + ".txt\nNo.SNP:\t" + numSNP + "\nWindow_kb:\t" + Windowkb + "\nStretch_kb:\t" + Stretchkb + "\nNo.GapSNP:\t" + numGapSNP + "\nNo.MinSNP:\t" + numMinSNP + "\n\n";
            FileTools.out3File(bw[0], out);
            int i4 = 0;
            while (i4 < numSNP) {
                String[] tmp = DataMap[i4].split("\t");
                SNPID[i4] = tmp[1];
                Chr[i4] = Integer.parseInt(tmp[0]);
                bp[i4] = Integer.parseInt(tmp[3]);
                Position[i4] = Long.parseLong(tmp[0]) * 100000000000L + Long.parseLong(tmp[3]);
                ++i4;
            }
            CaseCount = PedTools.TranslatePed12toCount(PedTools.ExtractPedonSampleID(DataPed, CaseID), 6);
            int[][] StretchLong = LOCH_MappingTools.LOCHMappingAll(CaseCount, Position, Windowkb, numGapSNP, numMinSNP, Stretchkb);
            int[] PointHit = LOCH_MappingTools.PointHitonStretch(StretchLong, PointPosition, Position);
            int numStretchLong = StretchLong.length;
            System.out.println(numStretchLong);
            int i5 = 0;
            while (i5 < numPoint) {
                PointHitResult[i5][0] = PointHit[i5];
                ++i5;
            }
            out = "\nNo.Long_Stretch_CaseOnly\t-\t" + numStretchLong + "\n\n";
            FileTools.out3File(bw[0], out);
            i5 = 0;
            while (i5 < numStretchLong) {
                out = String.valueOf(i5 + 1) + "\t" + Chr[StretchLong[i5][0]] + "\t" + SNPID[StretchLong[i5][0]] + "\t" + SNPID[StretchLong[i5][1]] + "\t" + bp[StretchLong[i5][0]] + "\t" + bp[StretchLong[i5][1]] + "\t" + (bp[StretchLong[i5][1]] - bp[StretchLong[i5][0]]) + "\n";
                FileTools.out3File(bw[0], out);
                ++i5;
            }
            i5 = 0;
            while (i5 < numControl) {
                CaseControlID[numCase] = ControlID[i5];
                CaseControlCount = PedTools.TranslatePed12toCount(PedTools.ExtractPedonSampleID(DataPed, CaseControlID), 6);
                int[][] StretchLongControl = LOCH_MappingTools.LOCHMappingAll(CaseControlCount, Position, Windowkb, numGapSNP, numMinSNP, StretchkbControl);
                int[] PointHitControl = LOCH_MappingTools.PointHitonStretch(StretchLongControl, PointPosition, Position);
                int numStretchLongControl = StretchLongControl.length;
                int j = 0;
                while (j < numPoint) {
                    PointHitResult[j][i5 + 1] = PointHitControl[j];
                    ++j;
                }
                out = "\n\nNo.Long_Stretch_CaseControl\t" + ControlID[i5] + "\t" + numStretchLongControl + "\n\n";
                FileTools.out3File(bw[0], out);
                j = 0;
                while (j < numStretchLongControl) {
                    out = String.valueOf(j + 1) + "\t" + Chr[StretchLongControl[j][0]] + "\t" + SNPID[StretchLongControl[j][0]] + "\t" + SNPID[StretchLongControl[j][1]] + "\t" + bp[StretchLongControl[j][0]] + "\t" + bp[StretchLongControl[j][1]] + "\t" + (bp[StretchLongControl[j][1]] - bp[StretchLongControl[j][0]]) + "\n";
                    FileTools.out3File(bw[0], out);
                    ++j;
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < PointHitResult.length) {
                int j = 1;
                while (j < PointHitResult[0].length) {
                    int n = i5;
                    PointHitSumControl[n] = PointHitSumControl[n] + PointHitResult[i5][j];
                    ++j;
                }
                Table2x2[2] = PointHitSumControl[i5];
                Table2x2[3] = numControl - PointHitSumControl[i5];
                PointHitFisherP[i5] = StatTools.FisherCount2x2(Table2x2, LogFact);
                PointHitFisherMidP[i5] = StatTools.FisherCountMidP2x2(Table2x2, LogFact)[1];
                ++i5;
            }
            out = "\n\nPositionHitResults\n\nLocus\tChr\tbp\tCaseSum\tControlSum\tFisherP\tFisherMidP\tCaseOnly\t";
            i5 = 0;
            while (i5 < numControl) {
                out = String.valueOf(out) + ControlID[i5] + "\t";
                ++i5;
            }
            out = String.valueOf(out) + "\n";
            i5 = 0;
            while (i5 < PointHitResult.length) {
                out = String.valueOf(out) + PointID[i5] + "\t" + PointChr[i5] + "\t" + Pointbp[i5] + "\t" + CaseID.length + "\t" + PointHitSumControl[i5] + "\t" + PointHitFisherP[i5] + "\t" + PointHitFisherMidP[i5] + "\t";
                int j = 0;
                while (j < PointHitResult[0].length) {
                    out = String.valueOf(out) + PointHitResult[i5][j] + "\t";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                ++i5;
            }
            FileTools.out3File(bw[0], out);
            out = "\nCalculation_finished_at:\t" + Tools.GetTime() + "\n";
            FileTools.out3File(bw[0], out);
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

