/*
 * Decompiled with CFR 0.152.
 */
package Interaction;

import Algorithms.MersenneTwisterFast;
import Interaction.TableManageInt;
import Likelihood.TableManage;
import Tool.FileTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class MakeTwoLociData {
    public static void main(String[] args) {
        int numsnp = 10000;
        int numcase = 2000;
        int numcont = 2000;
        int rep = 2;
        int testtype = 0;
        int numtest = 8;
        double[] AF1 = new double[]{0.5, 0.5};
        double[] AF2 = new double[]{0.5, 0.5};
        double R1 = 1.0;
        double R2 = 1.0;
        double prev = 1.0E-8;
        double[] r2 = new double[]{0.0, 0.0};
        double interact = 0.0;
        String out = "";
        String out1 = "";
        String out2 = "";
        String[] Genotype = new String[]{"0", "1", "2"};
        String[] Phenotype = new String[]{"1", "2"};
        String outfile = "TwoLociExa";
        String outfilelog = "";
        String outfileLD = "";
        String outfileCount = "";
        String outfilePhen = "";
        String outfilelist = "";
        int seedgiven = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-numcase")) {
                numcase = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numcont")) {
                numcont = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numsnp")) {
                numsnp = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-rep")) {
                rep = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-testtype")) {
                testtype = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-AF1")) {
                AF1[0] = Double.parseDouble(args[i + 1]);
                AF1[1] = Double.parseDouble(args[i + 2]);
            }
            if (args[i].equals("-AF2")) {
                AF2[0] = Double.parseDouble(args[i + 1]);
                AF2[1] = Double.parseDouble(args[i + 2]);
            }
            if (args[i].equals("-RR1")) {
                R1 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-RR2")) {
                R2 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-d")) {
                prev = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-r2")) {
                r2[0] = Double.parseDouble(args[i + 1]);
                r2[1] = Double.parseDouble(args[i + 2]);
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-out")) {
                outfile = args[i + 1];
            }
            ++i;
        }
        int seed = 999999999;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        String[] outfilegen = new String[rep];
        outfilelog = String.valueOf(outfile) + "_log.txt";
        outfileLD = String.valueOf(outfile) + "_snpLD.txt";
        outfileCount = String.valueOf(outfile) + "_snpCountLD.txt";
        outfilePhen = String.valueOf(outfile) + "_phen.txt";
        outfilelist = String.valueOf(outfile) + "_list.txt";
        BufferedWriter[] bw1 = new BufferedWriter[5];
        BufferedWriter[] bw2 = new BufferedWriter[rep];
        bw1[0] = null;
        bw1[1] = null;
        bw1[2] = null;
        bw1[3] = null;
        bw1[4] = null;
        int i2 = 0;
        while (i2 < rep) {
            outfilegen[i2] = String.valueOf(outfile) + "_gen" + i2 + ".txt";
            bw2[i2] = null;
            ++i2;
        }
        try {
            bw1[0] = new BufferedWriter(new FileWriter(outfilelog));
            bw1[1] = new BufferedWriter(new FileWriter(outfileLD));
            bw1[2] = new BufferedWriter(new FileWriter(outfileCount));
            bw1[3] = new BufferedWriter(new FileWriter(outfilePhen));
            bw1[4] = new BufferedWriter(new FileWriter(outfilelist));
            i2 = 0;
            while (i2 < rep) {
                bw2[i2] = new BufferedWriter(new FileWriter(outfilegen[i2]));
                ++i2;
            }
            out = "Parameters of MakeTwoLociData.java\nN.cases:\t" + numcase + "\nNo.controls:\t" + numcont + "\nNo.SNPs:\t" + numsnp + "\nAF in SNP1:\t" + AF1[0] + "-" + AF1[1] + "\nAF in SNP2:\t" + AF2[0] + "-" + AF2[1] + "\n";
            out = String.valueOf(out) + "gRR in SNP1:\t" + R1 + "\ngRR in SNP2:\t" + R2 + "\ndisease prevalence:\t" + prev + "\nLD(r2):\t" + r2[0] + "-" + r2[1] + "\nrepeat:\t" + rep + "\n\n";
            FileTools.out3File(bw1[0], out);
            TableManageInt.outputPhenArray(Phenotype, numcont, numcase, bw1[3]);
            out = String.valueOf(outfilePhen) + "\n";
            i2 = 0;
            while (i2 < rep) {
                out = String.valueOf(out) + outfilegen[i2] + "\n";
                ++i2;
            }
            FileTools.out3File(bw1[4], out);
            double[][] RRGeno = new double[3][3];
            double[][] popHapFreq = new double[2][2];
            double[][] contHapFreq = new double[2][2];
            double[][] caseHapFreq = new double[2][2];
            double[][] popGenoFreq = new double[3][3];
            double[][] contGenoFreq = new double[3][3];
            double[][] caseGenoFreq = new double[3][3];
            out = "popAF1\tpopAF2\tpopr2\t";
            int k = 0;
            while (k < numtest) {
                out = String.valueOf(out) + "contD_" + k + "\tcaseD_" + k + "\tcontr2_" + k + "\tcaser2_" + k + "\t";
                ++k;
            }
            out = String.valueOf(out) + "\n";
            FileTools.out3File(bw1[1], out);
            out = "cont00\tcont10\tcont20\tcont01\tcont11\tcont21\tcont02\tcont12\tcont22\tcase00\tcase10\tcase20\tcase01\tcase11\tcase21\tcase02\tcase12\tcase22\tcontSNP1_0\tcontSNP1_1\tcontSNP1_2\tcontSNP2_0\tcontSNP2_1\tcontSNP2_2\tcaseSNP1_0\tcaseSNP1_1\tcaseSNP1_2\tcaseSNP2_0\tcaseSNP2_1\tcaseSNP2_2\n";
            FileTools.out3File(bw1[2], out);
            int i3 = 0;
            while (i3 < rep) {
                int j = 0;
                while (j < numsnp) {
                    double popAF1 = mz.nextDouble() * (AF1[1] - AF1[0]) + AF1[0];
                    double popAF2 = mz.nextDouble() * (AF2[1] - AF2[0]) + AF2[0];
                    r2[1] = Math.min(TableManageInt.Maxr2Dposi(popAF1, popAF2), r2[1]);
                    double popr2 = mz.nextDouble() * (r2[1] - r2[0]) + r2[0];
                    double d = Math.pow(popr2 * (popAF1 * (1.0 - popAF1) * popAF2 * (1.0 - popAF2)), 0.5);
                    popHapFreq = TableManageInt.ChangeAlleleHapTwoLoci(popAF1, popAF2, d);
                    popGenoFreq = TableManageInt.ChangeHapGenoTwoLoci(popHapFreq);
                    out = String.valueOf(popAF1) + "\t" + popAF2 + "\t" + popr2 + "\t";
                    int k2 = 0;
                    while (k2 < numtest) {
                        double[][] tmpRRGeno = TableManage.ExtractTable(TableManageInt.MakeRRTable3x3(R1, R2, interact), k2);
                        double[][][] tmpGenoFreq = TableManageInt.CalcGenoFreqCaseCont(tmpRRGeno, popGenoFreq, prev);
                        double[][] tmpcontGenoFreq = TableManage.ExtractTable(tmpGenoFreq, 0);
                        double[][] tmpcaseGenoFreq = TableManage.ExtractTable(tmpGenoFreq, 1);
                        double[][] tmpcontHapFreq = TableManageInt.pairwiseEM(tmpcontGenoFreq);
                        double[][] tmpcaseHapFreq = TableManageInt.pairwiseEM(tmpcaseGenoFreq);
                        double tmpcontd = TableManageInt.ChangeHapAlleleTwoLoci(tmpcontHapFreq)[2];
                        double tmpcased = TableManageInt.ChangeHapAlleleTwoLoci(tmpcaseHapFreq)[2];
                        double tmpcontr2 = TableManageInt.ChangeHapAlleleTwoLoci(tmpcontHapFreq)[3];
                        double tmpcaser2 = TableManageInt.ChangeHapAlleleTwoLoci(tmpcaseHapFreq)[3];
                        if (k2 == testtype) {
                            RRGeno = tmpRRGeno;
                            contGenoFreq = tmpcontGenoFreq;
                            caseGenoFreq = tmpcaseGenoFreq;
                            contHapFreq = tmpcontHapFreq;
                            caseHapFreq = tmpcaseHapFreq;
                            double contd = tmpcontd;
                            double cased = tmpcased;
                            double contr2 = tmpcontr2;
                            double d2 = tmpcaser2;
                        }
                        out = String.valueOf(out) + tmpcontd + "\t" + tmpcased + "\t" + tmpcontr2 + "\t" + tmpcaser2 + "\t";
                        ++k2;
                    }
                    out = String.valueOf(out) + "\n";
                    FileTools.out3File(bw1[1], out);
                    int[][] Geno = TableManageInt.SamplingTwoSNPGenoData(contGenoFreq, caseGenoFreq, numcont, numcase, mz);
                    int[][][] Table = TableManageInt.MakeTwoSNPTable3x3(Geno, numcont, numcase);
                    int[][] contTable = TableManage.ExtractTable(Table, 0);
                    int[][] caseTable = TableManage.ExtractTable(Table, 1);
                    TableManageInt.outGenArray2SNP(Geno, Genotype, bw2[i3]);
                    out1 = "";
                    out2 = "";
                    int l = 0;
                    while (l < contTable[0].length) {
                        int k3 = 0;
                        while (k3 < contTable.length) {
                            out1 = String.valueOf(out1) + contTable[k3][l] + "\t";
                            out2 = String.valueOf(out2) + caseTable[k3][l] + "\t";
                            ++k3;
                        }
                        ++l;
                    }
                    out1 = String.valueOf(out1) + out2;
                    out1 = String.valueOf(out1) + (contTable[0][0] + contTable[0][1] + contTable[0][2]) + "\t" + (contTable[1][0] + contTable[1][1] + contTable[1][2]) + "\t" + (contTable[2][0] + contTable[2][1] + contTable[2][2]) + "\t";
                    out1 = String.valueOf(out1) + (contTable[0][0] + contTable[1][0] + contTable[2][0]) + "\t" + (contTable[0][1] + contTable[1][1] + contTable[2][1]) + "\t" + (contTable[0][2] + contTable[1][2] + contTable[2][2]) + "\t";
                    out1 = String.valueOf(out1) + (caseTable[0][0] + caseTable[0][1] + caseTable[0][2]) + "\t" + (caseTable[1][0] + caseTable[1][1] + caseTable[1][2]) + "\t" + (caseTable[2][0] + caseTable[2][1] + caseTable[2][2]) + "\t";
                    out1 = String.valueOf(out1) + (caseTable[0][0] + caseTable[1][0] + caseTable[2][0]) + "\t" + (caseTable[0][1] + caseTable[1][1] + caseTable[2][1]) + "\t" + (caseTable[0][2] + caseTable[1][2] + caseTable[2][2]) + "\n";
                    FileTools.out3File(bw1[2], out1);
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < bw1.length) {
                bw1[i3].close();
                ++i3;
            }
            i3 = 0;
            while (i3 < bw2.length) {
                bw2[i3].close();
                ++i3;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR!!!!!");
            System.out.println(e);
        }
    }
}

