/*
 * Decompiled with CFR 0.152.
 */
package HWE;

import Algorithms.MersenneTwisterFast;
import HWE.HWETools;
import HWE.MakeMultiAllele;
import Tool.FileTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class CompCalcTimeHWE {
    public static void main(String[] args) {
        int N = 100;
        int k = 3;
        int rep = 10;
        int seedgiven = 0;
        boolean Louis = true;
        boolean all = false;
        String outfile = "CalcTimeHWE";
        String out = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-N")) {
                N = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-k")) {
                k = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-rep")) {
                rep = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-out")) {
                outfile = args[i + 1];
            }
            if (args[i].equals("-all")) {
                all = true;
            }
            ++i;
        }
        double[] p = new double[k];
        boolean NoData = true;
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals("-p")) {
                int j = 0;
                while (j < k) {
                    p[j] = Double.parseDouble(args[i2 + j + 1]);
                    ++j;
                }
                NoData = false;
            }
            ++i2;
        }
        if (NoData) {
            p[0] = 0.333;
            p[1] = 0.333;
            p[2] = 0.333;
        }
        int seed = 999999999;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        String outfileSum = String.valueOf(outfile) + "_N" + N + "_k" + k;
        int i3 = 0;
        while (i3 < k) {
            outfileSum = String.valueOf(outfileSum) + "_" + p[i3];
            ++i3;
        }
        outfileSum = String.valueOf(outfileSum) + "_rep" + rep + ".txt";
        BufferedWriter[] bw1 = new BufferedWriter[]{null};
        try {
            int j;
            bw1[0] = new BufferedWriter(new FileWriter(outfileSum));
            out = "Calculation Time of HWE test\nStarted at:\t" + Tools.GetTime() + "\nNo.Sample:\t" + N + "\nNo.Allele:\t" + k + "\nAllele Freq:\t";
            int i4 = 0;
            while (i4 < k) {
                out = String.valueOf(out) + p[i4] + "\t";
                ++i4;
            }
            out = String.valueOf(out) + "\nrepeat:\t" + rep + "\n\nResults\n";
            FileTools.out3File(bw1[0], out);
            int kdip = k * (k + 1) / 2;
            int kTime = 6;
            int[][] Diplo = new int[kdip][3];
            long[][] Time = new long[kTime][rep];
            long[] tmpTime = new long[kTime];
            long[] tmprep = new long[rep];
            double[] meanTime = new double[kTime];
            double[] sdTime = new double[kTime];
            int i5 = 0;
            while (i5 < rep) {
                Diplo = MakeMultiAllele.MakeMultiDiploCount(p, N, true, mz);
                tmpTime = HWETools.GetCalcTime(Diplo, mz, Louis, all);
                j = 0;
                while (j < tmpTime.length) {
                    Time[j][i5] = tmpTime[j];
                    ++j;
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < Time.length) {
                j = 0;
                while (j < Time[0].length) {
                    tmprep[j] = Time[i5][j];
                    ++j;
                }
                meanTime[i5] = Tools.MeanVarSD(tmprep)[0] * Math.pow(10.0, -9.0);
                sdTime[i5] = Tools.MeanVarSD(tmprep)[2] * Math.pow(10.0, -9.0);
                ++i5;
            }
            out = "Chi2:\t" + meanTime[0] + "\t" + sdTime[0] + "\nChi2Permx10000:\t" + meanTime[1] + "\t" + sdTime[1] + "\nChi2Permx50000:\t" + meanTime[2] + "\t" + sdTime[2] + "\nChi2Permx100000:\t" + meanTime[3] + "\t" + sdTime[3] + "\nExactbyLouis:\t" + meanTime[4] + "\t" + sdTime[4] + "\nExactforAll:\t" + meanTime[5] + "\t" + sdTime[5];
            out = String.valueOf(out) + "\n\nEnded at:\t" + Tools.GetTime();
            FileTools.out3File(bw1[0], out);
            bw1[0].close();
        }
        catch (Exception e) {
            System.out.println("ERROR!!!!!");
            System.out.println(e);
        }
    }
}

