/*
 * Decompiled with CFR 0.152.
 */
package HWE;

import Algorithms.MersenneTwisterFast;
import HWE.HWEExact;
import HWE.HWETools;
import HWE.MakeMultiAllele;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class CheckTypeIMultiHWE {
    public static void main(String[] args) {
        int N = 100;
        int k = 3;
        int perm = 10000;
        int rep = 1000;
        int seedgiven = 0;
        int numTest = 4;
        int numgroup = 2;
        double[] alphaP = new double[]{0.5, 0.4, 0.3, 0.2, 0.15, 0.1, 0.05, 0.01, 0.005, 0.001};
        boolean Exact = true;
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] PorChi = blArray;
        String outfile = "CheckTypeIHWE";
        String out = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-N")) {
                N = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-k")) {
                k = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-perm")) {
                perm = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-rep")) {
                rep = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-group")) {
                numgroup = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-out")) {
                outfile = args[i + 1];
            }
            if (args[i].equals("-NoExact")) {
                Exact = false;
            }
            ++i;
        }
        byte df = Byte.parseByte(String.valueOf(k * (k - 1) / 2));
        int kdip = k * (k + 1) / 2;
        double[] p = new double[k];
        double[] alphaC = new double[alphaP.length];
        boolean NoData = true;
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals("-p")) {
                int j = 0;
                while (j < k) {
                    p[j] = Double.parseDouble(args[i2 + j + 1]);
                    ++j;
                }
                NoData = false;
            }
            ++i2;
        }
        if (NoData) {
            p[0] = 0.333;
            p[1] = 0.333;
            p[2] = 0.333;
        }
        int seed = 999999999;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        String outfileSum = String.valueOf(outfile) + "_N" + N + "_k" + k;
        int i3 = 0;
        while (i3 < k) {
            outfileSum = String.valueOf(outfileSum) + "_" + p[i3];
            ++i3;
        }
        String outfileRes = outfileSum = String.valueOf(outfileSum) + "_rep" + rep + "_group" + numgroup;
        String outfileCount = outfileSum;
        outfileSum = String.valueOf(outfileSum) + ".txt";
        outfileRes = String.valueOf(outfileRes) + "_result.txt";
        outfileCount = String.valueOf(outfileCount) + "_count.txt";
        BufferedWriter[] bw1 = new BufferedWriter[]{null, null, null};
        try {
            int j;
            bw1[0] = new BufferedWriter(new FileWriter(outfileSum));
            bw1[1] = new BufferedWriter(new FileWriter(outfileRes));
            bw1[2] = new BufferedWriter(new FileWriter(outfileCount));
            ChiSquaredDistributionImpl chidf = new ChiSquaredDistributionImpl((double)df);
            out = "Type I error rates of HWE test\nStarted at:\t" + Tools.GetTime() + "\nNo.Sample:\t" + N + "\nNo.Allele:\t" + k + "\nNo.Hetero:\t" + kdip + "\ndf:\t" + df + "\nAllele Freq:\t";
            int i4 = 0;
            while (i4 < k) {
                out = String.valueOf(out) + p[i4] + "\t";
                ++i4;
            }
            out = String.valueOf(out) + "\nPermutation:\t" + perm + "\nExact:\t" + Exact + "\nrepeat:\t" + rep + "\ngroup:\t" + numgroup + "\nAlphaP:\t";
            i4 = 0;
            while (i4 < alphaP.length) {
                out = String.valueOf(out) + alphaP[i4] + "\t";
                alphaC[i4] = chidf.inverseCumulativeProbability(1.0 - alphaP[i4]);
                ++i4;
            }
            out = String.valueOf(out) + "\nAlphaC:\t";
            i4 = 0;
            while (i4 < alphaC.length) {
                out = String.valueOf(out) + alphaC[i4] + "\t";
                ++i4;
            }
            out = String.valueOf(out) + "\n\nResults\n";
            FileTools.out3File(bw1[0], out);
            out = "Chi2\tPermChi2P\tPermExactP\tExactP\t\n";
            FileTools.out3File(bw1[1], out);
            int[][] Count = new int[kdip][3];
            Count = MakeMultiAllele.MakeMultiDiploCount(p, 10, true, mz);
            out = "";
            int i5 = 0;
            while (i5 < Count.length) {
                out = String.valueOf(out) + Count[i5][0] + " " + Count[i5][1] + "\t";
                ++i5;
            }
            FileTools.out3File(bw1[2], String.valueOf(out) + "\n");
            int[][] posiTest = new int[numTest][alphaP.length];
            int[][] posiTestCommon = new int[numTest - 1][alphaP.length];
            double[][][] typeI = new double[numgroup][numTest][alphaP.length];
            double[][] typeIMean = new double[numTest][alphaP.length];
            double[][] typeISD = new double[numTest][alphaP.length];
            double[][][] typeICommon = new double[numgroup][numTest - 1][alphaP.length];
            double[][] typeICommonMean = new double[numTest - 1][alphaP.length];
            double[][] typeICommonSD = new double[numTest - 1][alphaP.length];
            double[] tmp = new double[numgroup];
            ArrayTools.InitialaizeArray2(posiTest);
            ArrayTools.InitialaizeArray2(posiTestCommon);
            double[] TestStat = new double[numTest];
            double[] LogFact = ArrayTools.LogFact(N * 2);
            int l = 0;
            while (l < numgroup) {
                int j2;
                int i6 = 0;
                while (i6 < rep) {
                    Count = MakeMultiAllele.MakeMultiDiploCount(p, N, true, mz);
                    TestStat[0] = HWETools.HWEChifromDiplo(Count);
                    TestStat[1] = HWETools.HWEPfromDiploPerm(Count, perm, mz);
                    TestStat[2] = HWETools.HWEPfromDiploPermExact(Count, perm, mz, LogFact);
                    TestStat[3] = Exact ? HWEExact.ExactHWEMultiByLouis(Count, LogFact) : 99.0;
                    out = "";
                    j2 = 0;
                    while (j2 < Count.length) {
                        out = String.valueOf(out) + Count[j2][2] + "\t";
                        ++j2;
                    }
                    FileTools.out3File(bw1[2], String.valueOf(out) + "\n");
                    out = "";
                    j2 = 0;
                    while (j2 < numTest) {
                        int m = 0;
                        while (m < alphaP.length) {
                            if (PorChi[j2] && TestStat[j2] <= alphaP[m]) {
                                int[] nArray = posiTest[j2];
                                int n = m;
                                nArray[n] = nArray[n] + 1;
                            } else if (!PorChi[j2] && TestStat[j2] >= alphaC[m]) {
                                int[] nArray = posiTest[j2];
                                int n = m;
                                nArray[n] = nArray[n] + 1;
                            }
                            if (j2 != numTest - 1) {
                                if (PorChi[j2] && TestStat[j2] <= alphaP[m] && TestStat[numTest - 1] <= alphaP[m]) {
                                    int[] nArray = posiTestCommon[j2];
                                    int n = m;
                                    nArray[n] = nArray[n] + 1;
                                } else if (!PorChi[j2] && TestStat[j2] >= alphaC[m] && TestStat[numTest - 1] <= alphaP[m]) {
                                    int[] nArray = posiTestCommon[j2];
                                    int n = m;
                                    nArray[n] = nArray[n] + 1;
                                }
                            }
                            ++m;
                        }
                        out = String.valueOf(out) + TestStat[j2] + "\t";
                        ++j2;
                    }
                    FileTools.out3File(bw1[1], String.valueOf(out) + "\n");
                    if (mz.nextDouble() < 0.01) {
                        System.out.println(i6);
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < alphaP.length) {
                    j2 = 0;
                    while (j2 < numTest) {
                        typeI[l][j2][i6] = (double)posiTest[j2][i6] / (double)rep;
                        posiTest[j2][i6] = 0;
                        if (j2 != numTest - 1) {
                            typeICommon[l][j2][i6] = (double)posiTestCommon[j2][i6] / (double)rep;
                            posiTestCommon[j2][i6] = 0;
                        }
                        ++j2;
                    }
                    ++i6;
                }
                ++l;
            }
            int i7 = 0;
            while (i7 < alphaP.length) {
                j = 0;
                while (j < numTest) {
                    int l2 = 0;
                    while (l2 < numgroup) {
                        tmp[l2] = typeI[l2][j][i7];
                        ++l2;
                    }
                    double[] tmp2 = Tools.MeanVarSD(tmp);
                    typeIMean[j][i7] = tmp2[0];
                    typeISD[j][i7] = tmp2[2];
                    ++j;
                }
                j = 0;
                while (j < numTest - 1) {
                    int l3 = 0;
                    while (l3 < numgroup) {
                        tmp[l3] = typeICommon[l3][j][i7];
                        ++l3;
                    }
                    double[] tmp2 = Tools.MeanVarSD(tmp);
                    typeICommonMean[j][i7] = tmp2[0];
                    typeICommonSD[j][i7] = tmp2[2];
                    ++j;
                }
                ++i7;
            }
            out = "Alpha\tChi2\tPermChi2P\tPermExactP\tExactP\tChi2-Exact\tPermChi2-Exact\tPermExact-Exact\n";
            i7 = 0;
            while (i7 < alphaP.length) {
                int l4 = 0;
                while (l4 < numgroup) {
                    out = String.valueOf(out) + alphaP[i7] + "\t";
                    int j3 = 0;
                    while (j3 < numTest) {
                        out = String.valueOf(out) + typeI[l4][j3][i7] + "\t";
                        ++j3;
                    }
                    j3 = 0;
                    while (j3 < numTest - 1) {
                        out = String.valueOf(out) + typeICommon[l4][j3][i7] + "\t";
                        ++j3;
                    }
                    out = String.valueOf(out) + "\n";
                    ++l4;
                }
                out = String.valueOf(out) + "Mean\t";
                j = 0;
                while (j < numTest) {
                    out = String.valueOf(out) + typeIMean[j][i7] + "\t";
                    ++j;
                }
                j = 0;
                while (j < numTest - 1) {
                    out = String.valueOf(out) + typeICommonMean[j][i7] + "\t";
                    ++j;
                }
                out = String.valueOf(out) + "\nSD\t";
                j = 0;
                while (j < numTest) {
                    out = String.valueOf(out) + typeISD[j][i7] + "\t";
                    ++j;
                }
                j = 0;
                while (j < numTest - 1) {
                    out = String.valueOf(out) + typeICommonSD[j][i7] + "\t";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                ++i7;
            }
            out = String.valueOf(out) + "\nEnded at:\t" + Tools.GetTime();
            FileTools.out3File(bw1[0], out);
            bw1[0].close();
            bw1[1].close();
            bw1[2].close();
        }
        catch (Exception e) {
            System.out.println("ERROR!!!!!");
            System.out.println(e);
        }
    }
}

