#!	/usr/bin/perl	-w

=head1	header

	###########################################################
	#  
	#  This script unifies allele 1 and allele 2 of GWAS results
	#  This step is necessary if allele 1/2 are not defined in the same manner among different GWAS
	#  Allele 1 and 2 will be defined in order of priority of A, T, G, C
	#  
	#  perl FlipAssocResonAllele.pl TmpAssoc.txt
	#  
	#  Input : TmpAssoc.txt
	#  Output : TmpAssoc_Flip.txt, TmpAssoc_Flip_flip.txt
	#  
	#  Format of TmpAssoc.txt
	#  rs12184267	C	T	483	1631	0.9665	0.9599	0.218	0.268	0.4144
	#  Col 1 : SNPID
	#  Col 2 : (Origianl) allele 1
	#  Col 3 : (Origianl) allele 2
	#  Col 4 : No. cases
	#  Col 5 : No. controls
	#  Col 6 : Allele 1 frequency in cases
	#  Col 7 : Allele 1 frequency in controls
	#  Col 8 : Beta of Allele 1
	#  Col 9 : SE for Beta
	#  Col 10 : P-value
	#  
	#  TmpAssoc_Flip.txt has the same format, but based on newly-defined allele 1/2.
	#  
	#  TmpAssoc_Flip_log.txt includes the summary of allele 1/2 flipping patterns.
	#  No.SNPs_forward: ... No. SNPs originally in order of A>T>G>C
	#  No.SNPs_reverse: ... No. SNPs not originally in order of A>T>G>C
	#  No.SNPs_same: ... No. SNPs which have same allele 1 and allele 2
	#  No.SNPs_other: ... No. SNPs which do not follow forward/reverse/same patterns.
	#  It would be recommended to check the original file when ratio of No.forward/No.reverse differ much from 1.0, or there are many same/other SNPs
	#  
	#  Any questions to Yukinori Okada (http://plaza.umin.ac.jp/~yokada/datasource/software.htm   yokada@broadinstitute.org)

=cut

use	strict;


&main(@ARGV);
exit;

=head1	main
=cut

sub	main(@){
	my ($input_file)=@_;
	my $prefix = $input_file;
	for (my $i=0;$i<4;$i++)	{
	chop($prefix);
	}
	my $outfile1 = $prefix."_Flip.txt";
	my $outfile2 = $prefix."_Flip_log.txt";
	my $forward = 0;
	my $reverse = 0;
	my $same = 0;
	my $other = 0;
	open (OUT1, "> $outfile1");
	open (OUT2, "> $outfile2");
	

	open (INPUT1, "$input_file");
	while(<INPUT1>){
		chomp;
		my $last = substr $_,-1;
		if ($last eq "\r") {
			substr ($_,-1) = "";
		}
		my @inline = split(/\t/);
#		if (($inline[1] eq "A" && $inline[2] eq "T") || ($inline[1] eq "A" && $inline[2] eq "G") || ($inline[1] eq "A" && $inline[2] eq "C") || ($inline[1] eq "T" && $inline[2] eq "G") || ($inline[1] eq "T" && $inline[2] eq "C") || ($inline[1] eq "G" && $inline[2] eq "C")) {
		if (($inline[1] eq "A" && $inline[2] eq "T") || ($inline[1] eq "A" && $inline[2] eq "G") || ($inline[1] eq "A" && $inline[2] eq "C") || ($inline[1] eq "T" && $inline[2] eq "G") || ($inline[1] eq "T" && $inline[2] eq "C") || ($inline[1] eq "G" && $inline[2] eq "C") || ($inline[1] eq "D" && $inline[2] eq "I")) {
			print OUT1 $inline[0]."\t".$inline[1]."\t".$inline[2]."\t".$inline[3]."\t".$inline[4]."\t".$inline[5]."\t".$inline[6]."\t".$inline[7]."\t".$inline[8]."\t".$inline[9]."\n";
			$forward++;
#		} elsif (($inline[1] eq "T" && $inline[2] eq "A") || ($inline[1] eq "G" && $inline[2] eq "A") || ($inline[1] eq "C" && $inline[2] eq "A") || ($inline[1] eq "G" && $inline[2] eq "T") || ($inline[1] eq "C" && $inline[2] eq "T") || ($inline[1] eq "C" && $inline[2] eq "G")) {
		} elsif (($inline[1] eq "T" && $inline[2] eq "A") || ($inline[1] eq "G" && $inline[2] eq "A") || ($inline[1] eq "C" && $inline[2] eq "A") || ($inline[1] eq "G" && $inline[2] eq "T") || ($inline[1] eq "C" && $inline[2] eq "T") || ($inline[1] eq "C" && $inline[2] eq "G") || ($inline[1] eq "I" && $inline[2] eq "D")) {
			print OUT1 $inline[0]."\t".$inline[2]."\t".$inline[1]."\t".$inline[3]."\t".$inline[4]."\t".(1.0000-$inline[5])."\t".(1.0000-$inline[6])."\t".(-1*$inline[7])."\t".$inline[8]."\t".$inline[9]."\n";
			$reverse++;
		} elsif (($inline[1] eq "A" && $inline[2] eq "A") || ($inline[1] eq "T" && $inline[2] eq "T") || ($inline[1] eq "G" && $inline[2] eq "G") || ($inline[1] eq "C" && $inline[2] eq "C")) {
			$same++;
		} else {
			$other++;
		}
	}

	close OUT1;
	close INPUT1;
	
	my $out = "Fliplog_for_:\t".$input_file."\n";
	$out .= "No.SNPs_forward:\t".$forward."\n";
	$out .= "No.SNPs_reverse:\t".$reverse."\n";
	$out .= "No.SNPs_same:\t".$same."\n";
	$out .= "No.SNPs_other:\t".$other."\n";
	print OUT2 $out;
	close OUT2;
	
}
