/*
 * Decompiled with CFR 0.152.
 */
package WorksFromRY;

import WorksFromRY.NormalDistribution;
import WorksFromRY.NormalDistributionMore;

public class Chi2DistributionMore {
    public static double upper(int df, double chi2) {
        double s;
        if ((df & 1) != 0) {
            double s2;
            double chi = Math.sqrt(chi2);
            if (df == 1) {
                return 2.0 * NormalDistributionMore.upper(chi);
            }
            double t = s2 = chi * Math.exp(-0.5 * chi2) / Math.sqrt(Math.PI * 2);
            int k = 3;
            while (k < df) {
                s2 += (t *= chi2 / (double)k);
                k += 2;
            }
            return 2.0 * (NormalDistribution.upper(chi) + s2);
        }
        double t = s = Math.exp(-0.5 * chi2);
        int k = 2;
        while (k < df) {
            s += (t *= chi2 / (double)k);
            k += 2;
        }
        return s;
    }

    public static double lower(int df, double chi2) {
        return 1.0 - Chi2DistributionMore.upper(df, chi2);
    }
}

