/*
 * Decompiled with CFR 0.152.
 */
package Tool;

import Algorithms.MersenneTwisterFast;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.PlotTools;
import Tool.Quicksort;
import Tool.StatTools;
import Tool.Tools;
import java.io.IOException;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class GenoTools {
    public static void main(String[] args) {
        double[] array2 = new double[]{0.5, 1.0, 3.0, 0.2, 10.0, 5.0, 6.0, -1.0, -1.0, 2.0, 5.0, 4.0};
        byte[] byArray = new byte[12];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = -1;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byte[] array3 = byArray;
        PlotTools.Array2(GenoTools.PhenotypeByGenotype(array3, array2, 3));
    }

    public static double[] MainStatFrom2x3(int[] array, double[] LogFact, int type) {
        double[] tmpStat;
        double[] ret = new double[13];
        int[] arrayAdd = GenoTools.ChangeAddsingle(array);
        int[] arrayRec = GenoTools.ChangeRecsingle(array);
        int[] arrayDom = GenoTools.ChangeDomsingle(array);
        int i = 0;
        while (i < ret.length) {
            ret[i] = -99.0;
            ++i;
        }
        int[] flag = GenoTools.Flag2x3(type);
        if (flag[0] == 1) {
            ret[0] = StatTools.Chi2Count(arrayAdd);
        }
        if (flag[1] == 1 || flag[2] == 1) {
            tmpStat = StatTools.FisherCountMidP2x2(arrayAdd, LogFact);
            ret[1] = tmpStat[0];
            ret[2] = tmpStat[1];
        }
        if (flag[3] == 1) {
            ret[3] = StatTools.Chi2Count(arrayRec);
        }
        if (flag[4] == 1 || flag[5] == 1) {
            tmpStat = StatTools.FisherCountMidP2x2(arrayRec, LogFact);
            ret[4] = tmpStat[0];
            ret[5] = tmpStat[1];
        }
        if (flag[6] == 1) {
            ret[6] = StatTools.Chi2Count(arrayDom);
        }
        if (flag[7] == 1 || flag[8] == 1) {
            tmpStat = StatTools.FisherCountMidP2x2(arrayDom, LogFact);
            ret[7] = tmpStat[0];
            ret[8] = tmpStat[1];
        }
        if (flag[9] == 1) {
            ret[9] = StatTools.Chi2x3Count(array);
        }
        if (flag[10] == 1 || flag[11] == 1) {
            tmpStat = StatTools.FisherCountMidP2x3(array, LogFact);
            ret[10] = tmpStat[0];
            ret[11] = tmpStat[1];
        }
        if (flag[12] == 1) {
            ret[12] = StatTools.Armitage2x3(array);
        }
        return ret;
    }

    public static int[] Flag2x3(int type) {
        int[] ret = new int[50];
        int i = 0;
        while (i < ret.length) {
            ret[i] = 0;
            ++i;
        }
        if (type == 0) {
            ret[0] = 1;
            ret[1] = 1;
            ret[2] = 1;
            ret[3] = 1;
            ret[4] = 1;
            ret[5] = 1;
            ret[6] = 1;
            ret[7] = 1;
            ret[8] = 1;
            ret[9] = 1;
            ret[10] = 1;
            ret[11] = 1;
            ret[12] = 1;
        } else if (type == 1) {
            ret[0] = 1;
            ret[1] = 1;
            ret[2] = 1;
            ret[9] = 1;
            ret[10] = 1;
            ret[11] = 1;
            ret[12] = 1;
        } else if (type == 2) {
            ret[0] = 1;
            ret[1] = 1;
            ret[2] = 1;
            ret[12] = 1;
        } else if (type == 3) {
            ret[0] = 1;
            ret[3] = 1;
            ret[6] = 1;
            ret[9] = 1;
            ret[12] = 1;
        } else if (type == 4) {
            ret[0] = 1;
            ret[2] = 1;
        } else if (type == 5) {
            ret[0] = 1;
            ret[1] = 1;
        }
        return ret;
    }

    public static String Label2x3(int type) {
        String ret = "";
        int[] flag = GenoTools.Flag2x3(type);
        String[] head = new String[]{"alleleChi", "alleleFishP", "alleleMidP", "recChi", "recFishP", "recMidP", "domChi", "domFishP", "domMidP", "2x3Chi", "2x3FishP", "2x3midP", "TrendP"};
        int i = 0;
        while (i < head.length) {
            if (flag[i] == 1) {
                ret = String.valueOf(ret) + head[i] + "\t";
            }
            ++i;
        }
        ret = String.valueOf(ret) + "\n";
        return ret;
    }

    public static byte[][] GenotypeConvert(String filepath, String[] genotype, byte[] genotypeNum) throws IOException {
        String stFile = FileTools.readUsingIOString(filepath);
        String[] data1 = stFile.split("\n");
        byte[][] data = new byte[data1.length][0];
        int counter = 0;
        int i = 0;
        while (i < data1.length) {
            String[] tmp = data1[i].split("\t");
            tmp[tmp.length - 1] = tmp[tmp.length - 1].trim();
            data[counter] = new byte[tmp.length];
            int j = 0;
            while (j < tmp.length) {
                data[i][j] = -1;
                int k = 0;
                while (k < genotype.length) {
                    if (tmp[j].equals(genotype[k])) {
                        data[i][j] = genotypeNum[k];
                    }
                    ++k;
                }
                ++j;
            }
            ++counter;
            ++i;
        }
        return data;
    }

    public static int[] GenotypeCount(byte[] Genodata, double[] Phenodata) throws Exception {
        int[] ret = new int[6];
        if (Genodata.length != Phenodata.length) {
            throw new Exception("Sample lengths in Genptype File and Phenotype File are not equal!!");
        }
        int i = 0;
        while (i < Genodata.length) {
            if (Phenodata[i] == 2.0 && Genodata[i] >= 0) {
                byte by = Genodata[i];
                ret[by] = ret[by] + 1;
            } else if (Phenodata[i] == 1.0 && Genodata[i] >= 0) {
                int n = 3 + Genodata[i];
                ret[n] = ret[n] + 1;
            }
            ++i;
        }
        return ret;
    }

    public static int[] GenotypeCount0123(int[] Genodata, int[] Phenodata) throws Exception {
        int[] ret = new int[6];
        if (Genodata.length != Phenodata.length) {
            throw new Exception("Sample lengths in Genptype File and Phenotype File are not equal!!");
        }
        int i = 0;
        while (i < Genodata.length) {
            if (Phenodata[i] == 2 && Genodata[i] >= 1) {
                int n = Genodata[i] - 1;
                ret[n] = ret[n] + 1;
            } else if (Phenodata[i] == 1 && Genodata[i] >= 1) {
                int n = Genodata[i] - 1 + 3;
                ret[n] = ret[n] + 1;
            }
            ++i;
        }
        return ret;
    }

    public static int[] GenotypeCount(byte[] Genodata) {
        int[] ret = new int[3];
        int i = 0;
        while (i < Genodata.length) {
            if (Genodata[i] >= 0) {
                byte by = Genodata[i];
                ret[by] = ret[by] + 1;
            }
            ++i;
        }
        return ret;
    }

    public static double[][] PhenotypeByGenotype(byte[] Genodata, double[] Phendata, int PolyNum) {
        double[][] ret = new double[PolyNum][0];
        int[] count = new int[ret.length];
        int i = 0;
        while (i < Genodata.length) {
            if (Genodata[i] >= 0 && Phendata[i] >= 0.0) {
                byte by = Genodata[i];
                count[by] = count[by] + 1;
            }
            ++i;
        }
        i = 0;
        while (i < ret.length) {
            ret[i] = new double[count[i]];
            count[i] = 0;
            ++i;
        }
        i = 0;
        while (i < Genodata.length) {
            if (Genodata[i] >= 0 && Phendata[i] >= 0.0) {
                ret[Genodata[i]][count[Genodata[i]]] = Phendata[i];
                byte by = Genodata[i];
                count[by] = count[by] + 1;
            }
            ++i;
        }
        return ret;
    }

    public static double[][] PairedContDataWithThres(double[] array1, double[] array2, double thres) {
        int counter = 0;
        int i = 0;
        while (i < array1.length) {
            if (array1[i] >= thres && array2[i] >= thres) {
                ++counter;
            }
            ++i;
        }
        double[][] ret = new double[counter][2];
        counter = 0;
        int i2 = 0;
        while (i2 < array1.length) {
            if (array1[i2] >= thres && array2[i2] >= thres) {
                ret[counter][0] = array1[i2];
                ret[counter][1] = array2[i2];
                ++counter;
            }
            ++i2;
        }
        return ret;
    }

    public static int UniqPolyNum(byte[] array) {
        int counter = 0;
        Quicksort.sortByte(array);
        if (array[0] >= 0) {
            ++counter;
        }
        int i = 1;
        while (i < array.length) {
            if (array[i] != array[i - 1] && array[i] >= 0) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public static int UniqPolyNum(double[] array) {
        int counter = 0;
        Quicksort.sortDouble(array);
        if (array[0] >= 0.0) {
            ++counter;
        }
        int i = 1;
        while (i < array.length) {
            if (array[i] != array[i - 1] && array[i] >= 0.0) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public static double AFfromOR(double maf, double OR) {
        double ret = maf * OR / (1.0 - maf + maf * OR);
        return ret;
    }

    public static int[] GenoCount(int Num, double maf, double miss, MersenneTwisterFast mz) {
        int[] ret = new int[3];
        int i = 0;
        while (i < Num) {
            byte tmp = GenoTools.DecideGeno(maf * maf, 2.0 * maf * (1.0 - maf), (1.0 - maf) * (1.0 - maf), mz);
            if (miss > mz.nextDouble()) {
                byte by = tmp;
                ret[by] = ret[by] + 1;
            }
            ++i;
        }
        return ret;
    }

    public static int[] GenoCount(int Num, double maf, double miss, byte[] SerialArray, MersenneTwisterFast mz) {
        int[] ret = new int[3];
        int i = 0;
        while (i < Num) {
            byte tmp = GenoTools.DecideGeno(maf * maf, 2.0 * maf * (1.0 - maf), (1.0 - maf) * (1.0 - maf), mz);
            if (miss > mz.nextDouble()) {
                byte by = tmp;
                ret[by] = ret[by] + 1;
                SerialArray[i] = tmp;
            } else {
                SerialArray[i] = 3;
            }
            ++i;
        }
        return ret;
    }

    public static int[] GenoCountCausal(int Num, double gf1, double gf2, double gf3, double miss, MersenneTwisterFast mz) {
        int[] ret = new int[3];
        int i = 0;
        while (i < Num) {
            byte tmp = GenoTools.DecideGeno(gf1, gf2, gf3, mz);
            if (miss > mz.nextDouble()) {
                byte by = tmp;
                ret[by] = ret[by] + 1;
            }
            ++i;
        }
        return ret;
    }

    public static int[] GenoCountCausal(int Num, double gf1, double gf2, double gf3, double miss, byte[] SerialArray, MersenneTwisterFast mz) {
        int[] ret = new int[3];
        int i = 0;
        while (i < Num) {
            byte tmp = GenoTools.DecideGeno(gf1, gf2, gf3, mz);
            if (miss > mz.nextDouble()) {
                byte by = tmp;
                ret[by] = ret[by] + 1;
                SerialArray[i] = tmp;
            } else {
                SerialArray[i] = 3;
            }
            ++i;
        }
        return ret;
    }

    public static byte DecideGeno(double t1, double t2, double t3, MersenneTwisterFast mz) {
        int ret = -1;
        double tmp = t1 + t2 + t3;
        t1 = Math.abs(t1 / tmp);
        t2 = Math.abs(t2 / tmp);
        t3 = Math.abs(t3 / tmp);
        tmp = mz.nextDouble();
        if (tmp <= t1) {
            ret = 0;
        } else if (tmp <= t1 + t2) {
            ret = 1;
        } else if (tmp <= t1 + t2 + t3) {
            ret = 2;
        }
        return (byte)ret;
    }

    public static double[][] DecideGenoFreqHWE_2D(double p1, double p2) {
        double[][] ret = new double[3][3];
        ret[0][0] = p1 * p1 * p2 * p2;
        ret[0][1] = p1 * p1 * 2.0 * p2 * (1.0 - p2);
        ret[0][2] = p1 * p1 * (1.0 - p2) * (1.0 - p2);
        ret[1][0] = 2.0 * p1 * (1.0 - p1) * p2 * p2;
        ret[1][1] = 2.0 * p1 * (1.0 - p1) * 2.0 * p2 * (1.0 - p2);
        ret[1][2] = 2.0 * p1 * (1.0 - p1) * (1.0 - p2) * (1.0 - p2);
        ret[2][0] = (1.0 - p1) * (1.0 - p1) * p2 * p2;
        ret[2][1] = (1.0 - p1) * (1.0 - p1) * 2.0 * p2 * (1.0 - p2);
        ret[2][2] = (1.0 - p1) * (1.0 - p1) * (1.0 - p2) * (1.0 - p2);
        return ret;
    }

    public static int[][] DecideGenoCount_2D(int N, double[][] Freq, MersenneTwisterFast mz) {
        int[][] ret = new int[Freq.length][Freq[0].length];
        ArrayTools.InitialaizeArray2(ret);
        int i = 0;
        while (i < N) {
            int[] Posi = GenoTools.DecideGeno_2D(Freq, mz);
            int[] nArray = ret[Posi[0]];
            int n = Posi[1];
            nArray[n] = nArray[n] + 1;
            ++i;
        }
        return ret;
    }

    public static int[] DecideGeno_2D(double[][] Freq, MersenneTwisterFast mz) {
        int[] ret = new int[]{-1, -1};
        double tmp = 0.0;
        double Thres = 0.0;
        int i = 0;
        while (i < Freq.length) {
            int j = 0;
            while (j < Freq[0].length) {
                tmp += Freq[i][j];
                ++j;
            }
            ++i;
        }
        double rand = mz.nextDouble();
        int i2 = 0;
        while (i2 < Freq.length) {
            int j = 0;
            while (j < Freq[0].length) {
                Freq[i2][j] = Freq[i2][j] / tmp;
                if (rand < (Thres += Freq[i2][j])) {
                    ret[0] = i2;
                    ret[1] = j;
                    i2 = Freq.length;
                    j = Freq[0].length;
                }
                ++j;
            }
            ++i2;
        }
        return ret;
    }

    public static boolean AfCheck(int[] array, double af1, double af2) {
        boolean ret = false;
        double tmp = (double)(array[0] * 2 + array[1]) / ((double)(array[0] + array[1] + array[2]) * 2.0);
        if (tmp >= Math.min(af1, af2) & tmp <= Math.max(af1, af2)) {
            ret = true;
        }
        return ret;
    }

    public static boolean AfCheckCaCo(int[] array, double af1, double af2) {
        boolean ret = false;
        double tmp1 = (double)(array[0] * 2 + array[1]) / ((double)(array[0] + array[1] + array[2]) * 2.0);
        double tmp2 = (double)(array[3] * 2 + array[4]) / ((double)(array[3] + array[4] + array[5]) * 2.0);
        int Sum1 = array[0] + array[1] + array[2];
        int Sum2 = array[3] + array[4] + array[5];
        if (tmp1 >= Math.min(af1, af2) && tmp1 <= Math.max(af1, af2) && tmp2 >= Math.min(af1, af2) && tmp2 <= Math.max(af1, af2) && Sum1 > 0 && Sum2 > 0) {
            ret = true;
        }
        return ret;
    }

    public static boolean MonoCheck(int[] array) {
        boolean ret = false;
        int tmp = (array[0] * 2 + array[1]) * (array[2] * 2 + array[1]);
        if (tmp != 0) {
            ret = true;
        }
        return ret;
    }

    public static int[][] ChangeAdd(int[][] array) {
        int len = array.length;
        int[][] ret = new int[len][4];
        int i = 0;
        while (i < len) {
            ret[i][0] = array[i][0] * 2 + array[i][1];
            ret[i][1] = array[i][2] * 2 + array[i][1];
            ret[i][2] = array[i][3] * 2 + array[i][4];
            ret[i][3] = array[i][5] * 2 + array[i][4];
            ++i;
        }
        return ret;
    }

    public static int[] ChangeAddsingle(int[] array) {
        int[] ret = new int[]{array[0] * 2 + array[1], array[2] * 2 + array[1], array[3] * 2 + array[4], array[5] * 2 + array[4]};
        return ret;
    }

    public static int[] ChangeAddsinglesingle(int[] array) {
        int[] ret = new int[]{array[0] * 2 + array[1], array[2] * 2 + array[1]};
        return ret;
    }

    public static int[][] ChangeRec(int[][] array) {
        int len = array.length;
        int[][] ret = new int[len][4];
        int i = 0;
        while (i < len) {
            ret[i][0] = array[i][0];
            ret[i][1] = array[i][1] + array[i][2];
            ret[i][2] = array[i][3];
            ret[i][3] = array[i][4] + array[i][5];
            ++i;
        }
        return ret;
    }

    public static int[] ChangeRecsingle(int[] array) {
        int[] ret = new int[]{array[0], array[1] + array[2], array[3], array[4] + array[5]};
        return ret;
    }

    public static int[][] ChangeDom(int[][] array) {
        int len = array.length;
        int[][] ret = new int[len][4];
        int i = 0;
        while (i < len) {
            ret[i][0] = array[i][0] + array[i][1];
            ret[i][1] = array[i][2];
            ret[i][2] = array[i][3] + array[i][4];
            ret[i][3] = array[i][5];
            ++i;
        }
        return ret;
    }

    public static int[] ChangeDomsingle(int[] array) {
        int[] ret = new int[]{array[0] + array[1], array[2], array[3] + array[4], array[5]};
        return ret;
    }

    public static double AFfromFst(double p, double fst, MersenneTwisterFast mz) {
        double ret = 0.0;
        double std = Math.pow(p * (1.0 - p) * fst, 0.5);
        ret = p + std * mz.nextGaussian();
        if (ret < 0.0) {
            ret = 0.0;
        } else if (ret > 1.0) {
            ret = 1.0;
        }
        return ret;
    }

    public static double[][] CaseContAf(double popaf, double gRR, double d) {
        double[][] ret = new double[3][2];
        double tmp = popaf * popaf + 2.0 * popaf * (1.0 - popaf) * gRR + (1.0 - popaf) * (1.0 - popaf) * gRR * gRR;
        double r = d / tmp;
        ret[0][0] = popaf * popaf / tmp;
        ret[1][0] = 2.0 * popaf * (1.0 - popaf) * gRR / tmp;
        ret[2][0] = (1.0 - popaf) * (1.0 - popaf) * gRR * gRR / tmp;
        tmp = popaf * popaf * (1.0 - r) + 2.0 * popaf * (1.0 - popaf) * (1.0 - r * gRR) + (1.0 - popaf) * (1.0 - popaf) * (1.0 - r * gRR * gRR);
        ret[0][1] = popaf * popaf * (1.0 - r) / tmp;
        ret[1][1] = 2.0 * popaf * (1.0 - popaf) * (1.0 - r * gRR) / tmp;
        ret[2][1] = (1.0 - popaf) * (1.0 - popaf) * (1.0 - r * gRR * gRR) / tmp;
        return ret;
    }

    public static double[] GCwithLambda(double[] array, double lambda) throws Exception {
        boolean df = true;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df);
        if (Tools.MaxDouble(array) < 1.2) {
            int i = 0;
            while (i < array.length) {
                if (array[i] < Math.pow(10.0, -10.0)) {
                    array[i] = Math.pow(10.0, -10.0);
                }
                double tmp = chidf1.inverseCumulativeProbability(1.0 - array[i]);
                array[i] = 1.0 - chidf1.cumulativeProbability(tmp /= lambda);
                ++i;
            }
        } else {
            int i = 0;
            while (i < array.length) {
                array[i] = array[i] / lambda;
                ++i;
            }
        }
        return array;
    }
}

