/*
 * Decompiled with CFR 0.152.
 */
package PairLD;

import PairLD.LDTools;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.PlotTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class PairwiseLDsetSNP {
    public static void main(String[] args) {
        int SNPIDnum = -1;
        long Gap = 1000000L;
        double Thres = 0.3;
        double[] af = new double[2];
        byte[] byArray = new byte[9];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byte[] genotypeNum = byArray;
        String inputfile = "CEU_ind_Top";
        String inputfileList = "";
        String SNPIDfile = "SNPID.txt";
        String[] genotype = new String[]{"1 1", "1 2", "2 1", "2 2", "0 0", "0 1", "1 0", "0 2", "2 0"};
        String outfileBlock = "";
        String outfileSum = "";
        String out = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-file")) {
                inputfile = args[i + 1];
            }
            if (args[i].equals("-SNPs")) {
                SNPIDfile = args[i + 1];
            }
            if (args[i].equals("-Gap")) {
                Gap = Long.parseLong(args[i + 1]);
            }
            if (args[i].equals("-Thres")) {
                Thres = Double.parseDouble(args[i + 1]);
            }
            ++i;
        }
        outfileBlock = String.valueOf(outfileBlock) + inputfile + "_Block.txt";
        outfileSum = String.valueOf(outfileSum) + inputfile + "_LDdata.txt";
        inputfileList = String.valueOf(inputfile) + ".info";
        inputfile = String.valueOf(inputfile) + ".geno";
        BufferedWriter[] bw = new BufferedWriter[]{null, null};
        try {
            bw[1] = new BufferedWriter(new FileWriter(outfileSum));
            byte[][] GenoArray = GenoTools.GenotypeConvert(inputfile, genotype, genotypeNum);
            int numSNP = GenoArray[0].length;
            int numSample = GenoArray.length;
            String[] SNPlist = new String[numSNP];
            Long[] SNPPosi = new Long[numSNP];
            String[][] tmp = FileTools.readDatFileIOStringTABString(inputfileList);
            int i2 = 0;
            while (i2 < numSNP) {
                SNPlist[i2] = tmp[i2][0];
                SNPPosi[i2] = Long.parseLong(tmp[i2][1]);
                ++i2;
            }
            String[][] SNPID = FileTools.readDatFileIOStringTABString(SNPIDfile);
            int numSNPID = SNPID.length;
            byte[] SNP1 = new byte[numSample];
            byte[] SNP2 = new byte[numSample];
            double[] LD = new double[2];
            int[][] geno = new int[3][3];
            out = "SNP1\tPosi\tSNP2\tPosi\tAF1\tAF2\tr2\t|D'|\n";
            FileTools.out3File(bw[1], out);
            int j = 0;
            while (j < numSNPID) {
                SNPIDnum = -1;
                int k = 0;
                while (k < numSNP) {
                    if (SNPID[j][0].equals(SNPlist[k])) {
                        SNPIDnum = k;
                    }
                    ++k;
                }
                if (SNPIDnum >= 0) {
                    k = 0;
                    while (k < numSample) {
                        SNP1[k] = GenoArray[k][SNPIDnum];
                        ++k;
                    }
                    int i3 = 0;
                    while (i3 < numSNP) {
                        if (SNPPosi[SNPIDnum] - Gap <= SNPPosi[i3] && SNPPosi[SNPIDnum] + Gap >= SNPPosi[i3]) {
                            int k2 = 0;
                            while (k2 < numSample) {
                                SNP2[k2] = GenoArray[k2][i3];
                                ++k2;
                            }
                            geno = LDTools.make3x3table(SNP1, SNP2);
                            double[] hf = LDTools.pairwiseEM(geno);
                            af[0] = hf[0] + hf[1];
                            af[1] = hf[0] + hf[2];
                            double r2 = LDTools.Rsq(hf);
                            double D = LDTools.D(hf);
                            double Dprime = LDTools.Dprime(hf);
                            LD[0] = r2;
                            LD[1] = Math.abs(Dprime);
                            if (r2 > Thres) {
                                out = String.valueOf(SNPlist[SNPIDnum]) + "\t" + SNPPosi[SNPIDnum] + "\t" + SNPlist[i3] + "\t" + SNPPosi[i3] + "\t" + PlotTools.DecimalHU(af[0], 4) + "\t" + PlotTools.DecimalHU(af[1], 4) + "\t" + PlotTools.DecimalHU(r2, 4) + "\t" + PlotTools.DecimalHU(Dprime, 4) + "\n";
                                FileTools.out3File(bw[1], out);
                            }
                        }
                        ++i3;
                    }
                }
                ++j;
            }
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

