/*
 * Decompiled with CFR 0.152.
 */
package PairLD;

import PairLD.LDTools;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.Quicksort;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class LDpruning2pop {
    public static void main(String[] args) throws Exception {
        String Genfile1 = "JPT+CHB_cut.gen";
        String Genfile2 = "CEU_cut.gen";
        String Infofile1 = "JPT+CHB_cut.info";
        String Infofile2 = "CEU_cut.info";
        String out = "";
        String prefix = "JC_comm_noAssoc_posi";
        int kiz = 300;
        double Thres = 0.05;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-Genfile1")) {
                Genfile1 = args[i + 1];
            }
            if (args[i].equals("-Genfile2")) {
                Genfile2 = args[i + 1];
            }
            if (args[i].equals("-Infofile1")) {
                Infofile1 = args[i + 1];
            }
            if (args[i].equals("-Infofile2")) {
                Infofile2 = args[i + 1];
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            if (args[i].equals("-kiz")) {
                kiz = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Thres")) {
                Thres = Double.parseDouble(args[i + 1]);
            }
            ++i;
        }
        prefix = String.valueOf(prefix) + "_kiz" + kiz + "_LD" + Thres + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(prefix));
            int[][] Gen1 = FileTools.readDatFileIOStringTABint(Genfile1);
            int[][] Gen2 = FileTools.readDatFileIOStringTABint(Genfile2);
            String[][] Info1 = FileTools.readDatFileIOStringTABString(Infofile1);
            String[][] Info2 = FileTools.readDatFileIOStringTABString(Infofile2);
            int numSNP = Info1.length;
            int numSample1 = Gen1.length;
            int numSample2 = Gen2.length;
            int[] SNP1 = new int[numSample1];
            int[] SNP2 = new int[numSample1];
            int[] tmpSNP1 = new int[numSample1];
            int[] tmpSNP2 = new int[numSample1];
            if (Info1.length != Info2.length) {
                throw new Exception("No. SNPs differed between Infofiles!");
            }
            int[] flagLDprune = new int[numSNP];
            double[][] order1 = new double[numSNP][2];
            double[][] order2 = new double[numSNP][2];
            int[][] geno3x3_1 = new int[3][3];
            int[][] geno3x3_2 = new int[3][3];
            double[] hf1 = new double[2];
            double[] hf2 = new double[2];
            int i2 = 0;
            while (i2 < numSNP) {
                flagLDprune[i2] = 0;
                order1[i2][0] = i2;
                order1[i2][1] = Double.parseDouble(Info1[i2][1]);
                order2[i2][0] = i2;
                order2[i2][1] = Double.parseDouble(Info2[i2][1]);
                ++i2;
            }
            if (Quicksort.SortCheck(ArrayTools.ExtractTableCol(order1, 1))) {
                System.out.println("1 ... sorted.");
            } else {
                Quicksort.sortDouble2_x(order1, 1);
            }
            if (Quicksort.SortCheck(ArrayTools.ExtractTableCol(order2, 1))) {
                System.out.println("2 ... sorted.");
            } else {
                Quicksort.sortDouble2_x(order2, 1);
            }
            i2 = 0;
            while (i2 < numSNP) {
                double r2_2;
                double r2_1;
                int j;
                int posi1 = (int)order1[i2][0];
                int posi2 = (int)order2[i2][0];
                int posi1min = Math.max(posi1 - kiz, 0);
                int posi1max = Math.min(posi1 + kiz, numSNP - 1);
                int posi2min = Math.max(posi2 - kiz, 0);
                int posi2max = Math.min(posi2 + kiz, numSNP - 1);
                if (flagLDprune[posi1] != 1) {
                    flagLDprune[posi1] = 2;
                    SNP1 = LDpruning2pop.ExtractSNPfromGen(Gen1, posi1);
                    SNP2 = LDpruning2pop.ExtractSNPfromGen(Gen2, posi1);
                    j = posi1min;
                    while (j <= posi1max) {
                        if (flagLDprune[j] == 0) {
                            tmpSNP1 = LDpruning2pop.ExtractSNPfromGen(Gen1, j);
                            tmpSNP2 = LDpruning2pop.ExtractSNPfromGen(Gen2, j);
                            geno3x3_1 = LDTools.make3x3table(SNP1, tmpSNP1);
                            geno3x3_2 = LDTools.make3x3table(SNP2, tmpSNP2);
                            hf1 = LDTools.pairwiseEM(geno3x3_1);
                            hf2 = LDTools.pairwiseEM(geno3x3_2);
                            r2_1 = LDTools.Rsq(hf1);
                            r2_2 = LDTools.Rsq(hf2);
                            if (r2_1 > Thres && r2_2 > Thres) {
                                flagLDprune[j] = 1;
                            }
                        }
                        ++j;
                    }
                }
                if (flagLDprune[posi2] != 1) {
                    flagLDprune[posi2] = 2;
                    SNP1 = LDpruning2pop.ExtractSNPfromGen(Gen1, posi2);
                    SNP2 = LDpruning2pop.ExtractSNPfromGen(Gen2, posi2);
                    j = posi2min;
                    while (j <= posi2max) {
                        if (flagLDprune[j] == 0) {
                            tmpSNP1 = LDpruning2pop.ExtractSNPfromGen(Gen1, j);
                            tmpSNP2 = LDpruning2pop.ExtractSNPfromGen(Gen2, j);
                            geno3x3_1 = LDTools.make3x3table(SNP1, tmpSNP1);
                            geno3x3_2 = LDTools.make3x3table(SNP2, tmpSNP2);
                            hf1 = LDTools.pairwiseEM(geno3x3_1);
                            hf2 = LDTools.pairwiseEM(geno3x3_2);
                            r2_1 = LDTools.Rsq(hf1);
                            r2_2 = LDTools.Rsq(hf2);
                            if (r2_1 > Thres && r2_2 > Thres) {
                                flagLDprune[j] = 1;
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < numSNP) {
                out = String.valueOf(flagLDprune[i2] - 1) + "\n";
                FileTools.out3File(bw[0], out);
                ++i2;
            }
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static int[] ExtractSNPfromGen(int[][] Gen, int posi) {
        int numSample = Gen.length;
        int[] ret = new int[numSample];
        int i = 0;
        while (i < numSample) {
            ret[i] = Gen[i][posi];
            ++i;
        }
        return ret;
    }
}

