/*
 * Decompiled with CFR 0.152.
 */
package Mains_GC;

import Tool.FMCTools;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.PlotTools;
import Tool.StatTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class FisherGC {
    public static void main(String[] args) {
        String inputfile = "Sample.txt";
        String outputfile = "FisherGC";
        String out = "";
        int maxN = 5000;
        int thresnum = 0;
        double thres = 5.0E-5;
        double limitP = Math.pow(10.0, -15.0);
        boolean thresAdd = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-infile")) {
                inputfile = args[i + 1];
            }
            if (args[i].equals("-out")) {
                outputfile = args[i + 1];
            }
            if (args[i].equals("-thres")) {
                thres = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-AlphaNum")) {
                thresAdd = true;
                thresnum = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        double[] LogFact = new double[maxN * 2 + 1];
        int i2 = 0;
        while (i2 < maxN * 2 + 1) {
            LogFact[i2] = Tools.factlog(i2);
            ++i2;
        }
        double[] alphaPtmp = new double[]{0.001, 0.01, 0.05};
        double[] alphaPthres = new double[thresnum];
        int i3 = 0;
        while (i3 < args.length) {
            if (args[i3].equals("-Alpha") && thresAdd) {
                int j = 0;
                while (j < thresnum) {
                    alphaPthres[j] = Double.parseDouble(args[i3 + j + 1]);
                    ++j;
                }
            }
            ++i3;
        }
        double[] alphaP = new double[alphaPtmp.length + alphaPthres.length];
        alphaP = Tools.MixArray2(alphaPtmp, alphaPthres);
        Tools.NormalSort1array(alphaP);
        String outfileP = String.valueOf(outputfile) + "_P(beforeGC).txt";
        String outfileLambda = String.valueOf(outputfile) + "_lambda.txt";
        String outfileGCP = String.valueOf(outputfile) + "_P(afterGC).txt";
        String outfileTmpFish = String.valueOf(outputfile) + "_tmpFish.txt";
        String outfileFish = String.valueOf(outputfile) + "_Fish.txt";
        BufferedWriter[] bw = new BufferedWriter[]{null, null, null, null, null};
        boolean df = true;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df);
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileP));
            bw[1] = new BufferedWriter(new FileWriter(outfileLambda));
            bw[2] = new BufferedWriter(new FileWriter(outfileGCP));
            bw[3] = new BufferedWriter(new FileWriter(outfileTmpFish));
            bw[4] = new BufferedWriter(new FileWriter(outfileFish));
            short[][] data = FileTools.readDatFileIOStringTABshort(inputfile);
            int len = data.length;
            int[] array = new int[6];
            double[] FishP = new double[len];
            double[] FishGCP = new double[len];
            out = "Fisher's exact test p-value (before GC)\n";
            FileTools.out3File(bw[0], out);
            out = "Fisher's exact test p-value (after GC)\n";
            FileTools.out3File(bw[2], out);
            int i4 = 0;
            while (i4 < len) {
                int j = 0;
                while (j < 6) {
                    array[j] = data[i4][j];
                    ++j;
                }
                int[] arrayAdd = GenoTools.ChangeAddsingle(array);
                FishP[i4] = StatTools.FisherCount2x2(arrayAdd, LogFact);
                out = String.valueOf(FishP[i4]) + "\n";
                FileTools.out3File(bw[0], out);
                ++i4;
            }
            bw[0].close();
            double MedianP = Tools.Median(FishP);
            out = "Observed median p-value of Fisher's exact test:\t" + PlotTools.DecimalHU(MedianP, 5) + "\n";
            FileTools.out3File(bw[1], out);
            System.gc();
            int[][] MarginalArray = FMCTools.ShrinkArray(data);
            FMCTools.OutputTheoDistOnlyFish(MarginalArray, LogFact, thres, bw[3]);
            bw[3].close();
            System.gc();
            double[] AlphaFMC = FMCTools.MakeSumFileAlpha(outfileTmpFish, bw[4], alphaP);
            double MedianFMCP = AlphaFMC[AlphaFMC.length - 1];
            bw[4].close();
            FileTools.FileDelete(outfileTmpFish);
            FileTools.FileDelete(outfileFish);
            System.gc();
            double MedianC = chidf1.inverseCumulativeProbability(1.0 - Math.max(MedianP, limitP));
            double MedianFMCC = chidf1.inverseCumulativeProbability(1.0 - Math.max(MedianFMCP, limitP));
            double lambda = MedianC / MedianFMCC;
            out = "Estimated median p-value of Fihser's exact test:\t" + PlotTools.DecimalHU(MedianFMCP, 5) + "\nlambda_GC:\t" + PlotTools.DecimalHU(lambda, 5) + "\n";
            FileTools.out3File(bw[1], out);
            int i5 = 0;
            while (i5 < len) {
                FishGCP[i5] = 1.0 - chidf1.cumulativeProbability(chidf1.inverseCumulativeProbability(1.0 - Math.max(FishP[i5], limitP)) / lambda);
                out = String.valueOf(FishGCP[i5]) + "\n";
                FileTools.out3File(bw[2], out);
                ++i5;
            }
            bw[2].close();
            double[] AlphaP = Tools.AlphaCheckP(FishP, alphaP);
            double[] AlphaGCP = Tools.AlphaCheckP(FishGCP, alphaP);
            out = "\nType I error\nalpha\tbefore GC\tExpected\tAfter GC\n";
            int i6 = 0;
            while (i6 < alphaP.length) {
                out = String.valueOf(out) + PlotTools.DecimalHU(alphaP[i6], 5) + "\t" + PlotTools.DecimalHU(AlphaP[i6], 3) + "\t" + PlotTools.DecimalHU(AlphaFMC[i6], 3) + "\t" + PlotTools.DecimalHU(AlphaGCP[i6], 3) + "\n";
                ++i6;
            }
            FileTools.out3File(bw[1], out);
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

