/*
 * Decompiled with CFR 0.152.
 */
package Likelihood;

import Tool.PlotTools;

public class TableLike3x3x2 {
    public static void main(String[] args) {
        int[][] data2x3 = new int[][]{{12, 68, 79}, {12, 49, 20}};
        int[][][] data3x3 = new int[][][]{new int[][]{{12, 68, 79}, {12, 49, 20}, {5, 6, 1}}, new int[][]{{24, 228, 464}, {23, 123, 61}, {5, 11, 2}}};
        double[][][] data3x3d = new double[][][]{new double[][]{{12.0, 68.0, 79.0}, {12.0, 49.0, 20.0}, {5.0, 6.0, 1.0}}, new double[][]{{24.0, 228.0, 464.0}, {23.0, 123.0, 61.0}, {5.0, 11.0, 2.0}}};
        PlotTools.Array(TableLike3x3x2.CalcLikeH0H13x3(data3x3));
        PlotTools.Array(TableLike3x3x2.CalcLikeH0H13x3(data3x3d));
    }

    public static int[][] ChangeGenotoAllele2x3(int[][] array) {
        int[][] ret = new int[2][2];
        ret[0][0] = array[0][0] * 2 + array[0][1];
        ret[0][1] = array[0][2] * 2 + array[0][1];
        ret[1][0] = array[1][0] * 2 + array[1][1];
        ret[1][1] = array[1][2] * 2 + array[1][1];
        return ret;
    }

    public static int[][][] ChangeGenotoAllele3x3(int[][][] array) {
        int[][][] ret = new int[2][2][2];
        ret[0][0][0] = array[0][0][0] * 2 + array[0][0][1] + array[0][1][0] + array[0][1][1] / 2;
        ret[0][0][1] = array[0][0][2] * 2 + array[0][0][1] + array[0][1][2] + array[0][1][1] / 2;
        ret[0][1][0] = array[0][2][0] * 2 + array[0][2][1] + array[0][1][0] + array[0][1][1] / 2;
        ret[0][1][1] = array[0][2][2] * 2 + array[0][2][1] + array[0][1][2] + array[0][1][1] / 2;
        return ret;
    }

    public static double[] CalcLikeH0H13x3(int[][][] array) {
        double[] ret = new double[4];
        int[][] TotalArray = TableLike3x3x2.CombineTable3x3(array);
        int[][] CaseArray = TableLike3x3x2.ExtractTable3x3(array, 0);
        int[][] ContArray = TableLike3x3x2.ExtractTable3x3(array, 1);
        double[] TotalP = TableLike3x3x2.GetP1P2(TotalArray);
        double[] CaseP = TableLike3x3x2.GetP1P2(CaseArray);
        double[] ContP = TableLike3x3x2.GetP1P2(ContArray);
        double LikeH00 = TableLike3x3x2.Like3x3(CaseArray, TotalP[0], TotalP[1]) + TableLike3x3x2.Like3x3(ContArray, TotalP[0], TotalP[1]);
        double LikeH10 = TableLike3x3x2.Like3x3(CaseArray, CaseP[0], TotalP[1]) + TableLike3x3x2.Like3x3(ContArray, ContP[0], TotalP[1]);
        double LikeH01 = TableLike3x3x2.Like3x3(CaseArray, TotalP[0], CaseP[1]) + TableLike3x3x2.Like3x3(ContArray, TotalP[0], ContP[1]);
        double LikeH11 = TableLike3x3x2.Like3x3(CaseArray, CaseP[0], CaseP[1]) + TableLike3x3x2.Like3x3(ContArray, ContP[0], ContP[1]);
        ret[0] = LikeH00;
        ret[1] = LikeH10;
        ret[2] = LikeH01;
        ret[3] = LikeH11;
        return ret;
    }

    public static double[] CalcLikeH0H13x3(double[][][] array) {
        double[] ret = new double[4];
        double[][] TotalArray = TableLike3x3x2.CombineTable3x3(array);
        double[][] CaseArray = TableLike3x3x2.ExtractTable3x3(array, 0);
        double[][] ContArray = TableLike3x3x2.ExtractTable3x3(array, 1);
        double[] TotalP = TableLike3x3x2.GetP1P2(TotalArray);
        double[] CaseP = TableLike3x3x2.GetP1P2(CaseArray);
        double[] ContP = TableLike3x3x2.GetP1P2(ContArray);
        double LikeH00 = TableLike3x3x2.Like3x3(CaseArray, TotalP[0], TotalP[1]) + TableLike3x3x2.Like3x3(ContArray, TotalP[0], TotalP[1]);
        double LikeH10 = TableLike3x3x2.Like3x3(CaseArray, CaseP[0], TotalP[1]) + TableLike3x3x2.Like3x3(ContArray, ContP[0], TotalP[1]);
        double LikeH01 = TableLike3x3x2.Like3x3(CaseArray, TotalP[0], CaseP[1]) + TableLike3x3x2.Like3x3(ContArray, TotalP[0], ContP[1]);
        double LikeH11 = TableLike3x3x2.Like3x3(CaseArray, CaseP[0], CaseP[1]) + TableLike3x3x2.Like3x3(ContArray, ContP[0], ContP[1]);
        ret[0] = LikeH00;
        ret[1] = LikeH10;
        ret[2] = LikeH01;
        ret[3] = LikeH11;
        return ret;
    }

    public static double Like3x3(int[][] array, double p1, double p2) {
        double L = 0.0;
        double[][] p = new double[3][3];
        p[0][0] = p1 * p1 * p2 * p2;
        p[1][0] = 2.0 * p1 * (1.0 - p1) * p2 * p2;
        p[2][0] = (1.0 - p1) * (1.0 - p1) * p2 * p2;
        p[0][1] = p1 * p1 * 2.0 * p2 * (1.0 - p2);
        p[1][1] = 2.0 * p1 * (1.0 - p1) * 2.0 * p2 * (1.0 - p2);
        p[2][1] = (1.0 - p1) * (1.0 - p1) * 2.0 * p2 * (1.0 - p2);
        p[0][2] = p1 * p1 * (1.0 - p2) * (1.0 - p2);
        p[1][2] = 2.0 * p1 * (1.0 - p1) * (1.0 - p2) * (1.0 - p2);
        p[2][2] = (1.0 - p1) * (1.0 - p1) * (1.0 - p2) * (1.0 - p2);
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                L += (double)array[i][j] * Math.log(p[i][j]);
                ++j;
            }
            ++i;
        }
        return L;
    }

    public static double Like3x3(double[][] array, double p1, double p2) {
        double L = 0.0;
        double[][] p = new double[3][3];
        p[0][0] = p1 * p1 * p2 * p2;
        p[1][0] = 2.0 * p1 * (1.0 - p1) * p2 * p2;
        p[2][0] = (1.0 - p1) * (1.0 - p1) * p2 * p2;
        p[0][1] = p1 * p1 * 2.0 * p2 * (1.0 - p2);
        p[1][1] = 2.0 * p1 * (1.0 - p1) * 2.0 * p2 * (1.0 - p2);
        p[2][1] = (1.0 - p1) * (1.0 - p1) * 2.0 * p2 * (1.0 - p2);
        p[0][2] = p1 * p1 * (1.0 - p2) * (1.0 - p2);
        p[1][2] = 2.0 * p1 * (1.0 - p1) * (1.0 - p2) * (1.0 - p2);
        p[2][2] = (1.0 - p1) * (1.0 - p1) * (1.0 - p2) * (1.0 - p2);
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                L += array[i][j] * Math.log(p[i][j]);
                ++j;
            }
            ++i;
        }
        return L;
    }

    public static double[] GetP1P2(int[][] array) {
        double[] p = new double[2];
        int N = 0;
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                N += array[i][j];
                ++j;
            }
            ++i;
        }
        p[0] = (double)((array[0][0] + array[0][1] + array[0][2]) * 2 + array[1][0] + array[1][1] + array[1][2]) / (double)(N * 2);
        p[1] = (double)((array[0][0] + array[1][0] + array[2][0]) * 2 + array[0][1] + array[1][1] + array[2][1]) / (double)(N * 2);
        return p;
    }

    public static double[] GetP1P2(double[][] array) {
        double[] p = new double[2];
        double N = 0.0;
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                N += array[i][j];
                ++j;
            }
            ++i;
        }
        p[0] = ((array[0][0] + array[0][1] + array[0][2]) * 2.0 + array[1][0] + array[1][1] + array[1][2]) / (N * 2.0);
        p[1] = ((array[0][0] + array[1][0] + array[2][0]) * 2.0 + array[0][1] + array[1][1] + array[2][1]) / (N * 2.0);
        return p;
    }

    public static int[][] CombineTable3x3(int[][][] array) {
        int[][] ret = new int[3][3];
        int j = 0;
        while (j < array[0].length) {
            int k = 0;
            while (k < array[0][0].length) {
                ret[j][k] = array[0][j][k] + array[1][j][k];
                ++k;
            }
            ++j;
        }
        return ret;
    }

    public static double[][] CombineTable3x3(double[][][] array) {
        double[][] ret = new double[3][3];
        int j = 0;
        while (j < array[0].length) {
            int k = 0;
            while (k < array[0][0].length) {
                ret[j][k] = array[0][j][k] + array[1][j][k];
                ++k;
            }
            ++j;
        }
        return ret;
    }

    public static int[][] ExtractTable3x3(int[][][] array, int flag) {
        int[][] ret = new int[3][3];
        int j = 0;
        while (j < array[0].length) {
            int k = 0;
            while (k < array[0][0].length) {
                ret[j][k] = array[flag][j][k];
                ++k;
            }
            ++j;
        }
        return ret;
    }

    public static double[][] ExtractTable3x3(double[][][] array, int flag) {
        double[][] ret = new double[3][3];
        int j = 0;
        while (j < array[0].length) {
            int k = 0;
            while (k < array[0][0].length) {
                ret[j][k] = array[flag][j][k];
                ++k;
            }
            ++j;
        }
        return ret;
    }
}

