/*
 * Decompiled with CFR 0.152.
 */
package Likelihood;

import Likelihood.TableManage;
import Tool.PlotTools;
import Tool.RankTools;
import Tool.Tools;

public class TableLike2xkx2 {
    public static void main(String[] args) {
        double CILdiff_95 = 1.9207295;
        double[][][] data2xkx2_5p = new double[][][]{new double[][]{{27.08272642, 130.1738494}, {634.9115537, 0.0}, {104.0, 0.0}, {217.0377228, 158.2710889}, {121.0, 0.0}, {206.0, 0.0}, {105.016475259709, 74.1638670664764}, {341.790494116843, 114.531877501459}}, new double[][]{{7.546484514, 18.45351549}, {82.0, 0.0}, {51.0, 0.0}, {57.09070075, 27.90929925}, {41.0, 0.0}, {40.0, 0.0}, {30.9979598133739, 0.00204018662613293}, {163.843699834546, 24.1563001654539}}};
        double[][][] data2xkx2_2p = new double[][][]{new double[][]{{27.08272642, 130.1738494}, {18.52359701, 45.56621076}, {634.9115537, 0.0}, {34.41072823, 18.62603124}, {52.0341846, 0.0}, {40.00576047, 8.05737149}, {104.0, 0.0}, {217.0377228, 158.2710889}, {31.1433791, 18.89394279}, {25.6896249, 24.35814833}, {81.0, 0.0}, {31.03523149, 10.98636761}, {121.0, 0.0}, {206.0, 0.0}, {34.4586936508572, 28.5976563027381}, {98.5057699330553, 33.610016043107}}, new double[][]{{7.546484514, 18.45351549}, {3.997959813, 0.002040187}, {82.0, 0.0}, {21.0, 0.0}, {14.0, 0.0}, {14.55436475, 6.445635247}, {51.0, 0.0}, {57.09070075, 27.90929925}, {5.087756443, 5.912243557}, {30.0, 0.0}, {29.0, 0.0}, {16.0, 0.0}, {41.0, 0.0}, {40.0, 0.0}, {13.0, 0.0}, {48.2015786380121, 11.7984213619879}}};
        double[][][] data2xkx2_5p2 = new double[][][]{new double[][]{{27.08272642, 130.1738494}, {634.9115537, 0.0}, {104.0, 0.0}, {217.0377228, 158.2710889}, {121.0, 0.0}, {206.0, 0.0}, {103.008461, 78.18896454}, {312.12799, 142.2130403}}, new double[][]{{7.546484514, 18.45351549}, {82.0, 0.0}, {51.0, 0.0}, {57.09070075, 27.90929925}, {41.0, 0.0}, {40.0, 0.0}, {25.47937782, 5.520622182}, {145.8984718, 42.10152821}}};
        double[][][] data2xkx2_2p2 = new double[][][]{new double[][]{{27.08272642, 130.1738494}, {18.52359701, 45.56621076}, {634.9115537, 0.0}, {34.41072823, 18.62603124}, {52.0341846, 0.0}, {40.00576047, 8.05737149}, {104.0, 0.0}, {217.0377228, 158.2710889}, {31.1433791, 18.89394279}, {25.6896249, 24.35814833}, {81.0, 0.0}, {31.03523149, 10.98636761}, {121.0, 0.0}, {206.0, 0.0}, {27.4054180004525, 37.6683110359593}, {78.410778717327, 51.6907449816181}}, new double[][]{{7.546484514, 18.45351549}, {3.997959813, 0.002040187}, {82.0, 0.0}, {21.0, 0.0}, {14.0, 0.0}, {14.55436475, 6.445635247}, {51.0, 0.0}, {57.09070075, 27.90929925}, {5.087756443, 5.912243557}, {30.0, 0.0}, {29.0, 0.0}, {16.0, 0.0}, {41.0, 0.0}, {40.0, 0.0}, {13.0, 0.0}, {46.6715686302938, 13.3284313697062}}};
        double[][][] Haplo1121_3 = new double[][][]{new double[][]{{27.0827264170932, 130.17384942334}, {18.52359701, 45.56621076}, {28.0152673797646, 0.0346855932846909}, {634.911553703873, 0.0}, {34.4107282326649, 18.6260312409628}, {52.0341846008241, 0.0}, {40.0057604697264, 8.05737148991143}, {104.0, 0.0}, {2.94446228574349, 25.1050414692787}, {31.1433790996531, 18.8939427850599}, {25.6896248950776, 24.3581483319385}, {24.4655369572478, 8.55128212297152}, {80.9999999999999, 0.0}, {31.0352314866656, 10.9863676104797}, {11.3564613433586, 5.65464490707617}, {9.54191672630453, 1.46095454228641}, {26.5142313651137, 3.49261483345944}, {121.0, 0.0}, {206.0, 0.0}, {5.88542141418832, 15.1441966387204}, {217.037722819292, 158.271088869691}}, new double[][]{{7.54648451394492, 18.4535154860551}, {3.99795981337386, 0.00204018662613293}, {8.44499113363579, 7.55500886636419}, {82.0, 0.0}, {21.0, 0.0}, {14.0, 0.0}, {14.5543647532816, 6.44563524671836}, {51.0, 0.0}, {2.0, 0.0}, {5.08775644325231, 5.91224355674772}, {30.0, 0.0}, {2.31568377343151, 1.68431622656849}, {29.0, 0.0}, {16.0, 0.0}, {7.44090373094479, 2.55909626905518}, {20.0, 0.0}, {6.99999999999998, 0.0}, {41.0, 0.0}, {40.0, 0.0}, {3.0, 0.0}, {57.090700746933, 27.9092992530672}}};
        double[][][] Haplo1221_7 = new double[][][]{new double[][]{{157.256575840434, 0.0}, {64.0898077717655, 0.0}, {16.0538246392222, 11.9961283338271}, {397.859148249842, 237.052405454028}, {53.0367594736277, 0.0}, {43.7152304465498, 8.3189541542743}, {36.5790325292204, 11.4840994304174}, {104.0, 0.0}, {28.0495037550221, 0.0}, {50.0373218847132, 0.0}, {50.0477732270161, 0.0}, {33.0168190802192, 0.0}, {80.9999999999999, 0.0}, {42.0215990971454, 0.0}, {17.0111062504348, 0.0}, {11.0028712685909, 0.0}, {30.0068461985731, 0.0}, {121.0, 0.0}, {206.0, 0.0}, {21.0296180529087, 0.0}, {375.308811688983, 0.0}}, new double[][]{{26.0, 0.0}, {2.2293881997378, 1.7706118002622}, {16.0, 0.0}, {65.8852991415335, 16.1147008584664}, {19.6174171029894, 1.3825828970106}, {7.9343278600325, 6.0656721399676}, {17.8991668839378, 3.1008331160622}, {51.0, 0.0}, {2.0, 0.0}, {11.0, 0.0}, {27.8932071298167, 2.1067928701833}, {4.0, 0.0}, {29.0, 0.0}, {16.0, 0.0}, {10.0, 0.0}, {20.0, 0.0}, {7.0, 0.0}, {41.0, 0.0}, {40.0, 0.0}, {2.0000450188709, 0.9999549811291}, {85.0, 0.0}}};
        double[][][] Haplo1222_8 = new double[][][]{new double[][]{{157.256575840434, 0.0}, {64.0898077717655, 0.0}, {27.9182625928305, 0.1316903802189}, {297.942918044383, 336.96863565949}, {53.0367594736277, 0.0}, {23.5755080046397, 28.4586765961844}, {34.3355318370574, 13.7276001225805}, {104.0, 0.0}, {28.0495037550221, 0.0}, {50.0373218847132, 0.0}, {50.0477732270161, 0.0}, {33.0168190802192, 0.0}, {80.9999999999999, 0.0}, {42.0215990971454, 0.0}, {17.0111062504348, 0.0}, {11.0028712685909, 0.0}, {30.0068461985731, 0.0}, {121.0, 0.0}, {206.0, 0.0}, {21.0295069946558, 1.110582529E-4}, {375.308811688983, 0.0}}, new double[][]{{26.0, 0.0}, {4.0, 0.0}, {16.0, 0.0}, {24.6481301794228, 57.3518698205773}, {19.3839439689775, 1.6160560310225}, {6.943698588057, 7.0563014119429}, {20.9979613247798, 0.0020386752202}, {51.0, 0.0}, {2.0, 0.0}, {11.0, 0.0}, {30.0, 0.0}, {4.0, 0.0}, {29.0, 0.0}, {14.6568063671671, 1.3431936328329}, {10.0, 0.0}, {20.0, 0.0}, {7.0, 0.0}, {41.0, 0.0}, {40.0, 0.0}, {2.9999549811291, 4.50188709E-5}, {85.0, 0.0}}};
        double[][][] Haplo1122_4 = new double[][][]{new double[][]{{130.278052926403, 26.9785229140308}, {48.1246944067068, 15.9651133650586}, {18.2524617459856, 9.7974912270637}, {622.090504061666, 12.8210496422071}, {53.0367594736277, 0.0}, {49.9440274620736, 2.0901571387505}, {40.8456432734475, 7.2174886861902}, {101.422905697347, 2.5770943026531}, {26.3122791603508, 1.7372245946714}, {26.9711717015225, 23.0661501831907}, {25.1568542971856, 24.8909189298308}, {8.5512821229715, 24.4655369572478}, {80.9999999999999, 0.0}, {27.3588394900892, 14.6627596070562}, {5.8950564474581, 11.1160498029767}, {11.0028712685909, 0.0}, {5.673840743024, 24.3330054555491}, {116.881798164668, 4.1182018353322}, {206.0, 0.0}, {15.864481030047, 5.1651370228617}, {208.482838604823, 166.82597308416}}, new double[][]{{19.1234541523297, 6.8765458476703}, {4.0, 0.0}, {9.2996000807521, 6.7003999192479}, {82.0, 0.0}, {21.0, 0.0}, {14.0, 0.0}, {12.0523067592153, 8.9476932407847}, {51.0, 0.0}, {2.0, 0.0}, {11.0, 0.0}, {5.5493894067502, 24.4506105932498}, {4.0, 0.0}, {29.0, 0.0}, {14.3586677160618, 1.6413322839382}, {9.996321281843, 0.0036787181571}, {20.0, 0.0}, {4.598792784E-4, 6.9995401207216}, {41.0, 0.0}, {40.0, 0.0}, {3.0, 0.0}, {45.8642802043731, 39.1357197956269}}};
        double[][][] Haplo1212_6 = new double[][][]{new double[][]{{157.256575840434, 0.0}, {64.0898077717655, 0.0}, {25.7118879409036, 2.3380650321456}, {634.911553703873, 0.0}, {53.0367594736277, 0.0}, {50.7418083170344, 1.2923762837897}, {48.0631319596378, 0.0}, {85.3676574771843, 18.6323425228156}, {28.0495037550221, 0.0}, {50.0373218847132, 0.0}, {50.0477732270161, 0.0}, {33.0168190802192, 0.0}, {80.9819499788521, 0.018050021148}, {42.0215990971454, 0.0}, {17.0111062504348, 0.0}, {11.0028712685909, 0.0}, {30.0068461985731, 0.0}, {121.0, 0.0}, {16.1198335571944, 189.880166442805}, {21.0296180529087, 0.0}, {375.308811688983, 0.0}}, new double[][]{{26.0, 0.0}, {4.0, 0.0}, {16.0, 0.0}, {82.0, 0.0}, {21.0, 0.0}, {14.0, 0.0}, {21.0, 0.0}, {37.9387011816097, 13.0612988183903}, {2.0, 0.0}, {11.0, 0.0}, {30.0, 0.0}, {3.6899995909542, 0.3100004090458}, {29.0, 0.0}, {15.9997406966755, 2.593033245E-4}, {8.6317694033539, 1.3682305966461}, {20.0, 0.0}, {7.0, 0.0}, {41.0, 0.0}, {8.4070942976832, 31.5929057023168}, {3.0, 0.0}, {85.0, 0.0}}};
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiOR(Haplo1121_3, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiOR(Haplo1221_7, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiOR(Haplo1222_8, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiOR(Haplo1122_4, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiOR(Haplo1212_6, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiORwithCI(Haplo1121_3, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0, 100, 2.0, CILdiff_95));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiORwithCI(Haplo1221_7, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0, 100, 2.0, CILdiff_95));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiORwithCI(Haplo1222_8, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0, 100, 2.0, CILdiff_95));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiORwithCI(Haplo1122_4, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0, 100, 2.0, CILdiff_95));
        PlotTools.Array(TableLike2xkx2.CalcFreqMultiORwithCI(Haplo1212_6, 100, 100, 3.0, 1.01, 1000, Math.pow(10.0, -10.0), -1.0, 100, 2.0, CILdiff_95));
    }

    public static double TestORwithKW(double[][][] array) {
        double[][] TotalArray = TableManage.CombineTable(array);
        double[][] CaseArray = TableManage.ExtractTable(array, 0);
        double[][] ContArray = TableManage.ExtractTable(array, 1);
        double[][] OR = TableLike2xkx2.CalcBaseORforKW(CaseArray, ContArray, 1);
        int[][] IntArray = TableManage.FloorTable(TotalArray);
        double[][] ArrayKW = TableManage.MergeORCount(OR, IntArray);
        double ret = RankTools.KruskalWallis(ArrayKW);
        return ret;
    }

    public static double[] DetectLdiffCI(double[] OR_CIseq, double[] L_CIseq, double baseL, double CILdiff) {
        double[] ret = new double[4];
        int len = OR_CIseq.length;
        ret[0] = OR_CIseq[0];
        ret[1] = OR_CIseq[1];
        ret[2] = OR_CIseq[len - 2];
        ret[3] = OR_CIseq[len - 1];
        int i = 0;
        while (i < len - 1) {
            if (baseL - L_CIseq[i] >= CILdiff && baseL - L_CIseq[i + 1] <= CILdiff) {
                ret[0] = OR_CIseq[i];
                ret[1] = OR_CIseq[i + 1];
            }
            if (baseL - L_CIseq[i] <= CILdiff && baseL - L_CIseq[i + 1] >= CILdiff) {
                ret[2] = OR_CIseq[i];
                ret[3] = OR_CIseq[i + 1];
            }
            ++i;
        }
        return ret;
    }

    public static double[] CalcFreqMultiORwithCI(double[][][] array, int k, int ORk, double ThresOR, double kizOR, int rep, double ThresL, double ThresLdiff, int OR_CIk, double ThresOR_CI, double CILdiff_95) {
        double[] ret = new double[4];
        double[] base = TableLike2xkx2.CalcFreqMultiOR(array, k, ORk, ThresOR, kizOR, rep, ThresL, ThresLdiff);
        double baseL = base[5];
        double baseOR = base[6];
        double[] L_CIseq = new double[OR_CIk];
        double[] OR_CIseq = new double[OR_CIk];
        double[] L_CIseqLow = new double[OR_CIk];
        double[] OR_CIseqLow = new double[OR_CIk];
        double[] L_CIseqUp = new double[OR_CIk];
        double[] OR_CIseqUp = new double[OR_CIk];
        OR_CIseq = TableLike2xkx2.ChangeArrayLog(TableLike2xkx2.MakeThomasArray(OR_CIk, Math.log10(baseOR / ThresOR_CI), Math.log10(baseOR * ThresOR_CI)));
        int i = 0;
        while (i < OR_CIk) {
            L_CIseq[i] = TableLike2xkx2.CalcFreqFixedOR(array, k, ORk, ThresOR, kizOR, rep, ThresL, ThresLdiff, OR_CIseq[i]);
            ++i;
        }
        double[] CIpoint = TableLike2xkx2.DetectLdiffCI(OR_CIseq, L_CIseq, baseL, CILdiff_95);
        ret[0] = Tools.Means(CIpoint[0], CIpoint[1])[1];
        ret[1] = Tools.Means(CIpoint[2], CIpoint[3])[1];
        OR_CIseqLow = TableLike2xkx2.ChangeArrayLog(TableLike2xkx2.MakeThomasArray(OR_CIk, Math.log10(CIpoint[0]), Math.log10(CIpoint[1])));
        OR_CIseqUp = TableLike2xkx2.ChangeArrayLog(TableLike2xkx2.MakeThomasArray(OR_CIk, Math.log10(CIpoint[2]), Math.log10(CIpoint[3])));
        int i2 = 0;
        while (i2 < OR_CIk) {
            L_CIseqLow[i2] = TableLike2xkx2.CalcFreqFixedOR(array, k, ORk, ThresOR, kizOR, rep, ThresL, ThresLdiff, OR_CIseqLow[i2]);
            L_CIseqUp[i2] = TableLike2xkx2.CalcFreqFixedOR(array, k, ORk, ThresOR, kizOR, rep, ThresL, ThresLdiff, OR_CIseqUp[i2]);
            ++i2;
        }
        double[] CIpointLow = TableLike2xkx2.DetectLdiffCI(OR_CIseqLow, L_CIseqLow, baseL, CILdiff_95);
        double[] CIpointUp = TableLike2xkx2.DetectLdiffCI(OR_CIseqUp, L_CIseqUp, baseL, CILdiff_95);
        ret[2] = Tools.Means(CIpointLow[0], CIpointLow[1])[1];
        ret[3] = Tools.Means(CIpointUp[2], CIpointUp[3])[1];
        return ret;
    }

    public static double CalcFreqFixedOR(double[][][] array, int k, int ORk, double ThresOR, double kizOR, int rep, double ThresL, double ThresLdiff, double OR_CI) {
        double[][] TotalArray = TableManage.CombineTable(array);
        double[][] CaseArray = TableManage.ExtractTable(array, 0);
        double[][] ContArray = TableManage.ExtractTable(array, 1);
        double[][] Freq = TableManage.GetFreq(TotalArray);
        double[][] tmpOR = TableLike2xkx2.CalcBaseOR(CaseArray, ContArray, 1);
        double f = TableManage.SumTable(CaseArray) / TableManage.SumTable(TotalArray);
        double tmpkizOR = kizOR;
        double L0 = -9.99999999E8;
        int Point2 = 0;
        int ThresPoint = 5;
        double Boost = 10.0;
        int countH0 = 0;
        boolean kizORboost = false;
        int i = 0;
        while (i < rep) {
            double[][][][] tmpORk = TableLike2xkx2.ChangeORwithk(tmpOR, tmpkizOR);
            int[] Flag = TableLike2xkx2.MakeFlagFromORkseq(tmpORk, L0, CaseArray, ContArray, Freq, f, k, OR_CI);
            double[] tmp = TableLike2xkx2.MaxLikeORsH1(CaseArray, ContArray, Freq, tmpOR = TableLike2xkx2.ChangeORwithFlagk(tmpOR, Flag, tmpkizOR), f, k, OR_CI);
            if (tmp[0] - L0 < ThresL) {
                ++Point2;
            }
            if (Point2 == ThresPoint) {
                i = rep;
                Point2 = 0;
            } else if (Point2 == 1 && !kizORboost) {
                tmpkizOR = 1.0 + (kizOR - 1.0) / Boost;
                kizORboost = true;
            }
            L0 = tmp[0];
            ++countH0;
            ++i;
        }
        double ret = L0;
        return ret;
    }

    public static double[] CalcFreqMultiOR(double[][][] array, int k, int ORk, double ThresOR, double kizOR, int rep, double ThresL, double ThresLdiff) {
        double[] ret = new double[12];
        double[][] TotalArray = TableManage.CombineTable(array);
        double[][] CaseArray = TableManage.ExtractTable(array, 0);
        double[][] ContArray = TableManage.ExtractTable(array, 1);
        double[][] Freq = TableManage.GetFreq(TotalArray);
        double[][] CaseFreq = new double[array[0].length][array[1].length];
        double[][] ContFreq = new double[array[0].length][array[1].length];
        double[][] tmpOR = TableLike2xkx2.CalcBaseOR(CaseArray, ContArray, 1);
        double f = TableManage.SumTable(CaseArray) / TableManage.SumTable(TotalArray);
        double tmpkizOR = kizOR;
        String out = "";
        double[] tmpret = TableLike2xkx2.MaxLikeORsseq(CaseArray, ContArray, Freq, tmpOR, f, k, 1.0 / ThresOR, ThresOR, ORk);
        ret[0] = tmpret[0];
        ret[1] = tmpret[1];
        tmpret = TableLike2xkx2.MaxLikeORsH0(CaseArray, ContArray, Freq, tmpOR, f, k);
        ret[2] = tmpret[0];
        ret[3] = tmpret[1];
        ret[4] = (ret[0] - ret[2]) * 2.0;
        if (ret[4] < ThresLdiff) {
            int i = 5;
            while (i < ret.length) {
                ret[5] = -1.0;
                ++i;
            }
        } else {
            int[] Flag;
            double[][][][] tmpORk;
            double L0 = ret[2];
            double ORs = ret[3];
            int Point2 = 0;
            int ThresPoint = 5;
            double Boost = 10.0;
            int countH1 = 0;
            int countH0 = 0;
            boolean kizORboost = false;
            int i = 0;
            while (i < rep) {
                tmpORk = TableLike2xkx2.ChangeORwithk(tmpOR, tmpkizOR);
                Flag = TableLike2xkx2.MakeFlagFromORkH0(tmpORk, L0, CaseArray, ContArray, Freq, f, k);
                double[] tmp = TableLike2xkx2.MaxLikeORsH0(CaseArray, ContArray, Freq, tmpOR = TableLike2xkx2.ChangeORwithFlagk(tmpOR, Flag, tmpkizOR), f, k);
                if (tmp[0] - L0 < ThresL) {
                    ++Point2;
                }
                if (Point2 == ThresPoint) {
                    i = rep;
                    Point2 = 0;
                } else if (Point2 == 1 && !kizORboost) {
                    tmpkizOR = 1.0 + (kizOR - 1.0) / Boost;
                    kizORboost = true;
                }
                L0 = tmp[0];
                ORs = tmp[1];
                ++countH0;
                ++i;
            }
            ret[7] = L0;
            ret[8] = ORs;
            tmpOR = TableLike2xkx2.CalcBaseOR(CaseArray, ContArray, 1);
            L0 = ret[0];
            ORs = ret[1];
            tmpkizOR = kizOR;
            kizORboost = false;
            i = 0;
            while (i < rep) {
                tmpORk = TableLike2xkx2.ChangeORwithk(tmpOR, tmpkizOR);
                Flag = TableLike2xkx2.MakeFlagFromORkseq(tmpORk, L0, CaseArray, ContArray, Freq, f, k, ORs);
                tmpret = TableLike2xkx2.MaxLikeORsseq(CaseArray, ContArray, Freq, tmpOR = TableLike2xkx2.ChangeORwithFlagk(tmpOR, Flag, tmpkizOR), f, k, 1.0 / ThresOR, ThresOR, ORk);
                if (tmpret[0] - L0 < ThresL) {
                    ++Point2;
                }
                if (Point2 == ThresPoint) {
                    i = rep;
                    Point2 = 0;
                } else if (Point2 == 1 && !kizORboost) {
                    tmpkizOR = 1.0 + (kizOR - 1.0) / Boost;
                    kizORboost = true;
                }
                L0 = tmpret[0];
                ORs = tmpret[1];
                ++countH1;
                ++i;
            }
            ret[5] = L0;
            ret[6] = ORs;
            ret[9] = (ret[5] - ret[7]) * 2.0;
            ret[10] = countH1;
            ret[11] = countH0;
        }
        return ret;
    }

    public static int[] MakeFlagFromORkseq(double[][][][] tmpORk, double L0, double[][] CaseArray, double[][] ContArray, double[][] Freq, double f, int k, double ORs) {
        int[] ret = new int[tmpORk.length];
        double[][] OR_kizD = new double[tmpORk[0][0].length][tmpORk[0][0][0].length];
        double[][] OR_kizM = new double[tmpORk[0][0].length][tmpORk[0][0][0].length];
        int i = 0;
        while (i < ret.length) {
            int j = 0;
            while (j < tmpORk[0][0].length) {
                int l = 0;
                while (l < tmpORk[0][0][0].length) {
                    OR_kizD[j][l] = tmpORk[i][0][j][l];
                    OR_kizM[j][l] = tmpORk[i][1][j][l];
                    ++l;
                }
                ++j;
            }
            double L_D = TableLike2xkx2.MaxLikeORsH1(CaseArray, ContArray, Freq, OR_kizD, f, k, ORs)[0];
            double L_M = TableLike2xkx2.MaxLikeORsH1(CaseArray, ContArray, Freq, OR_kizM, f, k, ORs)[0];
            if (L0 >= L_D && L0 >= L_M) {
                ret[i] = 0;
            } else if (L_D > L_M) {
                ret[i] = 1;
            } else if (L_D < L_M) {
                ret[i] = 2;
            } else if (L_D == L_M) {
                ret[i] = 3;
                System.out.println("Same L diff observed");
            }
            ++i;
        }
        return ret;
    }

    public static int[] MakeFlagFromORkH0(double[][][][] tmpORk, double L0, double[][] CaseArray, double[][] ContArray, double[][] Freq, double f, int k) {
        int[] ret = new int[tmpORk.length];
        double[][] OR_kizD = new double[tmpORk[0][0].length][tmpORk[0][0][0].length];
        double[][] OR_kizM = new double[tmpORk[0][0].length][tmpORk[0][0][0].length];
        int i = 0;
        while (i < ret.length) {
            int j = 0;
            while (j < tmpORk[0][0].length) {
                int l = 0;
                while (l < tmpORk[0][0][0].length) {
                    OR_kizD[j][l] = tmpORk[i][0][j][l];
                    OR_kizM[j][l] = tmpORk[i][1][j][l];
                    ++l;
                }
                ++j;
            }
            OR_kizD = TableLike2xkx2.CalcORwithBaseS(OR_kizD, 1.0);
            OR_kizM = TableLike2xkx2.CalcORwithBaseS(OR_kizM, 1.0);
            double L_D = TableLike2xkx2.MaxLikeORsH0(CaseArray, ContArray, Freq, OR_kizD, f, k)[0];
            double L_M = TableLike2xkx2.MaxLikeORsH0(CaseArray, ContArray, Freq, OR_kizM, f, k)[0];
            if (L0 >= L_D && L0 >= L_M) {
                ret[i] = 0;
            } else if (L_D > L_M) {
                ret[i] = 1;
            } else if (L_D < L_M) {
                ret[i] = 2;
            } else if (L_D == L_M) {
                ret[i] = 3;
                System.out.println("Same L diff observed");
            }
            ++i;
        }
        return ret;
    }

    public static double[] CalcFreqSingleOR(double[][][] array, int k, int ORk, double ThresOR) {
        double[] ret = new double[5];
        double[][] TotalArray = TableManage.CombineTable(array);
        double[][] CaseArray = TableManage.ExtractTable(array, 0);
        double[][] ContArray = TableManage.ExtractTable(array, 1);
        double[][] Freq = TableManage.GetFreq(TotalArray);
        double[][] CaseFreq = new double[array[0].length][array[1].length];
        double[][] ContFreq = new double[array[0].length][array[1].length];
        double f = TableManage.SumTable(CaseArray) / TableManage.SumTable(TotalArray);
        double[] tmpret = TableLike2xkx2.MaxLikeORsseq(CaseArray, ContArray, Freq, TableLike2xkx2.CalcBaseOR(CaseArray, ContArray, 1), f, k, 1.0 / ThresOR, ThresOR, ORk);
        ret[0] = tmpret[0];
        ret[1] = tmpret[1];
        tmpret = TableLike2xkx2.MaxLikeORsH0(CaseArray, ContArray, Freq, TableLike2xkx2.CalcBaseOR(CaseArray, ContArray, 1), f, k);
        ret[2] = tmpret[0];
        ret[3] = tmpret[1];
        ret[4] = (ret[0] - ret[2]) * 2.0;
        return ret;
    }

    public static double[] MaxLikeORsH0(double[][] CaseArray, double[][] ContArray, double[][] Freq, double[][] OR, double f, int k) {
        double L;
        double[] ret = new double[2];
        double[][] tmpOR = TableLike2xkx2.CalcORwithBaseS(OR, 1.0);
        ret[0] = L = TableLike2xkx2.CalcLikewithBestP00(CaseArray, ContArray, Freq, tmpOR, f, k);
        ret[1] = 1.0;
        return ret;
    }

    public static double[] MaxLikeORsH1(double[][] CaseArray, double[][] ContArray, double[][] Freq, double[][] OR, double f, int k, double ORs) {
        double L;
        double[] ret = new double[2];
        double[][] tmpOR = TableLike2xkx2.CalcORwithBaseS(OR, ORs);
        ret[0] = L = TableLike2xkx2.CalcLikewithBestP00(CaseArray, ContArray, Freq, tmpOR, f, k);
        ret[1] = ORs;
        return ret;
    }

    public static double[] MaxLikeORsseq(double[][] CaseArray, double[][] ContArray, double[][] Freq, double[][] OR, double f, int k, double MinOR, double MaxOR, int ORk) {
        double[] ret = new double[2];
        double L = -999999.0;
        double ORs = -1.0;
        int tmpi = 0;
        double[] ORseq = new double[ORk];
        ORseq[0] = Math.min(MinOR, MaxOR);
        ORseq[1] = Math.max(MinOR, MaxOR);
        int j = 0;
        while (j < 4) {
            ORseq = TableLike2xkx2.ChangeArrayLog(TableLike2xkx2.MakeThomasArray(ORk, Math.log10(ORseq[Math.max(tmpi - 1, 0)]), Math.log10(ORseq[Math.min(tmpi + 1, ORseq.length - 1)])));
            int i = 0;
            while (i < ORseq.length) {
                double[][] tmpOR = TableLike2xkx2.CalcORwithBaseS(OR, ORseq[i]);
                double tmpL = TableLike2xkx2.CalcLikewithBestP00(CaseArray, ContArray, Freq, tmpOR, f, k);
                if (tmpL >= L) {
                    L = tmpL;
                    ORs = ORseq[i];
                    tmpi = i;
                }
                ++i;
            }
            ++j;
        }
        ret[0] = L;
        ret[1] = ORs;
        return ret;
    }

    public static double CalcLikewithBestP00(double[][] CaseArray, double[][] ContArray, double[][] Freq, double[][] OR, double f, int k) {
        double L = -999999.0;
        double P00 = TableLike2xkx2.FindBestP00Rep(Freq, OR, f, k)[0];
        double[][] P = TableLike2xkx2.CalcFreqCasewithOR(Freq, OR, P00, f);
        double[][] Q = TableLike2xkx2.CalcFreqContwithOR(Freq, P, f);
        L = TableManage.Like2x2(CaseArray, P) + TableManage.Like2x2(ContArray, Q);
        return L;
    }

    public static double[] FindBestP00Rep(double[][] Freq, double[][] OR, double f, int k) {
        double[] ret = new double[2];
        double finP = -1.0;
        double minRet = 1000000.0;
        ret = TableLike2xkx2.FindBestP00(Freq, OR, f, k, 0.0, 1.0);
        ret = TableLike2xkx2.FindBestP00(Freq, OR, f, k, ret[0] - 1.0 / (double)(k + 1), ret[0] + 1.0 / (double)(k + 1));
        ret = TableLike2xkx2.FindBestP00(Freq, OR, f, k, ret[0] - 2.0 / (double)((k + 1) * (k + 1)), ret[0] + 2.0 / (double)((k + 1) * (k + 1)));
        ret = TableLike2xkx2.FindBestP00(Freq, OR, f, k, ret[0] - 4.0 / (double)((k + 1) * (k + 1) * (k + 1)), ret[0] + 4.0 / (double)((k + 1) * (k + 1) * (k + 1)));
        return ret;
    }

    public static double[] FindBestP00(double[][] Freq, double[][] OR, double f, int k, double range0, double range1) {
        double[] ret = new double[2];
        double finP = -1.0;
        double minRet = 1000000.0;
        double[] Pcand = TableLike2xkx2.MakeThomasArray(k, range0, range1);
        int i = 0;
        while (i < Pcand.length) {
            double tmpRet = TableLike2xkx2.CheckSumPwithOR(Freq, OR, Pcand[i], f);
            if (tmpRet <= minRet) {
                minRet = tmpRet;
                finP = Pcand[i];
            }
            ++i;
        }
        ret[0] = finP;
        ret[1] = minRet;
        return ret;
    }

    public static double[] ChangeArrayLog(double[] OR) {
        double[] ret = new double[OR.length];
        int i = 0;
        while (i < OR.length) {
            ret[i] = Math.pow(10.0, OR[i]);
            ++i;
        }
        return ret;
    }

    public static double[] MakeThomasArray(int k, double range0, double range1) {
        double[] ret = new double[k];
        double minThres = Math.min(range0, range1);
        double maxThres = Math.max(range0, range1);
        int i = 0;
        while (i < k) {
            ret[i] = (double)(i + 1) / (double)(k + 1) * (maxThres - minThres) + minThres;
            ++i;
        }
        return ret;
    }

    public static double CheckSumPwithOR(double[][] Freq, double[][] OR, double P00, double f) {
        double[][] P = TableLike2xkx2.CalcFreqCasewithOR(Freq, OR, P00, f);
        double[][] Q = TableLike2xkx2.CalcFreqContwithOR(Freq, P, f);
        double ret = 1000000.0;
        if (TableManage.CheckRange(P, 0.0, 1.0) && TableManage.CheckRange(Q, 0.0, 1.0)) {
            ret = Math.abs(1.0 - TableManage.SumTable(P));
        }
        return ret;
    }

    public static double[][] CalcFreqCasewithOR(double[][] Freq, double[][] OR, double P00, double f) {
        double[][] P = new double[Freq.length][Freq[0].length];
        P[P.length - 1][0] = P00;
        double h00 = Freq[Freq.length - 1][0];
        int i = 0;
        while (i < P.length) {
            int j = 0;
            while (j < P[0].length) {
                if (i != P.length - 1 || j != 0) {
                    P[i][j] = Freq[i][j] * OR[i][j] * P00 / (h00 + (OR[i][j] - 1.0) * f * P00);
                }
                ++j;
            }
            ++i;
        }
        return P;
    }

    public static double[][] CalcFreqContwithOR(double[][] Freq, double[][] P, double f) {
        double[][] Q = new double[P.length][P[0].length];
        int i = 0;
        while (i < P.length) {
            int j = 0;
            while (j < P[0].length) {
                Q[i][j] = (Freq[i][j] - f * P[i][j]) / (1.0 - f);
                ++j;
            }
            ++i;
        }
        return Q;
    }

    public static double[][] ChangeORwithFlagk(double[][] OR, int[] flag, double kiz) {
        double[][] ret = TableManage.CopyArray2(OR);
        double[] tmp = new double[2];
        int i = 0;
        while (i < OR.length - 1) {
            if (flag[i] != 0) {
                if (flag[i] == 1) {
                    ret[i][0] = OR[i][0] / kiz;
                } else if (flag[i] == 2) {
                    ret[i][0] = OR[i][0] * kiz;
                } else if (flag[i] == 3) {
                    tmp[0] = OR[i][0] / kiz;
                    tmp[1] = OR[i][0] * kiz;
                    int tmpord = TableLike2xkx2.NearestValue(tmp, 1.0);
                    if (tmpord != -99) {
                        ret[i][0] = tmp[tmpord];
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    public static int NearestValue(double[] Array, double Point2) {
        int ret = -99;
        double dist = 999999.0;
        int i = 0;
        while (i < Array.length) {
            double tmp = Math.abs(Math.log(Array[i]) - Math.log(Point2));
            if (tmp < dist) {
                ret = i;
                dist = tmp;
            } else if (tmp == dist) {
                ret = -99;
                i = Array.length;
            }
            ++i;
        }
        return ret;
    }

    public static double[][][][] ChangeORwithk(double[][] OR, double kiz) {
        int k = OR.length;
        double[][][][] ret = new double[k - 1][2][k][OR[0].length];
        int i = 0;
        while (i < k - 1) {
            int j = 0;
            while (j < 2) {
                int l = 0;
                while (l < k) {
                    int m = 0;
                    while (m < OR[0].length) {
                        ret[i][j][l][m] = OR[l][m];
                        ++m;
                    }
                    ++l;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < k - 1) {
            ret[i][0][i][0] = OR[i][0] / kiz;
            ret[i][1][i][0] = OR[i][0] * kiz;
            ++i;
        }
        return ret;
    }

    public static double[][] CalcORwithBaseS(double[][] OR, double ORs) {
        double[][] ret = new double[OR.length][OR[0].length];
        int i = 0;
        while (i < OR.length) {
            ret[i][0] = OR[i][0];
            ret[i][1] = OR[i][0] * ORs;
            ++i;
        }
        return ret;
    }

    public static double[][] CalcBaseOR(double[][] CaseArray, double[][] ContArray, int base) {
        int j;
        double[][] ret = new double[CaseArray.length][CaseArray[0].length];
        double minOR = 99.0;
        double thres = 0.002;
        int i = 0;
        while (i < CaseArray.length) {
            j = 0;
            while (j < CaseArray[0].length) {
                if (CaseArray[i][j] >= thres && ContArray[i][j] >= thres) {
                    ret[i][j] = CaseArray[i][j] / ContArray[i][j];
                    if (minOR >= ret[i][j]) {
                        minOR = ret[i][j];
                    }
                } else if (CaseArray[i][j] >= thres && ContArray[i][j] < thres) {
                    ret[i][j] = 10.0;
                } else if (CaseArray[i][j] < thres && ContArray[i][j] >= thres) {
                    ret[i][j] = 0.1;
                } else if (CaseArray[i][j] < thres && ContArray[i][j] < thres) {
                    ret[i][j] = 1.0;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < CaseArray.length) {
            j = 0;
            while (j < CaseArray[0].length) {
                if (ret[i][j] != -99.0) {
                    if (base == 1) {
                        double[] dArray = ret[i];
                        int n = j;
                        dArray[n] = dArray[n] / (CaseArray[CaseArray.length - 1][0] / ContArray[CaseArray.length - 1][0]);
                    } else if (base == 2) {
                        double[] dArray = ret[i];
                        int n = j;
                        dArray[n] = dArray[n] / minOR;
                    }
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static double[][] CalcBaseORforKW(double[][] CaseArray, double[][] ContArray, int base) {
        int j;
        double[][] ret = new double[CaseArray.length][CaseArray[0].length];
        double minOR = 99.0;
        double maxOR = -99.0;
        int i = 0;
        while (i < CaseArray.length) {
            j = 0;
            while (j < CaseArray[0].length) {
                if (CaseArray[i][j] != 0.0 && ContArray[i][j] != 0.0) {
                    ret[i][j] = CaseArray[i][j] / ContArray[i][j];
                    if (minOR >= ret[i][j]) {
                        minOR = ret[i][j];
                    }
                    if (maxOR <= ret[i][j]) {
                        maxOR = ret[i][j];
                    }
                } else {
                    ret[i][j] = -99.0;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < CaseArray.length) {
            j = 0;
            while (j < CaseArray[0].length) {
                if (ret[i][j] != -99.0) {
                    if (base == 1) {
                        double[] dArray = ret[i];
                        int n = j;
                        dArray[n] = dArray[n] / (CaseArray[CaseArray.length - 1][0] / ContArray[CaseArray.length - 1][0]);
                    } else if (base == 2) {
                        double[] dArray = ret[i];
                        int n = j;
                        dArray[n] = dArray[n] / minOR;
                    }
                } else if (CaseArray[i][j] != 0.0 && ContArray[i][j] == 0.0) {
                    ret[i][j] = Math.max(maxOR * 2.0, 10.0);
                } else if (CaseArray[i][j] == 0.0 && ContArray[i][j] != 0.0) {
                    ret[i][j] = Math.min(minOR / 10.0, 0.1);
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static double CalcBaseORCol(double[][] CaseArray, double[][] ContArray) {
        int j;
        double ret = -99.0;
        double[][] CombArray = new double[2][CaseArray[0].length];
        int i = 0;
        while (i < CombArray.length) {
            j = 0;
            while (j < CombArray[0].length) {
                CombArray[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < CaseArray.length) {
            j = 0;
            while (j < CaseArray[0].length) {
                double[] dArray = CombArray[0];
                int n = j;
                dArray[n] = dArray[n] + CaseArray[i][j];
                double[] dArray2 = CombArray[1];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + ContArray[i][j];
                ++j;
            }
            ++i;
        }
        if (CombArray[0][0] * CombArray[0][1] * CombArray[1][0] * CombArray[1][1] != 0.0) {
            ret = CombArray[0][1] / CombArray[0][0] / CombArray[1][1] * CombArray[1][0];
        }
        return ret;
    }
}

