/*
 * Decompiled with CFR 0.152.
 */
package LOCH_Mapping;

import Tool.ArrayTools;

public class LOCH_MappingTools {
    public static void main(String[] args) {
    }

    public static int[] PointHitonStretch(int[][] Stretch, long[] PointPosition, long[] Position2) {
        int numStretch = Stretch.length;
        int numPoint = PointPosition.length;
        int[] ret = new int[numPoint];
        ArrayTools.InitializeArray1(ret);
        int i = 0;
        while (i < numStretch) {
            int j = 0;
            while (j < numPoint) {
                if (PointPosition[j] >= Position2[Stretch[i][0]] && PointPosition[j] <= Position2[Stretch[i][1]]) {
                    ret[j] = 1;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static int[][] LOCHMappingAll(int[][] Count, long[] Position2, int Windowkb, int numGapSNP, int numMinSNP, int Stretchkb) {
        int[] flagLOCHSNP = LOCH_MappingTools.CheckLOCHfromCount(Count);
        int[] flagLOCHWindow = LOCH_MappingTools.MakeLOCHonWindow(flagLOCHSNP, Position2, Windowkb, numGapSNP, numMinSNP);
        int[][] Stretch = LOCH_MappingTools.DecideLOCHStretch(flagLOCHWindow, Position2);
        int[][] StretchLong = LOCH_MappingTools.ExtractLOCHStretchLong(Stretch, Position2, Stretchkb);
        return StretchLong;
    }

    public static int[][] ExtractLOCHStretchLong(int[][] Stretch, long[] Position2, int Stretchkb) {
        int numStretch = Stretch.length;
        int numStretchLong = 0;
        int i = 0;
        while (i < numStretch) {
            if (Position2[Stretch[i][1]] - Position2[Stretch[i][0]] >= (long)(Stretchkb * 1000)) {
                ++numStretchLong;
            }
            ++i;
        }
        int[][] ret = new int[numStretchLong][2];
        numStretchLong = 0;
        int i2 = 0;
        while (i2 < numStretch) {
            if (Position2[Stretch[i2][1]] - Position2[Stretch[i2][0]] >= (long)(Stretchkb * 1000)) {
                ret[numStretchLong][0] = Stretch[i2][0];
                ret[numStretchLong][1] = Stretch[i2][1];
                ++numStretchLong;
            }
            ++i2;
        }
        return ret;
    }

    public static int[][] DecideLOCHStretch(int[] flagLOCHWindow, long[] Position2) {
        int numSNP = flagLOCHWindow.length;
        int numStretch = 0;
        boolean OnStretch = false;
        int StretchSt = 0;
        int StretchEd = 0;
        int i = 0;
        while (i < numSNP) {
            if (!OnStretch && flagLOCHWindow[i] == 1) {
                OnStretch = true;
                ++numStretch;
            }
            if (OnStretch && flagLOCHWindow[i] == 0) {
                OnStretch = false;
            }
            ++i;
        }
        int[][] ret = new int[numStretch][2];
        numStretch = 0;
        OnStretch = false;
        int i2 = 0;
        while (i2 < numSNP) {
            if (!OnStretch && flagLOCHWindow[i2] == 1) {
                OnStretch = true;
                StretchSt = i2;
            }
            if (OnStretch && flagLOCHWindow[i2] == 0) {
                OnStretch = false;
                StretchEd = i2 - 1;
                ret[numStretch][0] = StretchSt;
                ret[numStretch][1] = StretchEd;
                ++numStretch;
            }
            ++i2;
        }
        return ret;
    }

    public static int[] MakeLOCHonWindow(int[] flagLOCHSNP, long[] Position2, int Windowkb, int numGapSNP, int numMinSNP) {
        int numSNP = flagLOCHSNP.length;
        int WindowEd = 1;
        int[] ret = new int[numSNP];
        ArrayTools.InitializeArray1(ret);
        int i = 0;
        while (i < numSNP - 1) {
            int WindowSt = i;
            while (Position2[WindowEd] - Position2[WindowSt] < (long)(Windowkb * 1000) && WindowEd < numSNP - 1) {
                ++WindowEd;
            }
            if (Position2[WindowEd] - Position2[WindowSt] > 99500000000L) {
                --WindowEd;
            }
            boolean WindowFlag = true;
            int numObsGapSNP = 0;
            int j = WindowSt;
            while (j < WindowEd) {
                if (flagLOCHSNP[j] == 0) {
                    ++numObsGapSNP;
                }
                ++j;
            }
            if (numObsGapSNP > numGapSNP) {
                WindowFlag = false;
            }
            if (WindowEd - WindowSt + 1 < numMinSNP) {
                WindowFlag = false;
            }
            if (WindowFlag) {
                j = WindowSt;
                while (j < WindowEd) {
                    ret[j] = 1;
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    public static int[] CheckLOCHfromCount(int[][] Count) {
        int numSNP = Count.length;
        int[] ret = new int[numSNP];
        int i = 0;
        while (i < numSNP) {
            ret[i] = Count[i][0] > 0 && Count[i][2] > 0 ? 0 : 1;
            ++i;
        }
        return ret;
    }
}

